/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.common.PasswordPanel;
import org.netbeans.modules.php.project.connections.ftp.FtpConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteClient;
import org.netbeans.modules.php.project.connections.spi.RemoteFile;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpClient
implements RemoteClient {
    private static final Logger LOGGER = Logger.getLogger(FtpClient.class.getName());
    private static final Map<Integer, String> PASSWORDS = new HashMap<Integer, String>();
    private static final int[] PERMISSIONS_ACCESSES = new int[]{0, 1, 2};
    private final FtpConfiguration configuration;
    private final FTPClient ftpClient;

    public FtpClient(FtpConfiguration ftpConfiguration, InputOutput inputOutput) {
        assert (ftpConfiguration != null);
        this.configuration = ftpConfiguration;
        LOGGER.log(Level.FINE, "FTP client creating");
        this.ftpClient = new FTPClient();
        if (inputOutput != null) {
            this.ftpClient.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(inputOutput));
            LOGGER.log(Level.FINE, "Protocol command listener added");
        }
    }

    @Override
    public void connect() throws RemoteException {
        try {
            int n = this.configuration.getTimeout() * 1000;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Connecting to " + this.configuration.getHost() + " [timeout: " + n + " ms]");
            }
            String string = this.getPassword();
            this.ftpClient.setDefaultTimeout(n);
            this.ftpClient.connect(this.configuration.getHost(), this.configuration.getPort());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Reply is " + this.getReplyString());
            }
            if (!FTPReply.isPositiveCompletion((int)this.ftpClient.getReplyCode())) {
                LOGGER.fine("Disconnecting because of negative reply");
                this.ftpClient.disconnect();
                throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpRefusedConnection", (Object)this.configuration.getHost()), this.getReplyString());
            }
            LOGGER.fine("Login as " + this.configuration.getUserName());
            if (!this.ftpClient.login(this.configuration.getUserName(), string)) {
                LOGGER.fine("Login unusuccessful -> logout");
                this.ftpClient.logout();
                PASSWORDS.remove(this.configuration.hashCode());
                throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpLoginFailed"), this.getReplyString());
            }
            LOGGER.fine("Login successful");
            if (this.configuration.isPassiveMode()) {
                LOGGER.fine("Setting passive mode");
                this.ftpClient.enterLocalPassiveMode();
            }
            LOGGER.fine("Setting file type to BINARY");
            this.ftpClient.setFileType(2);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Remote system is " + this.ftpClient.getSystemName());
            }
            LOGGER.fine("Setting data timeout");
            this.ftpClient.setDataTimeout(n);
        }
        catch (IOException iOException) {
            IOException iOException2;
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException iOException3) {
                    LOGGER.log(Level.FINE, "Exception while disconnecting", iOException3);
                }
            }
            LOGGER.log(Level.INFO, "Exception while connecting", iOException);
            if (iOException instanceof UnknownHostException) {
                iOException2 = new IOException("Unknown host " + this.configuration.getHost());
            }
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotConnect", (Object)this.configuration.getHost()), iOException2, this.getReplyString());
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void disconnect() throws RemoteException {
        block8: {
            LOGGER.log(Level.FINE, "Remote client trying to disconnect");
            if (this.ftpClient.isConnected()) {
                LOGGER.log(Level.FINE, "Remote client connected -> disconnecting");
                this.ftpClient.logout();
                Object var3_1 = null;
                try {
                    this.ftpClient.disconnect();
                    LOGGER.log(Level.FINE, "Remote client disconnected");
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, "Remote client disconnected with exception", iOException);
                }
                break block8;
                {
                    catch (IOException iOException) {
                        LOGGER.log(Level.FINE, "Error while disconnecting", iOException);
                        throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotLogout", (Object)this.configuration.getHost()), iOException, this.getReplyString());
                    }
                }
                catch (Throwable throwable) {
                    Object var3_2 = null;
                    try {
                        this.ftpClient.disconnect();
                        LOGGER.log(Level.FINE, "Remote client disconnected");
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.FINE, "Remote client disconnected with exception", iOException);
                    }
                    throw throwable;
                }
            }
        }
    }

    private String getPassword() {
        String string = this.configuration.getPassword();
        assert (string != null);
        if (string.length() > 0) {
            return string;
        }
        string = PASSWORDS.get(this.configuration.hashCode());
        if (string != null) {
            return string;
        }
        PasswordPanel passwordPanel = PasswordPanel.forUser(this.configuration.getDisplayName(), this.configuration.getUserName());
        if (passwordPanel.open()) {
            string = passwordPanel.getPassword();
            PASSWORDS.put(this.configuration.hashCode(), string);
            return string;
        }
        return "";
    }

    @Override
    public String getReplyString() {
        String string = this.ftpClient.getReplyString();
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    @Override
    public String getNegativeReplyString() {
        int n = this.ftpClient.getReplyCode();
        if (FTPReply.isNegativePermanent((int)n) || FTPReply.isNegativeTransient((int)n)) {
            return this.getReplyString();
        }
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.ftpClient.isConnected();
    }

    @Override
    public String printWorkingDirectory() throws RemoteException {
        try {
            return this.ftpClient.printWorkingDirectory();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error while pwd", iOException);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotPwd", (Object)this.configuration.getHost()), iOException, this.getReplyString());
        }
    }

    @Override
    public boolean storeFile(String string, InputStream inputStream) throws RemoteException {
        try {
            return this.ftpClient.storeFile(string, inputStream);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error while storing file " + string, iOException);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotStoreFile", (Object)string), iOException, this.getReplyString());
        }
    }

    @Override
    public boolean deleteFile(String string) throws RemoteException {
        try {
            return this.ftpClient.deleteFile(string);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error while deleting file " + string, iOException);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotDeleteFile", (Object)string), iOException, this.getReplyString());
        }
    }

    @Override
    public boolean deleteDirectory(String string) throws RemoteException {
        try {
            return this.ftpClient.removeDirectory(string);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error while deleting file " + string, iOException);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotDeleteFile", (Object)string), iOException, this.getReplyString());
        }
    }

    @Override
    public boolean rename(String string, String string2) throws RemoteException {
        try {
            return this.ftpClient.rename(string, string2);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, String.format("Error while renaming file %s -> %s", string, string2), iOException);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotRenameFile", (Object)string, (Object)string2), iOException, this.getReplyString());
        }
    }

    @Override
    public List<RemoteFile> listFiles() throws RemoteException {
        ArrayList<RemoteFile> arrayList = null;
        String string = null;
        try {
            string = this.ftpClient.printWorkingDirectory();
            FTPFile[] fTPFileArray = this.ftpClient.listFiles(string);
            arrayList = new ArrayList<RemoteFile>(fTPFileArray.length);
            for (FTPFile fTPFile : fTPFileArray) {
                if (fTPFile == null) {
                    LOGGER.fine("NULL returned for listing of " + string);
                    continue;
                }
                arrayList.add(new RemoteFileImpl(fTPFile));
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error while listing files for " + string, iOException);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotListFiles", (Object)string), iOException, this.getReplyString());
        }
        return arrayList;
    }

    @Override
    public boolean retrieveFile(String string, OutputStream outputStream) throws RemoteException {
        try {
            return this.ftpClient.retrieveFile(string, outputStream);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error while retrieving file " + string, iOException);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotStoreFile", (Object)string), iOException, this.getReplyString());
        }
    }

    @Override
    public boolean changeWorkingDirectory(String string) throws RemoteException {
        try {
            return this.ftpClient.changeWorkingDirectory(string);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error while changing directory " + string, iOException);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotChangeDirectory", (Object)string), iOException, this.getReplyString());
        }
    }

    @Override
    public boolean makeDirectory(String string) throws RemoteException {
        try {
            return this.ftpClient.makeDirectory(string);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error while creating directory " + string, iOException);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotCreateDirectory", (Object)string), iOException, this.getReplyString());
        }
    }

    @Override
    public int getPermissions(String string) throws RemoteException {
        try {
            return this.getPermissions(this.getFile(string));
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error while getting permissions for " + string, iOException);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotGetPermissions", (Object)string), iOException, this.getReplyString());
        }
    }

    @Override
    public boolean setPermissions(int n, String string) throws RemoteException {
        try {
            return this.ftpClient.sendSiteCommand("chmod " + n + " " + string);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error while setting permissions for " + string, iOException);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotSetPermissions", (Object)string), iOException, this.getReplyString());
        }
    }

    @Override
    public boolean exists(String string, String string2) throws RemoteException {
        try {
            this.ftpClient.changeWorkingDirectory(string);
            for (RemoteFile remoteFile : this.listFiles()) {
                if (!remoteFile.getName().equals(string2)) continue;
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            String string3 = string + "/" + string2;
            LOGGER.log(Level.FINE, "Error while checking existence of " + string3, iOException);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotCheckFileExistence", (Object)string3), iOException, this.getReplyString());
        }
    }

    private FTPFile getFile(String string) throws IOException {
        assert (string != null && string.trim().length() > 0);
        FTPFile[] fTPFileArray = this.ftpClient.listFiles(string);
        LOGGER.fine(String.format("Exactly 1 file should be found for %s; found %d", string, fTPFileArray.length));
        if (fTPFileArray.length > 0) {
            return fTPFileArray[0];
        }
        return null;
    }

    private int getPermissions(FTPFile fTPFile) {
        if (fTPFile == null) {
            return -1;
        }
        StringBuilder stringBuilder = new StringBuilder(3);
        for (int n : PERMISSIONS_ACCESSES) {
            int n2 = 0;
            if (fTPFile.hasPermission(n, 0)) {
                n2 += 4;
            }
            if (fTPFile.hasPermission(n, 1)) {
                n2 += 2;
            }
            if (fTPFile.hasPermission(n, 2)) {
                ++n2;
            }
            stringBuilder.append(n2);
        }
        assert (stringBuilder.length() == 3) : "Buffer lenght is incorrect: " + stringBuilder.length();
        int n = Integer.valueOf(stringBuilder.toString());
        return n;
    }

    private static final class PrintCommandListener
    implements ProtocolCommandListener {
        private final InputOutput io;

        public PrintCommandListener(InputOutput inputOutput) {
            assert (inputOutput != null);
            this.io = inputOutput;
        }

        public void protocolCommandSent(ProtocolCommandEvent protocolCommandEvent) {
            this.processEvent(protocolCommandEvent);
        }

        public void protocolReplyReceived(ProtocolCommandEvent protocolCommandEvent) {
            this.processEvent(protocolCommandEvent);
        }

        private void processEvent(ProtocolCommandEvent protocolCommandEvent) {
            String string = protocolCommandEvent.getMessage();
            if (string.startsWith("PASS ")) {
                string = "PASS ******";
            }
            OutputWriter outputWriter = null;
            outputWriter = protocolCommandEvent.isReply() && (FTPReply.isNegativeTransient((int)protocolCommandEvent.getReplyCode()) || FTPReply.isNegativePermanent((int)protocolCommandEvent.getReplyCode())) ? this.io.getErr() : this.io.getOut();
            outputWriter.println(string.trim());
            outputWriter.flush();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Command listener: " + string.trim());
            }
        }
    }

    private static final class RemoteFileImpl
    implements RemoteFile {
        private final FTPFile ftpFile;

        public RemoteFileImpl(FTPFile fTPFile) {
            assert (fTPFile != null);
            this.ftpFile = fTPFile;
        }

        public String getName() {
            return this.ftpFile.getName();
        }

        public boolean isDirectory() {
            return this.ftpFile.isDirectory();
        }

        public boolean isFile() {
            return this.ftpFile.isFile();
        }

        public long getSize() {
            return this.ftpFile.getSize();
        }
    }
}

