/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import org.netbeans.modules.php.project.connections.ui.TransferFileTableChangeListener;
import org.netbeans.modules.php.project.connections.ui.TransferFileUnit;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransferFileTableModel
extends AbstractTableModel {
    private final List<TransferFileUnit> fileData = new ArrayList<TransferFileUnit>();
    private final List<TransferFileTableChangeListener> listeners = new CopyOnWriteArrayList<TransferFileTableChangeListener>();
    volatile String filter = "";

    protected abstract Type getType();

    protected abstract String getTabTitle();

    protected abstract String getFirstColumnName();

    List<TransferFileUnit> getData() {
        return new ArrayList<TransferFileUnit>(this.fileData);
    }

    static Map<Integer, Boolean> captureState(List<TransferFileUnit> list) {
        HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>(list.size());
        for (TransferFileUnit transferFileUnit : list) {
            hashMap.put(transferFileUnit.getId(), transferFileUnit.isMarked());
        }
        return hashMap;
    }

    static void restoreState(List<TransferFileUnit> list, Map<Integer, Boolean> map, boolean bl) {
        for (TransferFileUnit transferFileUnit : list) {
            Boolean bl2 = map.get(transferFileUnit.getId());
            if (bl2 != null) {
                if (bl2.booleanValue() && !transferFileUnit.isMarked() && transferFileUnit.canBeMarked()) {
                    transferFileUnit.setMarked(true);
                    continue;
                }
                if (bl2.booleanValue() || !transferFileUnit.isMarked() || !transferFileUnit.canBeMarked()) continue;
                transferFileUnit.setMarked(false);
                continue;
            }
            if (!bl || transferFileUnit.isMarked() || !transferFileUnit.canBeMarked()) continue;
            transferFileUnit.setMarked(true);
        }
    }

    public static boolean isMarkedAsDefault() {
        return true;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        TransferFileUnit transferFileUnit = this.getUnitAtRow(n);
        switch (n2) {
            case 0: {
                object = transferFileUnit.isMarked() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 1: {
                object = transferFileUnit.getDisplayName();
                break;
            }
            default: {
                assert (false) : "Unknown column index: " + n2;
                break;
            }
        }
        return object;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Class clazz = null;
        switch (n) {
            case 0: {
                clazz = Boolean.class;
                break;
            }
            case 1: {
                clazz = String.class;
            }
        }
        return clazz;
    }

    public String getTabTooltipText() {
        return null;
    }

    public String getToolTipText(int n, int n2) {
        String string = null;
        if (n2 == 0) {
            string = this.getTooltipForCheckBox(n);
        } else if (n2 == 1) {
            string = (String)this.getValueAt(n, 1);
        }
        return string;
    }

    private String getTooltipForCheckBox(int n) {
        return NbBundle.getMessage(TransferFileTableModel.class, (String)"FileConfirmation_TooltipCheckBox", (Object)((String)this.getValueAt(n, 1)));
    }

    public int getMinWidth(JTableHeader jTableHeader, int n) {
        return jTableHeader.getHeaderRect((int)n).width;
    }

    public int getPreferredWidth(JTableHeader jTableHeader, int n) {
        if (n == 1) {
            return this.getMinWidth(jTableHeader, n) * 4;
        }
        return this.getMinWidth(jTableHeader, n);
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return this.getFirstColumnName();
            }
            case 1: {
                return NbBundle.getMessage(TransferFileTableModel.class, (String)"FileConfirmationTableModel_Columns_RelativePath");
            }
        }
        assert (false) : "Unknown column index: " + n;
        return super.getColumnName(n);
    }

    public final void sort(int n, boolean bl) {
        if (n == 0) {
            Collections.sort(this.fileData, new MarkedComparator(bl));
        } else if (n == 1) {
            Collections.sort(this.fileData, new PathComparator(bl));
        } else assert (false) : "Unknown column index: " + n;
        this.fireTableDataChanged();
    }

    protected final void setData(List<TransferFileUnit> list) {
        assert (list != null);
        this.fileData.clear();
        this.fileData.addAll(list);
        this.fireTableDataChanged();
    }

    public void setFilter(final String string, final Runnable runnable) {
        assert (string != null);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TransferFileTableModel.this.filter = string.toLowerCase();
                TransferFileTableModel.this.fireFilterChange();
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
    }

    public String getFilter() {
        assert (this.filter != null);
        return this.filter;
    }

    public void addUpdateUnitListener(TransferFileTableChangeListener transferFileTableChangeListener) {
        this.listeners.add(transferFileTableChangeListener);
    }

    public void removeUpdateUnitListener(TransferFileTableChangeListener transferFileTableChangeListener) {
        this.listeners.remove(transferFileTableChangeListener);
    }

    void fireUpdataUnitChange() {
        for (TransferFileTableChangeListener transferFileTableChangeListener : this.listeners) {
            transferFileTableChangeListener.updateUnitsChanged();
        }
    }

    void fireFilterChange() {
        for (TransferFileTableChangeListener transferFileTableChangeListener : this.listeners) {
            transferFileTableChangeListener.filterChanged();
        }
    }

    public List<TransferFileUnit> getVisibleFileUnits() {
        List<TransferFileUnit> list = this.getData();
        String string = this.filter;
        ArrayList<TransferFileUnit> arrayList = new ArrayList<TransferFileUnit>(list.size());
        for (TransferFileUnit transferFileUnit : list) {
            if (!transferFileUnit.isVisible(string)) continue;
            arrayList.add(transferFileUnit);
        }
        return arrayList;
    }

    @Override
    public int getRowCount() {
        return this.getVisibleFileUnits().size();
    }

    public int getRawItemCount() {
        return this.fileData.size();
    }

    public List<TransferFileUnit> getAllUnits() {
        List<TransferFileUnit> list = this.getData();
        ArrayList<TransferFileUnit> arrayList = new ArrayList<TransferFileUnit>(list.size());
        for (TransferFileUnit transferFileUnit : list) {
            if (!transferFileUnit.getTransferFile().isFile()) continue;
            arrayList.add(transferFileUnit);
        }
        return arrayList;
    }

    public List<TransferFileUnit> getMarkedUnits() {
        List<TransferFileUnit> list = this.getAllUnits();
        ArrayList<TransferFileUnit> arrayList = new ArrayList<TransferFileUnit>(list.size());
        for (TransferFileUnit transferFileUnit : list) {
            assert (transferFileUnit.getTransferFile().isFile()) : "Only files can be visible";
            if (!transferFileUnit.isMarked()) continue;
            arrayList.add(transferFileUnit);
        }
        return arrayList;
    }

    public TransferFileUnit getUnitAtRow(int n) {
        assert (this.getVisibleFileUnits().size() > n) : String.format("Unknown row index [%d, size %d]", n, this.getVisibleFileUnits().size());
        return this.getVisibleFileUnits().get(n);
    }

    public int getRowForUnit(TransferFileUnit transferFileUnit) {
        int n = 0;
        for (TransferFileUnit transferFileUnit2 : this.getVisibleFileUnits()) {
            if (transferFileUnit.equals(transferFileUnit2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0 && Boolean.class.equals(this.getColumnClass(n2));
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        assert (n2 == 0) : "Only first column is editable.";
        assert (object instanceof Boolean) : object + " must be instance of Boolean.";
        TransferFileUnit transferFileUnit = this.getUnitAtRow(n);
        if (((Boolean)object).booleanValue() != transferFileUnit.isMarked()) {
            transferFileUnit.setMarked(!transferFileUnit.isMarked());
            this.fireUpdataUnitChange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MarkedComparator
    implements Comparator<TransferFileUnit> {
        private final boolean sortAscending;

        public MarkedComparator(boolean bl) {
            this.sortAscending = bl;
        }

        @Override
        public int compare(TransferFileUnit transferFileUnit, TransferFileUnit transferFileUnit2) {
            TransferFileUnit transferFileUnit3;
            TransferFileUnit transferFileUnit4 = this.sortAscending ? transferFileUnit : transferFileUnit2;
            TransferFileUnit transferFileUnit5 = transferFileUnit3 = this.sortAscending ? transferFileUnit2 : transferFileUnit;
            if (transferFileUnit4.isMarked() && transferFileUnit3.isMarked()) {
                return TransferFileUnit.compare(transferFileUnit4, transferFileUnit3);
            }
            if (transferFileUnit4.isMarked()) {
                return -1;
            }
            if (transferFileUnit3.isMarked()) {
                return 1;
            }
            return TransferFileUnit.compare(transferFileUnit4, transferFileUnit3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathComparator
    implements Comparator<TransferFileUnit> {
        private final boolean sortAscending;

        public PathComparator(boolean bl) {
            this.sortAscending = bl;
        }

        @Override
        public int compare(TransferFileUnit transferFileUnit, TransferFileUnit transferFileUnit2) {
            TransferFileUnit transferFileUnit3 = this.sortAscending ? transferFileUnit : transferFileUnit2;
            TransferFileUnit transferFileUnit4 = this.sortAscending ? transferFileUnit2 : transferFileUnit;
            return TransferFileUnit.compare(transferFileUnit3, transferFileUnit4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UPLOAD,
        DOWNLOAD;

    }
}

