/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.ui.TransferFileDownloadModel;
import org.netbeans.modules.php.project.connections.ui.TransferFileTableChangeListener;
import org.netbeans.modules.php.project.connections.ui.TransferFileTableModel;
import org.netbeans.modules.php.project.connections.ui.TransferFileUnit;
import org.netbeans.modules.php.project.connections.ui.TransferFileUploadModel;
import org.netbeans.modules.php.project.connections.ui.TransferFilterTable;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransferFilter
extends JPanel {
    private static final long serialVersionUID = -1971424369225251471L;
    private static final ImageIcon INFO_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/project/ui/resources/info_icon.png"));
    final TransferFilterTable table;
    final TransferFileTableModel model;
    private DocumentListener dlForSearch;
    private FocusListener flForSearch;
    private volatile String filter = "";
    private PopupActionSupport popupActionsSupport;
    private static final RequestProcessor FILTER_PROCESSOR = new RequestProcessor("filter processor");
    private final RequestProcessor.Task searchTask = FILTER_PROCESSOR.create(new Runnable(){

        public void run() {
            if (TransferFilter.this.filter != null) {
                int n = TransferFilter.this.getSelectedRow();
                final TransferFileUnit transferFileUnit = n != -1 ? TransferFilter.this.getModel().getUnitAtRow(n) : null;
                final Map<Integer, Boolean> map = TransferFileTableModel.captureState(TransferFilter.this.model.getData());
                Runnable runnable = new Runnable(){

                    public void run() {
                        if (transferFileUnit != null) {
                            int n = TransferFilter.this.model.getRowForUnit(transferFileUnit);
                            TransferFilter.this.restoreSelectedRow(n);
                        }
                        TransferFileTableModel.restoreState(TransferFilter.this.model.getData(), map, TransferFileTableModel.isMarkedAsDefault());
                        TransferFilter.this.refreshState();
                    }
                };
                TransferFilter.this.model.setFilter(TransferFilter.this.filter, runnable);
            }
        }
    });
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JLabel lSearch;
    private JLabel lSelectionInfo;
    private JLabel lWarning;
    private JTextField tfSearch;

    private TransferFilter(TransferFilterTable transferFilterTable) {
        this.table = transferFilterTable;
        TableModel tableModel = transferFilterTable.getModel();
        assert (tableModel instanceof TransferFileTableModel) : tableModel + " instanceof TransferFileTableModel.";
        this.model = (TransferFileTableModel)tableModel;
        transferFilterTable.getSelectionModel().setSelectionMode(0);
        this.initComponents();
    }

    private static TransferFilter create(TransferFilterTable transferFilterTable) {
        TransferFilter transferFilter = new TransferFilter(transferFilterTable);
        transferFilter.initPopup();
        transferFilter.listenOnSelection();
        transferFilter.listenOnUnitChanges();
        transferFilter.refreshState();
        return transferFilter;
    }

    public static Set<TransferFile> showUploadDialog(Set<TransferFile> set, long l) {
        return TransferFilter.showTransferDialog(set, TransferFileTableModel.Type.UPLOAD, l);
    }

    public static Set<TransferFile> showDownloadDialog(Set<TransferFile> set) {
        return TransferFilter.showTransferDialog(set, TransferFileTableModel.Type.DOWNLOAD, -1L);
    }

    public static TransferFilter getEmbeddableDownloadDialog(Set<TransferFile> set) {
        TransferFileDownloadModel transferFileDownloadModel = new TransferFileDownloadModel(TransferFilter.wrapTransferFiles(set));
        return TransferFilter.create(new TransferFilterTable(transferFileDownloadModel));
    }

    public static Set<TransferFile> getSelectedFiles(TransferFilter transferFilter) {
        return TransferFilter.unwrapFileUnits(transferFilter.getModel().getMarkedUnits());
    }

    public static boolean hasAnyTransferableFiles(Set<TransferFile> set) {
        if (set == null) {
            return false;
        }
        TransferFilter transferFilter = TransferFilter.getEmbeddableDownloadDialog(set);
        return !TransferFilter.unwrapFileUnits(transferFilter.getModel().getMarkedUnits()).isEmpty();
    }

    private static Set<TransferFile> showTransferDialog(Set<TransferFile> set, TransferFileTableModel.Type type, long l) {
        TransferFileTableModel transferFileTableModel = null;
        String string = null;
        switch (type) {
            case DOWNLOAD: {
                transferFileTableModel = new TransferFileDownloadModel(TransferFilter.wrapTransferFiles(set));
                string = NbBundle.getMessage(TransferFilter.class, (String)"Download_Title");
                break;
            }
            case UPLOAD: {
                transferFileTableModel = new TransferFileUploadModel(TransferFilter.wrapTransferFiles(set, l));
                string = NbBundle.getMessage(TransferFilter.class, (String)"Upload_Title");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown model type: " + (Object)((Object)type));
            }
        }
        TransferFilter transferFilter = TransferFilter.create(new TransferFilterTable(transferFileTableModel));
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(TransferFilter.class, (String)"LBL_Ok"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)transferFilter, string, true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, null, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == jButton) {
            return TransferFilter.getSelectedFiles(transferFilter);
        }
        return Collections.emptySet();
    }

    private static List<TransferFileUnit> wrapTransferFiles(Collection<TransferFile> collection) {
        ArrayList<TransferFileUnit> arrayList = new ArrayList<TransferFileUnit>(collection.size());
        for (TransferFile transferFile : collection) {
            arrayList.add(new TransferFileUnit(transferFile, TransferFileTableModel.isMarkedAsDefault()));
        }
        return arrayList;
    }

    private static List<TransferFileUnit> wrapTransferFiles(Collection<TransferFile> collection, long l) {
        ArrayList<TransferFileUnit> arrayList = new ArrayList<TransferFileUnit>(collection.size());
        boolean bl = l == -1L;
        for (TransferFile transferFile : collection) {
            if (l != -1L) {
                bl = transferFile.isFile() && transferFile.getTimestamp() > l;
            }
            arrayList.add(new TransferFileUnit(transferFile, bl));
        }
        return arrayList;
    }

    private static Set<TransferFile> unwrapFileUnits(List<TransferFileUnit> list) {
        HashSet<TransferFile> hashSet = new HashSet<TransferFile>();
        for (TransferFileUnit transferFileUnit : list) {
            hashSet.add(transferFileUnit.getTransferFile());
        }
        return hashSet;
    }

    void focusTable() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TransferFilter.this.table.requestFocusInWindow();
            }
        });
    }

    TransferFileTableModel getModel() {
        return this.model;
    }

    public String getHelpId() {
        return TransferFilter.class.getName() + '.' + (Object)((Object)this.model.getType());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.focusTable();
        if (this.dlForSearch == null) {
            this.tfSearch.getDocument().addDocumentListener(this.getDocumentListener());
        }
        if (this.flForSearch == null) {
            this.flForSearch = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    TransferFilter.this.tfSearch.selectAll();
                }

                public void focusLost(FocusEvent focusEvent) {
                    TransferFilter.this.tfSearch.select(0, 0);
                }
            };
            this.tfSearch.addFocusListener(this.flForSearch);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        assert (this.dlForSearch != null);
        this.tfSearch.getDocument().removeDocumentListener(this.getDocumentListener());
        this.dlForSearch = null;
        assert (this.flForSearch != null);
        this.tfSearch.removeFocusListener(this.flForSearch);
        this.flForSearch = null;
    }

    public void refreshState() {
        int n = this.model.getMarkedUnits().size();
        this.popupActionsSupport.tableDataChanged();
        if (n == 0) {
            this.cleanSelectionInfo();
        } else {
            this.setSelectionInfo(n);
        }
    }

    private void initPopup() {
        TabAction[] tabActionArray = null;
        switch (this.model.getType()) {
            case DOWNLOAD: 
            case UPLOAD: {
                tabActionArray = new TabAction[]{new CheckAllAction(), new UncheckAllAction(), new CheckAction()};
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown model type: " + (Object)((Object)this.model.getType()));
            }
        }
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                TransferFilter.this.refreshState();
            }
        });
        this.popupActionsSupport = new PopupActionSupport(tabActionArray);
        this.table.addMouseListener(this.popupActionsSupport);
    }

    private void cleanSelectionInfo() {
        this.lSelectionInfo.setText(" ");
        this.lWarning.setText(" ");
        this.lWarning.setIcon(null);
    }

    private void setSelectionInfo(int n) {
        String string = null;
        switch (this.model.getType()) {
            case UPLOAD: {
                string = "FileConfirmationTableModel_Warning_Upload";
                break;
            }
            case DOWNLOAD: {
                string = "FileConfirmationTableModel_Warning_Download";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown model type: " + (Object)((Object)this.model.getType()));
            }
        }
        String string2 = n == 1 ? "FileConfirmationPane_lHowManySelected_Single_Text" : "FileConfirmationPane_lHowManySelected_Many_Text";
        this.lSelectionInfo.setText(NbBundle.getMessage(TransferFilter.class, (String)string2, (Object)n));
        this.lWarning.setIcon(INFO_ICON);
        this.lWarning.setText(NbBundle.getMessage(TransferFilter.class, (String)string));
    }

    private void listenOnSelection() {
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    TransferFilter.this.popupActionsSupport.rowChanged(-1);
                } else {
                    TransferFilter.this.popupActionsSupport.rowChanged(listSelectionModel.getMinSelectionIndex());
                }
            }
        });
    }

    private void listenOnUnitChanges() {
        this.addUpdateUnitListener(new TransferFileTableChangeListener(){

            public void updateUnitsChanged() {
                TransferFilter.this.refreshState();
            }

            public void filterChanged() {
                TransferFilter.this.model.fireTableDataChanged();
                TransferFilter.this.refreshState();
            }
        });
    }

    public void addUpdateUnitListener(TransferFileTableChangeListener transferFileTableChangeListener) {
        this.model.addUpdateUnitListener(transferFileTableChangeListener);
    }

    public void removeUpdateUnitListener(TransferFileTableChangeListener transferFileTableChangeListener) {
        this.model.removeUpdateUnitListener(transferFileTableChangeListener);
    }

    void fireUpdataUnitChange() {
        this.model.fireUpdataUnitChange();
    }

    DocumentListener getDocumentListener() {
        if (this.dlForSearch == null) {
            this.dlForSearch = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.processUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.processUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.processUpdate(documentEvent);
                }

                private void processUpdate(DocumentEvent documentEvent) {
                    TransferFilter.this.filter = TransferFilter.this.tfSearch.getText().trim();
                    TransferFilter.this.searchTask.schedule(350);
                }
            };
        }
        return this.dlForSearch;
    }

    private void initComponents() {
        this.lSelectionInfo = new JLabel();
        this.lSearch = new JLabel();
        this.tfSearch = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = this.table;
        this.lWarning = new JLabel();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                return TransferFilter.this.tfSearch;
            }

            public Component getFirstComponent(Container container) {
                return TransferFilter.this.tfSearch;
            }

            public Component getLastComponent(Container container) {
                return TransferFilter.this.tfSearch;
            }

            public Component getComponentAfter(Container container, Component component) {
                return TransferFilter.this.tfSearch;
            }

            public Component getComponentBefore(Container container, Component component) {
                return TransferFilter.this.tfSearch;
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lSelectionInfo, (String)NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.lSelectionInfo.text"));
        this.lSearch.setLabelFor(this.tfSearch);
        Mnemonics.setLocalizedText((JLabel)this.lSearch, (String)NbBundle.getMessage(TransferFilter.class, (String)"lSearch1.text"));
        this.jTable1.setModel(this.table.getModel());
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.jTable1.AccessibleContext.accessibleName"));
        this.jTable1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.jTable1.AccessibleContext.accessibleDescription"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.lWarning).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lSearch).add(4, 4, 4).add((Component)this.tfSearch, -2, 114, -2)).add(1, (Component)this.lSelectionInfo).add(1, (Component)this.jScrollPane1, -1, 558, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(4).add((Component)this.tfSearch, -2, -1, -2).add((Component)this.lSearch)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 252, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lSelectionInfo, -1, -1, Short.MAX_VALUE).add((Component)this.lWarning)).addContainerGap()));
        this.lSelectionInfo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.lSelectionInfo.AccessibleContext.accessibleName"));
        this.lSelectionInfo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.lSelectionInfo.AccessibleContext.accessibleDescription"));
        this.lSearch.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.lSearch.AccessibleContext.accessibleName"));
        this.lSearch.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"ACD_Search"));
        this.tfSearch.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.tfSearch.AccessibleContext.accessibleName"));
        this.tfSearch.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.tfSearch.AccessibleContext.accessibleDescription"));
        this.jScrollPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.jScrollPane1.AccessibleContext.accessibleName"));
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.jScrollPane1.AccessibleContext.accessibleDescription"));
        this.lWarning.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.lWarning.AccessibleContext.accessibleName"));
        this.lWarning.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.lWarning.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.AccessibleContext.accessibleDescription"));
    }

    private void showPopup(Point point, Component component) {
        int n = this.table.rowAtPoint(point);
        if (n >= 0) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
            JPopupMenu jPopupMenu = this.popupActionsSupport.createPopup();
            if (jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.show(component, point.x, point.y);
            }
        }
    }

    int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    private void restoreSelectedRow(int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = this.table.getRowCount();
        for (int i = n; i >= 0; --i) {
            if (i >= n2 || i <= -1) continue;
            this.table.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    static String textForKey(String string) {
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(TransferFilter.class, (String)string));
        return jButton.getText();
    }

    static int mnemonicForKey(String string) {
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(TransferFilter.class, (String)string));
        return jButton.getMnemonic();
    }

    private class CheckAction
    extends RowTabAction {
        private static final long serialVersionUID = 3205317962231792782L;

        public CheckAction() {
            super("FileConfirmationPane_CheckAction", KeyStroke.getKeyStroke(32, 0), null);
        }

        public void performerImpl(TransferFileUnit transferFileUnit) {
            int n = TransferFilter.this.getSelectedRow();
            if (transferFileUnit != null && transferFileUnit.canBeMarked()) {
                transferFileUnit.setMarked(!transferFileUnit.isMarked());
            }
            TransferFilter.this.model.fireTableDataChanged();
            TransferFilter.this.restoreSelectedRow(n);
        }

        protected boolean isEnabled(TransferFileUnit transferFileUnit) {
            return transferFileUnit.canBeMarked();
        }

        protected String getContextName(TransferFileUnit transferFileUnit) {
            return this.getActionName();
        }

        protected boolean isVisible(TransferFileUnit transferFileUnit) {
            return false;
        }

        protected boolean isVisible(int n) {
            return false;
        }
    }

    private class CheckAllAction
    extends RowTabAction {
        private static final long serialVersionUID = -2771565736665639L;

        public CheckAllAction() {
            super("FileConfirmationPane_CheckAllAction", "Check");
        }

        public void performerImpl(TransferFileUnit transferFileUnit) {
            int n = TransferFilter.this.getSelectedRow();
            List<TransferFileUnit> list = TransferFilter.this.model.getVisibleFileUnits();
            for (TransferFileUnit transferFileUnit2 : list) {
                if (transferFileUnit2.isMarked() || !transferFileUnit2.canBeMarked()) continue;
                transferFileUnit2.setMarked(true);
            }
            TransferFilter.this.model.fireTableDataChanged();
            TransferFilter.this.restoreSelectedRow(n);
        }

        protected boolean isEnabled(TransferFileUnit transferFileUnit) {
            return true;
        }

        protected String getContextName(TransferFileUnit transferFileUnit) {
            return this.getActionName();
        }
    }

    private final class PopupActionSupport
    extends MouseAdapter {
        private final TabAction[] actions;

        PopupActionSupport(TabAction[] tabActionArray) {
            this.actions = tabActionArray;
        }

        void rowChanged(int n) {
            TransferFileUnit transferFileUnit = null;
            if (n > -1) {
                transferFileUnit = TransferFilter.this.model.getUnitAtRow(n);
            }
            for (TabAction tabAction : this.actions) {
                assert (tabAction instanceof RowTabAction) : "Need RowTabAction and not " + tabAction.getClass().getName();
                RowTabAction rowTabAction = (RowTabAction)tabAction;
                rowTabAction.unitChanged(n, transferFileUnit);
            }
        }

        void tableDataChanged() {
            List<TransferFileUnit> list = TransferFilter.this.model.getMarkedUnits();
            for (TabAction tabAction : this.actions) {
                tabAction.tableDataChanged(list);
            }
        }

        private JPopupMenu createPopup() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            HashSet<String> hashSet = new HashSet<String>(this.actions.length);
            ArrayList<String> arrayList = new ArrayList<String>(this.actions.length);
            for (TabAction tabActionArray : this.actions) {
                String string = tabActionArray.getActionCategory();
                if (!hashSet.add(string)) continue;
                arrayList.add(string);
            }
            for (String string : arrayList) {
                int n = jPopupMenu.getSubElements().length > 0 ? 1 : 0;
                for (TabAction tabAction : this.actions) {
                    String string2 = tabAction.getActionCategory();
                    if ((string == null || !string.equals(string2)) && (string != null || string2 != null)) continue;
                    assert (tabAction instanceof RowTabAction) : "Need RowTabAction and not " + tabAction.getClass().getName();
                    RowTabAction rowTabAction = (RowTabAction)tabAction;
                    if (!rowTabAction.isVisible()) continue;
                    if (n != 0) {
                        n = 0;
                        jPopupMenu.addSeparator();
                    }
                    jPopupMenu.add(new JMenuItem(tabAction));
                }
            }
            return jPopupMenu;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private boolean maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                TransferFilter.this.focusTable();
                TransferFilter.this.showPopup(mouseEvent.getPoint(), mouseEvent.getComponent());
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class RowTabAction
    extends TabAction {
        private volatile TransferFileUnit unit;
        private volatile int row;

        public RowTabAction(String string, String string2) {
            super(string, string2);
        }

        public RowTabAction(String string, KeyStroke keyStroke, String string2) {
            super(string, keyStroke, string2);
        }

        public void unitChanged(int n, TransferFileUnit transferFileUnit) {
            this.unit = transferFileUnit;
            this.row = n;
            this.unitChanged();
        }

        public final boolean isVisible() {
            return this.unit != null ? this.isVisible(this.unit) : this.isVisible(this.row);
        }

        private void unitChanged() {
            if (this.unit != null) {
                this.setEnabled(this.isEnabled(this.unit));
                this.setContextName(this.getContextName(this.unit));
            } else {
                this.setEnabled(this.isEnabled(this.row));
                this.setContextName(this.getContextName(this.row));
            }
        }

        @Override
        public void tableDataChanged() {
            this.unitChanged();
        }

        @Override
        public void tableDataChanged(Collection<TransferFileUnit> collection) {
            this.unitChanged();
        }

        @Override
        public final void performerImpl() {
            this.performerImpl(this.unit);
            TransferFilter.this.model.fireUpdataUnitChange();
        }

        protected boolean isVisible(TransferFileUnit transferFileUnit) {
            return transferFileUnit != null;
        }

        protected boolean isVisible(int n) {
            return false;
        }

        public abstract void performerImpl(TransferFileUnit var1);

        protected abstract boolean isEnabled(TransferFileUnit var1);

        protected boolean isEnabled(int n) {
            return false;
        }

        protected abstract String getContextName(TransferFileUnit var1);

        protected String getContextName(int n) {
            return this.getActionName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class TabAction
    extends AbstractAction {
        private final String name;
        private final String actionCategory;

        public TabAction(String string, String string2) {
            super(TransferFilter.textForKey(string));
            this.actionCategory = string2;
            this.putValue("MnemonicKey", TransferFilter.mnemonicForKey(string));
            this.name = (String)this.getValue("Name");
            this.putIntoActionMap(TransferFilter.this.table);
        }

        public TabAction(String string, KeyStroke keyStroke, String string2) {
            this(string, string2);
            this.putValue("AcceleratorKey", keyStroke);
            this.putIntoActionMap(transferFilter.table);
        }

        protected String getActionName() {
            return this.name;
        }

        public String getActionCategory() {
            return this.getActionCategoryImpl();
        }

        protected String getActionCategoryImpl() {
            return this.actionCategory;
        }

        protected void setContextName(String string) {
            this.putValue("Name", string);
        }

        public void putIntoActionMap(JComponent jComponent) {
            KeyStroke keyStroke = (KeyStroke)this.getValue("AcceleratorKey");
            Object object = this.getValue("Name");
            if (keyStroke == null) {
                keyStroke = KeyStroke.getKeyStroke((Integer)this.getValue("MnemonicKey"), 18);
            }
            if (keyStroke != null && object != null) {
                jComponent.getInputMap(0).put(keyStroke, object);
                jComponent.getActionMap().put(object, this);
            }
        }

        public final void performAction() {
            if (this.isEnabled()) {
                this.actionPerformed(null);
            }
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            this.performerImpl();
        }

        public void tableDataChanged() {
            this.tableDataChanged(TransferFilter.this.model.getMarkedUnits());
        }

        public void tableDataChanged(Collection<TransferFileUnit> collection) {
            this.setEnabled(collection.size() > 0);
        }

        public abstract void performerImpl();
    }

    private class UncheckAllAction
    extends RowTabAction {
        private static final long serialVersionUID = -1506415995282022116L;

        public UncheckAllAction() {
            super("FileConfirmationPane_UncheckAllAction", "Uncheck");
        }

        public void performerImpl(TransferFileUnit transferFileUnit) {
            int n = TransferFilter.this.getSelectedRow();
            List<TransferFileUnit> list = TransferFilter.this.model.getVisibleFileUnits();
            for (TransferFileUnit transferFileUnit2 : list) {
                if (!transferFileUnit2.isMarked() || !transferFileUnit2.canBeMarked()) continue;
                transferFileUnit2.setMarked(false);
            }
            TransferFilter.this.model.fireTableDataChanged();
            TransferFilter.this.restoreSelectedRow(n);
        }

        protected boolean isEnabled(TransferFileUnit transferFileUnit) {
            return true;
        }

        protected String getContextName(TransferFileUnit transferFileUnit) {
            return this.getActionName();
        }
    }
}

