/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.copysupport;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FileOperationFactory {
    protected final PhpProject project;
    private final FileObject nbprojectDir;
    private final PhpVisibilityQuery phpVisibilityQuery;
    private volatile boolean factoryError = false;

    public FileOperationFactory(PhpProject phpProject) {
        assert (phpProject != null);
        this.project = phpProject;
        this.phpVisibilityQuery = PhpVisibilityQuery.forProject(phpProject);
        this.nbprojectDir = phpProject.getProjectDirectory().getFileObject("nbproject");
        assert (this.nbprojectDir != null) : "No nbproject directory found for " + phpProject;
        assert (this.nbprojectDir.isFolder() && this.nbprojectDir.isValid()) : "Not valid nbproject directory found for " + phpProject;
    }

    final Callable<Boolean> createInitHandler(FileObject fileObject) {
        if (this.isInvalid()) {
            this.getLogger().log(Level.FINE, "No INIT handler, File Operation Factory invalid for project {0}", this.project.getName());
            return null;
        }
        return this.createInitHandlerInternal(fileObject);
    }

    final Callable<Boolean> createCopyHandler(FileObject fileObject) {
        if (this.isInvalid()) {
            this.getLogger().log(Level.FINE, "No CREATE handler, File Operation Factory invalid for project {0}", this.project.getName());
            return null;
        }
        return this.createCopyHandlerInternal(fileObject);
    }

    final Callable<Boolean> createRenameHandler(FileObject fileObject, String string) {
        if (this.isInvalid()) {
            this.getLogger().log(Level.FINE, "No RENAME handler, File Operation Factory invalid for project {0}", this.project.getName());
            return null;
        }
        return this.createRenameHandlerInternal(fileObject, string);
    }

    final Callable<Boolean> createDeleteHandler(FileObject fileObject) {
        if (this.isInvalid()) {
            this.getLogger().log(Level.FINE, "No DELETE handler, File Operation Factory invalid for project {0}", this.project.getName());
            return null;
        }
        return this.createDeleteHandlerInternal(fileObject);
    }

    abstract Logger getLogger();

    protected abstract boolean isEnabled();

    protected abstract Callable<Boolean> createInitHandlerInternal(FileObject var1);

    protected abstract Callable<Boolean> createCopyHandlerInternal(FileObject var1);

    protected abstract Callable<Boolean> createRenameHandlerInternal(FileObject var1, String var2);

    protected abstract Callable<Boolean> createDeleteHandlerInternal(FileObject var1);

    final void reset() {
        this.factoryError = false;
        this.resetInternal();
    }

    protected void resetInternal() {
    }

    final void invalidate() {
        this.factoryError = true;
    }

    final boolean isInvalid() {
        return this.factoryError;
    }

    protected final boolean isSourceFileValid(FileObject fileObject) {
        assert (CommandUtils.isUnderSources(this.project, fileObject)) : String.format("File %s not underneath sources of project %s", FileOperationFactory.getPath(fileObject), this.project.getName());
        return !this.isNbProjectMetadata(fileObject) && PhpProjectUtils.isVisible(this.phpVisibilityQuery, fileObject);
    }

    boolean isNbProjectMetadata(FileObject fileObject) {
        return FileUtil.isParentOf((FileObject)this.nbprojectDir, (FileObject)fileObject) || this.nbprojectDir.equals(fileObject);
    }

    protected FileObject getSources() {
        return ProjectPropertiesSupport.getSourcesDirectory(this.project);
    }

    protected static String getPath(FileObject fileObject) {
        return FileUtil.getFileDisplayName((FileObject)fileObject);
    }

    protected boolean askUser(String string) {
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string, this.project.getName(), 0));
        return object.equals(0);
    }

    protected void showCustomizer() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((CustomizerProviderImpl)FileOperationFactory.this.project.getLookup().lookup(CustomizerProviderImpl.class)).showCustomizer("Sources");
            }
        });
    }
}

