/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.environment;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WindowsPhpEnvironment
extends PhpEnvironment {
    private static final String PHP = "php.exe";
    private static final String XAMPP = "xampp";
    private static final FilenameFilter XAMPP_FILENAME_FILTER = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return string.toLowerCase().startsWith(WindowsPhpEnvironment.XAMPP);
        }
    };

    WindowsPhpEnvironment() {
    }

    @Override
    protected List<PhpEnvironment.DocumentRoot> getDocumentRoots(String string) {
        File[] fileArray = File.listRoots();
        if (fileArray == null) {
            return Collections.emptyList();
        }
        File file = null;
        for (File file2 : fileArray) {
            LOGGER.fine("FS root: " + file2);
            if (WindowsPhpEnvironment.isFloppy(file2)) {
                LOGGER.fine("Skipping floppy: " + file2);
                continue;
            }
            File file3 = new File(file2, "Program Files");
            file = WindowsPhpEnvironment.findHtDocsDirectory(file3, APACHE_FILENAME_FILTER);
            if (file != null || (file = new File(new File(file2, XAMPP), "htdocs")).isDirectory() || (file = WindowsPhpEnvironment.findHtDocsDirectory(file3, XAMPP_FILENAME_FILTER)) != null) break;
        }
        if (file != null) {
            String string2 = WindowsPhpEnvironment.getFolderName(file, string);
            String string3 = WindowsPhpEnvironment.getDefaultUrl(string);
            String string4 = NbBundle.getMessage(WindowsPhpEnvironment.class, (String)"TXT_HtDocs");
            return Arrays.asList(new PhpEnvironment.DocumentRoot(string2, string3, string4, Utils.isFolderWritable(file)));
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getAllPhpInterpreters() {
        return WindowsPhpEnvironment.getAllPhpInterpreters(PHP);
    }

    @Override
    public List<String> getAllPhpUnits() {
        return FileUtils.findFileOnUsersPath((String)"phpunit.bat");
    }

    private static boolean isFloppy(File file) {
        String string = file.getAbsolutePath();
        LOGGER.fine("Testing floppy on " + string);
        return string.toLowerCase().startsWith("a:") || string.toLowerCase().startsWith("b:");
    }
}

