/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.phpunit;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.phpunit.PhpUnitOptionsPanel;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class PhpUnitOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private PhpUnitOptionsPanel phpUnitOptionsPanel = null;
    private volatile boolean changed = false;

    public void update() {
        this.phpUnitOptionsPanel.setPhpUnit(this.getPhpOptions().getPhpUnit());
        this.changed = false;
    }

    public void applyChanges() {
        this.getPhpOptions().setPhpUnit(this.phpUnitOptionsPanel.getPhpUnit());
        this.changed = false;
    }

    public void cancel() {
    }

    public boolean isValid() {
        PhpUnit.resetVersion();
        PhpUnit phpUnit = null;
        try {
            phpUnit = PhpUnit.getCustom(this.phpUnitOptionsPanel.getPhpUnit());
        }
        catch (PhpProgram.InvalidPhpProgramException invalidPhpProgramException) {
            this.phpUnitOptionsPanel.setWarning(invalidPhpProgramException.getLocalizedMessage());
            return true;
        }
        assert (phpUnit != null);
        String string = PhpUnit.validateVersion(phpUnit);
        if (string != null) {
            this.phpUnitOptionsPanel.setWarning(string);
            return true;
        }
        this.phpUnitOptionsPanel.setError(" ");
        return true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public JComponent getComponent(Lookup lookup) {
        if (this.phpUnitOptionsPanel == null) {
            this.phpUnitOptionsPanel = new PhpUnitOptionsPanel();
            this.phpUnitOptionsPanel.addChangeListener(this);
        }
        return this.phpUnitOptionsPanel;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private PhpOptions getPhpOptions() {
        return PhpOptions.getInstance();
    }
}

