/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.openide.util.ChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalServer
implements Comparable<LocalServer> {
    public static final LocalServer PENDING_LOCAL_SERVER = new LocalServer(PhpEnvironment.PENDING_DOCUMENT_ROOT.getDocumentRoot());
    private final String virtualHost;
    private final String url;
    private final String documentRoot;
    private final boolean editable;
    private String hint = " ";
    private String srcRoot;

    public static LocalServer getEmpty() {
        return new LocalServer("", "");
    }

    public LocalServer(LocalServer localServer) {
        this(localServer.virtualHost, localServer.documentRoot, localServer.srcRoot, localServer.editable);
    }

    public LocalServer(String string) {
        this(null, null, string);
    }

    public LocalServer(String string, String string2) {
        this(null, string, string2);
    }

    public LocalServer(String string, String string2, String string3) {
        this(string, string2, string3, true);
    }

    public LocalServer(String string, String string2, String string3, boolean bl) {
        this(string, null, string2, string3, bl);
    }

    public LocalServer(String string, String string2, String string3, String string4, boolean bl) {
        this.virtualHost = string;
        this.url = string2;
        this.documentRoot = string3;
        this.srcRoot = string4;
        this.editable = bl;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDocumentRoot() {
        return this.documentRoot;
    }

    public String getSrcRoot() {
        return this.srcRoot;
    }

    public void setSrcRoot(String string) {
        if (!this.editable) {
            throw new IllegalStateException("srcRoot cannot be changed because instance is not editable");
        }
        this.srcRoot = string;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isPending() {
        return this == PENDING_LOCAL_SERVER;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String string) {
        this.hint = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[virtualHost: ");
        stringBuilder.append(this.virtualHost);
        stringBuilder.append(", url: ");
        stringBuilder.append(this.url);
        stringBuilder.append(", documentRoot: ");
        stringBuilder.append(this.documentRoot);
        stringBuilder.append(", srcRoot: ");
        stringBuilder.append(this.srcRoot);
        stringBuilder.append(", hint: ");
        stringBuilder.append(this.hint);
        stringBuilder.append(", editable: ");
        stringBuilder.append(this.editable);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(LocalServer localServer) {
        if (!this.editable) {
            return -1;
        }
        return this.srcRoot.compareTo(localServer.getSrcRoot());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LocalServer localServer = (LocalServer)object;
        if (!(this.virtualHost == localServer.virtualHost || this.virtualHost != null && this.virtualHost.equals(localServer.virtualHost))) {
            return false;
        }
        if (!(this.documentRoot == localServer.documentRoot || this.documentRoot != null && this.documentRoot.equals(localServer.documentRoot))) {
            return false;
        }
        if (this.editable != localServer.editable) {
            return false;
        }
        return this.srcRoot == localServer.srcRoot || this.srcRoot != null && this.srcRoot.equals(localServer.srcRoot);
    }

    public int hashCode() {
        int n = 7;
        n = 97 * n + (this.virtualHost != null ? this.virtualHost.hashCode() : 0);
        n = 97 * n + (this.documentRoot != null ? this.documentRoot.hashCode() : 0);
        n = 97 * n + (this.editable ? 1 : 0);
        n = 97 * n + (this.srcRoot != null ? this.srcRoot.hashCode() : 0);
        return n;
    }

    public static class ComboBoxEditor
    implements javax.swing.ComboBoxEditor,
    UIResource,
    DocumentListener {
        private static final long serialVersionUID = -4527321803090719483L;
        private final JTextField component;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private LocalServer activeItem = null;

        public ComboBoxEditor(JTextField jTextField) {
            this.component = jTextField;
            this.component.getDocument().addDocumentListener(this);
        }

        public Component getEditorComponent() {
            return this.component;
        }

        public void setItem(Object object) {
            if (object == null) {
                return;
            }
            assert (object instanceof LocalServer);
            this.activeItem = (LocalServer)object;
            this.component.setText(this.activeItem.getSrcRoot());
        }

        public Object getItem() {
            return new LocalServer(this.activeItem);
        }

        public void selectAll() {
            this.component.selectAll();
            this.component.requestFocus();
        }

        public void addActionListener(ActionListener actionListener) {
            this.component.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.component.removeActionListener(actionListener);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        private void processUpdate() {
            if (this.activeItem == null) {
                return;
            }
            boolean bl = false;
            if (this.activeItem.isEditable()) {
                bl = true;
                this.activeItem.setSrcRoot(this.component.getText().trim());
            }
            this.component.setEnabled(bl);
            this.changeSupport.fireChange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComboBoxModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        private static final long serialVersionUID = 194511142310432557L;
        private final List<LocalServer> data;
        private LocalServer selected = null;

        public ComboBoxModel(LocalServer ... localServerArray) {
            if (localServerArray == null || localServerArray.length == 0) {
                localServerArray = new LocalServer[]{LocalServer.getEmpty()};
            }
            this.data = new ArrayList<LocalServer>(2 * localServerArray.length);
            for (LocalServer localServer : localServerArray) {
                this.data.add(localServer);
            }
            this.selected = this.data.get(0);
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public LocalServer getElementAt(int n) {
            return this.data.get(n);
        }

        public void addElement(Object object) {
            assert (object instanceof LocalServer);
            LocalServer localServer = (LocalServer)object;
            if (!this.data.add(localServer)) {
                return;
            }
            Collections.sort(this.data);
            int n = this.indexOf(localServer);
            this.fireIntervalAdded(this, n, n);
        }

        public void insertElementAt(Object object, int n) {
            assert (object instanceof LocalServer);
            LocalServer localServer = (LocalServer)object;
            this.data.add(n, localServer);
            this.fireIntervalAdded(this, n, n);
        }

        public int indexOf(LocalServer localServer) {
            return this.data.indexOf(localServer);
        }

        @Override
        public void removeElement(Object object) {
            assert (object instanceof LocalServer);
            LocalServer localServer = (LocalServer)object;
            int n = this.indexOf(localServer);
            if (n == -1) {
                return;
            }
            boolean bl = this.data.remove(localServer);
            assert (bl);
            this.fireIntervalRemoved(this, n, n);
        }

        @Override
        public void removeElementAt(int n) {
            if (this.getElementAt(n) == this.selected) {
                if (n == 0) {
                    this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(n + 1));
                } else {
                    this.setSelectedItem(this.getElementAt(n - 1));
                }
            }
            this.data.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }

        @Override
        public void setSelectedItem(Object object) {
            if (this.selected != null && !this.selected.equals(object) || this.selected == null && object != null) {
                assert (object == null || object instanceof LocalServer) : "Trying to set object of type: " + object.getClass().getName();
                this.selected = (LocalServer)object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        public List<LocalServer> getElements() {
            return Collections.unmodifiableList(this.data);
        }

        public void setElements(List<LocalServer> list) {
            int n = this.data.size();
            this.data.clear();
            if (n > 0) {
                this.fireIntervalRemoved(this, 0, n - 1);
            }
            if (list.size() > 0) {
                this.data.addAll(list);
                Collections.sort(this.data);
                this.fireIntervalAdded(this, 0, this.data.size() - 1);
            }
        }
    }

    public static class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private static final long serialVersionUID = 31965318763243602L;

        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            if (object != null) {
                assert (object instanceof LocalServer);
                String string = ((LocalServer)object).getSrcRoot();
                this.setText(string.length() == 0 ? " " : string);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

