/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathUiSupport {
    private PathUiSupport() {
    }

    public static DefaultListModel createListModel(Iterator<BasePathSupport.Item> iterator) {
        DefaultListModel<BasePathSupport.Item> defaultListModel = new DefaultListModel<BasePathSupport.Item>();
        while (iterator.hasNext()) {
            defaultListModel.addElement(iterator.next());
        }
        return defaultListModel;
    }

    public static Iterator<BasePathSupport.Item> getIterator(DefaultListModel defaultListModel) {
        return PathUiSupport.getList(defaultListModel).iterator();
    }

    public static List<BasePathSupport.Item> getList(DefaultListModel defaultListModel) {
        return Collections.list(NbCollections.checkedEnumerationByFilter(defaultListModel.elements(), BasePathSupport.Item.class, (boolean)true));
    }

    public static int[] moveUp(DefaultListModel defaultListModel, int[] nArray) {
        int n;
        if (nArray == null || nArray.length == 0) assert (false) : "MoveUp button should be disabled";
        for (n = 0; n < nArray.length; ++n) {
            Object e = defaultListModel.get(nArray[n]);
            defaultListModel.remove(nArray[n]);
            defaultListModel.add(nArray[n] - 1, e);
        }
        n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] - 1;
        }
        return nArray;
    }

    public static boolean canMoveUp(ListSelectionModel listSelectionModel) {
        return listSelectionModel.getMinSelectionIndex() > 0;
    }

    public static int[] moveDown(DefaultListModel defaultListModel, int[] nArray) {
        int n;
        if (nArray == null || nArray.length == 0) assert (false) : "MoveDown button should be disabled";
        for (n = nArray.length - 1; n >= 0; --n) {
            Object e = defaultListModel.get(nArray[n]);
            defaultListModel.remove(nArray[n]);
            defaultListModel.add(nArray[n] + 1, e);
        }
        n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] + 1;
        }
        return nArray;
    }

    public static boolean canMoveDown(ListSelectionModel listSelectionModel, int n) {
        int n2 = listSelectionModel.getMaxSelectionIndex();
        return n2 != -1 && n2 < n - 1;
    }

    public static int[] remove(DefaultListModel defaultListModel, int[] nArray) {
        int n;
        if (nArray == null || nArray.length == 0) assert (false) : "Remove button should be disabled";
        for (n = nArray.length - 1; n >= 0; --n) {
            defaultListModel.remove(nArray[n]);
        }
        if (!defaultListModel.isEmpty()) {
            n = nArray[nArray.length - 1] - nArray.length + 1;
            if (n > defaultListModel.size() - 1) {
                n = defaultListModel.size() - 1;
            }
            return new int[]{n};
        }
        return new int[0];
    }

    public static int[] addFolders(DefaultListModel defaultListModel, int[] nArray, String[] stringArray) {
        int n = nArray == null || nArray.length == 0 ? defaultListModel.getSize() - 1 : nArray[nArray.length - 1];
        int[] nArray2 = new int[stringArray.length];
        int n2 = 0;
        int n3 = 0;
        while (n2 + n3 < stringArray.length) {
            int n4 = n + 1 + n2;
            BasePathSupport.Item item = BasePathSupport.Item.create(stringArray[n2 + n3], null);
            if (!defaultListModel.contains(item)) {
                defaultListModel.add(n4, item);
                nArray2[n3 + n2] = n4;
                ++n2;
                continue;
            }
            nArray2[n2 + n3] = defaultListModel.indexOf(item);
            ++n3;
        }
        return nArray2;
    }

    public static class ClassPathListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 619725480128831307L;
        private static final String RESOURCE_ICON_BROKEN_BADGE = "org/netbeans/modules/php/project/ui/resources/brokenProjectBadge.gif";
        private static final String RESOURCE_ICON_CLASSPATH = "org/netbeans/modules/php/project/ui/resources/referencedClasspath.gif";
        private static final ImageIcon ICON_BROKEN_BADGE = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/brokenProjectBadge.gif", (boolean)false);
        private static final ImageIcon ICON_CLASSPATH = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/referencedClasspath.gif", (boolean)false);
        private static ImageIcon ICON_FOLDER = null;
        private static ImageIcon ICON_BROKEN_FOLDER = null;
        private final PropertyEvaluator evaluator;
        private final FileObject projectFolder;
        private static final Map<String, String> WELL_KNOWN_PATHS_NAMES = new HashMap<String, String>();

        public ClassPathListCellRenderer() {
            this(null, null);
        }

        public ClassPathListCellRenderer(PropertyEvaluator propertyEvaluator, FileObject fileObject) {
            this.evaluator = propertyEvaluator;
            this.projectFolder = fileObject;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            BasePathSupport.Item item = (BasePathSupport.Item)object;
            super.getListCellRendererComponent((JList<?>)jList, this.getDisplayName(item), n, bl, bl2);
            this.setIcon(ClassPathListCellRenderer.getIcon(item));
            this.setToolTipText(this.getToolTipText(item));
            return this;
        }

        private String getDisplayName(BasePathSupport.Item item) {
            switch (item.getType()) {
                case CLASSPATH: {
                    String string = WELL_KNOWN_PATHS_NAMES.get(BasePathSupport.getAntPropertyName(item.getReference()));
                    return string == null ? item.getReference() : string;
                }
            }
            if (item.isBroken()) {
                return NbBundle.getMessage(PathUiSupport.class, (String)"LBL_MissingFile", (Object)this.getFileRefName(item));
            }
            File file = new File(item.getFilePath());
            if (file.isAbsolute()) {
                return file.getAbsolutePath();
            }
            return PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.projectFolder), (String)item.getFilePath()).getAbsolutePath();
        }

        private static Icon getIcon(BasePathSupport.Item item) {
            switch (item.getType()) {
                case CLASSPATH: {
                    return ICON_CLASSPATH;
                }
            }
            if (item.isBroken()) {
                if (ICON_BROKEN_FOLDER == null) {
                    ICON_BROKEN_FOLDER = new ImageIcon(ImageUtilities.mergeImages((Image)ClassPathListCellRenderer.getFolderIcon().getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                }
                return ICON_BROKEN_FOLDER;
            }
            return ClassPathListCellRenderer.getFolderIcon();
        }

        private String getToolTipText(BasePathSupport.Item item) {
            switch (item.getType()) {
                case FOLDER: {
                    if (item.isBroken()) {
                        if (this.evaluator != null) {
                            return this.evaluator.evaluate(item.getReference());
                        }
                        return item.getReference();
                    }
                    String string = item.getFilePath();
                    File file = new File(string);
                    if (file.isAbsolute()) break;
                    assert (this.projectFolder != null) : "project folder cannot be null because not absolute path given [" + file + "]";
                    file = PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.projectFolder), (String)string);
                    return file.getAbsolutePath();
                }
            }
            return null;
        }

        private static ImageIcon getFolderIcon() {
            if (ICON_FOLDER == null) {
                DataFolder dataFolder = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot());
                ICON_FOLDER = new ImageIcon(dataFolder.getNodeDelegate().getIcon(1));
            }
            return ICON_FOLDER;
        }

        private String getFileRefName(BasePathSupport.Item item) {
            switch (item.getType()) {
                case FOLDER: {
                    return item.getFilePath();
                }
            }
            return item.getReference();
        }

        static {
            WELL_KNOWN_PATHS_NAMES.put("php.global.include.path", NbBundle.getMessage(PathUiSupport.class, (String)"LBL_GlobalIncludePath_DisplayName"));
        }
    }

    public static final class EditMediator
    implements ActionListener,
    ListSelectionListener {
        private final PhpProject project;
        private final JList list;
        private final DefaultListModel listModel;
        private final ListSelectionModel selectionModel;
        private final ButtonModel addFolder;
        private final ButtonModel remove;
        private final ButtonModel moveUp;
        private final ButtonModel moveDown;
        private final FileChooserDirectoryHandler directoryHandler;

        private EditMediator(JList jList, ButtonModel buttonModel, ButtonModel buttonModel2, ButtonModel buttonModel3, ButtonModel buttonModel4, FileChooserDirectoryHandler fileChooserDirectoryHandler) {
            this(null, jList, buttonModel, buttonModel2, buttonModel3, buttonModel4, fileChooserDirectoryHandler);
        }

        private EditMediator(PhpProject phpProject, JList jList, ButtonModel buttonModel, ButtonModel buttonModel2, FileChooserDirectoryHandler fileChooserDirectoryHandler) {
            this(phpProject, jList, buttonModel, buttonModel2, null, null, fileChooserDirectoryHandler);
        }

        private EditMediator(PhpProject phpProject, JList jList, ButtonModel buttonModel, ButtonModel buttonModel2, ButtonModel buttonModel3, ButtonModel buttonModel4, FileChooserDirectoryHandler fileChooserDirectoryHandler) {
            assert (fileChooserDirectoryHandler != null);
            this.list = jList;
            if (!(jList.getModel() instanceof DefaultListModel)) {
                throw new IllegalArgumentException("The list's model has to be of class DefaultListModel");
            }
            this.listModel = (DefaultListModel)jList.getModel();
            this.selectionModel = jList.getSelectionModel();
            this.addFolder = buttonModel;
            this.remove = buttonModel2;
            this.moveUp = buttonModel3;
            this.moveDown = buttonModel4;
            this.project = phpProject;
            this.directoryHandler = fileChooserDirectoryHandler;
        }

        public static void register(PhpProject phpProject, JList jList, ButtonModel buttonModel, ButtonModel buttonModel2, ButtonModel buttonModel3, ButtonModel buttonModel4, FileChooserDirectoryHandler fileChooserDirectoryHandler) {
            EditMediator editMediator = new EditMediator(phpProject, jList, buttonModel, buttonModel2, buttonModel3, buttonModel4, fileChooserDirectoryHandler);
            buttonModel.addActionListener(editMediator);
            buttonModel2.addActionListener(editMediator);
            buttonModel3.addActionListener(editMediator);
            buttonModel4.addActionListener(editMediator);
            editMediator.selectionModel.addListSelectionListener(editMediator);
            editMediator.valueChanged(null);
        }

        public static void register(PhpProject phpProject, JList jList, ButtonModel buttonModel, ButtonModel buttonModel2, FileChooserDirectoryHandler fileChooserDirectoryHandler) {
            EditMediator editMediator = new EditMediator(phpProject, jList, buttonModel, buttonModel2, fileChooserDirectoryHandler);
            buttonModel.addActionListener(editMediator);
            buttonModel2.addActionListener(editMediator);
            editMediator.selectionModel.addListSelectionListener(editMediator);
            editMediator.valueChanged(null);
        }

        public static void register(JList jList, ButtonModel buttonModel, ButtonModel buttonModel2, ButtonModel buttonModel3, ButtonModel buttonModel4, FileChooserDirectoryHandler fileChooserDirectoryHandler) {
            EditMediator editMediator = new EditMediator(jList, buttonModel, buttonModel2, buttonModel3, buttonModel4, fileChooserDirectoryHandler);
            buttonModel.addActionListener(editMediator);
            buttonModel2.addActionListener(editMediator);
            buttonModel3.addActionListener(editMediator);
            buttonModel4.addActionListener(editMediator);
            editMediator.selectionModel.addListSelectionListener(editMediator);
            editMediator.valueChanged(null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.addFolder) {
                this.addFolders();
            } else if (object == this.remove) {
                int[] nArray = PathUiSupport.remove(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(nArray);
            } else if (this.moveUp != null && object == this.moveUp) {
                int[] nArray = PathUiSupport.moveUp(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(nArray);
            } else if (this.moveDown != null && object == this.moveDown) {
                int[] nArray = PathUiSupport.moveDown(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(nArray);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.remove.setEnabled(this.selectionModel.getMinSelectionIndex() != -1);
            if (this.moveUp != null) {
                this.moveUp.setEnabled(PathUiSupport.canMoveUp(this.selectionModel));
            }
            if (this.moveDown != null) {
                this.moveDown.setEnabled(PathUiSupport.canMoveDown(this.selectionModel, this.listModel.getSize()));
            }
        }

        private void addFolders() {
            JFileChooser jFileChooser = null;
            jFileChooser = this.project != null ? new FileChooser(this.project.getHelper(), false) : new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setDialogTitle(NbBundle.getMessage(PathUiSupport.class, (String)"LBL_AddFolders_DialogTitle"));
            jFileChooser.setCurrentDirectory(this.directoryHandler.getCurrentDirectory());
            int n = jFileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(this.list));
            if (n == 0) {
                Object[] objectArray;
                String[] stringArray;
                try {
                    if (jFileChooser instanceof FileChooser) {
                        stringArray = ((FileChooser)jFileChooser).getSelectedPaths();
                    } else {
                        objectArray = jFileChooser.getSelectedFiles();
                        stringArray = new String[objectArray.length];
                        for (int i = 0; i < objectArray.length; ++i) {
                            stringArray[i] = objectArray[i].getAbsolutePath();
                        }
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    return;
                }
                objectArray = PathUiSupport.addFolders(this.listModel, this.list.getSelectedIndices(), stringArray);
                this.list.setSelectedIndices((int[])objectArray);
                this.directoryHandler.setCurrentDirectory(jFileChooser.getCurrentDirectory());
            }
        }

        public static interface FileChooserDirectoryHandler {
            public File getCurrentDirectory();

            public void setCurrentDirectory(File var1);
        }
    }
}

