/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.TransferInfo;
import org.netbeans.modules.php.project.connections.ui.TransferFilter;
import org.netbeans.modules.php.project.ui.actions.RemoteCommand;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.Displayable;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadCommand
extends RemoteCommand
implements Displayable {
    public static final String ID = "download";
    public static final String DISPLAY_NAME = NbBundle.getMessage(DownloadCommand.class, (String)"LBL_DownloadCommand");

    public DownloadCommand(PhpProject phpProject) {
        super(phpProject);
    }

    @Override
    public String getCommandId() {
        return ID;
    }

    @Override
    protected Runnable getContextRunnable(final Lookup lookup) {
        return new Runnable(){

            public void run() {
                DownloadCommand.this.invokeActionImpl(lookup);
            }
        };
    }

    void invokeActionImpl(Lookup lookup) {
        FileObject[] fileObjectArray = CommandUtils.filesForContextOrSelectedNodes(lookup);
        if (fileObjectArray.length == 0) {
            return;
        }
        FileObject fileObject = ProjectPropertiesSupport.getSourcesDirectory(this.getProject());
        if (!this.sourcesFilesOnly(fileObject, fileObjectArray)) {
            return;
        }
        InputOutput inputOutput = DownloadCommand.getRemoteLog(this.getRemoteConfiguration().getDisplayName());
        RemoteCommand.DefaultOperationMonitor defaultOperationMonitor = new RemoteCommand.DefaultOperationMonitor("LBL_Downloading");
        RemoteClient remoteClient = this.getRemoteClient(inputOutput, defaultOperationMonitor);
        DownloadCommand.download(remoteClient, inputOutput, defaultOperationMonitor, this.getProject().getName(), true, fileObject, fileObjectArray);
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public static void download(RemoteClient remoteClient, InputOutput inputOutput, RemoteCommand.DefaultOperationMonitor defaultOperationMonitor, String string, FileObject fileObject, Set<TransferFile> set) {
        DownloadCommand.download(remoteClient, inputOutput, defaultOperationMonitor, string, false, fileObject, null, set);
    }

    public static void download(RemoteClient remoteClient, InputOutput inputOutput, RemoteCommand.DefaultOperationMonitor defaultOperationMonitor, String string, boolean bl, FileObject fileObject, FileObject ... fileObjectArray) {
        DownloadCommand.download(remoteClient, inputOutput, defaultOperationMonitor, string, bl, fileObject, fileObjectArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void download(RemoteClient remoteClient, InputOutput inputOutput, RemoteCommand.DefaultOperationMonitor defaultOperationMonitor, String string, boolean bl, FileObject fileObject, FileObject[] fileObjectArray, Set<TransferFile> set) {
        block16: {
            TransferInfo transferInfo;
            ProgressHandle progressHandle;
            block14: {
                Set<TransferFile> set2;
                String string2 = NbBundle.getMessage(DownloadCommand.class, (String)"MSG_DownloadingFiles", (Object)string);
                progressHandle = ProgressHandleFactory.createHandle((String)string2, (Cancellable)remoteClient);
                transferInfo = null;
                progressHandle.start();
                Set<TransferFile> set3 = set2 = set != null ? set : remoteClient.prepareDownload(fileObject, fileObjectArray);
                if (bl) {
                    remoteClient.disconnect();
                    set2 = TransferFilter.showDownloadDialog(set2);
                }
                if (set2.size() <= 0) break block14;
                progressHandle.finish();
                defaultOperationMonitor.progressHandle = progressHandle = ProgressHandleFactory.createHandle((String)string2, (Cancellable)remoteClient);
                int n = DownloadCommand.getWorkUnits(set2);
                if (n > 0) {
                    progressHandle.start(n);
                } else {
                    progressHandle.start();
                }
                transferInfo = remoteClient.download(fileObject, set2);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DownloadCommand.class, (String)"MSG_DownloadFinished", (Object)string));
            }
            Object var14_14 = null;
            try {
                remoteClient.disconnect();
            }
            catch (RemoteException remoteException) {
                DownloadCommand.processRemoteException(remoteException);
            }
            if (transferInfo != null) {
                DownloadCommand.processTransferInfo(transferInfo, inputOutput);
            }
            progressHandle.finish();
            {
                break block16;
                catch (RemoteException remoteException) {
                    DownloadCommand.processRemoteException(remoteException);
                    Object var14_15 = null;
                    try {
                        remoteClient.disconnect();
                    }
                    catch (RemoteException remoteException2) {
                        DownloadCommand.processRemoteException(remoteException2);
                    }
                    if (transferInfo != null) {
                        DownloadCommand.processTransferInfo(transferInfo, inputOutput);
                    }
                    progressHandle.finish();
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    remoteClient.disconnect();
                }
                catch (RemoteException remoteException) {
                    DownloadCommand.processRemoteException(remoteException);
                }
                if (transferInfo != null) {
                    DownloadCommand.processTransferInfo(transferInfo, inputOutput);
                }
                progressHandle.finish();
                throw throwable;
            }
        }
    }
}

