/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.actions.RunProjectCommand;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.Displayable;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class RunFileCommand
extends Command
implements Displayable {
    public static final String ID = "run.single";
    public static final String DISPLAY_NAME = RunProjectCommand.DISPLAY_NAME;

    public RunFileCommand(PhpProject phpProject) {
        super(phpProject);
    }

    public void invokeAction(Lookup lookup) {
        FileObject fileObject = CommandUtils.fileForContextOrSelectedNodes(lookup);
        if (this.isSeleniumFile(fileObject)) {
            ConfigAction.get(ConfigAction.Type.SELENIUM, this.getProject()).runFile(lookup);
        } else if (this.isTestFile(fileObject)) {
            ConfigAction.get(ConfigAction.Type.TEST, this.getProject()).runFile(lookup);
        } else {
            ConfigAction configAction = this.getConfigAction();
            if (!configAction.isValid(false)) {
                return;
            }
            configAction.runFile(lookup);
        }
    }

    public boolean isActionEnabled(Lookup lookup) {
        FileObject fileObject = CommandUtils.fileForContextOrSelectedNodes(lookup);
        if (this.isSeleniumFile(fileObject)) {
            return ConfigAction.get(ConfigAction.Type.SELENIUM, this.getProject()).isRunFileEnabled(lookup);
        }
        if (this.isTestFile(fileObject)) {
            return ConfigAction.get(ConfigAction.Type.TEST, this.getProject()).isRunFileEnabled(lookup);
        }
        return this.getConfigAction().isRunFileEnabled(lookup);
    }

    public String getCommandId() {
        return ID;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }
}

