/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunScript {
    protected static final Logger LOGGER = Logger.getLogger(RunScript.class.getName());
    private final Provider provider;

    public RunScript(Provider provider) {
        assert (provider != null);
        this.provider = provider;
    }

    public void run() {
        try {
            this.getCallable().call();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    protected final Callable<Cancellable> getCallable() {
        return new Callable<Cancellable>(){

            @Override
            public Cancellable call() throws Exception {
                if (!RunScript.this.provider.isValid()) {
                    LOGGER.info("RunScript provider is not valid");
                    return new Cancellable(){

                        public boolean cancel() {
                            return true;
                        }
                    };
                }
                final Future future = PhpProgram.executeLater((ExternalProcessBuilder)RunScript.this.getProcessBuilder(), (ExecutionDescriptor)RunScript.this.getDescriptor(), (String)RunScript.this.getOutputTabTitle());
                return new Cancellable(){

                    public boolean cancel() {
                        return future.cancel(true);
                    }
                };
            }
        };
    }

    protected boolean isControllable() {
        return true;
    }

    protected ExecutionDescriptor getDescriptor() throws IOException {
        return this.provider.getDescriptor().controllable(this.isControllable());
    }

    protected ExternalProcessBuilder getProcessBuilder() {
        return this.provider.getProcessBuilder();
    }

    protected String getOutputTabTitle() {
        return this.provider.getOutputTabTitle();
    }

    public static final class InOutPostRedirector
    implements ExecutionDescriptor.InputProcessorFactory,
    Runnable {
        private final File tmpFile;
        private final Charset encoding;
        private BufferedWriter fileWriter;

        public InOutPostRedirector(File file) throws IOException {
            assert (file != null);
            this.tmpFile = FileUtil.normalizeFile((File)InOutPostRedirector.tempFileForScript(file));
            this.encoding = FileEncodingQuery.getEncoding((FileObject)FileUtil.toFileObject((File)file));
        }

        public InputProcessor newInputProcessor(final InputProcessor inputProcessor) {
            return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{inputProcessor, new InputProcessor(){

                public void processInput(char[] cArray) throws IOException {
                    InOutPostRedirector.this.getFileWriter().write(cArray);
                }

                public void reset() throws IOException {
                    inputProcessor.reset();
                }

                public void close() throws IOException {
                    InOutPostRedirector.this.getFileWriter().flush();
                    InOutPostRedirector.this.getFileWriter().close();
                    inputProcessor.close();
                }
            }});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: {
                try {
                    block8: {
                        try {
                            PhpOptions phpOptions = PhpOptions.getInstance();
                            if (phpOptions.isOpenResultInBrowser()) {
                                HtmlBrowser.URLDisplayer.getDefault().showURL(this.tmpFile.toURI().toURL());
                            }
                            if (!phpOptions.isOpenResultInEditor()) break block8;
                            FileObject fileObject = FileUtil.toFileObject((File)this.tmpFile);
                            DataObject dataObject = DataObject.find((FileObject)fileObject);
                            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                            editorCookie.open();
                        }
                        catch (MalformedURLException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                            Object var6_10 = null;
                            this.setFileWriter(null);
                            break block9;
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                            Object var6_11 = null;
                            this.setFileWriter(null);
                            break block9;
                        }
                        catch (CancellationException cancellationException) {
                            Object var6_12 = null;
                            this.setFileWriter(null);
                            break block9;
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                            Object var6_13 = null;
                            this.setFileWriter(null);
                        }
                    }
                    Object var6_9 = null;
                    this.setFileWriter(null);
                }
                catch (Throwable throwable) {
                    Object var6_14 = null;
                    this.setFileWriter(null);
                    throw throwable;
                }
            }
        }

        public synchronized BufferedWriter getFileWriter() throws FileNotFoundException {
            if (this.fileWriter == null) {
                this.fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.tmpFile), this.encoding));
            }
            return this.fileWriter;
        }

        public synchronized void setFileWriter(BufferedWriter bufferedWriter) {
            this.fileWriter = bufferedWriter;
        }

        private static File tempFileForScript(File file) throws IOException {
            File file2 = File.createTempFile(file.getName(), ".html");
            file2.deleteOnExit();
            return file2;
        }
    }

    public static interface Provider {
        public ExecutionDescriptor getDescriptor() throws IOException;

        public ExternalProcessBuilder getProcessBuilder();

        public String getOutputTabTitle();

        public boolean isValid();
    }
}

