/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.codecoverage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.codecoverage.api.CoverageManager;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProviderHelper;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.codecoverage.CoverageVO;
import org.netbeans.modules.php.project.ui.codecoverage.PhpFileCoverageDetails;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PhpCoverageProvider
implements CoverageProvider {
    private static final Logger LOGGER = Logger.getLogger(PhpCoverageProvider.class.getName());
    private static final Set<String> MIME_TYPES = Collections.singleton("text/x-php5");
    private final Object lock = new Object();
    private final PhpProject project;
    private final PhpVisibilityQuery phpVisibilityQuery;
    private Boolean enabled = null;
    private CoverageVO coverage = null;

    public PhpCoverageProvider(PhpProject phpProject) {
        assert (phpProject != null);
        this.project = phpProject;
        this.phpVisibilityQuery = PhpVisibilityQuery.forProject(phpProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoverage(CoverageVO coverageVO) {
        assert (coverageVO != null);
        assert (this.isEnabled()) : "Coverage provider must be enabled";
        Object object = this.lock;
        synchronized (object) {
            this.coverage = coverageVO;
        }
        CoverageManager.INSTANCE.resultsUpdated((Project)this.project, (CoverageProvider)this);
    }

    public void updateCoverage(CoverageVO coverageVO) {
        assert (coverageVO != null);
        assert (this.isEnabled()) : "Coverage provider must be enabled";
        CoverageVO coverageVO2 = this.getCoverage();
        if (coverageVO2 == null) {
            this.setCoverage(coverageVO);
            return;
        }
        List<CoverageVO.FileVO> list = coverageVO2.getFiles();
        for (CoverageVO.FileVO fileVO : coverageVO.getFiles()) {
            boolean bl = true;
            for (int i = 0; i < list.size(); ++i) {
                if (!fileVO.getPath().equals(list.get(i).getPath())) continue;
                list.set(i, fileVO);
                bl = false;
                break;
            }
            if (!bl) continue;
            list.add(fileVO);
        }
        this.setCoverage(coverageVO2);
    }

    public static void notifyProjectOpened(Project project) {
        CoverageManager.INSTANCE.setEnabled(project, true);
    }

    public boolean supportsHitCounts() {
        return true;
    }

    public boolean supportsAggregation() {
        return false;
    }

    public synchronized boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = CoverageProviderHelper.isEnabled((Project)this.project);
        }
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != null && bl == this.enabled) {
            return;
        }
        this.enabled = bl;
        CoverageProviderHelper.setEnabled((Project)this.project, (boolean)bl);
    }

    public synchronized boolean isAggregating() {
        throw new IllegalStateException("Aggregating is not supported");
    }

    public synchronized void setAggregating(boolean bl) {
        throw new IllegalStateException("Aggregating is not supported");
    }

    public Set<String> getMimeTypes() {
        return MIME_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.coverage = null;
        }
    }

    public FileCoverageDetails getDetails(FileObject fileObject, Document document) {
        assert (fileObject != null);
        CoverageVO coverageVO = this.getCoverage();
        if (coverageVO == null) {
            return null;
        }
        if (!this.isUnderneathSourcesOnlyAndVisible(fileObject)) {
            return null;
        }
        String string = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
        for (CoverageVO.FileVO fileVO : coverageVO.getFiles()) {
            if (!string.equals(fileVO.getPath())) continue;
            return new PhpFileCoverageDetails(fileObject, fileVO);
        }
        return null;
    }

    public List<FileCoverageSummary> getResults() {
        CoverageVO coverageVO = this.getCoverage();
        if (coverageVO == null) {
            return null;
        }
        ArrayList<FileCoverageSummary> arrayList = new ArrayList<FileCoverageSummary>(coverageVO.getFiles().size());
        for (CoverageVO.FileVO fileVO : coverageVO.getFiles()) {
            if (!this.isUnderneathSourcesOnlyAndVisible(fileVO.getPath())) continue;
            arrayList.add(PhpCoverageProvider.getFileCoverageSummary(fileVO));
        }
        return arrayList;
    }

    public String getTestAllAction() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoverageVO getCoverage() {
        CoverageVO coverageVO = null;
        Object object = this.lock;
        synchronized (object) {
            coverageVO = this.coverage;
        }
        return coverageVO;
    }

    static FileCoverageSummary getFileCoverageSummary(CoverageVO.FileVO fileVO) {
        assert (fileVO != null);
        FileObject fileObject = FileUtil.toFileObject((File)new File(fileVO.getPath()));
        return new FileCoverageSummary(fileObject, fileObject.getNameExt(), fileVO.getMetrics().statements, fileVO.getMetrics().coveredStatements, -1, -1);
    }

    private boolean isUnderneathSourcesOnlyAndVisible(String string) {
        return this.isUnderneathSourcesOnlyAndVisible(FileUtil.toFileObject((File)new File(string)));
    }

    private boolean isUnderneathSourcesOnlyAndVisible(FileObject fileObject) {
        return fileObject != null && fileObject.isValid() && CommandUtils.isUnderSources(this.project, fileObject) && !CommandUtils.isUnderTests(this.project, fileObject, false) && !CommandUtils.isUnderSelenium(this.project, fileObject, false) && this.phpVisibilityQuery.isVisible(fileObject);
    }
}

