/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.UIResource;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsLocalWeb;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsRemoteWeb;
import org.netbeans.modules.php.project.ui.customizer.RunAsScript;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerRun
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = -5494488817914071L;
    private final ConfigComboBoxModel comboModel;
    private final ConfigManager manager;
    private final RunAsPanel.InsidePanel[] insidePanels;
    private JComboBox configCombo;
    private JButton configDel;
    private JLabel configLabel;
    private JButton configNew;
    private JPanel runPanel;
    private JSeparator separator;

    public CustomizerRun(PhpProjectProperties phpProjectProperties, ProjectCustomizer.Category category) {
        this.manager = new ConfigManager(phpProjectProperties);
        this.insidePanels = new RunAsPanel.InsidePanel[]{new RunAsLocalWeb(phpProjectProperties, this.manager, category), new RunAsRemoteWeb(phpProjectProperties, this.manager, category), new RunAsScript(phpProjectProperties.getProject(), this.manager, category)};
        this.initComponents();
        this.comboModel = new ConfigComboBoxModel();
        this.configCombo.setModel(this.comboModel);
    }

    public void addNotify() {
        super.addNotify();
        this.configCombo.setSelectedItem(this.manager.currentConfiguration().getName());
    }

    private ConfigManager.Configuration configurationFor(String string) {
        return this.manager.configurationFor(string);
    }

    private void selectCurrentItem() {
        ConfigManager.Configuration configuration = this.manager.currentConfiguration();
        this.configCombo.setSelectedItem(configuration.getName());
        this.configDel.setEnabled(!configuration.isDefault());
    }

    private void initComponents() {
        this.configLabel = new JLabel();
        this.configCombo = new JComboBox();
        this.configNew = new JButton();
        this.configDel = new JButton();
        this.separator = new JSeparator();
        this.runPanel = new RunAsPanel(this.insidePanels);
        this.setFocusTraversalPolicy(null);
        this.configLabel.setLabelFor(this.configCombo);
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_Configuration"));
        this.configCombo.setRenderer(new ConfigListCellRenderer());
        this.configCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.configComboActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configNew, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_New"));
        this.configNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.configNewActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configDel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_Delete"));
        this.configDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.configDelActionPerformed(actionEvent);
            }
        });
        this.runPanel.setLayout(new CardLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.runPanel, -1, 400, Short.MAX_VALUE).add(1, (Component)this.separator, -1, 400, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.configLabel).addPreferredGap(0).add((Component)this.configCombo, 0, 142, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.configNew).addPreferredGap(0).add((Component)this.configDel))).add(0, 0, 0)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.configLabel).add((Component)this.configCombo, -2, -1, -2).add((Component)this.configNew).add((Component)this.configDel)).addPreferredGap(1).add((Component)this.separator, -2, 2, -2).addPreferredGap(1).add((Component)this.runPanel, -1, 197, Short.MAX_VALUE).addContainerGap()));
        this.configLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configLabel.AccessibleContext.accessibleName"));
        this.configLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configLabel.AccessibleContext.accessibleDescription"));
        this.configCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configCombo.AccessibleContext.accessibleName"));
        this.configCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configCombo.AccessibleContext.accessibleDescription"));
        this.configNew.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configNew.AccessibleContext.accessibleName"));
        this.configNew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configNew.AccessibleContext.accessibleDescription"));
        this.configDel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configDel.AccessibleContext.accessibleName"));
        this.configDel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configDel.AccessibleContext.accessibleDescription"));
        this.separator.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.separator.AccessibleContext.accessibleName"));
        this.separator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.separator.AccessibleContext.accessibleDescription"));
        this.runPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.runPanel.AccessibleContext.accessibleName"));
        this.runPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.runPanel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.AccessibleContext.accessibleDescription"));
    }

    private void configComboActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.configCombo.getSelectedItem();
        this.manager.markAsCurrentConfiguration(string == null || string.length() == 0 ? null : string);
        this.selectCurrentItem();
    }

    private void configNewActionPerformed(ActionEvent actionEvent) {
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ConfigurationName"), NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CreateNewConfiguration"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION) {
            String string = inputLine.getInputText();
            if (string.trim().length() == 0) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerRun.class, (String)"MSG_ConfigurationNameBlank"), 2));
                return;
            }
            String string2 = string.replaceAll("[^a-zA-Z0-9_.-]", "_");
            if (this.manager.exists(string2)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerRun.class, (String)"MSG_ConfigurationExists", (Object)string2), 2));
                return;
            }
            ConfigManager.Configuration configuration = this.manager.createNew(string2, string);
            this.comboModel.addElement(string2);
            this.manager.markAsCurrentConfiguration(string2);
            this.selectCurrentItem();
        }
    }

    private void configDelActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.configCombo.getSelectedItem();
        assert (string != null);
        this.comboModel.removeElement(string);
        this.configurationFor(string).delete();
        this.selectCurrentItem();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerRun.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = -2086330612256611127L;

        public ConfigComboBoxModel() {
            TreeSet<String> treeSet = new TreeSet<String>(this.getComparator());
            treeSet.addAll(CustomizerRun.this.manager.configurationNames());
            for (String string : treeSet) {
                this.addElement(string);
            }
        }

        private Comparator<String> getComparator() {
            return new Comparator<String>(){
                Collator coll = Collator.getInstance();

                @Override
                public int compare(String string, String string2) {
                    String string3 = CustomizerRun.this.configurationFor(string).getDisplayName();
                    String string4 = CustomizerRun.this.configurationFor(string2).getDisplayName();
                    return this.coll.compare(string3, string4);
                }
            };
        }
    }

    private final class ConfigListCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private static final long serialVersionUID = 21963218553211553L;

        public ConfigListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            String string = (String)object;
            String string2 = CustomizerRun.this.configurationFor(string).getDisplayName();
            this.setText(string2);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }
}

