/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.ui.wizards.PhpFrameworksPanel;
import org.netbeans.modules.php.spi.phpmodule.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleExtender;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpFrameworksPanelVisual
extends JPanel
implements HelpCtx.Provider,
TableModelListener,
ListSelectionListener,
ChangeListener {
    private static final int STEP_INDEX = 2;
    private static final long serialVersionUID = 158602680330133653L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final FrameworksTableModel model;
    private final Map<PhpFrameworkProvider, PhpModuleExtender> extenders;
    private PhpModuleExtender actualExtender;
    private JPanel configPanel;
    private JLabel descriptionLabel;
    private JScrollPane frameworksScrollPane;
    private JTable frameworksTable;
    private JSeparator separator;

    public PhpFrameworksPanelVisual(PhpFrameworksPanel phpFrameworksPanel, Map<PhpFrameworkProvider, PhpModuleExtender> map) {
        assert (map != null);
        this.extenders = map;
        this.setName(phpFrameworksPanel.getSteps()[2]);
        this.putClientProperty("WizardPanel_contentSelectedIndex", 2);
        this.putClientProperty("WizardPanel_contentData", phpFrameworksPanel.getSteps());
        this.initComponents();
        this.model = new FrameworksTableModel();
        this.frameworksTable.setModel(this.model);
        this.createFrameworksList();
        FrameworksTableCellRenderer frameworksTableCellRenderer = new FrameworksTableCellRenderer(this.model);
        frameworksTableCellRenderer.setBooleanRenderer(this.frameworksTable.getDefaultRenderer(Boolean.class));
        this.frameworksTable.setDefaultRenderer(PhpFrameworkProvider.class, frameworksTableCellRenderer);
        this.frameworksTable.setDefaultRenderer(Boolean.class, frameworksTableCellRenderer);
        this.initTableVisualProperties();
        this.changeDescriptionAndPanel();
    }

    public void addPhpFrameworksListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removePhpFrameworksListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public Map<PhpFrameworkProvider, PhpModuleExtender> getSelectedExtenders() {
        LinkedHashMap<PhpFrameworkProvider, PhpModuleExtender> linkedHashMap = new LinkedHashMap<PhpFrameworkProvider, PhpModuleExtender>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            FrameworkModelItem frameworkModelItem = this.model.getItem(i);
            if (!frameworkModelItem.isSelected().booleanValue()) continue;
            PhpFrameworkProvider phpFrameworkProvider = frameworkModelItem.getFramework();
            assert (phpFrameworkProvider != null);
            PhpModuleExtender phpModuleExtender = this.extenders.get(phpFrameworkProvider);
            linkedHashMap.put(phpFrameworkProvider, phpModuleExtender);
        }
        return linkedHashMap;
    }

    public PhpModuleExtender getSelectedVisibleExtender() {
        int n = this.frameworksTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        FrameworkModelItem frameworkModelItem = this.model.getItem(n);
        assert (frameworkModelItem != null);
        if (frameworkModelItem.isSelected().booleanValue()) {
            return this.extenders.get(frameworkModelItem.getFramework());
        }
        return null;
    }

    public void markInvalidFrameworks(Set<PhpFrameworkProvider> set) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            FrameworkModelItem frameworkModelItem;
            frameworkModelItem.setValid(!set.contains((frameworkModelItem = this.model.getItem(i)).getFramework()));
        }
    }

    public HelpCtx getHelpCtx() {
        for (Component component : this.configPanel.getComponents()) {
            HelpCtx helpCtx;
            if (!(component instanceof HelpCtx.Provider) || (helpCtx = ((HelpCtx.Provider)component).getHelpCtx()) == null) continue;
            return helpCtx;
        }
        return null;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.changeDescriptionAndPanel();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.changeDescriptionAndPanel();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange();
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    private void createFrameworksList() {
        for (PhpFrameworkProvider phpFrameworkProvider : this.extenders.keySet()) {
            this.model.addItem(new FrameworkModelItem(phpFrameworkProvider));
        }
    }

    private void initTableVisualProperties() {
        this.frameworksTable.getModel().addTableModelListener(this);
        this.frameworksTable.getSelectionModel().addListSelectionListener(this);
        this.frameworksTable.setRowHeight(this.frameworksTable.getRowHeight() + 4);
        this.frameworksTable.setIntercellSpacing(new Dimension(0, 0));
        this.frameworksTable.getParent().setBackground(this.frameworksTable.getBackground());
        this.frameworksTable.getColumnModel().getColumn(0).setMaxWidth(30);
    }

    private void changeDescriptionAndPanel() {
        if (this.actualExtender != null) {
            this.actualExtender.removeChangeListener((ChangeListener)this);
        }
        if (this.frameworksTable.getSelectedRow() == -1) {
            this.descriptionLabel.setText(" ");
            this.configPanel.removeAll();
            this.configPanel.repaint();
            this.configPanel.revalidate();
        } else {
            FrameworkModelItem frameworkModelItem = this.model.getItem(this.frameworksTable.getSelectedRow());
            this.descriptionLabel.setText(frameworkModelItem.getFramework().getDescription());
            this.descriptionLabel.setEnabled(frameworkModelItem.isSelected());
            this.configPanel.removeAll();
            this.actualExtender = this.extenders.get(frameworkModelItem.getFramework());
            this.actualExtender.addChangeListener((ChangeListener)this);
            JComponent jComponent = this.actualExtender.getComponent();
            if (jComponent != null) {
                this.configPanel.add((Component)jComponent, "North");
                this.enableComponents(jComponent, frameworkModelItem.isSelected());
            }
            this.configPanel.revalidate();
            this.configPanel.repaint();
        }
        this.fireChange();
    }

    private void enableComponents(Container container, boolean bl) {
        container.setEnabled(bl);
        for (Component component : container.getComponents()) {
            if (component instanceof Container) {
                this.enableComponents((Container)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    private void initComponents() {
        this.frameworksScrollPane = new JScrollPane();
        this.frameworksTable = new JTable();
        this.descriptionLabel = new JLabel();
        this.separator = new JSeparator();
        this.configPanel = new JPanel();
        this.frameworksTable.setSelectionMode(0);
        this.frameworksTable.setShowHorizontalLines(false);
        this.frameworksTable.setShowVerticalLines(false);
        this.frameworksTable.setTableHeader(null);
        this.frameworksScrollPane.setViewportView(this.frameworksTable);
        this.descriptionLabel.setText("DUMMY");
        this.configPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.separator, -1, 400, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.descriptionLabel).addContainerGap()).add((Component)this.configPanel, -1, 400, Short.MAX_VALUE).add((Component)this.frameworksScrollPane, -1, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.frameworksScrollPane, -2, 90, -2).addPreferredGap(0).add((Component)this.separator, -2, 10, -2).addPreferredGap(0).add((Component)this.descriptionLabel).addPreferredGap(0).add((Component)this.configPanel, -1, 169, Short.MAX_VALUE)));
    }

    private static final class FrameworkModelItem {
        private final PhpFrameworkProvider framework;
        private Boolean selected;
        private boolean valid = true;

        public FrameworkModelItem(PhpFrameworkProvider phpFrameworkProvider) {
            assert (phpFrameworkProvider != null);
            this.framework = phpFrameworkProvider;
            this.setSelected(Boolean.FALSE);
        }

        public PhpFrameworkProvider getFramework() {
            return this.framework;
        }

        public Boolean isSelected() {
            return this.selected;
        }

        public void setSelected(Boolean bl) {
            this.selected = bl;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean bl) {
            this.valid = bl;
        }
    }

    private static final class FrameworksTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 22495101047716943L;
        private static final Color ERROR_COLOR = UIManager.getColor("nb.errorForeground");
        private static final Color NORMAL_COLOR = new JLabel().getForeground();
        private final FrameworksTableModel model;
        private TableCellRenderer booleanRenderer;

        private FrameworksTableCellRenderer(FrameworksTableModel frameworksTableModel) {
            this.model = frameworksTableModel;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof PhpFrameworkProvider) {
                FrameworkModelItem frameworkModelItem = this.model.getItem(n);
                Component component = super.getTableCellRendererComponent(jTable, frameworkModelItem.getFramework().getName(), bl, false, n, n2);
                if (frameworkModelItem.isValid()) {
                    component.setForeground(NORMAL_COLOR);
                } else {
                    component.setForeground(ERROR_COLOR);
                }
                return component;
            }
            if (object instanceof Boolean && this.booleanRenderer != null) {
                return this.booleanRenderer.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        }

        public void setBooleanRenderer(TableCellRenderer tableCellRenderer) {
            this.booleanRenderer = tableCellRenderer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FrameworksTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 8082636013224696L;
        private final DefaultListModel model = new DefaultListModel();

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.model.size();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return PhpFrameworkProvider.class;
                }
            }
            assert (false) : "Unknown column index: " + n;
            return super.getColumnClass(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            FrameworkModelItem frameworkModelItem = this.getItem(n);
            switch (n2) {
                case 0: {
                    return frameworkModelItem.isSelected();
                }
                case 1: {
                    return frameworkModelItem.getFramework();
                }
            }
            assert (false) : "Unknown column index: " + n2;
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            FrameworkModelItem frameworkModelItem = this.getItem(n);
            switch (n2) {
                case 0: {
                    frameworkModelItem.setSelected((Boolean)object);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    assert (false) : "Unknown column index: " + n2;
                    break;
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        FrameworkModelItem getItem(int n) {
            return (FrameworkModelItem)this.model.get(n);
        }

        void addItem(FrameworkModelItem frameworkModelItem) {
            this.model.addElement(frameworkModelItem);
        }
    }
}

