/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.bootstrap;

import com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Bootstrap {
    public static final int APPHOME = 1;
    public static final int CONFIGHOME = 2;
    public static ClassLoader loader = null;

    public static void main(String[] args) {
        if (args.length > 0) {
            if (args[0].equals("start")) {
                Bootstrap.startServer();
            } else if (args[0].equals("stop")) {
                Bootstrap.stopServer();
            } else if (args[0].equals("runTest")) {
                Bootstrap.runTest(args[1]);
            } else if (args[0].equals("runTestCL")) {
                Bootstrap.runTestCL(args);
            } else if (args[0].equals("startDebugger")) {
                Bootstrap.startDebugger();
            } else if (args[0].equals("stopDebugger")) {
                Bootstrap.stopDebugger();
            }
        }
    }

    private static void doWait() {
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String expandEnvironmentVariables(String inValue) {
        Pattern p = Pattern.compile("\\$\\{[^}]*\\}");
        Matcher m = p.matcher(inValue);
        while (m.find()) {
            String varName = m.group().substring(2, m.group().length() - 1);
            inValue = inValue.substring(0, m.start()) + System.getProperty(varName) + inValue.substring(m.end());
        }
        return inValue;
    }

    /*
     * Unable to fully structure code
     */
    private static ClassLoader createClassLoader(Map serverProps) {
        ret = null;
        folderList = new ArrayList<URL>();
        try {
            appHome = Bootstrap.getServerHome(1);
            appLibFolder = (appHome == null ? "" : appHome) + File.separatorChar + "lib" + File.separatorChar;
            loadFromFileSystem = new File(appLibFolder).exists();
            if (loadFromFileSystem) {
                appLibFolderFile = new File(appLibFolder);
                jarFiles = appLibFolderFile.listFiles();
                for (j = 0; j < jarFiles.length; ++j) {
                    jarFile = jarFiles[j];
                    fileName = jarFile.toString();
                    if (jarFile.isDirectory() || !fileName.toLowerCase().endsWith(".jar") && !fileName.toLowerCase().endsWith(".xml") && !fileName.toLowerCase().endsWith(".properties") && !fileName.toLowerCase().endsWith(".class")) continue;
                    folderList.add(jarFile.toURL());
                }
            } else {
                configURL = Bootstrap.getConfigURL();
                libXMLURL = configURL;
                libXMLURL = libXMLURL.indexOf("?") >= 0 ? libXMLURL + "&" : libXMLURL + "?";
                libXMLURL = libXMLURL + "context=server&filename=" + Bootstrap.encodeValue("conf/LibFolder.xml");
                try {
                    domFactory = DocumentBuilderFactory.newInstance();
                    domBuilder = domFactory.newDocumentBuilder();
                    doc = domBuilder.parse(libXMLURL);
                    factory = Bootstrap.newXPathFactory();
                    xpath = factory.newXPath();
                    if (doc == null) ** GOTO lbl45
                    root = doc.getDocumentElement();
                    commandInterfaceHostPortXPath = "/Root/LibFolder/Lib";
                    rootExp = xpath.compile(commandInterfaceHostPortXPath);
                    resultList = (NodeList)rootExp.evaluate(root, XPathConstants.NODESET);
                    if (resultList == null) ** GOTO lbl45
                    for (i = 0; i < resultList.getLength(); ++i) {
                        resultNode = resultList.item(i);
                        jarFileURL = Bootstrap.getNodeValue(resultNode);
                        folderList.add(new URL(jarFileURL));
                    }
                }
                catch (Exception e) {
                    System.out.println("Error parsing LibFolder.xml: " + e.toString());
                    e.printStackTrace();
                    Bootstrap.doWait();
                }
            }
lbl45:
            // 5 sources

            vhostsMap = (Map)serverProps.get("VHosts");
            if (vhostsMap != null) {
                iter = vhostsMap.keySet().iterator();
                while (iter.hasNext()) {
                    vhostMap = (Map)vhostsMap.get(iter.next());
                    configFolder = Bootstrap.expandEnvironmentVariables((String)vhostMap.get("ConfigDir"));
                    configAppFolder = configFolder + File.separatorChar + "applications";
                    configAppFolderFile = new File(configAppFolder);
                    if (configAppFolderFile.exists() && configAppFolderFile.isDirectory()) {
                        files = configAppFolderFile.listFiles();
                        for (i = 0; i < files.length; ++i) {
                            file = files[i];
                            if (!file.isDirectory()) continue;
                            jarFiles = file.listFiles();
                            for (j = 0; j < jarFiles.length; ++j) {
                                jarFile = jarFiles[j];
                                fileName = jarFile.toString();
                                if (jarFile.isDirectory() || !fileName.toLowerCase().endsWith(".jar") && !fileName.toLowerCase().endsWith(".xml") && !fileName.toLowerCase().endsWith(".properties") && !fileName.toLowerCase().endsWith(".class")) continue;
                                folderList.add(jarFile.toURL());
                            }
                        }
                        continue;
                    }
                    System.out.println("Error: applications folder missing: " + configAppFolderFile);
                }
            }
            locations = folderList.toArray(new URL[folderList.size()]);
            currLoader = Thread.currentThread().getContextClassLoader();
            loader = new URLClassLoader(locations, currLoader);
            Thread.currentThread().setContextClassLoader(loader);
            ret = loader;
        }
        catch (Exception e) {
            System.out.println("Error creating class loader: " + e);
            e.printStackTrace();
            Bootstrap.doWait();
        }
        return ret;
    }

    public static Class findClass(String className) {
        Class<?> ret = null;
        try {
            if (loader != null) {
                ret = loader.loadClass(className);
            } else {
                System.out.println("Bootstrap.findClass (" + className + "): Class loader is null");
            }
        }
        catch (Exception e) {
            System.out.println("Bootstrap.findClass (" + className + "): " + e);
            e.printStackTrace();
        }
        return ret;
    }

    private static void startServer() {
        try {
            Map serverProps = Bootstrap.getServerInfo();
            if (serverProps != null) {
                loader = Bootstrap.createClassLoader(serverProps);
                String serverClass = "com.wowza.wms.server.Server";
                Class<?> server = loader.loadClass(serverClass);
                Method method = server.getMethod("start", new Class[0]);
                method.invoke(null, null);
            }
        }
        catch (Exception e) {
            System.out.println("Error starting: " + e);
            e.printStackTrace();
            Bootstrap.doWait();
        }
    }

    private static void startDebugger() {
        try {
            Map serverProps = Bootstrap.getServerInfo();
            if (serverProps != null) {
                ClassLoader loader = Bootstrap.createClassLoader(serverProps);
                String serverClass = "com.wowza.wms.debugger.DebugServer";
                Class<?> server = loader.loadClass(serverClass);
                Method method = server.getMethod("startServer", new Class[0]);
                method.invoke(null, null);
            }
        }
        catch (Exception e) {
            System.out.println("Error starting: " + e);
            e.printStackTrace();
            Bootstrap.doWait();
        }
    }

    private static void stopDebugger() {
    }

    private static boolean sendServerCommand(String commandStr) {
        boolean res = true;
        try {
            Map serverProps = Bootstrap.getServerInfo();
            if (serverProps != null) {
                InetAddress address = (InetAddress)serverProps.get("HostPort.address");
                int port = (Integer)serverProps.get("HostPort.port");
                Socket socket = address == null ? new Socket("127.0.0.1", port) : new Socket(address, port);
                OutputStream stream = socket.getOutputStream();
                for (int i = 0; i < commandStr.length(); ++i) {
                    stream.write(commandStr.charAt(i));
                }
                stream.write(0);
                stream.flush();
                stream.close();
                socket.close();
            }
        }
        catch (Exception e) {
            res = false;
        }
        return res;
    }

    public static boolean isRunning() {
        return Bootstrap.sendServerCommand("ping");
    }

    public static void stopServer() {
        Bootstrap.sendServerCommand("shutdown");
    }

    public static void restartServer() {
        Bootstrap.sendServerCommand("restart");
    }

    public static XPathFactory newXPathFactory() {
        XPathFactory ret = null;
        if (ret == null) {
            try {
                ret = XPathFactory.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (ret == null) {
            try {
                new XPathFactoryImpl();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ret == null) {
            System.out.println("Error: Can't find XPathFactory");
        }
        return ret;
    }

    public static String encodeValue(String val) {
        String ret = val;
        try {
            ret = URLEncoder.encode(ret, "UTF-8");
        }
        catch (Exception e) {
            System.out.println("encodeValue (" + val + "): " + e.toString());
            ret = val;
        }
        return ret;
    }

    private static Map getServerInfo() {
        Element root;
        XPath xpath;
        XPathFactory factory;
        Document doc;
        DocumentBuilder domBuilder;
        DocumentBuilderFactory domFactory;
        String vhostsXMLURL;
        HashMap<String, Serializable> ret = null;
        String serverXMLURL = Bootstrap.getServerXMLURL();
        if (serverXMLURL == null) {
            System.out.println("ERROR: Server.xml not found: exiting.");
            System.exit(1);
        }
        if ((vhostsXMLURL = Bootstrap.getVHostsXMLURL()) == null) {
            System.out.println("ERROR: VHosts.xml not found: exiting.");
            System.exit(1);
        }
        ret = new HashMap<String, Serializable>();
        HashMap vhostsMap = new HashMap();
        ret.put("VHosts", vhostsMap);
        try {
            domFactory = DocumentBuilderFactory.newInstance();
            domBuilder = domFactory.newDocumentBuilder();
            doc = domBuilder.parse(serverXMLURL);
            factory = Bootstrap.newXPathFactory();
            xpath = factory.newXPath();
            if (doc != null) {
                root = doc.getDocumentElement();
                String commandInterfaceHostPortXPath = "/Root/Server/CommandInterface/HostPort";
                XPathExpression rootExp = xpath.compile(commandInterfaceHostPortXPath);
                Node resultNode = (Node)rootExp.evaluate(root, XPathConstants.NODE);
                if (resultNode != null) {
                    Node DomainNameElem = Bootstrap.getNodeByTagName((Element)resultNode, "DomainName");
                    Node ipAddressElem = Bootstrap.getNodeByTagName((Element)resultNode, "IpAddress");
                    Node portElem = Bootstrap.getNodeByTagName((Element)resultNode, "Port");
                    if ((DomainNameElem != null || ipAddressElem != null) && portElem != null) {
                        String DomainNameStr = Bootstrap.getNodeValue(DomainNameElem);
                        String ipAddressStr = Bootstrap.getNodeValue(ipAddressElem);
                        String portStr = Bootstrap.getNodeValue(portElem);
                        InetAddress address = null;
                        Object addressStr = null;
                        if (ipAddressElem != null) {
                            if (ipAddressStr.equals("*")) {
                                address = null;
                            } else {
                                String[] parts = ipAddressStr.split("[.]");
                                if (parts.length == 4) {
                                    byte[] byteParts = new byte[parts.length];
                                    for (int i = 0; i < parts.length; ++i) {
                                        byteParts[i] = (byte)Integer.parseInt(parts[i]);
                                    }
                                    address = InetAddress.getByAddress(byteParts);
                                } else {
                                    System.out.println("setIpAddress: invalid ipAddress: " + ipAddressStr);
                                }
                            }
                        } else if (DomainNameElem != null) {
                            address = DomainNameStr.equals("*") ? null : InetAddress.getByName(DomainNameStr);
                        }
                        ret.put("HostPort.address", address);
                        ret.put("HostPort.port", new Integer(Integer.parseInt(portStr)));
                    } else {
                        System.out.println("Error parsing Server.xml: <DomainName> or <IpAddress> and <Port> required");
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error parsing Server.xml: <DomainName> or <IpAddress> and <Port> required: " + e.toString());
            e.printStackTrace();
            Bootstrap.doWait();
        }
        try {
            domFactory = DocumentBuilderFactory.newInstance();
            domBuilder = domFactory.newDocumentBuilder();
            doc = domBuilder.parse(vhostsXMLURL);
            factory = Bootstrap.newXPathFactory();
            xpath = factory.newXPath();
            if (doc != null) {
                root = doc.getDocumentElement();
                String vhostsXPath = "/Root/VHosts/VHost";
                XPathExpression vhostsExp = xpath.compile(vhostsXPath);
                NodeList resultList = (NodeList)vhostsExp.evaluate(root, XPathConstants.NODESET);
                if (resultList != null) {
                    for (int i = 0; i < resultList.getLength(); ++i) {
                        Node resultNode = resultList.item(i);
                        Element resultElem = (Element)resultNode;
                        Node nameElem = Bootstrap.getNodeByTagName(resultElem, "Name");
                        Node configDirElem = Bootstrap.getNodeByTagName(resultElem, "ConfigDir");
                        Node connectionLimitElem = Bootstrap.getNodeByTagName(resultElem, "ConnectionLimit");
                        if (nameElem != null && configDirElem != null) {
                            String nameStr = Bootstrap.getNodeValue(nameElem);
                            String configDirStr = Bootstrap.getNodeValue(configDirElem);
                            String connectionLimitStr = null;
                            if (connectionLimitElem != null) {
                                connectionLimitStr = Bootstrap.getNodeValue(connectionLimitElem);
                            }
                            HashMap<String, String> vhostMap = new HashMap<String, String>();
                            vhostMap.put("Name", nameStr);
                            vhostMap.put("ConfigDir", configDirStr);
                            vhostMap.put("ConnectionLimit", connectionLimitStr);
                            vhostsMap.put(nameStr, vhostMap);
                            continue;
                        }
                        System.out.println("loadConfigFile: error parsing vhosts config file: (" + vhostsXMLURL + ") : error <Name> and <ConfigDir> required.");
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error parsing VHosts.xml (" + vhostsXMLURL + "): " + e.toString());
            e.printStackTrace();
            Bootstrap.doWait();
        }
        return ret;
    }

    private static Node getNodeByTagName(Element node, String name) {
        NodeList nodeList = node.getElementsByTagName(name);
        if (nodeList != null && nodeList.getLength() > 0) {
            return nodeList.item(0);
        }
        return null;
    }

    private static String getNodeValue(Node node) {
        String ret = "";
        if (node != null) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                ret = ret + child.getNodeValue();
            }
        }
        return ret;
    }

    public static String getServerLog4jPropertiesURL() {
        String serverLog4jPropertiesURL = null;
        String configURL = Bootstrap.getConfigURL();
        String configHome = Bootstrap.getServerHome(2);
        String serverXMLPath = (configHome == null ? "" : configHome) + File.separatorChar + "conf" + File.separatorChar + "log4j.properties";
        if (new File(serverXMLPath).exists()) {
            serverLog4jPropertiesURL = serverXMLPath.replace("\\", "/");
            if (serverLog4jPropertiesURL.charAt(1) == ':') {
                serverLog4jPropertiesURL = "/" + serverLog4jPropertiesURL;
            }
            serverLog4jPropertiesURL = "file://" + serverLog4jPropertiesURL;
        } else if (configURL != null) {
            serverLog4jPropertiesURL = configURL;
            serverLog4jPropertiesURL = serverLog4jPropertiesURL.indexOf("?") >= 0 ? serverLog4jPropertiesURL + "&" : serverLog4jPropertiesURL + "?";
            serverLog4jPropertiesURL = serverLog4jPropertiesURL + "context=server&filename=" + Bootstrap.encodeValue("conf/log4j.properties");
        }
        return serverLog4jPropertiesURL;
    }

    public static String getServerLicenseURL() {
        String serverLicenseURL = null;
        String configHome = Bootstrap.getServerHome(2);
        String serverXMLPath = (configHome == null ? "" : configHome) + File.separatorChar + "conf" + File.separatorChar + "Server.license";
        if (new File(serverXMLPath).exists()) {
            serverLicenseURL = serverXMLPath.replace("\\", "/");
            if (serverLicenseURL.charAt(1) == ':') {
                serverLicenseURL = "/" + serverLicenseURL;
            }
            serverLicenseURL = "file://" + serverLicenseURL;
        }
        return serverLicenseURL;
    }

    public static String getServerXMLURL() {
        String serverXMLURL = null;
        String configURL = Bootstrap.getConfigURL();
        String configHome = Bootstrap.getServerHome(2);
        String serverXMLPath = (configHome == null ? "" : configHome) + File.separatorChar + "conf" + File.separatorChar + "Server.xml";
        if (new File(serverXMLPath).exists()) {
            serverXMLURL = serverXMLPath.replace("\\", "/");
            if (serverXMLURL.charAt(1) == ':') {
                serverXMLURL = "/" + serverXMLURL;
            }
            serverXMLURL = "file://" + serverXMLURL;
        } else if (configURL != null) {
            serverXMLURL = configURL;
            serverXMLURL = serverXMLURL.indexOf("?") >= 0 ? serverXMLURL + "&" : serverXMLURL + "?";
            serverXMLURL = serverXMLURL + "context=server&filename=" + Bootstrap.encodeValue("conf/Server.xml");
        }
        return serverXMLURL;
    }

    public static String getVHostsXMLURL() {
        String vhostsXMLURL = null;
        String configURL = Bootstrap.getConfigURL();
        String configHome = Bootstrap.getServerHome(2);
        String vhostsXMLPath = (configHome == null ? "" : configHome) + File.separatorChar + "conf" + File.separatorChar + "VHosts.xml";
        if (new File(vhostsXMLPath).exists()) {
            vhostsXMLURL = vhostsXMLPath.replace("\\", "/");
            if (vhostsXMLURL.charAt(1) == ':') {
                vhostsXMLURL = "/" + vhostsXMLURL;
            }
            vhostsXMLURL = "file://" + vhostsXMLURL;
        } else if (configURL != null) {
            vhostsXMLURL = configURL;
            vhostsXMLURL = vhostsXMLURL.indexOf("?") >= 0 ? vhostsXMLURL + "&" : vhostsXMLURL + "?";
            vhostsXMLURL = vhostsXMLURL + "context=server&filename=" + Bootstrap.encodeValue("conf/VHosts.xml");
        }
        return vhostsXMLURL;
    }

    public static String getConfigURL() {
        String configURL = System.getProperty("com.wowza.wms.ConfigURL");
        if (configURL == null) {
            return null;
        }
        if (configURL.trim().length() == 0) {
            return null;
        }
        return configURL.trim();
    }

    public static boolean isServerURLConfig() {
        return Bootstrap.getConfigURL() != null;
    }

    public static String getServerHome(int pathType) {
        String configHome;
        String appHome = System.getProperty("com.wowza.wms.AppHome");
        if (appHome != null && (appHome = appHome.trim()).length() == 0) {
            appHome = null;
        }
        if ((configHome = System.getProperty("com.wowza.wms.ConfigHome")) != null && (configHome = configHome.trim()).length() == 0) {
            configHome = null;
        }
        if (configHome == null) {
            configHome = appHome;
        }
        return pathType == 1 ? appHome : configHome;
    }

    private static void runTest(String testName) {
        try {
            Map serverProps = Bootstrap.getServerInfo();
            if (serverProps != null) {
                ClassLoader loader = Bootstrap.createClassLoader(serverProps);
                String serverClass = "com.wowza.wms.performance.PerformanceTestList";
                Class<?> server = loader.loadClass(serverClass);
                Method method = server.getMethod("run", String.class);
                method.invoke(null, testName);
            }
        }
        catch (Exception e) {
            System.out.println("Error running test (" + testName + "): " + e);
            e.printStackTrace();
            Bootstrap.doWait();
        }
    }

    private static void runTestCL(String[] args) {
        try {
            Map serverProps = Bootstrap.getServerInfo();
            if (serverProps != null) {
                ClassLoader loader = Bootstrap.createClassLoader(serverProps);
                String serverClass = args[1];
                Class<?> server = loader.loadClass(serverClass);
                Method method = server.getMethod("run", List.class);
                ArrayList<String> argList = new ArrayList<String>();
                for (int i = 2; i < args.length; ++i) {
                    argList.add(args[i]);
                }
                method.invoke(null, argList);
            }
        }
        catch (Exception e) {
            System.out.println("Error running test (" + args[1] + "): " + e);
            e.printStackTrace();
            Bootstrap.doWait();
        }
    }
}

