/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.mysql.Database;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.DatabaseUser;
import org.netbeans.modules.db.mysql.impl.ConnectManager;
import org.netbeans.modules.db.mysql.impl.ConnectionProcessor;
import org.netbeans.modules.db.mysql.impl.MySQLOptions;
import org.netbeans.modules.db.mysql.impl.StartManager;
import org.netbeans.modules.db.mysql.impl.StopManager;
import org.netbeans.modules.db.mysql.util.DatabaseUtils;
import org.netbeans.modules.db.mysql.util.ExecSupport;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDatabaseServer
implements DatabaseServer,
PropertyChangeListener {
    private static final Object lock = new Object();
    private static final Image ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/db/mysql/resources/catalog.gif");
    private static final Image ERROR_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/db/mysql/resources/error-badge.gif");
    private static boolean first = true;
    private volatile String displayName;
    private volatile String shortDescription;
    private volatile Image icon;
    private static final Logger LOGGER = Logger.getLogger(DatabaseServer.class.getName());
    private static volatile DatabaseServer DEFAULT;
    private static final MySQLOptions OPTIONS;
    private static final String GET_DATABASES_SQL = "SHOW DATABASES";
    private static final String GET_USERS_SQL = "SELECT DISTINCT user, host FROM mysql.user";
    private static final String CREATE_DATABASE_SQL = "CREATE DATABASE ";
    private static final String DROP_DATABASE_SQL = "DROP DATABASE ";
    private static final String GRANT_ALL_SQL_1 = "GRANT ALL ON ";
    private static final String GRANT_ALL_SQL_2 = ".* TO ?@?";
    final LinkedBlockingQueue<Runnable> commandQueue = new LinkedBlockingQueue();
    final ConnectionProcessor connProcessor = new ConnectionProcessor(this.commandQueue);
    final CopyOnWriteArrayList<ChangeListener> changeListeners = new CopyOnWriteArrayList();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private volatile String adminPassword;
    private DatabaseServer.ServerState runstate = DatabaseServer.ServerState.DISCONNECTED;
    private volatile String configError = null;
    private volatile HashMap<String, Database> databases = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseServer getDefault() {
        Object object = lock;
        synchronized (object) {
            if (DEFAULT != null) {
                return DEFAULT;
            }
        }
        object = new MySQLDatabaseServer();
        Object object2 = lock;
        synchronized (object2) {
            if (DEFAULT == null) {
                DEFAULT = object;
            }
        }
        return DEFAULT;
    }

    private MySQLDatabaseServer() {
        RequestProcessor.getDefault().post((Runnable)this.connProcessor);
        MySQLOptions.getDefault().addPropertyChangeListener(this);
        this.addPropertyChangeListener(ConnectManager.getDefault().getReconnectListener());
        this.addPropertyChangeListener(StartManager.getDefault().getStartListener());
        this.addPropertyChangeListener(StopManager.getDefault().getStopListener());
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                MySQLDatabaseServer.this.checkRunning();
            }
        });
        this.updateDisplayInformation();
    }

    @Override
    public String getHost() {
        return Utils.isEmpty(OPTIONS.getHost()) ? MySQLOptions.getDefaultHost() : OPTIONS.getHost();
    }

    @Override
    public void setHost(String string) {
        OPTIONS.setHost(string);
        this.updateDisplayInformation();
        this.notifyChange();
    }

    @Override
    public String getPort() {
        String string = OPTIONS.getPort();
        if (Utils.isEmpty(string)) {
            return MySQLOptions.getDefaultPort();
        }
        return string;
    }

    @Override
    public void setPort(String string) {
        OPTIONS.setPort(string);
        this.updateDisplayInformation();
        this.notifyChange();
    }

    @Override
    public String getUser() {
        String string = OPTIONS.getAdminUser();
        if (Utils.isEmpty(string)) {
            return MySQLOptions.getDefaultAdminUser();
        }
        return string;
    }

    @Override
    public void setUser(String string) {
        OPTIONS.setAdminUser(string);
        this.updateDisplayInformation();
        this.notifyChange();
    }

    @Override
    public synchronized String getPassword() {
        if (this.adminPassword != null) {
            return this.adminPassword;
        }
        return OPTIONS.getAdminPassword();
    }

    @Override
    public synchronized void setPassword(String string) {
        String string2 = this.adminPassword = string == null ? "" : string;
        if (this.isSavePassword()) {
            OPTIONS.setAdminPassword(string);
        }
    }

    @Override
    public boolean isSavePassword() {
        return OPTIONS.isSavePassword();
    }

    @Override
    public void setSavePassword(boolean bl) {
        OPTIONS.setSavePassword(bl);
        OPTIONS.setAdminPassword(this.getPassword());
    }

    @Override
    public String getAdminPath() {
        return OPTIONS.getAdminPath();
    }

    @Override
    public void setAdminPath(String string) {
        OPTIONS.setAdminPath(string);
    }

    @Override
    public String getStartPath() {
        return OPTIONS.getStartPath();
    }

    @Override
    public void setStartPath(String string) {
        OPTIONS.setStartPath(string);
    }

    @Override
    public String getStopPath() {
        return OPTIONS.getStopPath();
    }

    @Override
    public void setStopPath(String string) {
        OPTIONS.setStopPath(string);
    }

    @Override
    public String getStopArgs() {
        return OPTIONS.getStopArgs();
    }

    @Override
    public void setStopArgs(String string) {
        OPTIONS.setStopArgs(string);
    }

    @Override
    public String getStartArgs() {
        return OPTIONS.getStartArgs();
    }

    @Override
    public void setStartArgs(String string) {
        OPTIONS.setStartArgs(string);
    }

    @Override
    public String getAdminArgs() {
        return OPTIONS.getAdminArgs();
    }

    @Override
    public void setAdminArgs(String string) {
        OPTIONS.setAdminArgs(string);
    }

    @Override
    public synchronized boolean isConnected() {
        return this.runstate == DatabaseServer.ServerState.CONNECTED;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    private void setDisplayName(String string) {
        this.displayName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDisplayInformation() {
        String string = this.runstate.toString();
        String string2 = this.getHostPort();
        String string3 = this.getUser();
        MySQLDatabaseServer mySQLDatabaseServer = this;
        synchronized (mySQLDatabaseServer) {
            this.setDisplayName(Utils.getMessage("LBL_ServerDisplayName", string2, string3, Utils.getMessage(string, new Object[0])));
            if (this.runstate != DatabaseServer.ServerState.CONFIGERR) {
                this.icon = ICON;
                this.setShortDescription(Utils.getMessage("LBL_ServerShortDescription", string2, string3, Utils.getMessage(string, new Object[0])));
            } else {
                assert (this.configError != null);
                this.icon = ImageUtilities.mergeImages((Image)ICON, (Image)ERROR_BADGE, (int)6, (int)6);
                this.setShortDescription(Utils.getMessage("LBL_ServerShortDescriptionError", this.configError));
            }
        }
        MySQLDatabaseServer.closeOutput();
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    private void setShortDescription(String string) {
        this.shortDescription = string;
    }

    private String getHostPort() {
        String string = this.getPort();
        string = Utils.isEmpty(string) ? "" : ":" + string;
        return this.getHost() + string;
    }

    @Override
    public String getURL() {
        return DatabaseUtils.getURL(this.getHost(), this.getPort());
    }

    @Override
    public String getURL(String string) {
        return DatabaseUtils.getURL(this.getHost(), this.getPort(), string);
    }

    private void notifyChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private void reportConnectionInvalid(DatabaseException databaseException) {
        this.disconnect();
        LOGGER.log(Level.INFO, null, databaseException);
        Utils.displayErrorMessage(databaseException.getMessage());
    }

    @Override
    public void refreshDatabaseList() {
        if (this.isConnected()) {
            final MySQLDatabaseServer mySQLDatabaseServer = this;
            new DatabaseCommand(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute() throws Exception {
                    try {
                        HashMap<String, Database> hashMap = new HashMap<String, Database>();
                        if (!MySQLDatabaseServer.this.isConnected()) {
                            MySQLDatabaseServer.this.setDatabases(hashMap);
                            return;
                        }
                        try {
                            MySQLDatabaseServer.this.connProcessor.validateConnection();
                        }
                        catch (DatabaseException databaseException) {
                            MySQLDatabaseServer.this.reportConnectionInvalid(databaseException);
                            MySQLDatabaseServer.this.setDatabases(hashMap);
                            MySQLDatabaseServer.this.notifyChange();
                            return;
                        }
                        Connection connection = MySQLDatabaseServer.this.connProcessor.getConnection();
                        if (connection == null) {
                            MySQLDatabaseServer.this.setDatabases(hashMap);
                            return;
                        }
                        PreparedStatement preparedStatement = connection.prepareStatement(MySQLDatabaseServer.GET_DATABASES_SQL);
                        ResultSet resultSet = preparedStatement.executeQuery();
                        while (resultSet.next()) {
                            String string = resultSet.getString(1);
                            hashMap.put(string, new Database(mySQLDatabaseServer, string));
                        }
                        MySQLDatabaseServer.this.setDatabases(hashMap);
                    }
                    finally {
                        MySQLDatabaseServer.this.notifyChange();
                    }
                }
            }.postCommand("refreshDatabaseList");
        } else {
            this.setDatabases(new HashMap<String, Database>());
            this.notifyChange();
        }
    }

    private synchronized void setDatabases(HashMap<String, Database> hashMap) {
        this.databases = hashMap;
    }

    @Override
    public synchronized Collection<Database> getDatabases() throws DatabaseException {
        return this.databases.values();
    }

    private void checkNotOnDispatchThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Can not call this method on the event dispatch thread");
        }
    }

    @Override
    public void disconnectSync() {
        this.disconnect(false);
    }

    @Override
    public void disconnect() {
        this.disconnect(true);
    }

    private void disconnect(boolean bl) {
        ArrayBlockingQueue arrayBlockingQueue = null;
        if (!bl) {
            this.checkNotOnDispatchThread();
            arrayBlockingQueue = new ArrayBlockingQueue(1);
        }
        DatabaseCommand databaseCommand = new DatabaseCommand((BlockingQueue)arrayBlockingQueue){

            public void execute() throws Exception {
                Connection connection = MySQLDatabaseServer.this.connProcessor.getConnection();
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.log(Level.FINE, null, sQLException);
                    }
                }
                MySQLDatabaseServer.this.connProcessor.setConnection(null);
                MySQLDatabaseServer.this.setState(DatabaseServer.ServerState.DISCONNECTED);
                MySQLDatabaseServer.this.updateDisplayInformation();
                MySQLDatabaseServer.this.refreshDatabaseList();
            }
        };
        databaseCommand.postCommand("disconnect");
        if (!bl) {
            try {
                databaseCommand.syncUp();
                if (databaseCommand.getException() != null) {
                    Throwable throwable = databaseCommand.getException();
                    if (throwable instanceof DatabaseException) {
                        throw new RuntimeException(throwable);
                    }
                    throw Utils.launderThrowable(throwable);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    @Override
    public void reconnect() throws DatabaseException, TimeoutException {
        this.reconnect(10000L);
    }

    @Override
    public void reconnect(long l) throws DatabaseException, TimeoutException {
        ArrayBlockingQueue arrayBlockingQueue = null;
        this.checkNotOnDispatchThread();
        arrayBlockingQueue = new ArrayBlockingQueue(1);
        DatabaseCommand databaseCommand = new DatabaseCommand((BlockingQueue)arrayBlockingQueue){

            public void execute() throws Exception {
                MySQLDatabaseServer.this.disconnectSync();
                MySQLDatabaseServer.this.checkConfiguration();
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)Utils.getMessage("MSG_ConnectingToServer", new Object[0]));
                try {
                    progressHandle.start();
                    progressHandle.switchToIndeterminate();
                    Connection connection = DatabaseUtils.connect(MySQLDatabaseServer.this.getURL(), MySQLDatabaseServer.this.getUser(), MySQLDatabaseServer.this.getPassword());
                    if (connection == null) {
                        throw new DatabaseException(NbBundle.getMessage(MySQLDatabaseServer.class, (String)"MSG_UnableToConnect", (Object)MySQLDatabaseServer.this.getURL(), (Object)MySQLDatabaseServer.this.getUser()));
                    }
                    MySQLDatabaseServer.this.connProcessor.setConnection(connection);
                    MySQLDatabaseServer.this.setState(DatabaseServer.ServerState.CONNECTED);
                }
                catch (DatabaseException databaseException) {
                    MySQLDatabaseServer.this.disconnect();
                    throw databaseException;
                }
                catch (TimeoutException timeoutException) {
                    MySQLDatabaseServer.this.disconnect();
                    throw timeoutException;
                }
                finally {
                    MySQLDatabaseServer.this.refreshDatabaseList();
                    progressHandle.finish();
                }
            }
        };
        databaseCommand.postCommand("reconnect");
        try {
            databaseCommand.syncUp();
            if (databaseCommand.getException() != null) {
                if (databaseCommand.getException() instanceof DatabaseException) {
                    throw new DatabaseException(databaseCommand.getException());
                }
                if (databaseCommand.getException() instanceof TimeoutException) {
                    TimeoutException timeoutException = new TimeoutException(databaseCommand.getException().getMessage());
                    timeoutException.initCause(databaseCommand.getException());
                    throw timeoutException;
                }
                throw Utils.launderThrowable(databaseCommand.getException());
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.log(Level.INFO, null, interruptedException);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkConfiguration() throws DatabaseException {
        try {
            InetAddress.getAllByName(this.getHost());
        }
        catch (UnknownHostException unknownHostException) {
            MySQLDatabaseServer mySQLDatabaseServer = this;
            synchronized (mySQLDatabaseServer) {
                this.configError = NbBundle.getMessage(MySQLDatabaseServer.class, (String)"MSG_UnknownHost", (Object)this.getHost());
                this.setState(DatabaseServer.ServerState.CONFIGERR);
            }
            LOGGER.log(Level.INFO, this.configError, unknownHostException);
            throw new DatabaseException(this.configError, (Throwable)unknownHostException);
        }
        try {
            String string = this.getPort();
            if (string == null) {
                throw new NumberFormatException();
            }
            Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            MySQLDatabaseServer mySQLDatabaseServer = this;
            synchronized (mySQLDatabaseServer) {
                this.configError = NbBundle.getMessage(MySQLDatabaseServer.class, (String)"MSG_InvalidPortNumber", (Object)this.getPort());
                this.setState(DatabaseServer.ServerState.CONFIGERR);
            }
            LOGGER.log(Level.INFO, this.configError, numberFormatException);
            throw new DatabaseException(this.configError, (Throwable)numberFormatException);
        }
    }

    @Override
    public void validateConnection() throws DatabaseException {
        ArrayBlockingQueue arrayBlockingQueue = new ArrayBlockingQueue(1);
        DatabaseCommand databaseCommand = new DatabaseCommand((BlockingQueue)arrayBlockingQueue, true){

            public void execute() throws Exception {
            }
        };
        databaseCommand.postCommand("validateConnection");
        try {
            databaseCommand.syncUp();
            Throwable throwable = databaseCommand.getException();
            if (throwable != null) {
                if (throwable instanceof DatabaseException) {
                    throw (DatabaseException)throwable;
                }
                throw Utils.launderThrowable(throwable);
            }
        }
        catch (InterruptedException interruptedException) {
            this.disconnect();
            throw new DatabaseException((Throwable)interruptedException);
        }
    }

    @Override
    public boolean databaseExists(String string) throws DatabaseException {
        return this.databases.containsKey(string);
    }

    @Override
    public void createDatabase(final String string) {
        new DatabaseCommand(true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() throws Exception {
                try {
                    Connection connection = MySQLDatabaseServer.this.connProcessor.getConnection();
                    SQLIdentifiers.Quoter quoter = MySQLDatabaseServer.this.connProcessor.getQuoter();
                    String string2 = quoter.quoteIfNeeded(string);
                    connection.prepareStatement(MySQLDatabaseServer.CREATE_DATABASE_SQL + string2).executeUpdate();
                }
                finally {
                    MySQLDatabaseServer.this.refreshDatabaseList();
                }
            }
        }.postCommand("createDatabase");
    }

    @Override
    public void dropDatabase(final String string, final boolean bl) {
        new DatabaseCommand(true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() throws Exception {
                try {
                    Connection connection = MySQLDatabaseServer.this.connProcessor.getConnection();
                    SQLIdentifiers.Quoter quoter = MySQLDatabaseServer.this.connProcessor.getQuoter();
                    String string4 = quoter.quoteIfNeeded(string);
                    connection.prepareStatement(MySQLDatabaseServer.DROP_DATABASE_SQL + string4).executeUpdate();
                    if (bl) {
                        DatabaseConnection[] databaseConnectionArray;
                        String string2 = MySQLDatabaseServer.this.getHost();
                        String string3 = Utils.getHostIpAddress(string2);
                        for (DatabaseConnection databaseConnection : databaseConnectionArray = ConnectionManager.getDefault().getConnections()) {
                            if (!databaseConnection.getDriverClass().equals(MySQLOptions.getDriverClass()) || !databaseConnection.getDatabaseURL().contains("/" + string) || !databaseConnection.getDatabaseURL().contains(MySQLDatabaseServer.this.getHost()) && !databaseConnection.getDatabaseURL().contains(string3) || !databaseConnection.getDatabaseURL().contains(MySQLDatabaseServer.this.getPort())) continue;
                            ConnectionManager.getDefault().removeConnection(databaseConnection);
                        }
                    }
                }
                finally {
                    MySQLDatabaseServer.this.refreshDatabaseList();
                }
            }
        }.postCommand("dropDatabase");
    }

    @Override
    public void dropDatabase(String string) {
        this.dropDatabase(string, true);
    }

    @Override
    public List<DatabaseUser> getUsers() throws DatabaseException {
        final ArrayList<DatabaseUser> arrayList = new ArrayList<DatabaseUser>();
        if (!this.isConnected()) {
            return arrayList;
        }
        ArrayBlockingQueue arrayBlockingQueue = new ArrayBlockingQueue(1);
        DatabaseCommand databaseCommand = new DatabaseCommand(arrayBlockingQueue, true){

            public void execute() throws Exception {
                ResultSet resultSet = MySQLDatabaseServer.this.connProcessor.getConnection().prepareStatement(MySQLDatabaseServer.GET_USERS_SQL).executeQuery();
                while (resultSet.next()) {
                    String string = resultSet.getString(1).trim();
                    String string2 = resultSet.getString(2).trim();
                    arrayList.add(new DatabaseUser(string, string2));
                }
                resultSet.close();
            }
        };
        databaseCommand.postCommand("getUsers");
        try {
            databaseCommand.syncUp();
            if (databaseCommand.getException() != null) {
                Throwable throwable = databaseCommand.getException();
                if (throwable instanceof DatabaseException) {
                    throw (DatabaseException)throwable;
                }
                throw Utils.launderThrowable(throwable);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new DatabaseException((Throwable)interruptedException);
        }
        return arrayList;
    }

    @Override
    public void grantFullDatabaseRights(final String string, final DatabaseUser databaseUser) {
        new DatabaseCommand(true){

            public void execute() throws Exception {
                String string2 = MySQLDatabaseServer.this.connProcessor.getQuoter().quoteIfNeeded(string);
                PreparedStatement preparedStatement = MySQLDatabaseServer.this.connProcessor.getConnection().prepareStatement(MySQLDatabaseServer.GRANT_ALL_SQL_1 + string2 + MySQLDatabaseServer.GRANT_ALL_SQL_2);
                preparedStatement.setString(1, databaseUser.getUser());
                preparedStatement.setString(2, databaseUser.getHost());
                preparedStatement.executeUpdate();
            }
        }.postCommand("grantFullDatabaseRights");
    }

    @Override
    public void start() throws DatabaseException {
        if (!Utils.isValidExecutable(this.getStartPath(), false)) {
            throw new DatabaseException(Utils.getMessage("MSG_InvalidStartCommand", new Object[0]));
        }
        new DatabaseCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() throws Exception {
                DatabaseServer.ServerState serverState = MySQLDatabaseServer.this.checkRunning(1000L);
                if (serverState == DatabaseServer.ServerState.CONNECTED) {
                    return;
                }
                try {
                    MySQLDatabaseServer.this.runProcess(MySQLDatabaseServer.this.getStartPath(), MySQLDatabaseServer.this.getStartArgs(), Utils.getMessage("LBL_MySQLOutputTab", new Object[0]));
                }
                finally {
                    MySQLDatabaseServer.this.updateDisplayInformation();
                    MySQLDatabaseServer.this.notifyChange();
                }
            }
        }.postCommand("start");
    }

    @Override
    public void stop() throws DatabaseException {
        if (!Utils.isValidExecutable(this.getStopPath(), false)) {
            throw new DatabaseException(Utils.getMessage("MSG_InvalidStopCommand", new Object[0]));
        }
        new StopDatabaseCommand().postCommand("stop");
    }

    @Override
    public void startAdmin() throws DatabaseException {
        String string = this.getAdminPath();
        if (string == null || string.length() == 0) {
            throw new DatabaseException(NbBundle.getMessage(DatabaseServer.class, (String)"MSG_AdminCommandNotSet"));
        }
        if (Utils.isValidURL(string, false)) {
            this.launchBrowser(string);
        } else if (Utils.isValidExecutable(string, false)) {
            this.runProcess(string, this.getAdminArgs(), Utils.getMessage("LBL_MySQLOutputTab", new Object[0]));
            MySQLDatabaseServer.closeOutput();
        } else {
            throw new DatabaseException(NbBundle.getMessage(DatabaseServer.class, (String)"MSG_InvalidAdminCommand", (Object)string));
        }
    }

    private Process runProcess(String string, String string2, String string3) throws DatabaseException {
        if (Utilities.isMac() && string.endsWith(".app")) {
            string2 = "\"" + string + "\" " + string2;
            string = "/usr/bin/open";
        }
        try {
            NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor(string, string2);
            Process process = nbProcessDescriptor.exec();
            new ExecSupport().displayProcessOutputs(process, string3);
            return process;
        }
        catch (Exception exception) {
            throw new DatabaseException((Throwable)exception);
        }
    }

    private void launchBrowser(String string) throws DatabaseException {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(string));
        }
        catch (Exception exception) {
            throw new DatabaseException((Throwable)exception);
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public synchronized DatabaseServer.ServerState getState() {
        return this.runstate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(DatabaseServer.ServerState serverState) {
        MySQLDatabaseServer mySQLDatabaseServer = this;
        synchronized (mySQLDatabaseServer) {
            this.runstate = serverState;
            if (serverState != DatabaseServer.ServerState.CONFIGERR) {
                this.configError = null;
            }
            this.updateDisplayInformation();
        }
        this.notifyChange();
    }

    public DatabaseServer.ServerState checkRunning() {
        return this.checkRunning(5000L);
    }

    public DatabaseServer.ServerState checkRunning(long l) {
        try {
            this.reconnect(l);
        }
        catch (DatabaseException databaseException) {
            LOGGER.log(Level.FINE, null, databaseException);
        }
        catch (TimeoutException timeoutException) {
            LOGGER.log(Level.INFO, null, timeoutException);
        }
        return this.runstate;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.pcs.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    @Override
    public Image getIcon() {
        return this.icon;
    }

    @Override
    public synchronized boolean hasConfigurationError() {
        return this.runstate == DatabaseServer.ServerState.CONFIGERR;
    }

    private static void closeOutput() {
        InputOutput inputOutput = IOProvider.getDefault().getIO(Utils.getMessage("LBL_MySQLOutputTab", new Object[0]), false);
        if (inputOutput != null && inputOutput.getOut() != null) {
            if (first) {
                first = false;
                inputOutput.getOut().println(' ');
            }
            inputOutput.getOut().close();
        }
    }

    static {
        OPTIONS = MySQLOptions.getDefault();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class DatabaseCommand
    implements Runnable {
        private Throwable throwable;
        private final BlockingQueue<Runnable> outqueue;
        private boolean checkConnection = false;
        private String callingMethod = "<unknown>";

        public DatabaseCommand(BlockingQueue<Runnable> blockingQueue) {
            this(blockingQueue, false);
        }

        public DatabaseCommand(BlockingQueue<Runnable> blockingQueue, boolean bl) {
            this.outqueue = blockingQueue;
            this.checkConnection = bl;
        }

        public DatabaseCommand(boolean bl) {
            this(null, bl);
        }

        public DatabaseCommand() {
            this(null, false);
        }

        public void postCommand(String string) {
            this.callingMethod = string;
            if (MySQLDatabaseServer.this.connProcessor.isConnProcessorThread()) {
                this.run();
            } else {
                MySQLDatabaseServer.this.commandQueue.offer(this);
            }
        }

        public void syncUp() throws InterruptedException {
            if (MySQLDatabaseServer.this.connProcessor.isConnProcessorThread()) {
                return;
            }
            assert (this.outqueue != null);
            this.outqueue.take();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.checkConnection) {
                    try {
                        MySQLDatabaseServer.this.connProcessor.validateConnection();
                    }
                    catch (DatabaseException databaseException) {
                        try {
                            MySQLDatabaseServer.this.reconnect();
                        }
                        catch (DatabaseException databaseException2) {
                            LOGGER.log(Level.INFO, null, databaseException2);
                            MySQLDatabaseServer.this.disconnect();
                            throw databaseException;
                        }
                    }
                }
                this.execute();
            }
            catch (DatabaseException databaseException) {
                if (this.outqueue != null) {
                    this.throwable = databaseException;
                } else {
                    LOGGER.log(Level.INFO, NbBundle.getMessage(MySQLDatabaseServer.class, (String)"MSG_DatabaseCommandFailed", (Object)this.callingMethod), databaseException);
                    Utils.displayErrorMessage(databaseException.getMessage());
                }
            }
            catch (Exception exception) {
                if (this.outqueue != null) {
                    this.throwable = exception;
                } else {
                    String string = NbBundle.getMessage(MySQLDatabaseServer.class, (String)"MSG_DatabaseCommandFailed", (Object)this.callingMethod);
                    Exceptions.printStackTrace((Throwable)new Exception(string, exception));
                }
            }
            finally {
                if (this.outqueue != null) {
                    this.outqueue.offer(this);
                }
            }
        }

        public abstract void execute() throws Exception;

        public Throwable getException() {
            return this.throwable;
        }
    }

    private class StopDatabaseCommand
    extends DatabaseCommand
    implements Cancellable {
        private Process proc = null;

        private StopDatabaseCommand() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws Exception {
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)Utils.getMessage("LBL_StoppingMySQLServer", new Object[0]), (Cancellable)this);
            try {
                progressHandle.start();
                progressHandle.switchToIndeterminate();
                this.proc = MySQLDatabaseServer.this.runProcess(MySQLDatabaseServer.this.getStopPath(), MySQLDatabaseServer.this.getStopArgs(), Utils.getMessage("LBL_MySQLOutputTab", new Object[0]));
                this.proc.waitFor();
            }
            finally {
                if (this.proc != null) {
                    this.proc.destroy();
                    MySQLDatabaseServer.closeOutput();
                }
                progressHandle.finish();
            }
        }

        public boolean cancel() {
            this.proc.destroy();
            MySQLDatabaseServer.closeOutput();
            return true;
        }
    }
}

