/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.bookmarks.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public final class Bookmark {
    public static final String BOOKMARK_ANNOTATION_TYPE = "editor-bookmark";
    private static Map<Line, AAnnotation> lineToAnnotation = new WeakHashMap<Line, AAnnotation>();
    private BookmarkList bookmarkList;
    private boolean released;
    private Line line;
    private AAnnotation annotation;
    private Map<BookmarkList, LineListener> bookmarkListToLineListener = new WeakHashMap<BookmarkList, LineListener>();

    Bookmark(BookmarkList bookmarkList, int n) {
        this.bookmarkList = bookmarkList;
        StyledDocument styledDocument = (StyledDocument)bookmarkList.getDocument();
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)styledDocument);
        for (Line line : lineToAnnotation.keySet()) {
            if (line.getLineNumber() != n2 || !((DataObject)line.getLookup().lookup(DataObject.class)).equals(dataObject)) continue;
            this.line = line;
            this.annotation = lineToAnnotation.get(line);
            return;
        }
        this.annotation = new AAnnotation();
        this.line = NbEditorUtilities.getLine((Document)bookmarkList.getDocument(), (int)n, (boolean)false);
        lineToAnnotation.put(this.line, this.annotation);
        this.annotation.attach((Annotatable)this.line);
        Object object = this.bookmarkListToLineListener.get(bookmarkList);
        if (object == null) {
            object = new LineListener(bookmarkList);
            this.bookmarkListToLineListener.put(bookmarkList, (LineListener)object);
        }
        this.line.addPropertyChangeListener((PropertyChangeListener)object);
    }

    public int getOffset() {
        return NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.bookmarkList.getDocument()), (int)this.line.getLineNumber());
    }

    public int getLineNumber() {
        return this.line.getLineNumber();
    }

    public BookmarkList getList() {
        return this.bookmarkList;
    }

    public boolean isReleased() {
        return this.released;
    }

    void release() {
        assert (!this.released);
        this.released = true;
        this.annotation.detach();
        lineToAnnotation.remove(this.line);
    }

    public final class AAnnotation
    extends Annotation {
        public String getAnnotationType() {
            return Bookmark.BOOKMARK_ANNOTATION_TYPE;
        }

        public String getShortDescription() {
            String string = NbBundle.getBundle(Bookmark.class).getString("Bookmark_Tooltip");
            int n = Bookmark.this.getLineNumber();
            return MessageFormat.format(string, new Integer(n + 1));
        }

        public String toString() {
            return this.getShortDescription();
        }
    }

    private static class LineListener
    implements PropertyChangeListener {
        private WeakReference<BookmarkList> bookmarkListReference;

        LineListener(BookmarkList bookmarkList) {
            this.bookmarkListReference = new WeakReference<BookmarkList>(bookmarkList);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BookmarkList bookmarkList = (BookmarkList)this.bookmarkListReference.get();
            if (bookmarkList == null) {
                return;
            }
            ArrayList<Bookmark> arrayList = new ArrayList<Bookmark>(bookmarkList.getBookmarks());
            int n = -1;
            for (Bookmark bookmark : arrayList) {
                if (bookmark.getLineNumber() == n) {
                    bookmarkList.removeBookmark(bookmark);
                }
                n = bookmark.getLineNumber();
            }
        }
    }
}

