/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.DefaultTabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.EqualPolygon;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;
import org.openide.util.Utilities;

public class ToolbarTabDisplayerUI
extends AbstractTabDisplayerUI {
    private JToolBar toolbar = null;
    private static final Border buttonBorder;
    private static final boolean isMac;
    private ButtonGroup bg = new ButtonGroup();
    private static int fontHeight;
    private static int ascent;
    private static final boolean isAqua;

    public ToolbarTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new ToolbarTabDisplayerUI((TabDisplayer)jComponent);
    }

    protected TabLayoutModel createLayoutModel() {
        return null;
    }

    protected void install() {
        this.toolbar = new TabToolbar();
        this.toolbar.setLayout(new AutoGridLayout());
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.toolbar.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.displayer.setLayout(new BorderLayout());
        this.displayer.add((Component)this.toolbar, "Center");
        if (this.displayer.getModel() != null && this.displayer.getModel().size() > 0) {
            this.syncButtonsWithModel();
        }
    }

    protected void modelChanged() {
        if (this.syncButtonsWithModel() && this.displayer.getParent() != null) {
            ((JComponent)this.displayer.getParent()).revalidate();
        }
    }

    protected MouseListener createMouseListener() {
        return null;
    }

    private IndexButton findButtonFor(int n) {
        Component[] componentArray = this.toolbar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof IndexButton) || ((IndexButton)componentArray[i]).getIndex() != n) continue;
            return (IndexButton)componentArray[i];
        }
        return null;
    }

    public void requestAttention(int n) {
    }

    public void cancelRequestAttention(int n) {
    }

    protected ChangeListener createSelectionListener() {
        return new ChangeListener(){
            private int lastKnownSelection = -1;

            public void stateChanged(ChangeEvent changeEvent) {
                int n = ToolbarTabDisplayerUI.this.selectionModel.getSelectedIndex();
                if (n != this.lastKnownSelection) {
                    IndexButton indexButton;
                    if (this.lastKnownSelection != -1 && (indexButton = ToolbarTabDisplayerUI.this.findButtonFor(this.lastKnownSelection)) != null) {
                        indexButton.getModel().setSelected(false);
                    }
                    if (n != -1) {
                        indexButton = ToolbarTabDisplayerUI.this.findButtonFor(n);
                        if (ToolbarTabDisplayerUI.this.toolbar.getComponentCount() == 0) {
                            ToolbarTabDisplayerUI.this.syncButtonsWithModel();
                        }
                        if (indexButton != null) {
                            indexButton.getModel().setSelected(true);
                        }
                    }
                }
                this.lastKnownSelection = n;
            }
        };
    }

    public Polygon getExactTabIndication(int n) {
        IndexButton indexButton = this.findButtonFor(n);
        if (indexButton != null) {
            return new EqualPolygon(indexButton.getBounds());
        }
        return new EqualPolygon(new Rectangle());
    }

    public Polygon getInsertTabIndication(int n) {
        return this.getExactTabIndication(n);
    }

    public Rectangle getTabRect(int n, Rectangle rectangle) {
        rectangle.setBounds(this.findButtonFor(n).getBounds());
        return rectangle;
    }

    public int tabForCoordinate(Point point) {
        Point point2 = SwingUtilities.convertPoint(this.displayer, point, this.toolbar);
        Component component = this.toolbar.getComponentAt(point2);
        if (component instanceof IndexButton) {
            return ((IndexButton)component).getIndex();
        }
        return -1;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.toolbar.getPreferredSize();
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.toolbar.getMinimumSize();
    }

    private boolean syncButtonsWithModel() {
        int n;
        boolean bl;
        assert (SwingUtilities.isEventDispatchThread());
        int n2 = this.displayer.getModel().size();
        int n3 = this.toolbar.getComponentCount();
        boolean bl2 = bl = n3 != n2;
        if (bl) {
            if (n2 > n3) {
                for (n = n3; n < n2; ++n) {
                    this.toolbar.add(new IndexButton());
                }
            } else if (n2 < n3) {
                for (n = n2; n < n3; ++n) {
                    this.toolbar.remove(this.toolbar.getComponentCount() - 1);
                }
            }
        }
        if ((n = this.selectionModel.getSelectedIndex()) != -1) {
            this.findButtonFor(n).setSelected(true);
        }
        if (bl) {
            this.displayer.revalidate();
            this.displayer.repaint();
        }
        return bl;
    }

    public Icon getButtonIcon(int n, int n2) {
        return null;
    }

    static /* synthetic */ boolean access$1500() {
        return isAqua;
    }

    static {
        isMac = "Aqua".equals(UIManager.getLookAndFeel().getID());
        Border border = (Border)UIManager.get("nb.tabbutton.border");
        if (border == null) {
            JToolBar jToolBar = new JToolBar();
            JButton jButton = new JButton();
            jToolBar.setRollover(true);
            jToolBar.add(jButton);
            border = jButton.getBorder();
            jToolBar.remove(jButton);
        }
        buttonBorder = border;
        fontHeight = -1;
        ascent = -1;
        isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
    }

    static class AutoGridLayout
    implements LayoutManager {
        private int h_margin_left = ToolbarTabDisplayerUI.access$1500() ? 0 : 2;
        private int h_margin_right = ToolbarTabDisplayerUI.access$1500() ? 0 : 1;
        private int v_margin_top = ToolbarTabDisplayerUI.access$1500() ? 0 : 2;
        private int v_margin_bottom = ToolbarTabDisplayerUI.access$1500() ? 0 : 3;
        private int h_gap = ToolbarTabDisplayerUI.access$1500() ? 0 : 1;
        private int v_gap = ToolbarTabDisplayerUI.access$1500() ? 0 : 1;

        AutoGridLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n;
                int n2 = container.getWidth();
                int n3 = container.getComponentCount();
                if (n2 <= 0 || n3 == 0) {
                    int n4 = 0;
                    int n5 = 0;
                    for (int i = 0; i < n3; ++i) {
                        Dimension dimension = container.getComponent(i).getPreferredSize();
                        n4 += dimension.width;
                        if (i + 1 < n3) {
                            n4 += this.h_gap;
                        }
                        if (dimension.height <= n5) continue;
                        n5 = dimension.height;
                    }
                    return new Dimension(n4 += this.h_margin_left + this.h_margin_right, n5 += this.v_margin_top + this.v_margin_bottom);
                }
                int n6 = 0;
                int n7 = 0;
                for (n = 0; n < n3; ++n) {
                    Dimension dimension = container.getComponent(n).getPreferredSize();
                    if (dimension.width > n6) {
                        n6 = dimension.width;
                    }
                    if (dimension.height <= n7) continue;
                    n7 = dimension.height;
                }
                n = 0;
                int n8 = this.h_margin_left + n6 + this.h_margin_right;
                while ((n8 += this.h_gap + n6) <= n2 && ++n < n3) {
                }
                int n9 = n3 / n + (n3 % n > 0 ? 1 : 0);
                int n10 = this.v_margin_top + n9 * n7 + (n9 - 1) * this.v_gap + this.v_margin_bottom;
                Dimension dimension = new Dimension(n2, n10);
                return dimension;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(this.h_margin_left + this.h_margin_right, this.v_margin_top + this.v_margin_bottom);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n;
                int n2;
                int n3;
                int n4 = container.getComponentCount();
                if (n4 == 0) {
                    return;
                }
                int n5 = 0;
                int n6 = 0;
                for (n3 = 0; n3 < n4; ++n3) {
                    Dimension dimension = container.getComponent(n3).getPreferredSize();
                    if (dimension.width > n5) {
                        n5 = dimension.width;
                    }
                    if (dimension.height <= n6) continue;
                    n6 = dimension.height;
                }
                n3 = container.getWidth();
                int n7 = 0;
                int n8 = this.h_margin_left + n5 + this.h_margin_right;
                while ((n8 += this.h_gap + n5) <= n3 && ++n7 < n4) {
                }
                if (n4 % n7 > 0 && (n2 = n7 - n4 % n7) > (n = n4 / n7)) {
                    n7 -= n2 / (n + 1);
                }
                if (n4 > n7) {
                    n5 = (n3 - this.h_margin_left - this.h_margin_right - (n7 - 1) * this.h_gap) / n7;
                }
                if (n5 < 0) {
                    n5 = 0;
                }
                n2 = 0;
                int n9 = 0;
                for (n = 0; n < n4; ++n) {
                    container.getComponent(n).setBounds(this.h_margin_left + n2 * (n5 + this.h_gap), this.v_margin_top + n9 * (n6 + this.v_gap), n5, n6);
                    if (++n2 < n7) continue;
                    n2 = 0;
                    ++n9;
                }
            }
        }
    }

    public final class IndexButton
    extends JToggleButton
    implements ActionListener {
        private String lastKnownText = null;

        public IndexButton() {
            this.addActionListener(this);
            this.setFont(ToolbarTabDisplayerUI.this.displayer.getFont());
            this.setFocusable(false);
            if (isMac) {
                this.putClientProperty("JButton.buttonType", "square");
            } else {
                this.setBorder(buttonBorder);
                this.setMargin(new Insets(0, 3, 0, 3));
            }
            this.setRolloverEnabled(true);
        }

        public void addNotify() {
            super.addNotify();
            ToolTipManager.sharedInstance().registerComponent(this);
            ToolbarTabDisplayerUI.this.bg.add(this);
        }

        public void removeNotify() {
            super.removeNotify();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            ToolbarTabDisplayerUI.this.bg.remove(this);
        }

        public boolean isActive() {
            return ToolbarTabDisplayerUI.this.displayer.isActive();
        }

        public String getText() {
            return " ";
        }

        public String doGetText() {
            int n = this.getIndex();
            if (n == -1) {
                return "";
            }
            if (this.getIndex() >= ToolbarTabDisplayerUI.this.displayer.getModel().size()) {
                return "This tab doesn't exist.";
            }
            this.lastKnownText = ToolbarTabDisplayerUI.this.displayer.getModel().getTab(n).getText();
            return this.lastKnownText;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            String string = this.doGetText();
            int n = DefaultTabLayoutModel.textWidth(string, this.getFont());
            dimension.width += n;
            if (Utilities.isMac()) {
                dimension.height -= 3;
                dimension.width -= 5;
            }
            return dimension;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            String string = this.doGetText();
            Insets insets = this.getInsets();
            int n = insets.left;
            int n2 = this.getWidth() - (insets.left + insets.right);
            int n3 = this.getHeight();
            int n4 = DefaultTabLayoutModel.textWidth(string, this.getFont());
            if (n4 < n2) {
                n += n2 / 2 - n4 / 2;
            }
            if (fontHeight == -1) {
                FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
                fontHeight = fontMetrics.getHeight();
                ascent = fontMetrics.getMaxAscent();
            }
            int n5 = insets.top + ascent + ((this.getHeight() - (insets.top + insets.bottom)) / 2 - fontHeight / 2);
            HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)n, (int)n5, (int)n2, (int)n3, (Font)this.getFont(), (Color)this.getForeground(), (int)1, (boolean)true);
        }

        public String getToolTipText() {
            return ToolbarTabDisplayerUI.this.displayer.getModel().getTab(this.getIndex()).getTooltip();
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            ToolbarTabDisplayerUI.this.selectionModel.setSelectedIndex(this.getIndex());
        }

        public int getIndex() {
            if (this.getParent() != null) {
                return Arrays.asList(this.getParent().getComponents()).indexOf(this);
            }
            return -1;
        }

        public Icon getIcon() {
            return null;
        }

        final boolean checkChanged() {
            boolean bl = false;
            String string = this.lastKnownText;
            String string2 = this.doGetText();
            if (string2 != string) {
                this.firePropertyChange("text", this.lastKnownText, this.doGetText());
                bl = true;
            }
            if (bl) {
                this.firePropertyChange("preferredSize", null, null);
            }
            return bl;
        }
    }

    static class TabToolbar
    extends JToolBar {
        TabToolbar() {
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Color color = graphics.getColor();
            graphics.setColor(UIManager.getColor("controlLtHighlight"));
            graphics.drawLine(0, 0, this.getWidth(), 0);
            graphics.drawLine(0, 0, 0, this.getHeight() - 1);
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            graphics.setColor(color);
        }
    }
}

