/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.xml.tax.beans.Lib;
import org.netbeans.modules.xml.tax.beans.TreeObjectListProxyListener;
import org.netbeans.modules.xml.tax.beans.editor.Util;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeName;
import org.netbeans.tax.TreeNamedObjectMap;
import org.openide.util.WeakListeners;

public class TreeElementAttributeListCustomizer
extends JPanel
implements Customizer,
PropertyChangeListener {
    private static final long serialVersionUID = 1071471854210683733L;
    private String headerToolTip = Util.THIS.getString("PROP_headerTooltip");
    private final int COL_NAME = 0;
    private final int COL_VALUE = 1;
    private final int COL_COUNT = 2;
    private JTable attrTable;
    private JButton addButton;
    private JScrollPane tableScrollPane;
    private JButton downButton;
    private JButton upButton;
    private JButton removeButton;
    private TreeNamedObjectMap peer;
    private AttlistTableModel tableModel;

    public TreeElementAttributeListCustomizer() {
        this.initComponents();
        this.upButton.setMnemonic(Util.THIS.getChar("MNE_element_attributelist_up"));
        this.downButton.setMnemonic(Util.THIS.getChar("MNE_element_attributelist_down"));
        this.removeButton.setMnemonic(Util.THIS.getChar("MNE_element_attributelist_remove"));
        this.addButton.setMnemonic(Util.THIS.getChar("MNE_element_attributelist_add"));
        this.initAccessibility();
        this.attrTable.getTableHeader().setDefaultRenderer(new HeaderRenderer());
        JTextField jTextField = new JTextField();
        jTextField.getCaret().setVisible(true);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
        defaultCellEditor.setClickCountToStart(1);
        this.attrTable.setDefaultEditor(String.class, defaultCellEditor);
        this.attrTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.attrTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\n#=- TreeElementAttributeListCustomizer::ListSelectionListener.valueChanged: event = " + listSelectionEvent);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("#=-     event.getValueIsAdjusting() = " + listSelectionEvent.getValueIsAdjusting());
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("#=-     event.getFirstIndex()       = " + listSelectionEvent.getFirstIndex());
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("#=-     event.getLastIndex()        = " + listSelectionEvent.getLastIndex());
                }
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("#=-     event.getSource()                 = " + listSelectionModel);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("#=-     selectionModel.isSelectionEmpty() = " + listSelectionModel.isSelectionEmpty());
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("#=-     attrTable.getSelectedRow()        = " + TreeElementAttributeListCustomizer.this.attrTable.getSelectedRow());
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("#=-     attrTable.getRowCount()           = " + TreeElementAttributeListCustomizer.this.attrTable.getRowCount());
                }
                if (listSelectionModel.isSelectionEmpty() || TreeElementAttributeListCustomizer.this.attrTable.getRowCount() == 0) {
                    TreeElementAttributeListCustomizer.this.upButton.setEnabled(false);
                    TreeElementAttributeListCustomizer.this.downButton.setEnabled(false);
                    TreeElementAttributeListCustomizer.this.removeButton.setEnabled(false);
                } else {
                    TreeElementAttributeListCustomizer.this.upButton.setEnabled(TreeElementAttributeListCustomizer.this.attrTable.getSelectedRow() > 0);
                    TreeElementAttributeListCustomizer.this.downButton.setEnabled(TreeElementAttributeListCustomizer.this.attrTable.getSelectedRow() < TreeElementAttributeListCustomizer.this.numRows() - 1);
                    TreeElementAttributeListCustomizer.this.removeButton.setEnabled(true);
                }
            }
        });
        this.attrTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = TreeElementAttributeListCustomizer.this.attrTable.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                if (n < 0) {
                    return;
                }
                int n2 = tableColumnModel.getColumn(n).getModelIndex();
                if (n2 < 0) {
                    return;
                }
                AttlistTableModel attlistTableModel = (AttlistTableModel)TreeElementAttributeListCustomizer.this.attrTable.getModel();
                attlistTableModel.sortByColumn(n);
            }
        });
    }

    private int numRows() {
        return this.attrTable.getModel().getRowCount();
    }

    private int numCols() {
        return this.attrTable.getModel().getColumnCount();
    }

    private void initComponents() {
        this.tableScrollPane = new JScrollPane();
        this.attrTable = new JTable();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(350, 230));
        this.attrTable.setPreferredScrollableViewportSize(new Dimension(200, 150));
        this.tableScrollPane.setViewportView(this.attrTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.tableScrollPane, gridBagConstraints);
        this.upButton.setText(Util.THIS.getString("TEXT_element_attributelist_up"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeElementAttributeListCustomizer.this.upButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setText(Util.THIS.getString("TEXT_element_attributelist_down"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeElementAttributeListCustomizer.this.downButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.add((Component)this.downButton, gridBagConstraints);
        this.addButton.setText(Util.THIS.getString("TEXT_element_attributelist_add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeElementAttributeListCustomizer.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText(Util.THIS.getString("TEXT_element_attributelist_remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeElementAttributeListCustomizer.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.add((Component)this.removeButton, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        AttlistTableModel attlistTableModel = (AttlistTableModel)this.attrTable.getModel();
        attlistTableModel.addRow();
        int n = this.numRows() - 1;
        this.attrTable.getSelectionModel().setSelectionInterval(n, n);
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        AttlistTableModel attlistTableModel = (AttlistTableModel)this.attrTable.getModel();
        int n = this.attrTable.getSelectedRow();
        if (n > 0) {
            attlistTableModel.moveRow(n, n - 1);
            this.attrTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        AttlistTableModel attlistTableModel = (AttlistTableModel)this.attrTable.getModel();
        int n = this.attrTable.getSelectedRow();
        if (n > -1) {
            attlistTableModel.removeRow(n);
            if (this.numRows() > 0) {
                if (n <= this.numRows() - 1) {
                    this.attrTable.getSelectionModel().setSelectionInterval(n, n);
                } else {
                    this.attrTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
                }
            } else {
                this.removeButton.setEnabled(false);
            }
        }
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        AttlistTableModel attlistTableModel = (AttlistTableModel)this.attrTable.getModel();
        int n = this.attrTable.getSelectedRow();
        if (n > -1 && n < this.numRows() - 1) {
            attlistTableModel.moveRow(n, n + 1);
            this.attrTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
        }
    }

    public void setObject(Object object) {
        this.peer = (TreeNamedObjectMap)object;
        this.tableModel = new AttlistTableModel();
        this.attrTable.setModel(this.tableModel);
        TableColumn tableColumn = null;
        for (int i = 0; i < 2; ++i) {
            tableColumn = this.attrTable.getColumnModel().getColumn(i);
        }
        this.updateView();
        TreeObjectListProxyListener treeObjectListProxyListener = new TreeObjectListProxyListener(this.peer);
        treeObjectListProxyListener.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)treeObjectListProxyListener));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == null) {
            return;
        }
        this.updateView();
    }

    private void updateView() {
        this.tableModel.fireTableDataChanged();
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TreeElementAttributeListCustomizer"));
        this.addButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_addButton"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_removeButton"));
        this.upButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_upButton"));
        this.downButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_downButton"));
        this.attrTable.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_attrTable"));
        this.attrTable.getAccessibleContext().setAccessibleName(Util.THIS.getString("ACSN_attrTable"));
    }

    private class AttlistTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1567143493464383838L;
        boolean ascending = true;
        int SortedColumn = -1;
        int[] indexes;

        public int getRowCount() {
            return TreeElementAttributeListCustomizer.this.peer.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String == null ? (class$java$lang$String = TreeElementAttributeListCustomizer.class$("java.lang.String")) : class$java$lang$String;
        }

        public void addRow() {
            TreeAttribute treeAttribute = Lib.createAttributeDialog(true);
            if (treeAttribute != null) {
                boolean bl = true;
                TreeAttribute treeAttribute2 = (TreeAttribute)TreeElementAttributeListCustomizer.this.peer.get(treeAttribute.getTreeName());
                if (treeAttribute2 != null) {
                    bl = Lib.confirmAction(Util.THIS.getString("MSG_replace_attribute", treeAttribute.getQName()));
                }
                if (bl) {
                    TreeElementAttributeListCustomizer.this.peer.add(treeAttribute);
                    this.SortedColumn = -1;
                    this.fireTableStructureChanged();
                }
            }
        }

        public void removeRow(int n) {
            TreeElementAttributeListCustomizer.this.peer.remove(n);
            this.fireTableStructureChanged();
        }

        public void moveRow(int n, int n2) {
            try {
                TreeElementAttributeListCustomizer.this.peer.switchObjects(n, n2);
                this.SortedColumn = -1;
                this.fireTableStructureChanged();
            }
            catch (TreeException treeException) {
                TAXUtil.notifyTreeException(treeException);
            }
        }

        public Object getValueAt(int n, int n2) {
            TreeAttribute treeAttribute = (TreeAttribute)TreeElementAttributeListCustomizer.this.peer.get(n);
            switch (n2) {
                case 0: {
                    return treeAttribute.getQName();
                }
                case 1: {
                    return treeAttribute.getValue();
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            TreeAttribute treeAttribute = (TreeAttribute)TreeElementAttributeListCustomizer.this.peer.get(n);
            try {
                if (n2 == 0) {
                    String string = (String)object;
                    boolean bl = true;
                    TreeAttribute treeAttribute2 = (TreeAttribute)TreeElementAttributeListCustomizer.this.peer.get(new TreeName(string));
                    if (treeAttribute != treeAttribute2 && treeAttribute2 != null) {
                        bl = Lib.confirmAction(Util.THIS.getString("MSG_replace_attribute", string));
                    }
                    if (bl) {
                        treeAttribute.setQName(string);
                    }
                } else if (n2 == 1) {
                    treeAttribute.setValue((String)object);
                }
            }
            catch (TreeException treeException) {
                TAXUtil.notifyTreeException(treeException);
            }
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return Util.THIS.getString("NAME_column_name");
                }
                case 1: {
                    return Util.THIS.getString("NAME_column_value");
                }
            }
            return "";
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public void sortByColumn(int n) {
            if (this.SortedColumn == n) {
                this.ascending = !this.ascending;
            } else {
                this.SortedColumn = n;
                this.ascending = true;
            }
            this.indexes = new int[this.getRowCount()];
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.indexes[i] = i;
            }
            this.n2sort(n);
            int[] nArray = new int[this.indexes.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[this.indexes[i]] = i;
            }
            try {
                TreeElementAttributeListCustomizer.this.peer.reorder(nArray);
                this.fireTableChanged(new TableModelEvent(this));
            }
            catch (TreeException treeException) {
                TAXUtil.notifyTreeException(treeException);
            }
        }

        private void n2sort(int n) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                for (int j = i + 1; j < this.getRowCount(); ++j) {
                    if (this.compare(this.indexes[i], this.indexes[j], n) != -1) continue;
                    int n2 = this.indexes[i];
                    this.indexes[i] = this.indexes[j];
                    this.indexes[j] = n2;
                }
            }
        }

        private int compare(int n, int n2, int n3) {
            int n4 = this.compareRowsByColumn(n, n2, n3);
            if (n4 != 0) {
                return this.ascending ? -n4 : n4;
            }
            return 0;
        }

        private int compareRowsByColumn(int n, int n2, int n3) {
            Class clazz = this.getColumnClass(n3);
            Object object = this.getValueAt(n, n3);
            Object object2 = this.getValueAt(n2, n3);
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (clazz == (class$java$lang$String == null ? (class$java$lang$String = TreeElementAttributeListCustomizer.class$("java.lang.String")) : class$java$lang$String)) {
                String string;
                String string2 = (String)this.getValueAt(n, n3);
                int n4 = string2.compareTo(string = (String)this.getValueAt(n2, n3));
                if (n4 < 0) {
                    return -1;
                }
                if (n4 > 0) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }

    private class HeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -3658206203140258583L;

        public HeaderRenderer() {
            this.setHorizontalAlignment(2);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setToolTipText(TreeElementAttributeListCustomizer.this.headerToolTip);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Serializable serializable;
            if (jTable != null && (serializable = jTable.getTableHeader()) != null) {
                this.setForeground(((Component)serializable).getForeground());
                this.setBackground(((Component)serializable).getBackground());
                this.setFont(((Component)serializable).getFont());
            }
            serializable = (AttlistTableModel)jTable.getModel();
            if (n2 == ((AttlistTableModel)serializable).SortedColumn) {
                this.setIcon(((AttlistTableModel)serializable).ascending ? new ImageIcon(this.getClass().getResource("down.gif")) : new ImageIcon(this.getClass().getResource("up.gif")));
            } else {
                this.setIcon(new ImageIcon(this.getClass().getResource("no.gif")));
            }
            this.setText(object == null ? "" : object.toString());
            return this;
        }
    }

    private class RowKeyListener
    extends KeyAdapter {
        private JTable table;

        public RowKeyListener(JTable jTable) {
            this.table = jTable;
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127) {
                TreeElementAttributeListCustomizer.this.tableModel.removeRow(this.table.getSelectedRow());
            }
        }
    }
}

