/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory;

import java.io.File;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.util.NbBundle;

public class LocalHistoryVCS
extends VersioningSystem {
    public LocalHistoryVCS() {
        this.putProperty("String VCS.DisplayName", NbBundle.getMessage(LocalHistoryVCS.class, (String)"CTL_DisplayName"));
        this.putProperty("String VCS.MenuLabel", NbBundle.getMessage(LocalHistoryVCS.class, (String)"CTL_MainMenuItem"));
        this.putProperty("Boolean VCS.LocalHistory", Boolean.TRUE);
        LocalHistory.getInstance().addVersioningListener(new VersioningListener(){

            public void versioningEvent(VersioningEvent versioningEvent) {
                if (versioningEvent.getId().equals(LocalHistory.EVENT_PROJECTS_CHANGED)) {
                    LocalHistoryVCS.this.fireVersionedFilesChanged();
                }
            }
        });
    }

    public File getTopmostManagedAncestor(File file) {
        if (file == null) {
            return null;
        }
        LocalHistory localHistory = LocalHistory.getInstance();
        if (localHistory.isOpenedOrTouched(file)) {
            return file;
        }
        File file2 = localHistory.isManagedByParent(file);
        if (file2 != null) {
            return file2;
        }
        return null;
    }

    public VCSAnnotator getVCSAnnotator() {
        return LocalHistory.getInstance().getVCSAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return LocalHistory.getInstance().getVCSInterceptor();
    }

    void managedFilesChanged() {
        this.fireVersionedFilesChanged();
    }
}

