/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.LocalHistoryStore;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.utils.FileUtils;
import org.netbeans.modules.turbo.CustomProviders;
import org.netbeans.modules.turbo.Turbo;
import org.netbeans.modules.turbo.TurboProvider;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalHistoryStoreImpl
implements LocalHistoryStore {
    private static final int DELETED = 0;
    private static final int TOUCHED = 1;
    private static final String DATA_FILE = "data";
    private static final String HISTORY_FILE = "history";
    private static final String LABELS_FILE = "labels";
    private static final String STORAGE_FILE = "storage";
    private static final String STORAGE_VERSION = "1.0";
    private File storage;
    private Turbo turbo;
    private DataFilesTurboProvider cacheProvider;
    private final ListenersSupport listenersSupport;
    private static List<HistoryEntry> emptyHistory = new ArrayList<HistoryEntry>(0);
    private static Map<Long, String> emptyLabels = new HashMap<Long, String>();
    private static StoreEntry[] emptyStoreEntryArray = new StoreEntry[0];
    private static FilenameFilter fileEntriesFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return !string.endsWith(LocalHistoryStoreImpl.DATA_FILE) && !string.endsWith(LocalHistoryStoreImpl.HISTORY_FILE) && !string.endsWith(LocalHistoryStoreImpl.LABELS_FILE) && !string.endsWith(LocalHistoryStoreImpl.STORAGE_FILE);
        }
    };

    LocalHistoryStoreImpl() {
        this.initStorage();
        this.listenersSupport = new ListenersSupport((Object)this);
        this.cacheProvider = new DataFilesTurboProvider();
        this.turbo = Turbo.createCustom((CustomProviders)new CustomProviders(){
            private final Set providers;
            {
                this.providers = Collections.singleton(LocalHistoryStoreImpl.this.cacheProvider);
            }

            public Iterator providers() {
                return this.providers.iterator();
            }
        }, (int)20, (int)-1);
    }

    @Override
    public synchronized void fileCreate(File file, long l) {
        try {
            this.fileCreateImpl(file, l, null, file.getAbsolutePath());
        }
        catch (IOException iOException) {
            LocalHistory.LOG.log(Level.WARNING, null, iOException);
        }
    }

    private void fileCreateImpl(File file, long l, String string, String string2) throws IOException {
        if (this.lastModified(file) > 0L) {
            return;
        }
        String string3 = Long.toString(l);
        File file2 = null;
        if (file.isFile()) {
            file2 = this.getStoreFile(file, string3, true);
            FileUtils.copy(file, StoreEntry.createStoreFileOutputStream(file2));
            LocalHistory.logCreate(file, file2, l, string, string2);
        }
        this.touch(file, new StoreDataFile(file.getAbsolutePath(), 1, l, file.isFile()));
        File file3 = file.getParentFile();
        if (file3 != null) {
            this.writeHistoryForFile(file3, new HistoryEntry[]{new HistoryEntry(l, string, string2, 1)}, true);
        }
        this.fireChanged(file);
    }

    @Override
    public synchronized void fileChange(File file, long l) {
        long l2 = this.lastModified(file);
        if (l2 == l) {
            return;
        }
        if (file.isFile()) {
            try {
                File file2 = this.getStoreFile(file, Long.toString(l), true);
                FileUtils.copy(file, StoreEntry.createStoreFileOutputStream(file2));
                LocalHistory.logChange(file, file2, l);
                this.touch(file, new StoreDataFile(file.getAbsolutePath(), 1, l, file.isFile()));
            }
            catch (IOException iOException) {
                LocalHistory.LOG.log(Level.WARNING, null, iOException);
            }
        } else {
            try {
                this.touch(file, new StoreDataFile(file.getAbsolutePath(), 1, l, file.isFile()));
            }
            catch (IOException iOException) {
                LocalHistory.LOG.log(Level.WARNING, null, iOException);
            }
        }
        this.fireChanged(file);
    }

    @Override
    public synchronized void fileDelete(File file, long l) {
        try {
            this.fileDeleteImpl(file, null, file.getAbsolutePath(), l);
        }
        catch (IOException iOException) {
            LocalHistory.LOG.log(Level.WARNING, null, iOException);
        }
        this.fireChanged(file);
    }

    private void fileDeleteImpl(File file, String string, String string2, long l) throws IOException {
        File file2;
        StoreDataFile storeDataFile = this.readStoreData(file, true);
        if (storeDataFile == null) {
            LocalHistory.log("deleting without data for file : " + file);
            return;
        }
        long l2 = storeDataFile.getLastModified();
        boolean bl = storeDataFile.isFile();
        if (!LocalHistory.LOG.isLoggable(Level.FINE)) {
            file2 = this.getDataFile(file);
            LocalHistory.logDelete(file, file2, l);
        }
        this.touch(file, new StoreDataFile(file.getAbsolutePath(), 0, l2, bl));
        file2 = file.getParentFile();
        if (file2 != null) {
            this.writeHistoryForFile(file2, new HistoryEntry[]{new HistoryEntry(l, string, string2, 0)}, true);
        }
    }

    @Override
    public synchronized void fileCreateFromMove(File file, File file2, long l) {
        if (this.lastModified(file2) > 0L) {
            return;
        }
        try {
            this.fileCreateImpl(file2, l, file.getAbsolutePath(), file2.getAbsolutePath());
        }
        catch (IOException iOException) {
            LocalHistory.LOG.log(Level.WARNING, null, iOException);
        }
        this.fireChanged(file2);
    }

    @Override
    public synchronized void fileDeleteFromMove(File file, File file2, long l) {
        try {
            this.fileDeleteImpl(file, file.getAbsolutePath(), file2.getAbsolutePath(), l);
        }
        catch (IOException iOException) {
            LocalHistory.LOG.log(Level.WARNING, null, iOException);
        }
        this.fireChanged(file);
    }

    static File getStorageRootFile() {
        String string = System.getProperty("netbeans.user");
        return new File(new File(string, "var"), "filehistory");
    }

    private long lastModified(File file) {
        StoreDataFile storeDataFile = this.readStoreData(file, true);
        return storeDataFile != null && storeDataFile.getStatus() != 0 ? storeDataFile.getLastModified() : -1L;
    }

    @Override
    public synchronized StoreEntry[] getStoreEntries(File file) {
        return this.getStoreEntriesImpl(file);
    }

    private StoreEntry[] getStoreEntriesImpl(File file) {
        File file2 = this.getStoreFolder(file);
        File[] fileArray = file2.listFiles(fileEntriesFilter);
        if (fileArray != null && fileArray.length > 0) {
            ArrayList<StoreEntry> arrayList = new ArrayList<StoreEntry>(fileArray.length);
            if (fileArray.length > 0) {
                Map<Long, String> map = this.getLabels(this.getLabelsFile(file));
                for (int i = 0; i < fileArray.length; ++i) {
                    long l = Long.parseLong(fileArray[i].getName());
                    String string = map.get(l);
                    arrayList.add(StoreEntry.createStoreEntry(file, fileArray[i], l, string));
                }
                return arrayList.toArray(new StoreEntry[fileArray.length]);
            }
            return emptyStoreEntryArray;
        }
        return emptyStoreEntryArray;
    }

    @Override
    public StoreEntry[] getFolderState(File file, File[] fileArray, long l) {
        Object object;
        Object object2;
        List<HistoryEntry> list;
        File file2 = file.getParentFile();
        if (file2 != null && this.wasDeleted(file, list = this.readHistoryForFile(file2), l)) {
            return emptyStoreEntryArray;
        }
        list = this.readHistoryForFile(file);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap<File, HistoryEntry> hashMap = new HashMap<File, HistoryEntry>();
        HashMap<File, HistoryEntry> hashMap2 = new HashMap<File, HistoryEntry>();
        for (HistoryEntry historyEntry : list) {
            File file3 = new File(historyEntry.getTo());
            if (historyEntry.getTimestamp() < l) {
                hashMap.put(file3, historyEntry);
                continue;
            }
            if (hashMap2.containsKey(file3)) continue;
            hashMap2.put(file3, historyEntry);
        }
        for (File object3 : fileArray) {
            object2 = (HistoryEntry)hashMap.get(object3);
            object = (HistoryEntry)hashMap2.get(object3);
            hashMap.remove(object3);
            hashMap2.remove(object3);
            if (object2 != null && ((HistoryEntry)object2).getStatus() == 0) {
                arrayList.add(StoreEntry.createDeletedStoreEntry(object3, l));
                continue;
            }
            StoreDataFile storeDataFile = this.readStoreData(object3, true);
            if (storeDataFile == null) continue;
            if (storeDataFile.isFile()) {
                StoreEntry storeEntry = this.getStoreEntry(object3, l);
                if (storeEntry != null) {
                    arrayList.add(storeEntry);
                    continue;
                }
                if (object == null || ((HistoryEntry)object).getStatus() != 1) continue;
                arrayList.add(StoreEntry.createDeletedStoreEntry(object3, l));
                continue;
            }
            if (object == null || ((HistoryEntry)object).getStatus() != 1) continue;
            arrayList.add(StoreEntry.createDeletedStoreEntry(object3, l));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            StoreDataFile storeDataFile;
            File file4 = (File)entry.getKey();
            hashMap2.remove(file4);
            if (((HistoryEntry)entry.getValue()).getStatus() == 0 || (storeDataFile = this.readStoreData(file4, true)) == null) continue;
            if (storeDataFile.isFile()) {
                object2 = this.getStoreEntry(file4, l);
                if (object2 == null) continue;
                arrayList.add(object2);
                continue;
            }
            object2 = this.getStoreFolder(file);
            object = StoreEntry.createStoreEntry(new File(storeDataFile.getAbsolutePath()), (File)object2, storeDataFile.getLastModified(), "");
            arrayList.add(object);
        }
        return arrayList.toArray(new StoreEntry[arrayList.size()]);
    }

    private boolean wasDeleted(File file, List<HistoryEntry> list, long l) {
        String string = file.getAbsolutePath();
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            HistoryEntry historyEntry = list.get(i);
            if (historyEntry.getTo().equals(string)) {
                bl = historyEntry.getStatus() == 0;
            }
            if (historyEntry.ts >= l) break;
        }
        return bl;
    }

    @Override
    public synchronized StoreEntry getStoreEntry(File file, long l) {
        return this.getStoreEntryImpl(file, l, this.readStoreData(file, true));
    }

    private StoreEntry getStoreEntryImpl(File file, long l, StoreDataFile storeDataFile) {
        StoreEntry storeEntry = null;
        if (storeDataFile == null) {
            return null;
        }
        if (storeDataFile.isFile()) {
            StoreEntry[] storeEntryArray;
            for (StoreEntry storeEntry2 : storeEntryArray = this.getStoreEntriesImpl(file)) {
                if (storeEntry2.getTimestamp() > l || storeEntry != null && storeEntry2.getTimestamp() <= storeEntry.getTimestamp()) continue;
                storeEntry = storeEntry2;
            }
        }
        return storeEntry;
    }

    @Override
    public synchronized void deleteEntry(File file, long l) {
        File file2 = this.getStoreFile(file, Long.toString(l), false);
        if (file2.exists()) {
            file2.delete();
        }
        this.fireDeleted(file);
    }

    @Override
    public synchronized StoreEntry[] getDeletedFiles(File file) {
        Object object;
        StoreEntry[] storeEntryArray;
        Object object2;
        if (file.isFile()) {
            return null;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        List<HistoryEntry> list = this.readHistoryForFile(file);
        for (HistoryEntry object32 : list) {
            if (object32.getStatus() != 0 || hashMap.containsKey(object2 = object32.getTo()) || (storeEntryArray = this.readStoreData(new File(object32.getTo()), true)) == null || storeEntryArray.getStatus() != 0) continue;
            object = ((StoreDataFile)storeEntryArray).isFile ? this.getStoreFile(new File(storeEntryArray.getAbsolutePath()), Long.toString(storeEntryArray.getLastModified()), false) : this.getStoreFolder(file);
            hashMap.put(object2, StoreEntry.createStoreEntry(new File(storeEntryArray.getAbsolutePath()), (File)object, storeEntryArray.getLastModified(), ""));
        }
        List<File> list2 = this.getLostFiles();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object2 = (File)iterator.next();
            if (hashMap.containsKey(((File)object2).getAbsolutePath()) || !file.equals(((File)object2).getParentFile()) || (storeEntryArray = this.getStoreEntriesImpl((File)object2)) == null || storeEntryArray.length == 0) continue;
            object = storeEntryArray[0];
            for (int i = 1; i < storeEntryArray.length; ++i) {
                if (((StoreEntry)object).getTimestamp() >= storeEntryArray[i].getTimestamp()) continue;
                object = storeEntryArray[i];
            }
            hashMap.put(((File)object2).getAbsolutePath(), object);
        }
        return hashMap.values().toArray(new StoreEntry[hashMap.size()]);
    }

    private List<File> getLostFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = this.storage.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return arrayList;
        }
        for (File file : fileArray) {
            File[] fileArray2 = file.listFiles();
            if (fileArray2 == null || fileArray2.length == 0) continue;
            for (File file2 : fileArray2) {
                File file3;
                StoreDataFile storeDataFile = this.readStoreData(new File(file2, DATA_FILE), false);
                if (storeDataFile == null || (file3 = new File(storeDataFile.getAbsolutePath())).exists()) continue;
                arrayList.add(file3);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setLabel(File file, long l, String string) {
        File file2 = this.getLabelsFile(file);
        File file3 = file2.getParentFile();
        if (!file3.exists()) {
            file3.mkdirs();
        }
        File file4 = null;
        FilterInputStream filterInputStream = null;
        FilterOutputStream filterOutputStream = null;
        boolean bl = false;
        try {
            block36: {
                if (!file2.exists()) {
                    filterOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
                    ((DataOutputStream)filterOutputStream).writeLong(l);
                    LocalHistoryStoreImpl.writeString((DataOutputStream)filterOutputStream, string);
                } else {
                    file4 = new File(file2.getParentFile(), file2.getName() + ".new");
                    filterOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file4)));
                    filterInputStream = LocalHistoryStoreImpl.getInputStream(file2);
                    long l2 = -1L;
                    try {
                        while (true) {
                            if ((l2 = ((DataInputStream)filterInputStream).readLong()) == l) {
                                bl = true;
                                if (string != null) {
                                    ((DataOutputStream)filterOutputStream).writeLong(l2);
                                    LocalHistoryStoreImpl.writeString((DataOutputStream)filterOutputStream, string);
                                    int n = ((DataInputStream)filterInputStream).readInt();
                                    LocalHistoryStoreImpl.skip(filterInputStream, n * 2);
                                    LocalHistoryStoreImpl.copyStreams(filterOutputStream, filterInputStream);
                                    continue;
                                }
                                int n = ((DataInputStream)filterInputStream).readInt();
                                LocalHistoryStoreImpl.skip(filterInputStream, n * 2);
                                continue;
                            }
                            ((DataOutputStream)filterOutputStream).writeLong(l2);
                            String string2 = LocalHistoryStoreImpl.readString((DataInputStream)filterInputStream);
                            LocalHistoryStoreImpl.writeString((DataOutputStream)filterOutputStream, string2);
                        }
                    }
                    catch (EOFException eOFException) {
                        if (bl || string == null) break block36;
                        ((DataOutputStream)filterOutputStream).writeLong(l);
                        LocalHistoryStoreImpl.writeString((DataOutputStream)filterOutputStream, string);
                    }
                }
            }
            ((DataOutputStream)filterOutputStream).flush();
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            LocalHistory.LOG.log(Level.INFO, null, exception);
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            if (file4 != null) {
                FileUtils.renameFile(file4, file2);
            }
        }
        catch (IOException iOException) {
            LocalHistory.LOG.log(Level.SEVERE, null, iOException);
        }
    }

    @Override
    public synchronized void addVersioningListener(VersioningListener versioningListener) {
        this.listenersSupport.addListener(versioningListener);
    }

    @Override
    public synchronized void removeVersioningListener(VersioningListener versioningListener) {
        this.listenersSupport.removeListener(versioningListener);
    }

    @Override
    public void cleanUp(final long l) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                LocalHistory.log("Cleanup Start");
                LocalHistoryStoreImpl.this.cleanUpImpl(l);
                LocalHistory.log("Cleanup End");
            }
        });
    }

    private void cleanUpImpl(long l) {
        long l2 = System.currentTimeMillis();
        File[] fileArray = this.storage.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        for (File file : fileArray) {
            if (file.getName().equals(STORAGE_FILE)) continue;
            File[] fileArray2 = file.listFiles();
            if (fileArray2 == null || fileArray2.length == 0) {
                FileUtils.deleteRecursively(file);
                continue;
            }
            boolean bl = true;
            for (File file2 : fileArray2) {
                boolean bl2 = this.cleanUpFolder(file2, l, l2);
                if (bl2) {
                    if (!file2.exists()) continue;
                    FileUtils.deleteRecursively(file2);
                    continue;
                }
                bl = false;
            }
            if (!bl) continue;
            FileUtils.deleteRecursively(file);
        }
    }

    private synchronized boolean cleanUpFolder(File file, long l, long l2) {
        File file2 = new File(file, DATA_FILE);
        if (!file2.exists()) {
            return this.cleanUpStoredFolder(file, l, l2);
        }
        StoreDataFile storeDataFile = this.readStoreData(file2, false);
        if (storeDataFile == null || storeDataFile.getAbsolutePath() == null) {
            return true;
        }
        if (storeDataFile.isFile()) {
            return this.cleanUpStoredFile(file, l, l2);
        }
        return this.cleanUpStoredFolder(file, l, l2);
    }

    private boolean cleanUpStoredFile(File file, long l, long l2) {
        File file2 = new File(file, DATA_FILE);
        if (!file2.exists()) {
            return true;
        }
        if (file2.lastModified() < l2 - l) {
            this.purgeDataFile(file2);
            return true;
        }
        File[] fileArray = file.listFiles(fileEntriesFilter);
        boolean bl = false;
        File file3 = new File(file, LABELS_FILE);
        Map<Long, String> map = emptyLabels;
        if (file3.exists()) {
            map = this.getLabels(file3);
        }
        if (fileArray != null) {
            for (File file4 : fileArray) {
                long l3 = 0L;
                try {
                    l3 = Long.parseLong(file4.getName());
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                if (l3 < l2 - l) {
                    if (map.size() > 0) {
                        map.remove(l3);
                    }
                    file4.delete();
                    continue;
                }
                bl = true;
            }
        }
        if (!bl) {
            file3.delete();
            this.writeStoreData(file2, null, false);
        } else if (map.size() > 0) {
            this.writeLabels(file3, map);
        } else {
            file3.delete();
        }
        return !bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLabels(File file, Map<Long, String> map) {
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        FilterInputStream filterInputStream = null;
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = LocalHistoryStoreImpl.getOutputStream(file, false);
            for (Map.Entry<Long, String> entry : map.entrySet()) {
                dataOutputStream.writeLong(entry.getKey());
                LocalHistoryStoreImpl.writeString(dataOutputStream, entry.getValue());
            }
            dataOutputStream.flush();
        }
        catch (Exception exception) {
            LocalHistory.LOG.log(Level.INFO, null, exception);
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean cleanUpStoredFolder(File file, long l, long l2) {
        boolean bl;
        File file2 = new File(file, HISTORY_FILE);
        File file3 = new File(file, DATA_FILE);
        boolean bl2 = !file3.exists() || file3.lastModified() < l2 - l;
        boolean bl3 = bl = !file2.exists() || file2.lastModified() < l2 - l;
        if (!bl) {
            List<HistoryEntry> list = this.readHistory(file2);
            ArrayList<HistoryEntry> arrayList = new ArrayList<HistoryEntry>();
            for (HistoryEntry historyEntry : list) {
                if (historyEntry.getTimestamp() <= l2 - l) continue;
                arrayList.add(historyEntry);
            }
            if (arrayList.size() > 0) {
                this.writeHistory(file2, arrayList.toArray(new HistoryEntry[arrayList.size()]), false);
            } else {
                file2.delete();
                bl = true;
            }
        }
        if (bl2) {
            this.purgeDataFile(file3);
        }
        if (bl) {
            file2.delete();
        }
        return bl2 && bl;
    }

    private void purgeDataFile(File file) {
        if (file.exists()) {
            this.writeStoreData(file, null, false);
        }
    }

    private void fireChanged(File file) {
        this.listenersSupport.fireVersioningEvent(EVENT_HISTORY_CHANGED, (Object)file);
    }

    private void fireDeleted(File file) {
        this.listenersSupport.fireVersioningEvent(EVENT_ENTRY_DELETED, (Object)file);
    }

    private void touch(File file, StoreDataFile storeDataFile) throws IOException {
        this.writeStoreData(file, storeDataFile, true);
    }

    private void initStorage() {
        this.storage = LocalHistoryStoreImpl.getStorageRootFile();
        if (!this.storage.exists()) {
            this.storage.mkdirs();
        }
        this.writeStorage();
    }

    private File getStoreFolder(File file) {
        StoreDataFile storeDataFile;
        String string = file.getAbsolutePath();
        File file2 = this.getStoreFolderName(string);
        int n = 0;
        while (file2.exists() && (storeDataFile = this.readStoreData(new File(file2, DATA_FILE), false)) != null && !storeDataFile.getAbsolutePath().equals(string)) {
            file2 = this.getStoreFolderName(string + "." + n++);
        }
        return file2;
    }

    private File getStoreFolderName(String string) {
        int n = string.hashCode();
        String string2 = this.getMD5(string);
        String string3 = this.storage.getAbsolutePath() + "/" + Integer.toString(n % 173 + 172);
        return new File(string3 + "/" + string2);
    }

    private String getMD5(String string) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        messageDigest.update(string.getBytes());
        byte[] byArray = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(byArray[i] & 0xFF);
            if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private File getStoreFile(File file, String string, boolean bl) {
        File file2 = this.getStoreFolder(file);
        if (bl && !file2.exists()) {
            file2.mkdirs();
        }
        return new File(file2, string);
    }

    private File getHistoryFile(File file) {
        File file2 = this.getStoreFolder(file);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        return new File(file2, HISTORY_FILE);
    }

    private File getDataFile(File file) {
        File file2 = this.getStoreFolder(file);
        return new File(file2, DATA_FILE);
    }

    private File getLabelsFile(File file) {
        File file2 = this.getStoreFolder(file);
        return new File(file2, LABELS_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, String> getLabels(File file) {
        if (!file.exists()) {
            return emptyLabels;
        }
        DataInputStream dataInputStream = null;
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        try {
            dataInputStream = LocalHistoryStoreImpl.getInputStream(file);
            while (true) {
                long l = dataInputStream.readLong();
                String string = LocalHistoryStoreImpl.readString(dataInputStream);
                hashMap.put(l, string);
            }
        }
        catch (EOFException eOFException) {
            HashMap<Long, String> hashMap2 = hashMap;
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return hashMap2;
        }
        catch (Exception exception) {
            try {
                LocalHistory.LOG.log(Level.INFO, null, exception);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (dataInputStream != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return emptyLabels;
    }

    private void writeHistoryForFile(File file, HistoryEntry[] historyEntryArray, boolean bl) {
        if (!LocalHistory.LOG.isLoggable(Level.FINE) && this.getDataFile(file) == null) {
            LocalHistory.log("writing history for file without data : " + file);
        }
        File file2 = this.getHistoryFile(file);
        this.writeHistory(file2, historyEntryArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHistory(File file, HistoryEntry[] historyEntryArray, boolean bl) {
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = LocalHistoryStoreImpl.getOutputStream(file, bl);
            for (HistoryEntry historyEntry : historyEntryArray) {
                dataOutputStream.writeLong(historyEntry.getTimestamp());
                LocalHistoryStoreImpl.writeString(dataOutputStream, historyEntry.getFrom());
                LocalHistoryStoreImpl.writeString(dataOutputStream, historyEntry.getTo());
                dataOutputStream.writeInt(historyEntry.getStatus());
            }
            dataOutputStream.flush();
        }
        catch (Exception exception) {
            LocalHistory.LOG.log(Level.INFO, null, exception);
            return;
        }
        finally {
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private List<HistoryEntry> readHistoryForFile(File file) {
        return this.readHistory(this.getHistoryFile(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HistoryEntry> readHistory(File file) {
        if (!file.exists()) {
            return emptyHistory;
        }
        DataInputStream dataInputStream = null;
        ArrayList<HistoryEntry> arrayList = new ArrayList<HistoryEntry>();
        try {
            dataInputStream = LocalHistoryStoreImpl.getInputStream(file);
            while (true) {
                long l = dataInputStream.readLong();
                String string = LocalHistoryStoreImpl.readString(dataInputStream);
                String string2 = LocalHistoryStoreImpl.readString(dataInputStream);
                int n = dataInputStream.readInt();
                arrayList.add(new HistoryEntry(l, string, string2, n));
            }
        }
        catch (EOFException eOFException) {
            ArrayList<HistoryEntry> arrayList2 = arrayList;
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return arrayList2;
        }
        catch (Exception exception) {
            try {
                LocalHistory.LOG.log(Level.INFO, null, exception);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (dataInputStream != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return emptyHistory;
    }

    private StoreDataFile readStoreData(File file, boolean bl) {
        if (bl) {
            file = this.getDataFile(file);
        }
        return (StoreDataFile)this.turbo.readEntry((Object)file, "localhistory.ATTR_DATA_FILES");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStorage() {
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = LocalHistoryStoreImpl.getOutputStream(new File(this.storage, STORAGE_FILE), false);
            LocalHistoryStoreImpl.writeString((DataOutputStream)filterOutputStream, STORAGE_VERSION);
            ((DataOutputStream)filterOutputStream).flush();
        }
        catch (Exception exception) {
            LocalHistory.LOG.log(Level.INFO, null, exception);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeStoreData(File file, StoreDataFile storeDataFile, boolean bl) {
        if (bl) {
            file = this.getDataFile(file);
        }
        this.turbo.writeEntry((Object)file, "localhistory.ATTR_DATA_FILES", (Object)storeDataFile);
    }

    private static void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string != null) {
            dataOutputStream.writeInt(string.length());
            dataOutputStream.writeChars(string);
        } else {
            dataOutputStream.writeInt(0);
        }
    }

    private static String readString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            char c = dataInputStream.readChar();
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static void skip(InputStream inputStream, long l) throws IOException {
        while (l > 0L) {
            long l2 = inputStream.skip(l);
            if (l2 < 0L) {
                throw new EOFException("Missing " + l + " bytes.");
            }
            l -= l2;
        }
    }

    private static void copyStreams(OutputStream outputStream, InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    private static DataOutputStream getOutputStream(File file, boolean bl) throws IOException, InterruptedException {
        int n = 0;
        while (true) {
            try {
                return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file, bl)));
            }
            catch (IOException iOException) {
                if (++n > 7) {
                    throw iOException;
                }
                Thread.sleep(n * 30);
                continue;
            }
            break;
        }
    }

    private static DataInputStream getInputStream(File file) throws IOException, InterruptedException {
        int n = 0;
        while (true) {
            try {
                return new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            }
            catch (IOException iOException) {
                if (++n > 7) {
                    throw iOException;
                }
                Thread.sleep(n * 30);
                continue;
            }
            break;
        }
    }

    private class DataFilesTurboProvider
    implements TurboProvider {
        static final String ATTR_DATA_FILES = "localhistory.ATTR_DATA_FILES";

        private DataFilesTurboProvider() {
        }

        public boolean recognizesAttribute(String string) {
            return ATTR_DATA_FILES.equals(string);
        }

        public boolean recognizesEntity(Object object) {
            return object instanceof File;
        }

        public synchronized Object readEntry(Object object, String string, TurboProvider.MemoryCache memoryCache) {
            assert (object instanceof File);
            assert (string != null);
            File file = (File)object;
            if (!file.exists()) {
                return null;
            }
            return StoreDataFile.read(file);
        }

        public synchronized boolean writeEntry(Object object, String string, Object object2) {
            assert (object instanceof File);
            assert (object2 == null || object2 instanceof StoreDataFile);
            assert (string != null);
            File file = (File)object;
            if (object2 == null) {
                if (file.exists()) {
                    file.delete();
                }
                return true;
            }
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            StoreDataFile.write(file, (StoreDataFile)object2);
            return true;
        }
    }

    private class HistoryEntry {
        private long ts;
        private String from;
        private String to;
        private int status;

        HistoryEntry(long l, String string, String string2, int n) {
            this.ts = l;
            this.from = string;
            this.to = string2;
            this.status = n;
        }

        long getTimestamp() {
            return this.ts;
        }

        String getFrom() {
            return this.from;
        }

        String getTo() {
            return this.to;
        }

        int getStatus() {
            return this.status;
        }
    }

    private static class StoreDataFile {
        private final int status;
        private final long lastModified;
        private final String absolutePath;
        private final boolean isFile;

        private StoreDataFile(String string, int n, long l, boolean bl) {
            this.status = n;
            this.lastModified = l;
            this.absolutePath = string;
            this.isFile = bl;
        }

        int getStatus() {
            return this.status;
        }

        long getLastModified() {
            return this.lastModified;
        }

        String getAbsolutePath() {
            return this.absolutePath;
        }

        boolean isFile() {
            return this.isFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static synchronized StoreDataFile read(File file) {
            DataInputStream dataInputStream = null;
            try {
                dataInputStream = LocalHistoryStoreImpl.getInputStream(file);
                boolean bl = dataInputStream.readBoolean();
                int n = dataInputStream.readInt();
                long l = dataInputStream.readLong();
                String string = LocalHistoryStoreImpl.readString(dataInputStream);
                StoreDataFile storeDataFile = new StoreDataFile(string, n, l, bl);
                return storeDataFile;
            }
            catch (Exception exception) {
                LocalHistory.LOG.log(Level.INFO, null, exception);
            }
            finally {
                if (dataInputStream != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static synchronized void write(File file, StoreDataFile storeDataFile) {
            DataOutputStream dataOutputStream = null;
            try {
                dataOutputStream = LocalHistoryStoreImpl.getOutputStream(file, false);
                StoreDataFile storeDataFile2 = storeDataFile;
                dataOutputStream.writeBoolean(storeDataFile2.isFile);
                dataOutputStream.writeInt(storeDataFile2.getStatus());
                dataOutputStream.writeLong(storeDataFile2.getLastModified());
                dataOutputStream.writeInt(storeDataFile2.getAbsolutePath().length());
                dataOutputStream.writeChars(storeDataFile2.getAbsolutePath());
                dataOutputStream.flush();
            }
            catch (Exception exception) {
                LocalHistory.LOG.log(Level.INFO, null, exception);
            }
            finally {
                if (dataOutputStream != null) {
                    try {
                        dataOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

