/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StoreEntry {
    private final File file;
    private final File storeFile;
    private final long ts;
    private final String label;
    private final Date date;
    private String mimeType = null;
    private List<StoreEntry> siblingEntries;

    public static StoreEntry createStoreEntry(File file, File file2, long l, String string) {
        return new DefaultStoreEntry(file, file2, l, string);
    }

    public static StoreEntry createDeletedStoreEntry(File file, long l) {
        return new DeletedStoreEntry(file, l);
    }

    public static StoreEntry createFakeStoreEntry(File file, long l) {
        return new FakeStoreEntry(file, l);
    }

    private StoreEntry(File file, File file2, long l, String string) {
        this.file = file;
        this.storeFile = file2;
        this.ts = l;
        this.label = string;
        this.date = new Date(l);
        this.setSiblings(Collections.EMPTY_LIST);
    }

    public File getStoreFile() {
        return this.storeFile;
    }

    public File getFile() {
        return this.file;
    }

    public long getTimestamp() {
        return this.ts;
    }

    public String getLabel() {
        return this.label != null ? this.label : "";
    }

    public Date getDate() {
        return this.date;
    }

    public boolean representsFile() {
        return this.storeFile.isFile();
    }

    public List<StoreEntry> getSiblingEntries() {
        return this.siblingEntries;
    }

    public void setSiblings(Collection<StoreEntry> collection) {
        this.siblingEntries = new ArrayList<StoreEntry>(collection.size());
        for (StoreEntry storeEntry : collection) {
            if (!storeEntry.representsFile() || this.getFile().equals(storeEntry.getFile())) continue;
            this.siblingEntries.add(storeEntry);
        }
        this.siblingEntries = Collections.unmodifiableList(this.siblingEntries);
    }

    public String getMIMEType() {
        if (this.mimeType == null) {
            FileObject fileObject = FileUtil.toFileObject((File)this.getFile());
            this.mimeType = fileObject != null ? fileObject.getMIMEType() : "content/unknown";
        }
        return this.mimeType;
    }

    static OutputStream createStoreFileOutputStream(File file) throws FileNotFoundException, IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        ZipEntry zipEntry = new ZipEntry(file.getName());
        zipOutputStream.putNextEntry(zipEntry);
        return zipOutputStream;
    }

    abstract OutputStream getStoreFileOutputStream() throws FileNotFoundException, IOException;

    public abstract InputStream getStoreFileInputStream() throws FileNotFoundException, IOException;

    private static class DefaultStoreEntry
    extends StoreEntry {
        private DefaultStoreEntry(File file, File file2, long l, String string) {
            super(file, file2, l, string);
        }

        OutputStream getStoreFileOutputStream() throws FileNotFoundException, IOException {
            return DefaultStoreEntry.createStoreFileOutputStream(this.getStoreFile());
        }

        public InputStream getStoreFileInputStream() throws FileNotFoundException, IOException {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.getStoreFile())));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(this.getStoreFile().getName())) continue;
                return zipInputStream;
            }
            throw new FileNotFoundException();
        }
    }

    private static class DeletedStoreEntry
    extends StoreEntry {
        public DeletedStoreEntry(File file, long l) {
            super(file, null, l, "");
        }

        OutputStream getStoreFileOutputStream() throws FileNotFoundException, IOException {
            this.throwNoStoreEntry();
            return null;
        }

        public InputStream getStoreFileInputStream() throws FileNotFoundException, IOException {
            this.throwNoStoreEntry();
            return null;
        }

        private void throwNoStoreEntry() throws FileNotFoundException {
            throw new FileNotFoundException("There is no store entry for file " + this.getFile() + " and timestamp " + this.getTimestamp());
        }
    }

    private static class FakeStoreEntry
    extends StoreEntry {
        public FakeStoreEntry(File file, long l) {
            super(file, file, l, "");
        }

        OutputStream getStoreFileOutputStream() throws FileNotFoundException, IOException {
            throw new FileNotFoundException("There is no OutputStream for this for file " + this.getFile());
        }

        public InputStream getStoreFileInputStream() throws FileNotFoundException, IOException {
            return new FileInputStream(this.getFile());
        }
    }
}

