/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.revert;

import java.awt.Dialog;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JButton;
import org.netbeans.modules.localhistory.LocalHistorySettings;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryFileView;
import org.netbeans.modules.localhistory.utils.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RevertFileChanges
implements PropertyChangeListener {
    private LocalHistoryFileView view = new LocalHistoryFileView();
    private DialogDescriptor dialogDescriptor;
    private JButton okButton;

    RevertFileChanges() {
        this.view.getPanel().setPreferredSize(new Dimension(550, 250));
        this.okButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"CTL_Revert"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"CTL_Revert"));
        JButton jButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"CTL_Cancel"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"CTL_Cancel"));
        this.dialogDescriptor = new DialogDescriptor((Object)this.view.getPanel(), NbBundle.getMessage(this.getClass(), (String)"LBL_RevertToDialog"));
        this.dialogDescriptor.setOptions(new Object[]{this.okButton, jButton});
        this.dialogDescriptor.setModal(true);
        this.dialogDescriptor.setHelpCtx(new HelpCtx(this.getClass()));
        this.view.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
    }

    void show(File file) {
        StoreEntry[] storeEntryArray;
        long l = LocalHistorySettings.getInstance().getLastSelectedEntry(file);
        this.view.refresh(new File[]{file}, l);
        if (this.show() && (storeEntryArray = this.view.getSelectedEntries()) != null && storeEntryArray.length > 0) {
            this.revert(storeEntryArray[0]);
            LocalHistorySettings.getInstance().setLastSelectedEntry(file, storeEntryArray[0].getTimestamp());
        }
    }

    protected boolean show() {
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription("LBL_RevertToDialog");
        dialog.setVisible(true);
        return this.dialogDescriptor.getValue() == this.okButton;
    }

    private void revert(final StoreEntry storeEntry) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Utils.revert(storeEntry);
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            this.okButton.setEnabled(this.isEnabled(nodeArray));
        }
    }

    private boolean isEnabled(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        for (Node node : nodeArray) {
            StoreEntry storeEntry = (StoreEntry)node.getLookup().lookup(StoreEntry.class);
            if (storeEntry != null) continue;
            return false;
        }
        return true;
    }
}

