/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony.ui.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import org.netbeans.modules.csl.core.UiUtils;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.editor.PhpElement;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.symfony.SymfonyPhpFrameworkProvider;
import org.netbeans.modules.php.symfony.util.SymfonyUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class GoToActionOrViewAction
extends TextAction
implements ContextAwareAction {
    private static final long serialVersionUID = -1231423139431663L;
    static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private static final GoToActionOrViewAction INSTANCE = new GoToActionOrViewAction();
    private static final int DEFAULT_OFFSET = 0;

    private GoToActionOrViewAction() {
        super(GoToActionOrViewAction.getFullName());
        this.putValue("noIconInMenu", true);
        this.putValue("Name", GoToActionOrViewAction.getFullName());
        this.putValue("menuText", GoToActionOrViewAction.getPureName());
    }

    public static GoToActionOrViewAction getInstance() {
        return INSTANCE;
    }

    private static String getFullName() {
        return NbBundle.getMessage(GoToActionOrViewAction.class, (String)"LBL_SymfonyAction", (Object)GoToActionOrViewAction.getPureName());
    }

    private static String getPureName() {
        return NbBundle.getMessage(GoToActionOrViewAction.class, (String)"LBL_GoToActionOrView");
    }

    public Action createContextAwareInstance(Lookup lookup) {
        FileObject fileObject = FileUtils.getFileObject((Lookup)lookup);
        return this.getGoToAction(fileObject, this.getOffset(lookup));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)this.getTextComponent(actionEvent).getDocument());
        Action action = this.getGoToAction(fileObject, this.getTextComponent(actionEvent).getCaretPosition());
        if (action != null) {
            action.actionPerformed(actionEvent);
        }
    }

    private Action getGoToAction(FileObject fileObject, int n) {
        if (!this.isValid(fileObject)) {
            return null;
        }
        if (SymfonyUtils.isViewWithAction(fileObject)) {
            return new GoToActionAction(fileObject);
        }
        if (SymfonyUtils.isAction(fileObject)) {
            return new GoToViewAction(fileObject, n);
        }
        return null;
    }

    private boolean isValid(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        PhpModule phpModule = PhpModule.forFileObject((FileObject)fileObject);
        if (phpModule == null) {
            return false;
        }
        return SymfonyPhpFrameworkProvider.getInstance().isInPhpModule(phpModule);
    }

    private int getOffset(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (editorCookie != null) {
            return this.getOffset(editorCookie);
        }
        FileObject fileObject = FileUtils.getFileObject((Lookup)lookup);
        if (fileObject == null) {
            return 0;
        }
        try {
            editorCookie = (EditorCookie)DataObject.find((FileObject)fileObject).getLookup().lookup(EditorCookie.class);
            return this.getOffset(editorCookie);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            return 0;
        }
    }

    private int getOffset(EditorCookie editorCookie) {
        if (editorCookie == null) {
            return 0;
        }
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length == 0) {
            return 0;
        }
        return jEditorPaneArray[0].getCaretPosition();
    }

    static final class GoToActionAction
    extends AbstractAction {
        private static final long serialVersionUID = -95284445913404L;
        private static final Pattern ACTION_METHOD_NAME = Pattern.compile("^(\\w+)[A-Z]");
        private final FileObject fo;

        public GoToActionAction(FileObject fileObject) {
            super(NbBundle.getMessage(GoToActionOrViewAction.class, (String)"LBL_GoToAction"));
            assert (SymfonyUtils.isViewWithAction(fileObject));
            this.fo = fileObject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EXECUTOR.submit(new Runnable(){

                public void run() {
                    FileObject fileObject = SymfonyUtils.getAction(GoToActionAction.this.fo);
                    if (fileObject != null) {
                        UiUtils.open((FileObject)fileObject, (int)GoToActionAction.this.getActionMethodOffset(fileObject));
                    }
                }
            });
        }

        private int getActionMethodOffset(FileObject fileObject) {
            String string = GoToActionAction.getActionMethodName(this.fo.getName());
            EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
            Iterator iterator = editorSupport.getClasses(fileObject).iterator();
            if (iterator.hasNext()) {
                PhpClass phpClass = (PhpClass)iterator.next();
                if (string != null) {
                    for (PhpClass.Method method : phpClass.getMethods()) {
                        if (!string.equals(method.getName())) continue;
                        return method.getOffset();
                    }
                }
                return phpClass.getOffset();
            }
            return 0;
        }

        static String getActionMethodName(String string) {
            Matcher matcher = ACTION_METHOD_NAME.matcher(string);
            if (matcher.find()) {
                String string2 = matcher.group(1);
                return "execute" + string2.substring(0, 1).toUpperCase() + string2.substring(1);
            }
            return null;
        }
    }

    private static final class GoToViewAction
    extends AbstractAction {
        private static final long serialVersionUID = -95232154930113404L;
        private final FileObject fo;
        private final int offset;

        public GoToViewAction(FileObject fileObject, int n) {
            super(NbBundle.getMessage(GoToActionOrViewAction.class, (String)"LBL_GoToView"));
            assert (SymfonyUtils.isAction(fileObject));
            this.fo = fileObject;
            this.offset = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EXECUTOR.submit(new Runnable(){

                public void run() {
                    EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
                    PhpElement phpElement = editorSupport.getElement(GoToViewAction.this.fo, GoToViewAction.this.offset);
                    if (phpElement == null) {
                        return;
                    }
                    FileObject fileObject = SymfonyUtils.getView(GoToViewAction.this.fo, phpElement);
                    if (fileObject != null) {
                        UiUtils.open((FileObject)fileObject, (int)0);
                    }
                }
            });
        }
    }
}

