/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.CompletionContextFinder;
import org.netbeans.modules.php.editor.PHPCodeCompletion;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedClassMember;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.IndexedFullyQualified;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.IndexedInterface;
import org.netbeans.modules.php.editor.index.IndexedNamespace;
import org.netbeans.modules.php.editor.index.IndexedType;
import org.netbeans.modules.php.editor.index.IndexedTypedElement;
import org.netbeans.modules.php.editor.index.IndexedVariable;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.index.PredefinedSymbolElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Parameter;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.QualifiedNameKind;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.options.OptionsUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PHPCompletionItem
implements CompletionProposal {
    private static final String PHP_KEYWORD_ICON = "org/netbeans/modules/php/editor/resources/php16Key.png";
    protected static ImageIcon keywordIcon = null;
    protected final CompletionRequest request;
    private final ElementHandle element;
    private QualifiedNameKind generateAs;
    private static ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();

    PHPCompletionItem(ElementHandle elementHandle, CompletionRequest completionRequest, QualifiedNameKind qualifiedNameKind) {
        this.request = completionRequest;
        this.element = elementHandle;
        keywordIcon = new ImageIcon(ImageUtilities.loadImage((String)PHP_KEYWORD_ICON));
        this.generateAs = qualifiedNameKind;
    }

    PHPCompletionItem(ElementHandle elementHandle, CompletionRequest completionRequest) {
        this(elementHandle, completionRequest, null);
    }

    public int getAnchorOffset() {
        return this.request.anchor;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        return this.getName();
    }

    public String getSortText() {
        IndexedElement indexedElement = null;
        if (this.getElement() instanceof IndexedElement) {
            indexedElement = (IndexedElement)this.getElement();
        } else if (this.getElement() instanceof IndexedClassMember) {
            indexedElement = ((IndexedClassMember)this.getElement()).getMember();
        }
        if (indexedElement != null && indexedElement.isResolved()) {
            return "-" + this.getName();
        }
        return this.getName();
    }

    public int getSortPrioOverride() {
        return 0;
    }

    public String getLhsHtml(HtmlFormatter htmlFormatter) {
        htmlFormatter.appendText(this.getName());
        return htmlFormatter.getText();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        Set set = Collections.emptySet();
        ElementHandle elementHandle = this.getElement();
        return elementHandle != null ? elementHandle.getModifiers() : set;
    }

    public boolean isSmart() {
        IndexedElement indexedElement = null;
        if (this.getElement() instanceof IndexedElement) {
            indexedElement = (IndexedElement)this.getElement();
        } else if (this.getElement() instanceof IndexedClassMember) {
            indexedElement = ((IndexedClassMember)this.getElement()).getMember();
        }
        if (indexedElement != null) {
            String string = indexedElement.getFilenameUrl();
            return string != null && string.equals(this.request.currentlyEditedFileURL);
        }
        return false;
    }

    private static NamespaceDeclaration findEnclosingNamespace(PHPParseResult pHPParseResult, int n) {
        Program program = pHPParseResult.getProgram();
        List<ASTNode> list = NavUtils.underCaret(pHPParseResult, Math.min(program != null ? program.getEndOffset() : n, n));
        for (ASTNode aSTNode : list) {
            if (!(aSTNode instanceof NamespaceDeclaration)) continue;
            return (NamespaceDeclaration)aSTNode;
        }
        return null;
    }

    public String getCustomInsertTemplate() {
        StringBuilder stringBuilder = new StringBuilder();
        ElementHandle elementHandle = this.getElement();
        if (elementHandle instanceof IndexedFullyQualified) {
            Object object;
            PhpLanguageOptions.Properties properties;
            IndexedFullyQualified indexedFullyQualified = (IndexedFullyQualified)elementHandle;
            QualifiedName qualifiedName = QualifiedName.create(this.request.prefix);
            FileObject fileObject = this.request.result.getSnapshot().getSource().getFileObject();
            PhpLanguageOptions.Properties properties2 = properties = fileObject != null ? PhpLanguageOptions.getDefault().getProperties(fileObject) : null;
            if (properties != null && properties.getPhpVersion() == PhpLanguageOptions.PhpVersion.PHP_53) {
                if (this.generateAs == null) {
                    object = OptionsUtils.codeCompletionType();
                    switch (2.$SwitchMap$org$netbeans$modules$php$editor$options$CodeCompletionPanel$CodeCompletionType[((Enum)object).ordinal()]) {
                        case 1: {
                            stringBuilder.append(indexedFullyQualified.getFullyQualifiedName());
                            return stringBuilder.toString();
                        }
                        case 2: {
                            stringBuilder.append(this.getName());
                            return stringBuilder.toString();
                        }
                        case 3: {
                            this.generateAs = qualifiedName.getKind();
                        }
                    }
                } else if (this.generateAs.isQualified() && indexedFullyQualified instanceof IndexedType && indexedFullyQualified.getNamespaceName().equals("")) {
                    this.generateAs = QualifiedNameKind.FULLYQUALIFIED;
                }
            } else {
                stringBuilder.append(this.getName());
                return stringBuilder.toString();
            }
            switch (this.generateAs) {
                case FULLYQUALIFIED: {
                    stringBuilder.append(indexedFullyQualified.getFullyQualifiedName());
                    break;
                }
                case QUALIFIED: {
                    object = indexedFullyQualified.getFullyQualifiedName();
                    int n = ((String)object).toLowerCase().indexOf(qualifiedName.toNamespaceName().toString().toLowerCase());
                    if (n != -1) {
                        stringBuilder.append(((String)object).substring(n == 0 ? 1 : n));
                        break;
                    }
                }
                case UNQUALIFIED: {
                    boolean bl;
                    boolean bl2 = bl = indexedFullyQualified instanceof IndexedFunction && indexedFullyQualified.getIn() == null && "".equals(indexedFullyQualified.getNamespaceName());
                    if (!(elementHandle instanceof IndexedNamespace) && !bl) {
                        Model model = this.request.result.getModel();
                        NamespaceDeclaration namespaceDeclaration = PHPCompletionItem.findEnclosingNamespace(this.request.result, this.request.anchor);
                        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(namespaceDeclaration, model.getFileScope());
                        if (namespaceScope != null) {
                            QualifiedName qualifiedName2;
                            LinkedList<String> linkedList = QualifiedName.create(indexedFullyQualified.getFullyQualifiedName()).getSegments();
                            QualifiedName qualifiedName3 = QualifiedName.create(false, linkedList);
                            if (!(namespaceScope.isDefaultNamespace() && qualifiedName3.getKind().isUnqualified() || (qualifiedName2 = QualifiedName.getPreferredName(qualifiedName3, namespaceScope)) == null)) {
                                stringBuilder.append(qualifiedName2.toString());
                                break;
                            }
                        }
                    }
                    stringBuilder.append(this.getName());
                }
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public String getRhsHtml(HtmlFormatter htmlFormatter) {
        if (this.element instanceof IndexedClassMember) {
            IndexedClassMember indexedClassMember = (IndexedClassMember)this.element;
            IndexedType indexedType = indexedClassMember.getType();
            QualifiedName qualifiedName = QualifiedName.create(indexedType.getNamespaceName());
            if (qualifiedName.isDefaultNamespace()) {
                htmlFormatter.appendText(indexedType.getName());
                return htmlFormatter.getText();
            }
            htmlFormatter.appendText(indexedType.getFullyQualifiedName());
            return htmlFormatter.getText();
        }
        if (this.element.getIn() != null) {
            htmlFormatter.appendText(this.element.getIn());
            return htmlFormatter.getText();
        }
        if (this.element instanceof IndexedElement) {
            IndexedElement indexedElement = (IndexedElement)this.element;
            if (indexedElement.isPlatform()) {
                return NbBundle.getMessage(PHPCompletionItem.class, (String)"PHPPlatform");
            }
            String string = indexedElement.getFilenameUrl();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                htmlFormatter.appendText(string);
                return htmlFormatter.getText();
            }
        }
        return null;
    }

    public static ImageIcon getInterfaceIcon() {
        return InterfaceItem.icon();
    }

    private static void scheduleShowingCompletion() {
        if (OptionsUtils.autoCompletionTypes()) {
            service.schedule(new Runnable(){

                public void run() {
                    Completion.get().showCompletion();
                }
            }, 750L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassConstantItem
    extends VariableItem {
        ClassConstantItem(IndexedClassMember<IndexedConstant> indexedClassMember, CompletionRequest completionRequest) {
            super(indexedClassMember, completionRequest);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CONSTANT;
        }
    }

    static class ClassItem
    extends PHPCompletionItem {
        private boolean endWithDoubleColon;

        ClassItem(IndexedClass indexedClass, CompletionRequest completionRequest, boolean bl, QualifiedNameKind qualifiedNameKind) {
            super(indexedClass, completionRequest, qualifiedNameKind);
            this.endWithDoubleColon = bl;
        }

        public ElementKind getKind() {
            return ElementKind.CLASS;
        }

        public String getCustomInsertTemplate() {
            String string = super.getCustomInsertTemplate();
            if (this.endWithDoubleColon) {
                StringBuilder stringBuilder = new StringBuilder();
                if (string != null) {
                    stringBuilder.append(string);
                } else {
                    stringBuilder.append(this.getName());
                }
                stringBuilder.append("::${cursor}");
                PHPCompletionItem.scheduleShowingCompletion();
                return stringBuilder.toString();
            }
            return string;
        }
    }

    static class CompletionRequest {
        public int anchor;
        public PHPParseResult result;
        public ParserResult info;
        public String prefix;
        public String currentlyEditedFileURL;
        PHPIndex index;

        CompletionRequest() {
        }
    }

    static class ConstantItem
    extends PHPCompletionItem {
        private IndexedConstant constant = null;

        ConstantItem(IndexedConstant indexedConstant, CompletionRequest completionRequest) {
            super(indexedConstant, completionRequest);
            this.constant = indexedConstant;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            IndexedConstant indexedConstant = (IndexedConstant)this.getElement();
            htmlFormatter.name(this.getKind(), true);
            if (indexedConstant.isResolved()) {
                htmlFormatter.emphasis(true);
                htmlFormatter.appendText(this.getName());
                htmlFormatter.emphasis(false);
            } else {
                htmlFormatter.appendText(this.getName());
            }
            htmlFormatter.name(this.getKind(), false);
            return htmlFormatter.getText();
        }

        public ElementKind getKind() {
            return ElementKind.GLOBAL;
        }
    }

    public static class FunctionDeclarationItem
    extends FunctionItem {
        private boolean isIface;

        public FunctionDeclarationItem(IndexedFunction indexedFunction, CompletionRequest completionRequest, int n, boolean bl) {
            super(indexedFunction, completionRequest, n);
            this.isIface = bl;
        }

        public String getCustomInsertTemplate() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.getFunction().getModifiersString();
            if (string.length() != 0) {
                string = string.replace("abstract", "").trim();
                stringBuilder.append(string);
            }
            stringBuilder.append(" ").append("function");
            stringBuilder.append(this.getNameAndFunctionBodyForTemplate());
            return stringBuilder.toString();
        }

        protected String getNameAndFunctionBodyForTemplate() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.getFunction().getFunctionSignature(true);
            stringBuilder.append(" ").append(string);
            stringBuilder.append(" ").append("{\n");
            stringBuilder.append(this.getFunctionBodyForTemplate());
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        protected String getFunctionBodyForTemplate() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.isIface) {
                stringBuilder.append("${cursor};\n");
            } else {
                String string = this.getFunction().getFunctionSignature(false);
                stringBuilder.append("${cursor}parent::" + string.replace("&$", "$") + ";\n");
            }
            return stringBuilder.toString();
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.getLhsHtml(htmlFormatter));
            stringBuilder.append(' ').append(NbBundle.getMessage(PHPCompletionItem.class, (String)"Generate"));
            return stringBuilder.toString();
        }

        public boolean isSmart() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FunctionItem
    extends PHPCompletionItem {
        private int optionalArgCount = 0;

        FunctionItem(IndexedFunction indexedFunction, CompletionRequest completionRequest, int n) {
            super(indexedFunction, completionRequest);
            this.optionalArgCount = n;
        }

        FunctionItem(IndexedClassMember<IndexedFunction> indexedClassMember, CompletionRequest completionRequest, int n) {
            super(indexedClassMember, completionRequest);
            this.optionalArgCount = n;
        }

        public IndexedFunction getFunction() {
            if (this.getElement() instanceof IndexedClassMember) {
                return (IndexedFunction)((IndexedClassMember)this.getElement()).getMember();
            }
            return (IndexedFunction)this.getElement();
        }

        public ElementKind getKind() {
            return ElementKind.METHOD;
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = super.getCustomInsertTemplate();
            if (string != null) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append(this.getName());
            }
            stringBuilder.append("(");
            List<String> list = this.getInsertParams();
            for (int i = 0; i < list.size(); ++i) {
                String string2 = list.get(i);
                stringBuilder.append("${php-cc-");
                stringBuilder.append(Integer.toString(i));
                stringBuilder.append(" default=\"");
                if (string2.startsWith("&")) {
                    string2 = string2.substring(1);
                }
                stringBuilder.append(string2);
                stringBuilder.append("\"}");
                if (i >= list.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }

        @Override
        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            ElementKind elementKind = this.getKind();
            htmlFormatter.name(elementKind, true);
            if (this.emphasisName()) {
                htmlFormatter.emphasis(true);
                htmlFormatter.appendText(this.getName());
                htmlFormatter.emphasis(false);
            } else {
                htmlFormatter.appendText(this.getName());
            }
            htmlFormatter.name(elementKind, false);
            htmlFormatter.appendHtml("(");
            htmlFormatter.parameters(true);
            this.appendParamsStr(htmlFormatter);
            htmlFormatter.parameters(false);
            htmlFormatter.appendHtml(")");
            return htmlFormatter.getText();
        }

        protected boolean emphasisName() {
            return this.getFunction().isResolved();
        }

        public List<String> getInsertParams() {
            LinkedList<String> linkedList = new LinkedList<String>();
            Parameter[] parameterArray = this.getFunction().getParameters().toArray(new Parameter[0]);
            boolean[] blArray = new boolean[parameterArray.length];
            int[] nArray = this.getFunction().getOptionalArgs();
            int n = 0;
            int n2 = this.optionalArgCount;
            while (n < nArray.length) {
                if (n2 <= 0) {
                    blArray[nArray[n]] = true;
                }
                ++n;
                --n2;
            }
            for (n = 0; n < parameterArray.length; ++n) {
                Parameter parameter = parameterArray[n];
                if (blArray[n]) continue;
                linkedList.add(parameter.getName());
            }
            return linkedList;
        }

        @Override
        public String getSortText() {
            int n = this.optionalArgCount;
            return this.getName() + n;
        }

        private void appendParamsStr(HtmlFormatter htmlFormatter) {
            Parameter[] parameterArray = this.getFunction().getParameters().toArray(new Parameter[0]);
            int[] nArray = this.getFunction().getOptionalArgs();
            boolean[] blArray = new boolean[parameterArray.length];
            boolean[] blArray2 = new boolean[parameterArray.length];
            int n = 0;
            int n2 = this.optionalArgCount;
            while (n < nArray.length) {
                blArray2[nArray[n]] = true;
                if (n2 <= 0) {
                    blArray[nArray[n]] = true;
                }
                ++n;
                --n2;
            }
            n = 1;
            for (n2 = 0; n2 < parameterArray.length; ++n2) {
                if (blArray[n2]) continue;
                Parameter parameter = parameterArray[n2];
                String string = parameter.getName();
                if (string.startsWith("&")) {
                    string = string.substring(1);
                }
                if (n != 0) {
                    n = 0;
                } else {
                    htmlFormatter.appendText(", ");
                }
                if (blArray2[n2]) {
                    htmlFormatter.appendText(string);
                    continue;
                }
                htmlFormatter.emphasis(true);
                htmlFormatter.appendText(string);
                htmlFormatter.emphasis(false);
            }
        }
    }

    static class InterfaceItem
    extends PHPCompletionItem {
        private static final String PHP_INTERFACE_ICON = "org/netbeans/modules/php/editor/resources/interface.png";
        private static ImageIcon INTERFACE_ICON = null;
        private boolean endWithDoubleColon;

        InterfaceItem(IndexedInterface indexedInterface, CompletionRequest completionRequest, boolean bl) {
            super(indexedInterface, completionRequest);
            this.endWithDoubleColon = bl;
        }

        InterfaceItem(IndexedInterface indexedInterface, CompletionRequest completionRequest, QualifiedNameKind qualifiedNameKind, boolean bl) {
            super(indexedInterface, completionRequest, qualifiedNameKind);
            this.endWithDoubleColon = bl;
        }

        public ElementKind getKind() {
            return ElementKind.CLASS;
        }

        private static ImageIcon icon() {
            if (INTERFACE_ICON == null) {
                INTERFACE_ICON = new ImageIcon(ImageUtilities.loadImage((String)PHP_INTERFACE_ICON));
            }
            return INTERFACE_ICON;
        }

        public ImageIcon getIcon() {
            return InterfaceItem.icon();
        }

        public String getCustomInsertTemplate() {
            String string = super.getCustomInsertTemplate();
            if (this.endWithDoubleColon) {
                StringBuilder stringBuilder = new StringBuilder();
                if (string != null) {
                    stringBuilder.append(string);
                } else {
                    stringBuilder.append(this.getName());
                }
                stringBuilder.append("::${cursor}");
                PHPCompletionItem.scheduleShowingCompletion();
                return stringBuilder.toString();
            }
            return string;
        }
    }

    static class KeywordItem
    extends PHPCompletionItem {
        private String description = null;
        private String keyword = null;
        private static final List<String> CLS_KEYWORDS = Arrays.asList(PHPCodeCompletion.PHP_CLASS_KEYWORDS);

        KeywordItem(String string, CompletionRequest completionRequest) {
            super(null, completionRequest);
            this.keyword = string;
        }

        public String getName() {
            return this.keyword;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.name(this.getKind(), true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(this.getKind(), false);
            return htmlFormatter.getText();
        }

        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            if (this.description != null) {
                htmlFormatter.appendHtml(this.description);
                return htmlFormatter.getText();
            }
            return null;
        }

        public ImageIcon getIcon() {
            return keywordIcon;
        }

        public boolean isSmart() {
            return CLS_KEYWORDS.contains(this.getName()) ? true : super.isSmart();
        }

        public String getCustomInsertTemplate() {
            CompletionContextFinder.KeywordCompletionType keywordCompletionType;
            StringBuilder stringBuilder = new StringBuilder();
            if (CLS_KEYWORDS.contains(this.getName())) {
                PHPCompletionItem.scheduleShowingCompletion();
            }
            if ((keywordCompletionType = PHPCodeCompletion.PHP_KEYWORDS.get(this.getName())) == null) {
                return null;
            }
            switch (keywordCompletionType) {
                case SIMPLE: {
                    stringBuilder.append(this.getName());
                    break;
                }
                case ENDS_WITH_SPACE: {
                    stringBuilder.append(this.getName());
                    stringBuilder.append(" ${cursor}");
                    break;
                }
                case CURSOR_INSIDE_BRACKETS: {
                    stringBuilder.append(this.getName());
                    stringBuilder.append(" (${cursor})");
                    break;
                }
                case ENDS_WITH_CURLY_BRACKETS: {
                    stringBuilder.append(this.getName());
                    stringBuilder.append(" {${cursor}");
                    break;
                }
                case ENDS_WITH_SEMICOLON: {
                    stringBuilder.append(this.getName());
                    stringBuilder.append(";");
                    break;
                }
                case ENDS_WITH_COLON: {
                    stringBuilder.append(this.getName());
                    stringBuilder.append(" ${cursor}:");
                    break;
                }
                default: {
                    assert (false) : keywordCompletionType.toString();
                    break;
                }
            }
            return stringBuilder.toString();
        }
    }

    static class MagicMethodItem
    extends FunctionDeclarationItem {
        public MagicMethodItem(IndexedFunction indexedFunction, CompletionRequest completionRequest) {
            super(indexedFunction, completionRequest, 0, false);
        }

        public boolean isSmart() {
            return false;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            return super.getLhsHtml(htmlFormatter);
        }

        protected boolean emphasisName() {
            return false;
        }

        protected String getFunctionBodyForTemplate() {
            return "${cursor}\n";
        }
    }

    static class MagicMethodNameItem
    extends MagicMethodItem {
        public MagicMethodNameItem(IndexedFunction indexedFunction, CompletionRequest completionRequest) {
            super(indexedFunction, completionRequest);
        }

        public String getCustomInsertTemplate() {
            return super.getNameAndFunctionBodyForTemplate();
        }
    }

    static class NamespaceItem
    extends PHPCompletionItem {
        Boolean isSmart;

        NamespaceItem(IndexedNamespace indexedNamespace, CompletionRequest completionRequest, QualifiedNameKind qualifiedNameKind) {
            super(indexedNamespace, completionRequest, qualifiedNameKind);
        }

        public int getSortPrioOverride() {
            return this.isSmart() ? -10001 : super.getSortPrioOverride();
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.name(this.getKind(), true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(this.getKind(), false);
            return htmlFormatter.getText();
        }

        public String getName() {
            return this.getIndexedNamespace().getName();
        }

        IndexedNamespace getIndexedNamespace() {
            return (IndexedNamespace)this.getElement();
        }

        public ElementKind getKind() {
            return ElementKind.PACKAGE;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            String string = this.getIndexedNamespace().getNamespaceName();
            if (string != null && !"".equals(string)) {
                htmlFormatter.appendText(string);
                return htmlFormatter.getText();
            }
            return null;
        }

        public boolean isSmart() {
            if (this.isSmart == null) {
                String string = this.getIndexedNamespace().getNamespaceName();
                this.isSmart = string != null && "".equals(string);
                if (!this.isSmart.booleanValue()) {
                    NamespaceScope namespaceScope;
                    FileScope fileScope = this.request.result.getModel().getFileScope();
                    NamespaceScope namespaceScope2 = namespaceScope = fileScope != null ? ModelUtils.getNamespaceScope(fileScope, this.request.anchor) : null;
                    if (namespaceScope != null) {
                        IndexedNamespace indexedNamespace = this.getIndexedNamespace();
                        LinkedList<String> linkedList = QualifiedName.create(indexedNamespace.getFullyQualifiedName()).getSegments();
                        QualifiedName qualifiedName = QualifiedName.create(false, linkedList);
                        Collection<QualifiedName> collection = QualifiedName.getRelativesToUses(namespaceScope, qualifiedName);
                        for (QualifiedName qualifiedName2 : collection) {
                            if (qualifiedName2.getSegments().size() != 1) continue;
                            this.isSmart = true;
                            break;
                        }
                        if (!this.isSmart.booleanValue()) {
                            collection = QualifiedName.getRelativesToNamespace(namespaceScope, qualifiedName);
                            for (QualifiedName qualifiedName2 : collection) {
                                if (qualifiedName2.getSegments().size() != 1) continue;
                                this.isSmart = true;
                                break;
                            }
                        }
                    }
                }
            }
            return this.isSmart;
        }
    }

    static class NewClassItem
    extends FunctionItem {
        public NewClassItem(IndexedFunction indexedFunction, CompletionRequest completionRequest, int n) {
            super(indexedFunction, completionRequest, n);
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            String string;
            if (this.getElement() instanceof IndexedFunction && this.getElement().getIn() != null && (string = ((IndexedFunction)this.getElement()).getNamespaceName()) != null && !"".equals(string)) {
                htmlFormatter.appendText(string);
                return htmlFormatter.getText();
            }
            return super.getRhsHtml(htmlFormatter);
        }

        public String getName() {
            String string = this.getElement().getIn();
            return string != null ? string : super.getName();
        }

        public ElementKind getKind() {
            return ElementKind.CONSTRUCTOR;
        }
    }

    static class ReturnItem
    extends KeywordItem {
        public ReturnItem(CompletionRequest completionRequest) {
            super("return", completionRequest);
        }

        public String getCustomInsertTemplate() {
            return "return ${cursor};";
        }
    }

    static class SpecialFunctionItem
    extends KeywordItem {
        public SpecialFunctionItem(String string, CompletionRequest completionRequest) {
            super(string, completionRequest);
        }

        public String getCustomInsertTemplate() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getName());
            stringBuilder.append(" '${cursor}';");
            return stringBuilder.toString();
        }
    }

    static class SuperGlobalItem
    extends PHPCompletionItem {
        private String name;

        public SuperGlobalItem(CompletionRequest completionRequest, String string) {
            super(new PredefinedSymbolElement(string), completionRequest);
            this.name = string;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.name(this.getKind(), true);
            htmlFormatter.emphasis(true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.emphasis(false);
            htmlFormatter.name(this.getKind(), false);
            return htmlFormatter.getText();
        }

        public String getName() {
            return "$" + this.name;
        }

        public String getCustomInsertTemplate() {
            return super.getCustomInsertTemplate();
        }

        public ElementKind getKind() {
            return ElementKind.VARIABLE;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.appendText(NbBundle.getMessage(PHPCompletionItem.class, (String)"PHPPlatform"));
            return htmlFormatter.getText();
        }

        public String getDocumentation() {
            return null;
        }

        public ImageIcon getIcon() {
            return keywordIcon;
        }
    }

    static class UnUniqueVaraibaleItems
    extends VariableItem {
        public UnUniqueVaraibaleItems(IndexedVariable indexedVariable, CompletionRequest completionRequest) {
            super(indexedVariable, completionRequest);
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.type(true);
            htmlFormatter.appendText("?");
            htmlFormatter.type(false);
            htmlFormatter.appendText(" ");
            htmlFormatter.name(this.getKind(), true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(this.getKind(), false);
            return htmlFormatter.getText();
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VariableItem
    extends PHPCompletionItem {
        private boolean insertDollarPrefix = true;

        VariableItem(IndexedVariable indexedVariable, CompletionRequest completionRequest) {
            super(indexedVariable, completionRequest);
            assert (indexedVariable instanceof IndexedTypedElement);
        }

        VariableItem(IndexedClassMember<? extends IndexedElement> indexedClassMember, CompletionRequest completionRequest) {
            super(indexedClassMember, completionRequest);
            assert (indexedClassMember.getMember() instanceof IndexedTypedElement);
        }

        VariableItem(IndexedConstant indexedConstant, CompletionRequest completionRequest) {
            super(indexedConstant, completionRequest);
            assert (indexedConstant instanceof IndexedTypedElement);
        }

        private IndexedTypedElement getIndexedTypedElement() {
            Object object = this.getElement();
            if (object instanceof IndexedClassMember) {
                object = ((IndexedClassMember)object).getMember();
            }
            return (IndexedTypedElement)object;
        }

        @Override
        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.type(true);
            htmlFormatter.appendText(this.getTypeName());
            htmlFormatter.type(false);
            htmlFormatter.appendText(" ");
            htmlFormatter.name(this.getKind(), true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(this.getKind(), false);
            return htmlFormatter.getText();
        }

        protected String getTypeName() {
            String string = null;
            IndexedTypedElement indexedTypedElement = this.getIndexedTypedElement();
            if (CodeUtils.isTypeResolved(indexedTypedElement)) {
                string = indexedTypedElement.getTypeName();
            }
            if (string == null) {
                string = indexedTypedElement.isTypeResolved() ? "?" : "";
            }
            return string;
        }

        public ElementKind getKind() {
            return ElementKind.VARIABLE;
        }

        @Override
        public String getName() {
            String string = super.getName();
            if (!this.insertDollarPrefix && string.startsWith("$")) {
                return string.substring(1);
            }
            return string;
        }

        void doNotInsertDollarPrefix() {
            this.insertDollarPrefix = false;
        }

        @Override
        public String getCustomInsertTemplate() {
            Completion.get().showToolTip();
            return super.getCustomInsertTemplate();
        }
    }
}

