/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;

public final class PHPBracesMatcher
implements BracesMatcher {
    MatcherContext context;

    public PHPBracesMatcher(MatcherContext matcherContext) {
        this.context = matcherContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            Token token;
            BaseDocument baseDocument = (BaseDocument)this.context.getDocument();
            int n = this.context.getSearchOffset();
            TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
            if (tokenSequence != null) {
                tokenSequence.move(n);
                if (!tokenSequence.moveNext()) {
                    int[] nArray = null;
                    return nArray;
                }
                token = tokenSequence.token();
                if (token == null) {
                    int[] nArray = null;
                    return nArray;
                }
                TokenId tokenId = token.id();
                if (LexUtilities.textEquals(token.text(), '(')) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), ')')) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
                if (tokenId == PHPTokenId.PHP_CURLY_OPEN) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
                if (tokenId == PHPTokenId.PHP_CURLY_CLOSE) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), '[')) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), ']')) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
            }
            token = null;
            return token;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            Token token;
            BaseDocument baseDocument = (BaseDocument)this.context.getDocument();
            int n = this.context.getSearchOffset();
            TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
            if (tokenSequence != null) {
                tokenSequence.move(n);
                if (!tokenSequence.moveNext()) {
                    int[] nArray = null;
                    return nArray;
                }
                token = tokenSequence.token();
                if (token == null) {
                    int[] nArray = null;
                    return nArray;
                }
                TokenId tokenId = token.id();
                if (LexUtilities.textEquals(token.text(), '(')) {
                    OffsetRange offsetRange = LexUtilities.findFwd(baseDocument, tokenSequence, '(', ')');
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), ')')) {
                    OffsetRange offsetRange = LexUtilities.findBwd(baseDocument, tokenSequence, '(', ')');
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
                if (tokenId == PHPTokenId.PHP_CURLY_OPEN) {
                    OffsetRange offsetRange = LexUtilities.findFwd(baseDocument, tokenSequence, '{', '}');
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
                if (tokenId == PHPTokenId.PHP_CURLY_CLOSE) {
                    OffsetRange offsetRange = LexUtilities.findBwd(baseDocument, tokenSequence, '{', '}');
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), '[')) {
                    OffsetRange offsetRange = LexUtilities.findFwd(baseDocument, tokenSequence, '[', ']');
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), ']')) {
                    OffsetRange offsetRange = LexUtilities.findBwd(baseDocument, tokenSequence, '[', ']');
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
            }
            token = null;
            return token;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }
}

