/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.Formatter;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.indent.IndentLevelCalculator;
import org.netbeans.modules.php.editor.indent.PHPNewLineIndenter;
import org.netbeans.modules.php.editor.indent.WSTransformer;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPFormatter
implements Formatter {
    private static final Logger LOG = Logger.getLogger(PHPFormatter.class.getName());
    private static final Set<PHPTokenId> IGNORE_BREAK_IN = new HashSet<PHPTokenId>(Arrays.asList(PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_WHILE, PHPTokenId.PHP_DO));

    public PHPFormatter() {
        LOG.fine("PHP Formatter: " + this);
    }

    public boolean needsParserResult() {
        return true;
    }

    public void reindent(Context context) {
        String string = PHPFormatter.getMimeTypeAtOffset(context.document(), context.startOffset());
        if (!"text/x-php5".equals(string)) {
            return;
        }
        PHPNewLineIndenter pHPNewLineIndenter = new PHPNewLineIndenter(context);
        pHPNewLineIndenter.process();
    }

    public void reformat(Context context, ParserResult parserResult) {
        LOG.log(Level.FINE, "PHPFormatter snapshot: \n''{0}''\n", ((Object)parserResult.getSnapshot().getText()).toString());
        LinkedHashMap<Position, Integer> linkedHashMap = new LinkedHashMap<Position, Integer>();
        IndentLevelCalculator indentLevelCalculator = new IndentLevelCalculator(context.document(), linkedHashMap);
        PHPParseResult pHPParseResult = (PHPParseResult)parserResult;
        pHPParseResult.getProgram().accept(indentLevelCalculator);
        this.prettyPrint(context, parserResult);
        this.astReformat(context, linkedHashMap);
    }

    public int indentSize() {
        return CodeStyle.get((Document)null).getIndentSize();
    }

    public int hangingIndentSize() {
        return CodeStyle.get((Document)null).getContinuationIndentSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean lineUnformattable(BaseDocument baseDocument, int n) throws BadLocationException {
        TokenId tokenId;
        Token<? extends PHPTokenId> token = LexUtilities.getToken(baseDocument, n);
        if (token.id() == PHPTokenId.PHP_LINE_COMMENT) {
            return true;
        }
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 != -1) {
            int n3;
            int n4;
            Token token2 = LexUtilities.getToken(baseDocument, n2);
            TokenSequence<? extends PHPTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n2);
            if (tokenSequence != null) {
                token2 = tokenSequence.token();
            }
            if (token2 == null) return true;
            TokenId tokenId2 = token2.id();
            if (tokenId2 == PHPTokenId.PHP_COMMENT || tokenId2 == PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE || tokenId2 == PHPTokenId.T_INLINE_HTML || tokenId2 == PHPTokenId.PHP_HEREDOC_TAG || tokenId2 == PHPTokenId.PHP_NOWDOC_TAG) {
                return true;
            }
            if (tokenId2 != PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING) return false;
            if (tokenSequence.movePrevious()) {
                if (tokenSequence.token().id() == PHPTokenId.PHP_HEREDOC_TAG || tokenSequence.token().id() == PHPTokenId.PHP_NOWDOC_TAG) {
                    return true;
                }
                tokenSequence.moveNext();
            }
            if ((n4 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenSequence.offset())) >= (n3 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2))) return false;
            return true;
        }
        Token<? extends PHPTokenId> token3 = LexUtilities.getToken(baseDocument, n);
        if (token3 == null || (tokenId = token3.id()) != PHPTokenId.PHP_COMMENT && tokenId != PHPTokenId.PHP_COMMENT_START && tokenId != PHPTokenId.PHP_COMMENT_END && tokenId != PHPTokenId.PHPDOC_COMMENT && tokenId != PHPTokenId.PHPDOC_COMMENT_START && tokenId != PHPTokenId.PHPDOC_COMMENT_END && tokenId != PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING && tokenId != PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE && tokenId != PHPTokenId.PHP_HEREDOC_TAG && tokenId != PHPTokenId.PHP_NOWDOC_TAG) return false;
        return true;
    }

    private static boolean isSectionBorderLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n);
        TokenSequence<? extends PHPTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n2);
        PHPTokenId pHPTokenId = (PHPTokenId)tokenSequence.token().id();
        return pHPTokenId == PHPTokenId.PHP_CLOSETAG || pHPTokenId == PHPTokenId.PHP_OPENTAG;
    }

    private void prettyPrint(final Context context, final ParserResult parserResult) {
        final BaseDocument baseDocument = (BaseDocument)context.document();
        String string = CodeStyle.get((Document)baseDocument).getOpeningBraceStyle();
        if ("ob.preserve".equals(string)) {
            return;
        }
        baseDocument.runAtomic(new Runnable(){

            public void run() {
                WSTransformer wSTransformer = new WSTransformer(context);
                PHPParseResult pHPParseResult = (PHPParseResult)parserResult;
                pHPParseResult.getProgram().accept(wSTransformer);
                wSTransformer.tokenScan();
                List<WSTransformer.Replacement> list = wSTransformer.getReplacements();
                Collections.sort(list);
                Collections.reverse(list);
                for (WSTransformer.Replacement replacement : list) {
                    int n = replacement.offset();
                    if (n < context.startOffset() || n > context.endOffset()) continue;
                    try {
                        baseDocument.insertString(n, replacement.newString(), null);
                        if (replacement.length() <= 0) continue;
                        baseDocument.remove(n - replacement.length(), replacement.length());
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            }
        });
    }

    private static String getMimeTypeAtOffset(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        List list = tokenHierarchy.embeddedTokenSequences(n, false);
        if (list != null && list.size() > 0) {
            TokenSequence tokenSequence = (TokenSequence)list.get(list.size() - 1);
            return tokenSequence.language().mimeType();
        }
        return null;
    }

    private void astReformat(final Context context, final Map<Position, Integer> map) {
        Document document = context.document();
        document.putProperty("HTML_FORMATTER_ACTS_ON_TOP_LEVEL", Boolean.TRUE);
        try {
            final BaseDocument baseDocument = (BaseDocument)document;
            final Map map2 = (Map)baseDocument.getProperty((Object)"AbstractIndenter.lineIndents");
            final int n = Utilities.getRowStart((BaseDocument)baseDocument, (int)context.startOffset());
            final int n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    int n15 = 0;
                    boolean bl = n == 0;
                    try {
                        int n22;
                        int n3;
                        int n4;
                        int n5 = CodeStyle.get((Document)baseDocument).getInitialIndent();
                        int n6 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)(baseDocument.getLength() - 1)) + 1;
                        LinkedHashMap<Integer, Integer> linkedHashMap = new LinkedHashMap<Integer, Integer>();
                        for (Position position : map.keySet()) {
                            n4 = (Integer)map.get(position);
                            n3 = position.getOffset();
                            int n7 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n3);
                            n22 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n3);
                            int n8 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)n3);
                            if (n8 >= n22) {
                                ++n7;
                            }
                            Integer n9 = (Integer)linkedHashMap.get(n7);
                            linkedHashMap.put(n7, n9 == null ? n4 : n9 + n4);
                        }
                        boolean bl2 = baseDocument.getProperty((Object)"code-template-insert-handler") != null;
                        n4 = 0;
                        for (int i = 0; i < n6; ++i) {
                            int n10;
                            Integer n11;
                            n3 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)i);
                            Integer n12 = (Integer)linkedHashMap.get(i);
                            if (n12 != null) assert ((n4 += n12.intValue()) >= 0) : "currentIndent < 0";
                            if (PHPFormatter.this.lineUnformattable(baseDocument, n3)) continue;
                            n22 = 0;
                            if (map2 != null && (n11 = (Integer)map2.get(i)) != null) {
                                n22 = n11;
                            }
                            if (!bl && (bl2 && i >= n2 || !bl2 && i >= n2 - 1)) {
                                n15 = n4 - GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n3) - n22 + n5;
                                bl = true;
                            }
                            if (n3 < context.startOffset() || n3 > context.endOffset()) continue;
                            int n13 = 0;
                            int n14 = n10 = PHPFormatter.isSectionBorderLine(baseDocument, n3) ? 0 : n5;
                            if (n4 + n22 + n10 > n15) {
                                n13 = n4 + n22 + n10 - n15;
                            }
                            GsfUtilities.setLineIndentation((BaseDocument)baseDocument, (int)n3, (int)n13);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }
}

