/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.index.IdentifierSignature;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;

public final class PHPIndexer
extends EmbeddingIndexer {
    private static final Logger LOG = Logger.getLogger(PHPIndexer.class.getName());
    static final boolean PREINDEXING = Boolean.getBoolean("gsf.preindexing");
    private static final Collection<String> INDEXABLE_EXTENSIONS = Arrays.asList("php", "php3", "php4", "php5", "phtml", "inc");
    static final String FIELD_BASE = "base";
    static final String FIELD_EXTEND = "extend";
    static final String FIELD_CLASS = "clz";
    static final String FIELD_IFACE = "iface";
    static final String FIELD_CONST = "const";
    static final String FIELD_CLASS_CONST = "clz.const";
    static final String FIELD_FIELD = "field";
    static final String FIELD_METHOD = "method";
    static final String FIELD_CONSTRUCTOR = "constructor";
    static final String FIELD_INCLUDE = "include";
    static final String FIELD_IDENTIFIER = "identifier_used";
    static final String FIELD_IDENTIFIER_DECLARATION = "identifier_declaration";
    static final String FIELD_NAMESPACE = "ns";
    static final String FIELD_VAR = "var";
    static final String FIELD_TOP_LEVEL = "top";
    static final String[] ALL_FIELDS = new String[]{"base", "extend", "clz", "iface", "const", "clz.const", "field", "method", "constructor", "include", "identifier_used", "var", "top", "ns"};

    public String getPersistentUrl(File file) {
        try {
            String string = file.toURI().toURL().toExternalForm();
            return PHPIndex.getPreindexUrl(string);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return file.getPath();
        }
    }

    protected void index(Indexable indexable, Parser.Result result, Context context) {
        try {
            Collection<? extends MethodScope> collection;
            PHPParseResult pHPParseResult = (PHPParseResult)result;
            if (pHPParseResult.getProgram() == null) {
                return;
            }
            String string = null;
            try {
                string = pHPParseResult.getSnapshot().getSource().getFileObject().getURL().toExternalForm();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
            if (string == null) {
                return;
            }
            PHPIndex.clearNamespaceCache();
            LinkedList<Object> linkedList = new LinkedList<Object>();
            IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
            Model model = pHPParseResult.getModel();
            FileScope fileScope = model.getFileScope();
            IndexDocument indexDocument = indexingSupport.createDocument(indexable);
            linkedList.add(indexDocument);
            for (ClassScope iterator2 : ModelUtils.getDeclaredClasses(fileScope)) {
                IndexDocument indexDocument2 = indexingSupport.createDocument(indexable);
                linkedList.add(indexDocument2);
                indexDocument2.addPair(FIELD_CLASS, iterator2.getIndexSignature(), true, true);
                indexDocument2.addPair(FIELD_TOP_LEVEL, iterator2.getName().toLowerCase(), true, true);
                for (MethodScope methodScope : iterator2.getDeclaredMethods()) {
                    indexDocument2.addPair(FIELD_METHOD, methodScope.getIndexSignature(), true, true);
                    if (!methodScope.isConstructor()) continue;
                    indexDocument2.addPair(FIELD_CONSTRUCTOR, methodScope.getConstructorIndexSignature(), false, true);
                }
                collection = iterator2.getDeclaredConstructors();
                if (collection.isEmpty()) {
                    indexDocument2.addPair(FIELD_CONSTRUCTOR, iterator2.getDefaultConstructorIndexSignature(), false, true);
                }
                for (FieldElement fieldElement : iterator2.getDeclaredFields()) {
                    indexDocument2.addPair(FIELD_FIELD, fieldElement.getIndexSignature(), true, true);
                }
                for (ClassConstantElement classConstantElement : iterator2.getDeclaredConstants()) {
                    indexDocument2.addPair(FIELD_CLASS_CONST, classConstantElement.getIndexSignature(), true, true);
                }
            }
            for (InterfaceScope interfaceScope : ModelUtils.getDeclaredInterfaces(fileScope)) {
                IndexDocument indexDocument3 = indexingSupport.createDocument(indexable);
                linkedList.add(indexDocument3);
                indexDocument3.addPair(FIELD_IFACE, interfaceScope.getIndexSignature(), true, true);
                indexDocument3.addPair(FIELD_TOP_LEVEL, interfaceScope.getName().toLowerCase(), true, true);
                for (MethodScope methodScope : interfaceScope.getDeclaredMethods()) {
                    indexDocument3.addPair(FIELD_METHOD, methodScope.getIndexSignature(), true, true);
                }
                for (ClassConstantElement classConstantElement : interfaceScope.getDeclaredConstants()) {
                    indexDocument3.addPair(FIELD_CLASS_CONST, classConstantElement.getIndexSignature(), true, true);
                }
            }
            Iterator<TypeScope> iterator4 = indexingSupport.createDocument(indexable);
            linkedList.add(iterator4);
            for (FunctionScope functionScope : ModelUtils.getDeclaredFunctions(fileScope)) {
                iterator4.addPair(FIELD_BASE, functionScope.getIndexSignature(), true, true);
                iterator4.addPair(FIELD_TOP_LEVEL, functionScope.getName().toLowerCase(), true, true);
            }
            for (ConstantElement constantElement : ModelUtils.getDeclaredConstants(fileScope)) {
                iterator4.addPair(FIELD_CONST, constantElement.getIndexSignature(), true, true);
                iterator4.addPair(FIELD_TOP_LEVEL, constantElement.getName().toLowerCase(), true, true);
            }
            for (NamespaceScope namespaceScope : fileScope.getDeclaredNamespaces()) {
                collection = namespaceScope.getDeclaredVariables();
                for (VariableName variableName : collection) {
                    String string2 = variableName.getName();
                    String string3 = string2.startsWith("$") ? string2.substring(1) : string2;
                    if (PredefinedSymbols.isSuperGlobalName(string3)) continue;
                    String string4 = variableName.getIndexSignature();
                    iterator4.addPair(FIELD_VAR, string4, true, true);
                    iterator4.addPair(FIELD_TOP_LEVEL, variableName.getName().toLowerCase(), true, true);
                }
                if (namespaceScope.isDefaultNamespace()) continue;
                iterator4.addPair(FIELD_NAMESPACE, namespaceScope.getIndexSignature(), true, true);
                iterator4.addPair(FIELD_TOP_LEVEL, namespaceScope.getName().toLowerCase(), true, true);
            }
            final IndexDocument indexDocument4 = indexingSupport.createDocument(indexable);
            linkedList.add(indexDocument4);
            Program program = pHPParseResult.getProgram();
            collection = new DefaultVisitor(){

                public void visit(Identifier identifier) {
                    IdentifierSignature identifierSignature = IdentifierSignature.createIdentifier(identifier);
                    indexDocument4.addPair(PHPIndexer.FIELD_IDENTIFIER, identifierSignature.getSignature(), true, true);
                    super.visit(identifier);
                }
            };
            program.accept((Visitor)((Object)collection));
            for (IndexDocument indexDocument5 : linkedList) {
                indexingSupport.addDocument(indexDocument5);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public File getPreindexedData() {
        return null;
    }

    public boolean acceptQueryPath(String string) {
        return string.indexOf("jsstubs") == -1 && string.indexOf("/ruby2/") == -1 && string.indexOf("/gems/") == -1 && string.indexOf("lib/ruby/") == -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends EmbeddingIndexerFactory {
        public static final String NAME = "php";
        public static final int VERSION = 10;

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(indexable, snapshot)) {
                return new PHPIndexer();
            }
            return null;
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 10;
        }

        private boolean isIndexable(Indexable indexable, Snapshot snapshot) {
            FileObject fileObject = snapshot.getSource().getFileObject();
            if (INDEXABLE_EXTENSIONS.contains(fileObject.getExt().toLowerCase())) {
                return true;
            }
            return FileUtils.isPhpFile((FileObject)fileObject);
        }

        public void filesDeleted(Iterable<? extends Indexable> iterable, Context context) {
            try {
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : iterable) {
                    indexingSupport.removeDocuments(indexable);
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
        }

        public void rootsRemoved(Iterable<? extends URL> iterable) {
        }

        public void filesDirty(Iterable<? extends Indexable> iterable, Context context) {
            try {
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : iterable) {
                    indexingSupport.markDirtyDocuments(indexable);
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
        }
    }
}

