/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.CodeMarker;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.Parameter;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.CodeMarkerBuilder;
import org.netbeans.modules.php.editor.model.impl.ConstantElementImpl;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.FileScopeImpl;
import org.netbeans.modules.php.editor.model.impl.FunctionScopeImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelBuilder;
import org.netbeans.modules.php.editor.model.impl.ModelElementFactory;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.NamespaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.OccurenceBuilder;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VarAssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameFactory;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.ClassConstantDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.ConstantDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.PhpDocTypeTagInfo;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.GotoLabel;
import org.netbeans.modules.php.editor.parser.astnodes.GotoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InstanceOfExpression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.ReflectionVariable;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelVisitor
extends DefaultTreePathVisitor {
    private final FileScopeImpl fileScope;
    private Map<VariableNameFactory, Map<String, VariableNameImpl>> vars;
    private Map<String, List<PhpDocTypeTagInfo>> varTypeComments;
    private OccurenceBuilder occurencesBuilder;
    private CodeMarkerBuilder markerBuilder;
    private ModelBuilder modelBuilder;
    private ParserResult info;
    private static Set<String> recursionDetection = new HashSet<String>();

    public ModelVisitor(ParserResult parserResult) {
        this(parserResult, -1);
    }

    public ModelVisitor(ParserResult parserResult, int n) {
        this.fileScope = new FileScopeImpl(parserResult);
        this.varTypeComments = new HashMap<String, List<PhpDocTypeTagInfo>>();
        this.occurencesBuilder = new OccurenceBuilder(n);
        this.markerBuilder = new CodeMarkerBuilder(n);
        this.modelBuilder = new ModelBuilder(this.fileScope);
        this.info = parserResult;
    }

    public ModelVisitor(ParserResult parserResult, ModelElement modelElement) {
        this.fileScope = new FileScopeImpl(parserResult);
        this.varTypeComments = new HashMap<String, List<PhpDocTypeTagInfo>>();
        this.occurencesBuilder = new OccurenceBuilder(modelElement);
        this.markerBuilder = new CodeMarkerBuilder(-1);
        this.modelBuilder = new ModelBuilder(this.fileScope);
        this.info = parserResult;
    }

    public ParserResult getCompilationInfo() {
        return this.info;
    }

    @Override
    public void scan(ASTNode aSTNode) {
        super.scan(aSTNode);
    }

    @Override
    public void visit(PHPDocTag pHPDocTag) {
        super.visit(pHPDocTag);
        PHPDocTag.Type type = pHPDocTag.getKind();
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        if (scopeImpl instanceof TypeScope && type.equals((Object)PHPDocTag.Type.METHOD)) {
            this.modelBuilder.buildMagicMethod(pHPDocTag, this.occurencesBuilder);
        }
    }

    @Override
    public void visit(ReturnStatement returnStatement) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        this.markerBuilder.prepare(returnStatement, (Scope)scopeImpl);
        String string = null;
        if (scopeImpl instanceof FunctionScope) {
            Object object;
            Collection<? extends VariableName> collection;
            FunctionScopeImpl functionScopeImpl = (FunctionScopeImpl)scopeImpl;
            Expression expression = returnStatement.getExpression();
            if (expression instanceof ClassInstanceCreation) {
                collection = (ClassInstanceCreation)expression;
                object = ASTNodeInfo.create((ClassInstanceCreation)((Object)collection));
                string = object.getQualifiedName().toString();
            } else if (expression instanceof VariableBase && (string = VariousUtils.extractTypeFroVariableBase((VariableBase)expression)) != null) {
                collection = VariousUtils.getAllVariables(functionScopeImpl, string);
                object = new HashMap();
                for (VariableName variableName : collection) {
                    String string2 = variableName.getName();
                    String object2 = this.resolveVariableType(string2, functionScopeImpl, returnStatement);
                    if (object2 == null) {
                        object = Collections.emptyMap();
                        break;
                    }
                    object.put(string2, object2);
                }
                if (!object.isEmpty()) {
                    string = VariousUtils.replaceVarNames(string, (Map<String, String>)object);
                }
            }
            if (string != null) {
                collection = new HashSet();
                if (functionScopeImpl.returnType != null) {
                    object = functionScopeImpl.returnType.split("\\|");
                    for (String string2 : object) {
                        collection.add((VariableName)((Object)string2));
                    }
                }
                object = QualifiedName.create(string).toString();
                if (collection.isEmpty()) {
                    functionScopeImpl.returnType = object;
                } else if (collection.add((VariableName)object)) {
                    functionScopeImpl.returnType = functionScopeImpl.returnType + "|" + (String)object;
                }
            }
        }
        super.visit(returnStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveVariableType(String string, FunctionScopeImpl functionScopeImpl, ReturnStatement returnStatement) {
        try {
            if (string != null && recursionDetection.add(string)) {
                String string2;
                AssignmentImpl assignmentImpl;
                if (string.equalsIgnoreCase("$this") && functionScopeImpl instanceof MethodScope) {
                    String string3 = functionScopeImpl.getInScope().getName();
                    return string3;
                }
                VariableNameImpl variableNameImpl = (VariableNameImpl)ModelUtils.getFirst(functionScopeImpl.getDeclaredVariables(), string);
                if (variableNameImpl != null && (assignmentImpl = variableNameImpl.findVarAssignment(returnStatement.getStartOffset())) != null && (string2 = assignmentImpl.typeNameFromUnion()) != null) {
                    if (!string2.contains("@")) {
                        String string4 = string2;
                        return string4;
                    }
                    String string5 = ModelVisitor.getName(string2, VariousUtils.Kind.VAR, true);
                    if (string5 != null && !string5.equalsIgnoreCase(string)) {
                        String string6 = this.resolveVariableType(string5, functionScopeImpl, returnStatement);
                        return string6;
                    }
                    String string7 = string2;
                    return string7;
                }
            }
        }
        finally {
            if (string != null) {
                recursionDetection.remove(string);
            }
        }
        return null;
    }

    @Override
    public void visit(GotoLabel gotoLabel) {
        super.visit(gotoLabel);
        this.occurencesBuilder.prepare(gotoLabel, this.modelBuilder.getCurrentScope());
    }

    @Override
    public void visit(GotoStatement gotoStatement) {
        super.visit(gotoStatement);
        this.occurencesBuilder.prepare(gotoStatement, this.modelBuilder.getCurrentScope());
    }

    public static String getName(String string, VariousUtils.Kind kind, boolean bl) {
        String[] stringArray;
        String string2;
        if (string != null && string.startsWith(string2 = "@" + kind.toString()) && (stringArray = string.split(string2, 2)).length > 1) {
            if (stringArray[1].contains("@")) {
                if (bl) {
                    return null;
                }
                if ((stringArray = stringArray[1].split("@")).length < 1) {
                    return null;
                }
                return stringArray[0];
            }
            return stringArray[1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(Program program) {
        this.modelBuilder.setProgram(program);
        this.fileScope.setBlockRange(program);
        this.vars = new HashMap<VariableNameFactory, Map<String, VariableNameImpl>>();
        try {
            this.prepareVarComments(program);
            super.visit(program);
            this.handleVarComments();
        }
        finally {
            program = null;
            this.vars = null;
            this.buildOccurences();
            this.buildCodeMarks();
        }
    }

    @Override
    public void visit(Include include) {
        this.modelBuilder.build(include, this.occurencesBuilder);
        super.visit(include);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(NamespaceDeclaration namespaceDeclaration) {
        this.modelBuilder.build(namespaceDeclaration, this.occurencesBuilder);
        try {
            super.visit(namespaceDeclaration);
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    @Override
    public void visit(NamespaceName namespaceName) {
        super.visit(namespaceName);
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CONSTANT, namespaceName, (Scope)this.fileScope);
    }

    @Override
    public void visit(UseStatementPart useStatementPart) {
        ASTNodeInfo<UseStatementPart> aSTNodeInfo = ASTNodeInfo.create(useStatementPart);
        this.modelBuilder.getCurrentNameSpace().createElement(aSTNodeInfo);
        super.visit(useStatementPart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(ClassDeclaration classDeclaration) {
        this.modelBuilder.build(classDeclaration, this.occurencesBuilder);
        this.checkComments(classDeclaration);
        try {
            super.visit(classDeclaration);
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(InterfaceDeclaration interfaceDeclaration) {
        this.modelBuilder.build(interfaceDeclaration, this.occurencesBuilder);
        try {
            super.visit(interfaceDeclaration);
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(MethodDeclaration methodDeclaration) {
        this.modelBuilder.build(methodDeclaration, this.occurencesBuilder);
        this.markerBuilder.prepare(methodDeclaration, (Scope)this.modelBuilder.getCurrentScope());
        this.checkComments(methodDeclaration);
        try {
            this.scan(methodDeclaration.getFunction().getFormalParameters());
            this.scan(methodDeclaration.getFunction().getBody());
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    @Override
    public void visit(FieldsDeclaration fieldsDeclaration) {
        this.modelBuilder.build(fieldsDeclaration, this.occurencesBuilder);
        this.checkComments(fieldsDeclaration);
        super.visit(fieldsDeclaration);
    }

    @Override
    public void visit(ClassInstanceCreation classInstanceCreation) {
        this.occurencesBuilder.prepare(classInstanceCreation, (Scope)this.modelBuilder.getCurrentScope());
        this.scan(classInstanceCreation.ctorParams());
    }

    @Override
    public void visit(InstanceOfExpression instanceOfExpression) {
        Expression expression;
        this.occurencesBuilder.prepare(instanceOfExpression.getClassName(), (Scope)this.modelBuilder.getCurrentScope());
        String string = CodeUtils.extractClassName(instanceOfExpression.getClassName());
        if (string != null && (expression = instanceOfExpression.getExpression()) instanceof Variable) {
            Variable variable = (Variable)expression;
            ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
            VariableNameImpl variableNameImpl = this.findVariable((Scope)scopeImpl, variable);
            if (variableNameImpl != null) {
                variableNameImpl.addElement(new VarAssignmentImpl(variableNameImpl, (Scope)scopeImpl, this.getBlockRange(scopeImpl), ASTNodeInfo.create(variable).getRange(), string));
            }
        }
        super.visit(instanceOfExpression);
    }

    @Override
    public void visit(MethodInvocation methodInvocation) {
        this.occurencesBuilder.prepare(methodInvocation, (Scope)this.modelBuilder.getCurrentScope());
        this.scan(methodInvocation.getDispatcher());
        this.scan(methodInvocation.getMethod().getParameters());
    }

    @Override
    public void visit(Scalar scalar) {
        String string = scalar.getStringValue();
        if (string != null && string.trim().length() > 0 && scalar.getScalarType() == Scalar.Type.STRING && !NavUtils.isQuoted(string)) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CONSTANT, scalar, (Scope)this.fileScope);
        }
        super.visit(scalar);
    }

    @Override
    public void visit(StaticMethodInvocation staticMethodInvocation) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(staticMethodInvocation, (Scope)scopeImpl);
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, staticMethodInvocation.getClassName(), (Scope)scopeImpl);
        this.scan(staticMethodInvocation.getMethod().getParameters());
    }

    @Override
    public void visit(ClassName className) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(className, (Scope)scopeImpl);
    }

    @Override
    public void visit(StaticConstantAccess staticConstantAccess) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(staticConstantAccess, (Scope)scopeImpl);
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, staticConstantAccess.getClassName(), (Scope)scopeImpl);
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.IFACE, staticConstantAccess.getClassName(), (Scope)scopeImpl);
    }

    @Override
    public void visit(ConstantDeclaration constantDeclaration) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        if (scopeImpl instanceof NamespaceScope) {
            List<? extends ConstantDeclarationInfo> list = ConstantDeclarationInfo.create(constantDeclaration);
            for (ConstantDeclarationInfo constantDeclarationInfo : list) {
                ConstantElementImpl constantElementImpl = this.modelBuilder.getCurrentNameSpace().createElement(constantDeclarationInfo);
                this.occurencesBuilder.prepare(constantDeclarationInfo, (ConstantElement)constantElementImpl);
            }
        } else {
            List<? extends ClassConstantDeclarationInfo> list = ClassConstantDeclarationInfo.create(constantDeclaration);
            for (ClassConstantDeclarationInfo classConstantDeclarationInfo : list) {
                this.occurencesBuilder.prepare(classConstantDeclarationInfo, ModelElementFactory.create(classConstantDeclarationInfo, this.modelBuilder));
            }
        }
        super.visit(constantDeclaration);
    }

    @Override
    public void visit(SingleFieldDeclaration singleFieldDeclaration) {
    }

    @Override
    public void visit(ReflectionVariable reflectionVariable) {
        Expression expression = reflectionVariable.getName();
        while (expression instanceof ReflectionVariable) {
            ReflectionVariable reflectionVariable2 = (ReflectionVariable)expression;
            expression = reflectionVariable2.getName();
        }
        if (expression instanceof Variable) {
            this.scan(expression);
        }
    }

    @Override
    public void visit(Variable variable) {
        String string = CodeUtils.extractVariableName(variable);
        if (string == null) {
            return;
        }
        Scope scope = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(variable, scope);
        if (scope instanceof VariableNameFactory) {
            ASTNodeInfo<Variable> aSTNodeInfo = ASTNodeInfo.create(variable);
            if (scope instanceof MethodScope && aSTNodeInfo.getName().equals("$this")) {
                scope = scope.getInScope();
            }
            this.createVariable((VariableNameFactory)scope, variable);
        } else assert (scope instanceof ClassScope) : scope;
        super.visit(variable);
    }

    @Override
    public void visit(GlobalStatement globalStatement) {
        super.visit(globalStatement);
        List<Variable> list = globalStatement.getVariables();
        for (Variable variable : list) {
            ScopeImpl scopeImpl;
            String string = CodeUtils.extractVariableName(variable);
            if (string == null || !((scopeImpl = this.modelBuilder.getCurrentScope()) instanceof VariableNameFactory)) continue;
            VariableNameFactory variableNameFactory = (VariableNameFactory)((Object)scopeImpl);
            List<? extends VariableName> list2 = ModelUtils.filter(variableNameFactory.getDeclaredVariables(), string);
            VariableNameImpl variableNameImpl = (VariableNameImpl)ModelUtils.getFirst(list2);
            if (variableNameImpl != null) {
                variableNameImpl.setGloballyVisible(true);
                continue;
            }
            variableNameFactory = this.modelBuilder.getCurrentNameSpace();
            list2 = ModelUtils.filter(variableNameFactory.getDeclaredVariables(), string);
            variableNameImpl = (VariableNameImpl)ModelUtils.getFirst(list2);
            if (variableNameImpl == null) continue;
            variableNameImpl.setGloballyVisible(true);
        }
    }

    @Override
    public void visit(FieldAccess fieldAccess) {
        this.occurencesBuilder.prepare(fieldAccess, (Scope)this.modelBuilder.getCurrentScope());
        Variable variable = fieldAccess.getField();
        if (variable instanceof ArrayAccess) {
            ArrayAccess arrayAccess = (ArrayAccess)variable;
            this.scan(arrayAccess.getIndex());
            VariableBase variableBase = arrayAccess.getName();
            while (variableBase instanceof ArrayAccess) {
                ArrayAccess arrayAccess2 = (ArrayAccess)variableBase;
                this.scan(arrayAccess2.getIndex());
                variableBase = arrayAccess2.getName();
            }
        }
        this.scan(fieldAccess.getDispatcher());
    }

    @Override
    public void visit(FunctionName functionName) {
    }

    private Map<String, AssignmentImpl> getAssignmentMap(Scope scope, VariableBase variableBase) {
        HashMap<String, AssignmentImpl> hashMap = new HashMap<String, AssignmentImpl>();
        if (scope instanceof VariableScope) {
            VariableScope variableScope = (VariableScope)scope;
            Collection<? extends VariableName> collection = variableScope.getDeclaredVariables();
            for (VariableName variableName : collection) {
                VariableNameImpl variableNameImpl;
                AssignmentImpl assignmentImpl;
                if (!(variableName instanceof VariableNameImpl) || (assignmentImpl = (variableNameImpl = (VariableNameImpl)variableName).findVarAssignment(variableBase.getStartOffset())) == null) continue;
                hashMap.put(variableNameImpl.getName(), assignmentImpl);
            }
        }
        return hashMap;
    }

    @Override
    public void visit(Assignment assignment) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        VariableBase variableBase = assignment.getLeftHandSide();
        Expression expression = assignment.getRightHandSide();
        super.scan(variableBase);
        if (variableBase instanceof Variable) {
            VariableNameImpl variableNameImpl = this.findVariable((Scope)scopeImpl, variableBase);
            if (variableNameImpl != null) {
                Map<String, AssignmentImpl> map = this.getAssignmentMap(scopeImpl, variableBase);
                Variable variable = (Variable)variableBase;
                if (expression instanceof ArrayCreation) {
                    ArrayCreation arrayCreation = (ArrayCreation)expression;
                    List<ArrayElement> list = arrayCreation.getElements();
                    if (!list.isEmpty()) {
                        for (ArrayElement arrayElement : list) {
                            Expression expression2 = arrayElement.getValue();
                            String string = VariousUtils.extractVariableTypeFromExpression(expression2, map);
                            VarAssignmentImpl varAssignmentImpl = new VarAssignmentImpl(variableNameImpl, (Scope)scopeImpl, this.getBlockRange(scopeImpl), new OffsetRange(variable.getStartOffset(), variable.getEndOffset()), string);
                            varAssignmentImpl.setAsArrayAccess(true);
                        }
                    } else {
                        String string = VariousUtils.extractVariableTypeFromExpression(expression, map);
                        VarAssignmentImpl varAssignmentImpl = new VarAssignmentImpl(variableNameImpl, (Scope)scopeImpl, this.getBlockRange(scopeImpl), new OffsetRange(variable.getStartOffset(), variable.getEndOffset()), string);
                    }
                } else {
                    variableNameImpl.createAssignment(scopeImpl, this.getBlockRange(scopeImpl), new OffsetRange(variable.getStartOffset(), variable.getEndOffset()), assignment, map);
                }
                this.occurencesBuilder.prepare((Variable)variableBase, (Scope)scopeImpl);
            }
        } else if (variableBase instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)variableBase;
            VariableNameImpl variableNameImpl = this.findVariable((Scope)this.modelBuilder.getCurrentScope(), fieldAccess.getDispatcher());
            if (variableNameImpl != null) {
                variableNameImpl.createLazyFieldAssignment(fieldAccess, assignment, scopeImpl);
            }
        } else if (variableBase instanceof StaticFieldAccess) {
            StaticFieldAccess staticFieldAccess = (StaticFieldAccess)variableBase;
        }
        super.scan(expression);
    }

    @Override
    public void visit(ForEachStatement forEachStatement) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        super.visit(forEachStatement);
        Expression expression = forEachStatement.getExpression();
        Expression expression2 = forEachStatement.getValue();
        if (expression instanceof Variable && expression2 instanceof Variable) {
            VariableNameImpl variableNameImpl = this.findVariable((Scope)scopeImpl, (Variable)expression);
            VariableNameImpl variableNameImpl2 = this.findVariable((Scope)scopeImpl, (Variable)expression2);
            if (variableNameImpl != null && variableNameImpl2 != null) {
                variableNameImpl2.setTypeResolutionKind(VariableNameImpl.TypeResolutionKind.MERGE_ASSIGNMENTS);
                Collection<? extends String> collection = variableNameImpl.getArrayAccessTypeNames(forEachStatement.getStartOffset());
                for (String string : collection) {
                    new VarAssignmentImpl(variableNameImpl2, (Scope)scopeImpl, this.getBlockRange(scopeImpl), new OffsetRange(expression2.getStartOffset(), expression2.getEndOffset()), string);
                }
            }
        }
    }

    @Override
    public void visit(FormalParameter formalParameter) {
        Object object;
        Object object2;
        Object object3 = formalParameter.getParameterName();
        Expression expression = formalParameter.getParameterType();
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        FunctionScopeImpl functionScopeImpl = (FunctionScopeImpl)scopeImpl;
        while (object3 instanceof Reference) {
            object2 = (Reference)object3;
            object = ((Reference)object2).getExpression();
            if (!(object instanceof Variable) && !(object instanceof Reference)) continue;
            object3 = object;
        }
        object2 = functionScopeImpl.getParameters();
        if (object3 instanceof Variable) {
            object = object2.iterator();
            while (object.hasNext()) {
                Parameter parameter = (Parameter)object.next();
                List<QualifiedName> list = parameter.getTypes();
                VariableNameImpl variableNameImpl = this.createParameter(functionScopeImpl, parameter);
                if (list.isEmpty() || variableNameImpl == null) continue;
                variableNameImpl.addElement(new VarAssignmentImpl(variableNameImpl, (Scope)functionScopeImpl, functionScopeImpl.getBlockRange(), parameter.getOffsetRange(), list.get(0).toString()));
            }
        }
        if (object3 instanceof Variable) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, expression, (Scope)functionScopeImpl);
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.IFACE, expression, (Scope)functionScopeImpl);
            this.occurencesBuilder.prepare((Variable)object3, (Scope)functionScopeImpl);
        }
        super.visit(formalParameter);
    }

    @Override
    public void visit(CatchClause catchClause) {
        VariableNameImpl variableNameImpl;
        Variable variable = catchClause.getVariable();
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        if (scopeImpl instanceof VariableNameFactory && (variableNameImpl = this.createVariable((VariableNameFactory)((Object)scopeImpl), variable)) != null) {
            variableNameImpl.addElement(new VarAssignmentImpl(variableNameImpl, (Scope)scopeImpl, new OffsetRange(catchClause.getStartOffset(), catchClause.getEndOffset()), VariableNameImpl.toOffsetRange(variable), CodeUtils.extractUnqualifiedTypeName(catchClause)));
        }
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, catchClause.getClassName(), (Scope)scopeImpl);
        this.occurencesBuilder.prepare(variable, (Scope)scopeImpl);
        this.scan(catchClause.getBody());
    }

    @Override
    public void visit(LambdaFunctionDeclaration lambdaFunctionDeclaration) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        FunctionScopeImpl functionScopeImpl = FunctionScopeImpl.createElement(scopeImpl, lambdaFunctionDeclaration);
        scopeImpl = functionScopeImpl;
        this.modelBuilder.setCurrentScope(scopeImpl);
        List<Expression> list = lambdaFunctionDeclaration.getLexicalVariables();
        for (Expression expression : list) {
            if (!(expression instanceof Variable)) continue;
            Variable variable = (Variable)expression;
            VariableNameImpl variableNameImpl = this.createVariable((VariableNameFactory)((Object)scopeImpl), variable);
            variableNameImpl.setGloballyVisible(true);
        }
        this.scan(list);
        scopeImpl.setBlockRange(lambdaFunctionDeclaration.getBody());
        this.scan(lambdaFunctionDeclaration.getFormalParameters());
        this.scan(lambdaFunctionDeclaration.getBody());
        this.modelBuilder.reset();
    }

    @Override
    public void visit(FunctionDeclaration functionDeclaration) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        assert (scopeImpl != null && (scopeImpl instanceof FunctionScope || scopeImpl instanceof MethodScope || scopeImpl instanceof NamespaceScopeImpl));
        if (scopeImpl instanceof NamespaceScopeImpl) {
            NamespaceScopeImpl namespaceScopeImpl = (NamespaceScopeImpl)scopeImpl;
            FunctionScopeImpl functionScopeImpl = namespaceScopeImpl.createElement(this.modelBuilder.getProgram(), functionDeclaration);
            scopeImpl = functionScopeImpl;
            this.modelBuilder.setCurrentScope(scopeImpl);
            this.occurencesBuilder.prepare(functionDeclaration, functionScopeImpl);
            this.markerBuilder.prepare(functionDeclaration, (Scope)this.modelBuilder.getCurrentScope());
            this.checkComments(functionDeclaration);
        } else if (!(scopeImpl instanceof NamespaceScope)) {
            Scope scope = scopeImpl;
            while (!(scope instanceof NamespaceScope)) {
                scope = scope.getInScope();
            }
            if (scope instanceof NamespaceScopeImpl) {
                NamespaceScopeImpl namespaceScopeImpl = (NamespaceScopeImpl)scope;
                FunctionScopeImpl functionScopeImpl = namespaceScopeImpl.createElement(this.modelBuilder.getProgram(), functionDeclaration);
                scopeImpl = functionScopeImpl;
                this.modelBuilder.setCurrentScope(scopeImpl);
                this.occurencesBuilder.prepare(functionDeclaration, functionScopeImpl);
                this.markerBuilder.prepare(functionDeclaration, (Scope)this.modelBuilder.getCurrentScope());
                this.checkComments(functionDeclaration);
            }
        }
        scopeImpl.setBlockRange(functionDeclaration.getBody());
        this.scan(functionDeclaration.getFormalParameters());
        this.scan(functionDeclaration.getBody());
        this.modelBuilder.reset();
    }

    @Override
    public void visit(FunctionInvocation functionInvocation) {
        Scalar scalar;
        Expression expression;
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(functionInvocation, (Scope)scopeImpl);
        ASTNodeInfo<FunctionInvocation> aSTNodeInfo = ASTNodeInfo.create(functionInvocation);
        String string = aSTNodeInfo.getName();
        if ("define".equals(string) && functionInvocation.getParameters().size() == 2) {
            Scalar scalar2;
            String string2;
            Expression expression2 = functionInvocation.getParameters().get(0);
            if (expression2 instanceof Scalar && ((Scalar)expression2).getScalarType() == Scalar.Type.STRING && NavUtils.isQuoted(string2 = (scalar2 = (Scalar)expression2).getStringValue())) {
                ASTNodeInfo<Scalar> aSTNodeInfo2 = ASTNodeInfo.create(ASTNodeInfo.Kind.CONSTANT, scalar2);
                ConstantElementImpl constantElementImpl = this.modelBuilder.getCurrentNameSpace().createElement(aSTNodeInfo2);
                this.occurencesBuilder.prepare(aSTNodeInfo2, (ConstantElement)constantElementImpl);
            }
        } else if ("constant".equals(string) && functionInvocation.getParameters().size() == 1 && (expression = functionInvocation.getParameters().get(0)) instanceof Scalar && (scalar = (Scalar)expression).getScalarType() == Scalar.Type.STRING && NavUtils.isQuoted(scalar.getStringValue())) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CONSTANT, scalar, (Scope)this.fileScope);
        }
        super.visit(functionInvocation);
    }

    @Override
    public void visit(StaticFieldAccess staticFieldAccess) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(staticFieldAccess, (Scope)scopeImpl);
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, staticFieldAccess.getClassName(), (Scope)scopeImpl);
        Variable variable = staticFieldAccess.getField();
        if (variable instanceof ArrayAccess) {
            ArrayAccess arrayAccess = (ArrayAccess)variable;
            this.scan(arrayAccess.getIndex());
            VariableBase variableBase = arrayAccess.getName();
            while (variableBase instanceof ArrayAccess) {
                ArrayAccess arrayAccess2 = (ArrayAccess)variableBase;
                this.scan(arrayAccess2.getIndex());
                variableBase = arrayAccess2.getName();
            }
        }
    }

    @Override
    public void visit(PHPDocTypeTag pHPDocTypeTag) {
        this.occurencesBuilder.prepare(pHPDocTypeTag, (Scope)this.modelBuilder.getCurrentScope());
        super.visit(pHPDocTypeTag);
    }

    @Override
    public void visit(PHPDocVarTypeTag pHPDocVarTypeTag) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        StringBuilder stringBuilder = new StringBuilder();
        List<? extends PhpDocTypeTagInfo> list = PhpDocTypeTagInfo.create((PHPDocTypeTag)pHPDocVarTypeTag, scopeImpl);
        Iterator<? extends PhpDocTypeTagInfo> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string;
            PhpDocTypeTagInfo phpDocTypeTagInfo = iterator.next();
            if (phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.FIELD)) {
                string = phpDocTypeTagInfo.getTypeName();
                if (string != null) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("|");
                    }
                    stringBuilder.append(string);
                }
                if (!(scopeImpl instanceof ClassScope) || iterator.hasNext()) continue;
                new FieldElementImpl((Scope)scopeImpl, stringBuilder.length() > 0 ? stringBuilder.toString() : null, phpDocTypeTagInfo);
                continue;
            }
            if (!pHPDocVarTypeTag.getKind().equals((Object)PHPDocTag.Type.GLOBAL) || !phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.VARIABLE)) continue;
            string = phpDocTypeTagInfo.getTypeName();
            String string2 = phpDocTypeTagInfo.getName();
            VariableScope variableScope = this.getVariableScope(pHPDocVarTypeTag.getStartOffset());
            if (variableScope == null) continue;
            VariableNameImpl variableNameImpl = this.findVariable((Scope)variableScope, string2);
            if (variableNameImpl == null && variableScope instanceof VariableNameFactory) {
                VariableNameFactory variableNameFactory = (VariableNameFactory)variableScope;
                OffsetRange offsetRange = new OffsetRange(pHPDocVarTypeTag.getStartOffset(), pHPDocVarTypeTag.getEndOffset());
                variableNameImpl = new VariableNameImpl((Scope)variableNameFactory, string2, variableScope.getFile(), offsetRange, true);
            }
            if (variableNameImpl == null) continue;
            variableNameImpl.addElement(new VarAssignmentImpl(variableNameImpl, (Scope)variableScope, variableScope.getBlockRange(), variableNameImpl.getNameRange(), string));
        }
        this.occurencesBuilder.prepare(pHPDocVarTypeTag, (Scope)scopeImpl);
        super.visit(pHPDocVarTypeTag);
    }

    public FileScope getFileScope() {
        return this.fileScope;
    }

    @CheckForNull
    public CodeMarker getCodeMarker(int n) {
        return this.findStrictCodeMarker((FileScopeImpl)this.getFileScope(), n, null);
    }

    private void checkComments(ASTNode aSTNode) {
        block4: {
            Comment comment;
            block3: {
                Comment comment2 = comment = aSTNode instanceof Comment ? (Comment)aSTNode : Utils.getCommentForNode(this.modelBuilder.getProgram(), aSTNode);
                if (!(comment instanceof PHPDocBlock)) break block3;
                PHPDocBlock pHPDocBlock = (PHPDocBlock)comment;
                for (PHPDocTag pHPDocTag : pHPDocBlock.getTags()) {
                    this.scan(pHPDocTag);
                }
                break block4;
            }
            if (!(comment instanceof PHPVarComment)) break block4;
            PHPDocVarTypeTag pHPDocVarTypeTag = ((PHPVarComment)comment).getVariable();
            List<? extends PhpDocTypeTagInfo> list = PhpDocTypeTagInfo.create((PHPDocTypeTag)pHPDocVarTypeTag, this.fileScope);
            for (PhpDocTypeTagInfo phpDocTypeTagInfo : list) {
                if (!phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.VARIABLE)) continue;
                String string = phpDocTypeTagInfo.getName();
                List<PhpDocTypeTagInfo> list2 = this.varTypeComments.get(string);
                if (list2 == null) {
                    list2 = new ArrayList<PhpDocTypeTagInfo>();
                    this.varTypeComments.put(string, list2);
                }
                list2.add(phpDocTypeTagInfo);
            }
        }
    }

    private VariableNameImpl findVariable(Scope scope, String string) {
        VariableNameImpl variableNameImpl = null;
        if (string != null) {
            Map<String, VariableNameImpl> map = this.vars.get(scope);
            while (scope != null && (map == null || (variableNameImpl = map.get(string)) == null)) {
                scope = scope.getInScope();
                map = this.vars.get(scope);
            }
        }
        return variableNameImpl;
    }

    private VariableNameImpl findVariable(Scope scope, VariableBase variableBase) {
        String string = null;
        if (variableBase instanceof Variable) {
            string = VariableNameImpl.toName((Variable)variableBase);
        }
        return string != null ? this.findVariable(scope, string) : null;
    }

    private VariableNameImpl createParameter(FunctionScopeImpl functionScopeImpl, Parameter parameter) {
        String string;
        VariableNameImpl variableNameImpl;
        FunctionScopeImpl functionScopeImpl2 = functionScopeImpl;
        Map<String, VariableNameImpl> map = this.vars.get(functionScopeImpl2);
        if (map == null) {
            map = new HashMap<String, VariableNameImpl>();
            this.vars.put(functionScopeImpl2, map);
        }
        if ((variableNameImpl = map.get(string = parameter.getName())) == null && ModelUtils.filter(functionScopeImpl2.getDeclaredVariables(), string).isEmpty()) {
            variableNameImpl = new VariableNameImpl((Scope)functionScopeImpl, string, functionScopeImpl.getFile(), parameter.getOffsetRange(), false);
            functionScopeImpl.addElement(variableNameImpl);
            map.put(string, variableNameImpl);
        }
        return variableNameImpl;
    }

    private VariableNameImpl createVariable(VariableNameFactory variableNameFactory, Variable variable) {
        String string;
        VariableNameImpl variableNameImpl;
        Map<String, VariableNameImpl> map = this.vars.get(variableNameFactory);
        if (map == null) {
            map = new HashMap<String, VariableNameImpl>();
            this.vars.put(variableNameFactory, map);
        }
        if ((variableNameImpl = map.get(string = VariableNameImpl.toName(variable))) == null && ModelUtils.filter(variableNameFactory.getDeclaredVariables(), string).isEmpty()) {
            variableNameImpl = variableNameFactory.createElement(variable);
            map.put(string, variableNameImpl);
        }
        return variableNameImpl;
    }

    @CheckForNull
    private ASTNode findConditionalStatement(List<ASTNode> list) {
        for (ASTNode aSTNode : list) {
            if (aSTNode instanceof IfStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof WhileStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof DoStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof ForEachStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof ForStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof CatchClause) {
                return aSTNode;
            }
            if (!(aSTNode instanceof SwitchStatement)) continue;
            return aSTNode;
        }
        return null;
    }

    private CodeMarker findStrictCodeMarker(FileScopeImpl fileScopeImpl, int n, CodeMarker codeMarker) {
        this.buildCodeMarks();
        List<? extends CodeMarker> list = fileScopeImpl.getMarkers();
        for (CodeMarker codeMarker2 : list) {
            assert (codeMarker2 != null);
            if (!codeMarker2.getOffsetRange().containsInclusive(n)) continue;
            codeMarker = codeMarker2;
        }
        return codeMarker;
    }

    @CheckForNull
    public Occurence getOccurence(int n) {
        return this.findStrictOccurence((FileScopeImpl)this.getFileScope(), n);
    }

    @CheckForNull
    public Occurence getOccurence(ModelElement modelElement) {
        return this.findStrictOccurence((FileScopeImpl)this.getFileScope(), modelElement);
    }

    public VariableScope getNearestVariableScope(int n) {
        return this.findNearestVarScope((FileScopeImpl)this.getFileScope(), n, null);
    }

    public VariableScope getVariableScope(int n) {
        Scope scope = null;
        ArrayList<? extends ModelElement> arrayList = new ArrayList<ModelElement>();
        arrayList.add(this.getFileScope());
        arrayList.addAll(ModelUtils.getElements(this.getFileScope(), true));
        for (ModelElement modelElement : arrayList) {
            Object object;
            VariableScope variableScope;
            if (modelElement instanceof VariableScope) {
                variableScope = (VariableScope)modelElement;
                object = variableScope.getBlockRange();
                if (object == null || !object.containsInclusive(n) || scope != null && !scope.getBlockRange().overlaps(variableScope.getBlockRange())) continue;
                scope = variableScope;
                continue;
            }
            if (!(modelElement instanceof ClassScope)) continue;
            variableScope = (ClassScope)modelElement;
            object = variableScope.getDeclaredMethods();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                MethodScope methodScope = (MethodScope)iterator.next();
                OffsetRange offsetRange = methodScope.getBlockRange();
                if (offsetRange == null || !offsetRange.containsInclusive(n) || scope != null && !scope.getBlockRange().overlaps(methodScope.getBlockRange())) continue;
                scope = methodScope;
            }
        }
        return scope;
    }

    static List<Occurence> getAllOccurences(FileScope fileScope, Occurence occurence) {
        Scope scope;
        ModelElementImpl modelElementImpl = (ModelElementImpl)occurence.getDeclaration();
        if (modelElementImpl instanceof MethodScope && (scope = (MethodScope)((Object)modelElementImpl)).isConstructor()) {
            modelElementImpl = (ModelElementImpl)((Object)scope.getInScope());
        }
        if (modelElementImpl instanceof VarAssignmentImpl) {
            scope = (VarAssignmentImpl)modelElementImpl;
            modelElementImpl = ((AssignmentImpl)scope).getContainer();
        }
        return ((FileScopeImpl)fileScope).getAllOccurences(modelElementImpl);
    }

    public static IndexScope getIndexScope(ParserResult parserResult) {
        return new IndexScopeImpl(parserResult);
    }

    public static IndexScope getIndexScope(PHPIndex pHPIndex) {
        return new IndexScopeImpl(pHPIndex);
    }

    private void buildCodeMarks() {
        if (this.markerBuilder != null) {
            this.markerBuilder.build(this.fileScope);
            this.markerBuilder = null;
        }
    }

    private void buildOccurences() {
        if (this.occurencesBuilder != null) {
            this.occurencesBuilder.build(this.fileScope);
            this.occurencesBuilder = null;
        }
    }

    private Occurence findStrictOccurence(FileScopeImpl fileScopeImpl, int n) {
        Occurence occurence = null;
        this.buildOccurences();
        List<Occurence> list = fileScopeImpl.getOccurences();
        for (Occurence occurence2 : list) {
            assert (occurence2 != null);
            if (!occurence2.getOccurenceRange().containsInclusive(n)) continue;
            occurence = occurence2;
        }
        return occurence;
    }

    private Occurence findStrictOccurence(FileScopeImpl fileScopeImpl, ModelElement modelElement) {
        Occurence occurence = null;
        this.buildOccurences();
        List<Occurence> list = fileScopeImpl.getOccurences();
        for (Occurence occurence2 : list) {
            assert (occurence2 != null);
            if (!occurence2.getDeclaration().equals(modelElement)) continue;
            occurence = occurence2;
        }
        return occurence;
    }

    private VariableScope findNearestVarScope(Scope scope, int n, VariableScope variableScope) {
        this.buildOccurences();
        List<? extends ModelElement> list = scope.getElements();
        OffsetRange offsetRange = list.iterator();
        while (offsetRange.hasNext()) {
            VariableScope variableScope2;
            OffsetRange offsetRange2;
            FileObject fileObject;
            ModelElement modelElement = (ModelElement)offsetRange.next();
            if (modelElement instanceof ClassScope || modelElement instanceof NamespaceScope) {
                variableScope = this.findNearestVarScope((Scope)modelElement, n, variableScope);
            }
            if (!(modelElement instanceof VariableScope) || modelElement.getNameRange().getStart() > n || variableScope != null && variableScope.getOffset() >= modelElement.getOffset() || !(modelElement instanceof VariableScope) || (fileObject = modelElement.getFileObject()) != scope.getFileObject() || (offsetRange2 = (variableScope2 = (VariableScope)modelElement).getBlockRange()) != null && !offsetRange2.containsInclusive(n)) continue;
            variableScope = variableScope2;
        }
        if (variableScope == null) {
            while (scope != null && !(scope instanceof VariableScope)) {
                scope = scope.getInScope();
            }
            if (scope != null && ((offsetRange = scope.getBlockRange()) == null || offsetRange.containsInclusive(n))) {
                variableScope = (VariableScope)scope;
            }
        }
        return variableScope;
    }

    private OffsetRange getBlockRange(Scope scope) {
        ASTNode aSTNode = this.findConditionalStatement(this.getPath());
        OffsetRange offsetRange = aSTNode != null ? new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset()) : scope.getBlockRange();
        return offsetRange;
    }

    private void handleVarComments() {
        Set<String> set = this.varTypeComments.keySet();
        for (String string : set) {
            List<PhpDocTypeTagInfo> list = this.varTypeComments.get(string);
            if (list == null) continue;
            for (PhpDocTypeTagInfo phpDocTypeTagInfo : list) {
                Scope scope;
                VariableScope variableScope = this.getVariableScope(phpDocTypeTagInfo.getRange().getStart());
                VariableNameImpl variableNameImpl = null;
                if (variableScope instanceof Scope) {
                    scope = variableScope;
                    variableNameImpl = (VariableNameImpl)ModelUtils.getFirst(ModelUtils.filter(variableScope.getDeclaredVariables(), string));
                    if (variableNameImpl == null) {
                        variableNameImpl = new VariableNameImpl(scope, string, scope.getFile(), phpDocTypeTagInfo.getRange(), scope instanceof NamespaceScopeImpl);
                    }
                }
                if (variableNameImpl != null) {
                    scope = new VarAssignmentImpl(variableNameImpl, (Scope)variableScope, this.getBlockRange(variableScope), phpDocTypeTagInfo.getRange(), phpDocTypeTagInfo.getTypeName());
                    variableNameImpl.addElement((ModelElementImpl)((Object)scope));
                }
                this.occurencesBuilder.prepare(phpDocTypeTagInfo.getTypeTag(), (Scope)variableScope);
            }
        }
    }

    private void prepareVarComments(Program program) {
        List<Comment> list = program.getComments();
        for (Comment comment : list) {
            Comment.Type type = comment.getCommentType();
            if (!type.equals((Object)Comment.Type.TYPE_VARTYPE)) continue;
            this.checkComments(comment);
        }
    }
}

