/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.model.Parameter;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterImpl
implements Parameter {
    private String name;
    private String defaultValue;
    private List<QualifiedName> types;
    private OffsetRange range;

    public ParameterImpl(String string, String string2, List<QualifiedName> list, OffsetRange offsetRange) {
        this.name = string;
        this.defaultValue = string2;
        this.types = list == null ? Collections.emptyList() : list;
        this.range = offsetRange;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isMandatory() {
        return this.defaultValue == null;
    }

    @Override
    public List<QualifiedName> getTypes() {
        return this.types;
    }

    @Override
    public OffsetRange getOffsetRange() {
        return this.range;
    }

    @Override
    public String getIndexSignature() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName()).append(":");
        List<QualifiedName> list = this.getTypes();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append('|');
            }
            QualifiedName qualifiedName = list.get(i);
            stringBuilder.append(qualifiedName.toString());
        }
        stringBuilder.append(":");
        String string = this.getDefaultValue();
        if (string != null) {
            stringBuilder.append(ParameterImpl.encode(string));
        }
        return stringBuilder.toString();
    }

    public static List<Parameter> toParameters(String string) {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        if (string != null && string.length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\,")) {
                String string3;
                String[] stringArray2 = string2.split("\\:");
                if (stringArray2.length <= 0) continue;
                String string4 = stringArray2[0];
                ArrayList<QualifiedName> arrayList2 = new ArrayList<QualifiedName>();
                if (stringArray2.length > 1) {
                    String[] stringArray3;
                    string3 = stringArray2[1];
                    for (String string5 : stringArray3 = string3.length() > 0 ? string3.split("\\|") : new String[]{}) {
                        arrayList2.add(QualifiedName.create(string5));
                    }
                }
                string3 = stringArray2.length > 2 ? stringArray2[2] : "";
                arrayList.add(new ParameterImpl(string4, string3.length() != 0 ? ParameterImpl.decode(string3) : null, arrayList2, OffsetRange.NONE));
            }
        }
        return arrayList;
    }

    private static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer(6 * string.length());
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ':' || string.charAt(i) == '|' || string.charAt(i) == ';' || ParameterImpl.isEncodedChar(i, string)) {
                stringBuffer.append(ParameterImpl.encodeChar(string.charAt(i)));
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static String encodeChar(char c) {
        String string = Integer.toString(c, 16);
        return "\\u" + "0000".substring(0, "0000".length() - string.length()).concat(string);
    }

    private static String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        try {
            for (int i = 0; i < string.length(); ++i) {
                if (ParameterImpl.isEncodedChar(i, string)) {
                    String string2 = string.substring(i + 2, i + 6);
                    stringBuffer.append((char)Integer.parseInt(string2, 16));
                    i += 5;
                    continue;
                }
                stringBuffer.append(string.charAt(i));
            }
        }
        catch (NumberFormatException numberFormatException) {
            Exceptions.printStackTrace((Throwable)numberFormatException);
            return string;
        }
        return stringBuffer.toString();
    }

    private static boolean isEncodedChar(int n, String string) {
        boolean bl;
        boolean bl2 = bl = n + 5 < string.length();
        if (bl) {
            char c;
            bl &= string.charAt(n) == '\\' && string.charAt(n + 1) == 'u';
            for (int i = n + 2; bl && i < n + 6; bl &= Character.digit(c = string.charAt(i), 16) != -1, ++i) {
            }
        }
        return bl;
    }
}

