/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.PhpModifiers;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.openide.filesystems.FileObject;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ScopeImpl
extends ModelElementImpl
implements Scope {
    private OffsetRange blockRange = null;
    private final List<ModelElementImpl> elements = Collections.synchronizedList(new LinkedList());

    ScopeImpl(Scope scope, ASTNodeInfo aSTNodeInfo, PhpModifiers phpModifiers, Block block) {
        super(scope, aSTNodeInfo, phpModifiers);
        this.setBlockRange(block);
    }

    ScopeImpl(Scope scope, IndexedElement indexedElement, PhpKind phpKind) {
        super(scope, indexedElement, phpKind);
    }

    ScopeImpl(Scope scope, String string, Union2<String, FileObject> union2, OffsetRange offsetRange, PhpKind phpKind) {
        super(scope, string, union2, offsetRange, phpKind);
        assert (ScopeImpl.isScopeKind(phpKind)) : phpKind.toString();
    }

    ScopeImpl(Scope scope, String string, Union2<String, FileObject> union2, OffsetRange offsetRange, PhpKind phpKind, PhpModifiers phpModifiers) {
        super(scope, string, union2, offsetRange, phpKind, phpModifiers);
        assert (ScopeImpl.isScopeKind(phpKind)) : phpKind.toString();
    }

    private static boolean isScopeKind(PhpKind phpKind) {
        switch (phpKind) {
            case PROGRAM: 
            case NAMESPACE_DECLARATION: 
            case INDEX: 
            case CLASS: 
            case FUNCTION: 
            case IFACE: 
            case METHOD: 
            case VARIABLE: 
            case FIELD: {
                return true;
            }
        }
        return false;
    }

    public List<? extends ModelElementImpl> getElements() {
        return new ArrayList<ModelElementImpl>(this.elements);
    }

    void addElement(ModelElementImpl modelElementImpl) {
        this.elements.add(modelElementImpl);
    }

    static <T extends ModelElement> Collection<? extends T> filter(Collection<? extends ModelElement> collection, ElementFilter<T> elementFilter) {
        HashSet<ModelElement> hashSet = new HashSet<ModelElement>();
        for (ModelElement modelElement : collection) {
            boolean bl = elementFilter.isAccepted(modelElement);
            if (!bl) continue;
            hashSet.add(modelElement);
        }
        return hashSet;
    }

    void setBlockRange(Block block) {
        if (block != null) {
            this.blockRange = new OffsetRange(block.getStartOffset(), block.getEndOffset());
        }
    }

    void setBlockRange(ASTNode aSTNode) {
        this.blockRange = new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset());
    }

    @Override
    public OffsetRange getBlockRange() {
        return this.blockRange;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ElementFilter<T extends ModelElement> {
        public boolean isAccepted(ModelElement var1);
    }
}

