/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.NamespaceIndexFilter;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.QualifiedNameKind;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.CachingSupport;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariousUtils {
    public static final String CONSTRUCTOR_TYPE_PREFIX = "constuct:";
    public static final String FUNCTION_TYPE_PREFIX = "fn:";
    public static final String METHOD_TYPE_PREFIX = "mtd:";
    public static final String STATIC_METHOD_TYPE_PREFIX = "static.mtd:";
    public static final String FIELD_TYPE_PREFIX = "fld:";
    public static final String STATIC_FIELD__TYPE_PREFIX = "static.fld:";
    public static final String VAR_TYPE_PREFIX = "var:";
    public static final String ARRAY_TYPE_PREFIX = "array:";
    private static Set<String> recursionDetection = new HashSet<String>();
    private static final Collection<PHPTokenId> CTX_DELIMITERS = Arrays.asList(PHPTokenId.PHP_OPENTAG, PHPTokenId.PHP_SEMICOLON, PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_RETURN, PHPTokenId.PHP_OPERATOR, PHPTokenId.PHP_ECHO, PHPTokenId.PHP_EVAL, PHPTokenId.PHP_NEW, PHPTokenId.PHP_NOT, PHPTokenId.PHP_CASE, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_PRINT, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_WHILE, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING, PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE);

    public static String extractTypeFroVariableBase(VariableBase variableBase) {
        return VariousUtils.extractTypeFroVariableBase(variableBase, Collections.<String, AssignmentImpl>emptyMap());
    }

    static String extractTypeFroVariableBase(VariableBase variableBase, Map<String, AssignmentImpl> map) {
        Stack<VariableBase> stack = new Stack<VariableBase>();
        String string = null;
        VariousUtils.createVariableBaseChain(variableBase, stack);
        while (!stack.isEmpty() && stack.peek() != null) {
            variableBase = stack.pop();
            String string2 = VariousUtils.extractVariableTypeFromVariableBase(variableBase, map);
            if (string2 == null) {
                string = string2;
                break;
            }
            if (string == null) {
                string = string2;
                continue;
            }
            string = string + string2;
        }
        return string;
    }

    private VariousUtils() {
    }

    public static String getReturnTypeFromPHPDoc(Program program, FunctionDeclaration functionDeclaration) {
        return VariousUtils.getTypeFromPHPDoc(program, functionDeclaration, PHPDocTag.Type.RETURN);
    }

    public static String getFieldTypeFromPHPDoc(Program program, SingleFieldDeclaration singleFieldDeclaration) {
        return VariousUtils.getTypeFromPHPDoc(program, singleFieldDeclaration, PHPDocTag.Type.VAR);
    }

    public static Map<String, List<QualifiedName>> getParamTypesFromPHPDoc(Program program, ASTNode aSTNode) {
        HashMap<String, List<QualifiedName>> hashMap = new HashMap<String, List<QualifiedName>>();
        Comment comment = Utils.getCommentForNode(program, aSTNode);
        if (comment instanceof PHPDocBlock) {
            PHPDocBlock pHPDocBlock = (PHPDocBlock)comment;
            for (PHPDocTag pHPDocTag : pHPDocBlock.getTags()) {
                String[] stringArray;
                if (pHPDocTag.getKind() != PHPDocTag.Type.PARAM || (stringArray = pHPDocTag.getValue().split("\\s+", 3)).length <= 1) continue;
                String[] stringArray2 = stringArray[0].split("\\|", 2);
                ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>();
                for (String string : stringArray2) {
                    arrayList.add(QualifiedName.create(string));
                }
                String object = stringArray[1].split("\\s+", 2)[0];
                hashMap.put(object, arrayList);
            }
        }
        return hashMap;
    }

    public static String getTypeFromPHPDoc(Program program, ASTNode aSTNode, PHPDocTag.Type type) {
        Comment comment = Utils.getCommentForNode(program, aSTNode);
        if (comment instanceof PHPDocBlock) {
            PHPDocBlock pHPDocBlock = (PHPDocBlock)comment;
            for (PHPDocTag pHPDocTag : pHPDocBlock.getTags()) {
                if (pHPDocTag.getKind() != type) continue;
                String[] stringArray = pHPDocTag.getValue().split("\\s+", 2);
                if (stringArray.length <= 0) break;
                String string = stringArray[0].split("\\;", 2)[0];
                return string;
            }
        }
        return null;
    }

    @CheckForNull
    static String extractVariableTypeFromAssignment(Assignment assignment, Map<String, AssignmentImpl> map) {
        Expression expression = assignment.getRightHandSide();
        return VariousUtils.extractVariableTypeFromExpression(expression, map);
    }

    static String extractVariableTypeFromExpression(Expression expression, Map<String, AssignmentImpl> map) {
        InfixExpression.OperatorType operatorType;
        Expression expression2;
        if (expression instanceof Assignment) {
            return VariousUtils.extractVariableTypeFromAssignment((Assignment)expression, map);
        }
        if (expression instanceof Reference) {
            expression2 = (Reference)expression;
            expression = ((Reference)expression2).getExpression();
        }
        if (expression instanceof ClassInstanceCreation) {
            expression2 = (ClassInstanceCreation)expression;
            ClassName className = ((ClassInstanceCreation)expression2).getClassName();
            Expression expression3 = className.getName();
            if (expression3 instanceof NamespaceName) {
                QualifiedName qualifiedName = QualifiedName.create(expression3);
                return qualifiedName.toString();
            }
            return CodeUtils.extractClassName(className);
        }
        if (expression instanceof ArrayCreation) {
            return "array";
        }
        if (expression instanceof VariableBase) {
            return VariousUtils.extractTypeFroVariableBase((VariableBase)expression, map);
        }
        if (expression instanceof Scalar) {
            String string;
            expression2 = (Scalar)expression;
            Scalar.Type type = ((Scalar)expression2).getScalarType();
            if (type.equals((Object)Scalar.Type.STRING) && ((string = ((Scalar)expression2).getStringValue().toLowerCase()).equals("false") || string.equals("true"))) {
                return "boolean";
            }
            return type.toString().toLowerCase();
        }
        if (expression instanceof InfixExpression && (operatorType = ((InfixExpression)(expression2 = (InfixExpression)expression)).getOperator()).equals((Object)InfixExpression.OperatorType.CONCAT)) {
            return Scalar.Type.STRING.toString().toLowerCase();
        }
        return null;
    }

    public static String replaceVarNames(String string, Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("[@:]");
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string2 = stringArray[i];
            if (string2.trim().length() == 0) continue;
            if (VAR_TYPE_PREFIX.startsWith(string2)) {
                String string3;
                if (i + 1 < stringArray.length && (string3 = map.get(object = stringArray[++i])) != null) {
                    stringBuilder.append(string3);
                    continue;
                }
                return null;
            }
            object = Kind.values();
            boolean bl = false;
            for (Kind kind : object) {
                if (!kind.toString().startsWith(string2)) continue;
                bl = true;
                break;
            }
            if (bl) {
                stringBuilder.append("@");
                stringBuilder.append(string2);
                stringBuilder.append(":");
                bl = true;
                continue;
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static Collection<? extends VariableName> getAllVariables(VariableScope variableScope, String string) {
        ArrayList<VariableName> arrayList = new ArrayList<VariableName>();
        String[] stringArray = string.split("[@:]");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            VariableName variableName;
            String string3 = stringArray[i];
            if (string3.trim().length() == 0 || !VAR_TYPE_PREFIX.startsWith(string3) || i + 1 >= stringArray.length) continue;
            VariableName variableName2 = variableName = (string2 = stringArray[++i]) != null ? ModelUtils.getFirst(variableScope.getDeclaredVariables(), string2) : null;
            if (variableName != null) {
                arrayList.add(variableName);
                continue;
            }
            return Collections.emptyList();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<? extends TypeScope> getType(VariableScope variableScope, String string, int n, boolean bl) throws IllegalStateException {
        List<? extends ClassScope> list = Collections.emptyList();
        List<Object> list2 = Collections.emptyList();
        Stack<Object> stack = new Stack<Object>();
        if (string != null && string.contains("@")) {
            String string2 = null;
            String[] stringArray = string.split("[@:]");
            int n2 = bl ? stringArray.length - 1 : stringArray.length;
            for (int i = 0; i < n2; ++i) {
                Collection<? extends TypeScope> collection;
                Object object;
                Object object2;
                Object object3;
                Object object422;
                Object object522;
                Object object6;
                Object object7;
                String string3;
                list2 = list;
                String string4 = stringArray[i].trim();
                if (string4.length() == 0) continue;
                String string5 = string3 = string4.endsWith(":") ? string4 : String.format("%s:", string4);
                if (METHOD_TYPE_PREFIX.equalsIgnoreCase(string3)) {
                    string2 = METHOD_TYPE_PREFIX;
                    continue;
                }
                if (FUNCTION_TYPE_PREFIX.equalsIgnoreCase(string3)) {
                    string2 = FUNCTION_TYPE_PREFIX;
                    continue;
                }
                if (STATIC_METHOD_TYPE_PREFIX.equalsIgnoreCase(string3)) {
                    string2 = STATIC_METHOD_TYPE_PREFIX;
                    continue;
                }
                if (STATIC_FIELD__TYPE_PREFIX.equalsIgnoreCase(string3)) {
                    string2 = FIELD_TYPE_PREFIX;
                    continue;
                }
                if (VAR_TYPE_PREFIX.equalsIgnoreCase(string3)) {
                    string2 = VAR_TYPE_PREFIX;
                    continue;
                }
                if (ARRAY_TYPE_PREFIX.equalsIgnoreCase(string3)) {
                    string2 = ARRAY_TYPE_PREFIX;
                    continue;
                }
                if (FIELD_TYPE_PREFIX.equalsIgnoreCase(string3)) {
                    string2 = FIELD_TYPE_PREFIX;
                    continue;
                }
                if (CONSTRUCTOR_TYPE_PREFIX.equalsIgnoreCase(string3)) {
                    string2 = CONSTRUCTOR_TYPE_PREFIX;
                    continue;
                }
                if (string2 == null) {
                    assert (i == 0) : string4;
                    object7 = new NamespaceIndexFilter(string4);
                    object6 = ((NamespaceIndexFilter)object7).getKind();
                    object522 = object6.isUnqualified() ? string4 : ((NamespaceIndexFilter)object7).getName();
                    list = CachingSupport.getClasses((String)object522, variableScope);
                    if (list.isEmpty()) {
                        list = CachingSupport.getInterfaces((String)object522, variableScope);
                    }
                    if (object6.isUnqualified()) continue;
                    list = ((NamespaceIndexFilter)object7).filterModelElements(list, true);
                    continue;
                }
                if (string2.startsWith(CONSTRUCTOR_TYPE_PREFIX)) {
                    return Collections.emptyList();
                }
                if (string2.startsWith(METHOD_TYPE_PREFIX)) {
                    object7 = new ArrayList();
                    for (Object object522 : list2) {
                        Collection<? extends MethodScope> collection2 = CachingSupport.getInheritedMethods((TypeScope)object522, string4, variableScope, -1);
                        object422 = collection2.iterator();
                        while (object422.hasNext()) {
                            MethodScope methodScope = object422.next();
                            object7.addAll(methodScope.getReturnTypes(true));
                        }
                    }
                    list = object7;
                    string2 = null;
                    continue;
                }
                if (string2.startsWith(FUNCTION_TYPE_PREFIX)) {
                    object7 = new ArrayList();
                    object6 = ModelUtils.getFirst(CachingSupport.getFunctions(string4, variableScope));
                    if (object6 != null) {
                        object7.addAll(object6.getReturnTypes(true));
                    }
                    list = object7;
                    string2 = null;
                    continue;
                }
                if (string2.startsWith(STATIC_METHOD_TYPE_PREFIX)) {
                    object7 = new ArrayList();
                    object6 = string4.split("\\.");
                    assert (((Object)object6).length == 2);
                    object522 = object6[0];
                    if (object522 != null) {
                        QualifiedNameKind qualifiedNameKind;
                        boolean bl2 = false;
                        if (variableScope instanceof MethodScope) {
                            if ("self".equals(object522)) {
                                object422 = variableScope.getInScope();
                                object522 = object422.getName();
                            } else if ("parent".equals(object522)) {
                                object422 = variableScope.getInScope();
                                object522 = object422.getName();
                                bl2 = true;
                            }
                        }
                        object3 = (qualifiedNameKind = ((NamespaceIndexFilter)(object422 = new NamespaceIndexFilter(string4))).getKind()).isUnqualified() ? string4 : ((NamespaceIndexFilter)object422).getName();
                        list = CachingSupport.getClasses((String)object3, variableScope);
                        object2 = CachingSupport.getClasses((String)object522, variableScope);
                        if (!qualifiedNameKind.isUnqualified()) {
                            object2 = ((NamespaceIndexFilter)object422).filterModelElements((Collection<? extends ModelElement>)object2, true);
                        }
                        object = object2.iterator();
                        while (object.hasNext()) {
                            collection = (ClassScope)object.next();
                            if (bl2 && (collection = ModelUtils.getFirst(collection.getSuperClasses())) == null) continue;
                            Collection<? extends MethodScope> collection3 = CachingSupport.getInheritedMethods((TypeScope)((Object)collection), (String)object6[1], variableScope, -1);
                            for (MethodScope methodScope : collection3) {
                                object7.addAll(methodScope.getReturnTypes(true));
                            }
                        }
                    }
                    list = object7;
                    string2 = null;
                    continue;
                }
                if (string2.startsWith(VAR_TYPE_PREFIX) || string2.startsWith(ARRAY_TYPE_PREFIX)) {
                    object7 = new ArrayList();
                    object6 = string4;
                    object522 = ModelUtils.getFirst(variableScope.getDeclaredVariables(), new String[]{object6});
                    if (object522 != null) {
                        if (i + 2 < n2 && FIELD_TYPE_PREFIX.startsWith(stringArray[i + 1])) {
                            stack.push(object522);
                        }
                        String string6 = object522.getName() + String.valueOf(n);
                        boolean bl3 = recursionDetection.add(string6);
                        try {
                            if (bl3) {
                                boolean bl4 = string2.startsWith(ARRAY_TYPE_PREFIX);
                                if (bl4) {
                                    object7.addAll(object522.getArrayAccessTypes(n));
                                } else {
                                    object7.addAll(object522.getTypes(n));
                                }
                            }
                        }
                        finally {
                            recursionDetection.remove(string6);
                        }
                    }
                    if (object7.isEmpty() && variableScope instanceof MethodScope) {
                        MethodScope methodScope = (MethodScope)variableScope;
                        if (string4.equals("this") || string4.equals("$this")) {
                            String string7 = ((ClassScope)methodScope.getInScope()).getName();
                            object7.addAll(CachingSupport.getClasses(string7, variableScope));
                        }
                    }
                    list = object7;
                    string2 = null;
                    continue;
                }
                if (string2.startsWith(FIELD_TYPE_PREFIX)) {
                    object7 = stack.isEmpty() ? null : (VariableName)stack.pop();
                    object6 = new ArrayList();
                    object522 = string4;
                    if (!((String)object522).startsWith("$")) {
                        object522 = "$" + (String)object522;
                    }
                    for (Object object422 : list2) {
                        if (!(object422 instanceof ClassScope)) continue;
                        ClassScope classScope = (ClassScope)object422;
                        object3 = CachingSupport.getInheritedFields(classScope, (String)object522, variableScope, -1);
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            object = (FieldElement)object2.next();
                            if (object7 != null) {
                                collection = object7.getFieldTypes((FieldElement)object, n);
                                if (collection.isEmpty() && object instanceof FieldElementImpl) {
                                    object6.addAll(((FieldElementImpl)object).getDefaultTypes());
                                    continue;
                                }
                                object6.addAll(collection);
                                continue;
                            }
                            object6.addAll(object.getTypes(n));
                        }
                    }
                    list = object6;
                    string2 = null;
                    continue;
                }
                throw new UnsupportedOperationException(string2);
            }
        } else if (string != null) {
            NamespaceIndexFilter namespaceIndexFilter = new NamespaceIndexFilter(string);
            QualifiedName qualifiedName = QualifiedName.create(string);
            QualifiedNameKind qualifiedNameKind = qualifiedName.getKind();
            String string8 = qualifiedNameKind.isUnqualified() ? string : namespaceIndexFilter.getName();
            Collection<ModelElement> collection = new ArrayList<TypeScope>(CachingSupport.getTypes(string8, variableScope));
            if (collection.isEmpty() && variableScope instanceof MethodScope) {
                string8 = VariousUtils.translateSpecialClassName(variableScope, string8);
                collection = new ArrayList<TypeScope>(CachingSupport.getTypes(string8, variableScope));
            }
            if (!qualifiedNameKind.isUnqualified()) {
                collection = namespaceIndexFilter.filterModelElements(collection, true);
            }
            return collection;
        }
        return list;
    }

    public static Stack<? extends ModelElement> getElemenst(FileScope fileScope, VariableScope variableScope, String string, int n) throws IllegalStateException {
        Stack stack = new Stack();
        Stack<Object> stack2 = new Stack<Object>();
        Stack<String> stack3 = new Stack<String>();
        TypeScope typeScope = null;
        if (string != null && string.contains("@")) {
            String string2 = null;
            String[] stringArray = string.split("[@:]");
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                ModelElement modelElement;
                Object object;
                Object object2;
                String string3 = stringArray[i];
                if (string3.trim().length() == 0) continue;
                if (METHOD_TYPE_PREFIX.startsWith(string3)) {
                    string2 = METHOD_TYPE_PREFIX;
                    continue;
                }
                if (FUNCTION_TYPE_PREFIX.startsWith(string3)) {
                    assert (string2 == null);
                    string2 = FUNCTION_TYPE_PREFIX;
                    continue;
                }
                if (STATIC_METHOD_TYPE_PREFIX.startsWith(string3)) {
                    assert (string2 == null);
                    string2 = STATIC_METHOD_TYPE_PREFIX;
                    continue;
                }
                if (VAR_TYPE_PREFIX.startsWith(string3)) {
                    assert (string2 == null);
                    string2 = VAR_TYPE_PREFIX;
                    continue;
                }
                if (FIELD_TYPE_PREFIX.startsWith(string3)) {
                    assert (string2 == null);
                    string2 = FIELD_TYPE_PREFIX;
                    continue;
                }
                if (CONSTRUCTOR_TYPE_PREFIX.startsWith(string3)) {
                    assert (string2 == null);
                    string2 = CONSTRUCTOR_TYPE_PREFIX;
                    continue;
                }
                if (string2 == null) {
                    assert (i == 0);
                    stack3.push(string3);
                    continue;
                }
                if (string2.startsWith(METHOD_TYPE_PREFIX)) {
                    Object object3 = object2 = stack3.isEmpty() ? null : (String)stack3.pop();
                    if (object2 == null) {
                        return stack;
                    }
                    object = ModelUtils.getFirst(CachingSupport.getClasses((String)object2, fileScope));
                    if (object == null) {
                        return stack;
                    }
                    modelElement = ModelUtils.getFirst(CachingSupport.getInheritedMethods((TypeScope)object, string3, fileScope, -1));
                    if (modelElement == null) {
                        return stack;
                    }
                    stack2.push(modelElement);
                    typeScope = ModelUtils.getFirst(modelElement.getReturnTypes(true));
                    if (typeScope == null) {
                        string = null;
                        break;
                    }
                    stack3.push(typeScope.getName());
                    string2 = null;
                    continue;
                }
                if (string2.startsWith(FUNCTION_TYPE_PREFIX)) {
                    object2 = ModelUtils.getFirst(CachingSupport.getFunctions(string3, fileScope));
                    if (object2 == null) {
                        string = null;
                        break;
                    }
                    stack2.push(object2);
                    typeScope = ModelUtils.getFirst(object2.getReturnTypes(true));
                    if (typeScope == null) {
                        string = null;
                        break;
                    }
                    stack3.push(typeScope.getName());
                    string2 = null;
                    continue;
                }
                if (string2.startsWith(CONSTRUCTOR_TYPE_PREFIX)) {
                    object2 = ModelUtils.getFirst(CachingSupport.getClasses(string3, fileScope));
                    if (object2 == null) {
                        string = null;
                        break;
                    }
                    object = ModelUtils.getFirst(CachingSupport.getMethods((ClassScope)object2, "__construct", fileScope, -1));
                    if (object == null) {
                        return stack;
                    }
                    stack2.push(object);
                    stack3.push(object2.getName());
                    string2 = null;
                    continue;
                }
                if (string2.startsWith(STATIC_METHOD_TYPE_PREFIX)) {
                    object2 = string3.split("\\.");
                    assert (((String[])object2).length == 2);
                    object = object2[0];
                    if (object == null) {
                        return stack;
                    }
                    modelElement = ModelUtils.getFirst(CachingSupport.getClasses((String)object, fileScope));
                    if (modelElement == null) {
                        return stack;
                    }
                    MethodScope methodScope = ModelUtils.getFirst(CachingSupport.getMethods((ClassScope)modelElement, (String)object2[1], fileScope, -1));
                    if (methodScope == null) {
                        return stack;
                    }
                    stack2.push(methodScope);
                    typeScope = ModelUtils.getFirst(methodScope.getReturnTypes(true));
                    if (typeScope == null) {
                        string = null;
                        break;
                    }
                    stack3.push(typeScope.getName());
                    string2 = null;
                    continue;
                }
                if (string2.startsWith(VAR_TYPE_PREFIX)) {
                    typeScope = null;
                    if (variableScope instanceof MethodScope) {
                        object2 = (MethodScope)variableScope;
                        if (string3.equals("this") || string3.equals("$this")) {
                            typeScope = (ClassScope)object2.getInScope();
                        }
                        if (typeScope != null) {
                            stack3.push(typeScope.getName());
                            string2 = null;
                        }
                    } else if (variableScope instanceof NamespaceScope && (object = ModelUtils.getFirst((object2 = (NamespaceScope)variableScope).getDeclaredVariables(), string3)) != null && (typeScope = ModelUtils.getFirst(object.getTypes(n))) != null) {
                        stack3.push(typeScope.getName());
                        string2 = null;
                    }
                    if (typeScope != null || (object2 = ModelUtils.filter(variableScope.getDeclaredVariables(), string3)).isEmpty()) continue;
                    object = (VariableName)ModelUtils.getFirst(object2);
                    TypeScope typeScope2 = typeScope = object != null ? ModelUtils.getFirst(object.getTypes(n)) : null;
                    if (object != null) {
                        stack2.push(object);
                    }
                    if (typeScope == null) {
                        string = null;
                        break;
                    }
                    stack3.push(typeScope.getName());
                    string2 = null;
                    continue;
                }
                if (string2.startsWith(FIELD_TYPE_PREFIX)) {
                    Object object4 = object2 = stack3.isEmpty() ? null : (String)stack3.pop();
                    if (object2 == null) {
                        return stack;
                    }
                    object = ModelUtils.getFirst(CachingSupport.getClasses((String)object2, fileScope));
                    if (object == null) {
                        return stack;
                    }
                    modelElement = ModelUtils.getFirst(CachingSupport.getInheritedFields((ClassScope)object, !string3.startsWith("$") ? String.format("%s%s", "$", string3) : string3, fileScope, -1));
                    if (modelElement == null) {
                        return stack;
                    }
                    stack2.push(modelElement);
                    typeScope = ModelUtils.getFirst(modelElement.getTypes(n));
                    if (typeScope == null) {
                        string = null;
                        break;
                    }
                    stack3.push(typeScope.getName());
                    string2 = null;
                    continue;
                }
                throw new UnsupportedOperationException(string2);
            }
            if (stack3.size() == 1) {
                string = (String)stack3.pop();
            }
        }
        return stack2;
    }

    private static void createVariableBaseChain(VariableBase variableBase, Stack<VariableBase> stack) {
        stack.push(variableBase);
        if (variableBase instanceof MethodInvocation) {
            VariousUtils.createVariableBaseChain(((MethodInvocation)variableBase).getDispatcher(), stack);
        } else if (variableBase instanceof FieldAccess) {
            VariousUtils.createVariableBaseChain(((FieldAccess)variableBase).getDispatcher(), stack);
        }
    }

    private static String extractVariableTypeFromVariableBase(VariableBase variableBase, Map<String, AssignmentImpl> map) {
        if (variableBase instanceof Variable) {
            String string;
            String string2 = CodeUtils.extractVariableName((Variable)variableBase);
            AssignmentImpl assignmentImpl = map.get(string2);
            if (assignmentImpl != null && (string = assignmentImpl.typeNameFromUnion()) != null) {
                return string;
            }
            return "@var:" + string2;
        }
        if (variableBase instanceof FunctionInvocation) {
            FunctionInvocation functionInvocation = (FunctionInvocation)variableBase;
            String string = CodeUtils.extractFunctionName(functionInvocation);
            return "@fn:" + string;
        }
        if (variableBase instanceof StaticMethodInvocation) {
            StaticMethodInvocation staticMethodInvocation = (StaticMethodInvocation)variableBase;
            String string = CodeUtils.extractUnqualifiedClassName(staticMethodInvocation);
            String string3 = CodeUtils.extractFunctionName(staticMethodInvocation.getMethod());
            if (string != null && string3 != null) {
                return "@static.mtd:" + string + '.' + string3;
            }
        } else if (variableBase instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)variableBase;
            String string = CodeUtils.extractFunctionName(methodInvocation.getMethod());
            if (string != null) {
                return "@mtd:" + string;
            }
        } else if (variableBase instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)variableBase;
            String string = CodeUtils.extractVariableName(fieldAccess.getField());
            if (string != null) {
                return "@fld:" + string;
            }
        } else if (variableBase instanceof StaticFieldAccess) {
            StaticFieldAccess staticFieldAccess = (StaticFieldAccess)variableBase;
            String string = CodeUtils.extractUnqualifiedName(staticFieldAccess.getClassName());
            String string4 = CodeUtils.extractVariableName(staticFieldAccess.getField());
            if (string != null && string4 != null) {
                return string + "@" + STATIC_FIELD__TYPE_PREFIX + string4;
            }
        }
        return null;
    }

    public static String resolveFileName(Include include) {
        Scalar scalar;
        Expression expression = include.getExpression();
        if (expression instanceof ParenthesisExpression) {
            expression = ((ParenthesisExpression)expression).getExpression();
        }
        if (expression instanceof Scalar && Scalar.Type.STRING == (scalar = (Scalar)expression).getScalarType()) {
            String string = scalar.getStringValue();
            string = string.length() >= 2 ? string.substring(1, string.length() - 1) : string;
            return string;
        }
        return null;
    }

    public static FileObject resolveInclude(FileObject fileObject, Include include) {
        Parameters.notNull((CharSequence)"sourceFile", (Object)fileObject);
        if (fileObject.isFolder()) {
            throw new IllegalArgumentException(FileUtil.getFileDisplayName((FileObject)fileObject));
        }
        return VariousUtils.resolveInclude(fileObject, VariousUtils.resolveFileName(include));
    }

    public static FileObject resolveInclude(FileObject fileObject, String string) {
        FileObject fileObject2 = null;
        if (string != null) {
            File file = new File(string);
            if (file.exists()) {
                fileObject2 = FileUtil.toFileObject((File)file);
            } else {
                FileObject fileObject3 = fileObject.getParent();
                if (fileObject3 != null) {
                    fileObject2 = PhpSourcePath.resolveFile((FileObject)fileObject3, (String)string);
                }
            }
        }
        return fileObject2;
    }

    public static String getSemiType(TokenSequence<PHPTokenId> tokenSequence, State state, VariableScope variableScope) throws IllegalStateException {
        String string;
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        int n4 = State.PARAMS.equals((Object)state) ? 1 : 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (!state.equals((Object)State.INVALID) && !state.equals((Object)State.STOP) && tokenSequence.movePrevious() && VariousUtils.skipWhitespaces(tokenSequence)) {
            string = tokenSequence.token();
            if (!CTX_DELIMITERS.contains(string.id())) {
                switch (state) {
                    case METHOD: 
                    case START: {
                        State state2 = state = state.equals((Object)State.METHOD) ? State.STOP : State.INVALID;
                        if (VariousUtils.isReference((Token<PHPTokenId>)string)) {
                            stringBuilder.insert(0, "@mtd:");
                            state = State.REFERENCE;
                            break;
                        }
                        if (VariousUtils.isStaticReference((Token<PHPTokenId>)string)) {
                            stringBuilder.insert(0, "@mtd:");
                            state = State.STATIC_REFERENCE;
                            break;
                        }
                        if (!state.equals((Object)State.STOP)) break;
                        stringBuilder.insert(0, "@fn:");
                        break;
                    }
                    case IDX: {
                        if (VariousUtils.isLeftArryBracket((Token<PHPTokenId>)string)) {
                            state = State.ARRAYREFERENCE;
                            break;
                        }
                        if (!CTX_DELIMITERS.contains(string.id())) break;
                        state = State.INVALID;
                        break;
                    }
                    case ARRAYREFERENCE: 
                    case REFERENCE: {
                        boolean bl = state.equals((Object)State.ARRAYREFERENCE);
                        state = State.INVALID;
                        if (VariousUtils.isRightBracket((Token<PHPTokenId>)string)) {
                            ++n4;
                            state = State.PARAMS;
                            break;
                        }
                        if (VariousUtils.isRightArryBracket((Token<PHPTokenId>)string)) {
                            state = State.IDX;
                            break;
                        }
                        if (VariousUtils.isString((Token<PHPTokenId>)string)) {
                            stringBuilder.insert(0, ((Object)string.text()).toString());
                            state = bl ? State.ARRAY_FIELD : State.FIELD;
                            break;
                        }
                        if (!VariousUtils.isVariable((Token<PHPTokenId>)string)) break;
                        stringBuilder.insert(0, ((Object)string.text()).toString());
                        state = bl ? State.ARRAY_VARIABLE : State.VARBASE;
                        break;
                    }
                    case STATIC_REFERENCE: {
                        state = State.INVALID;
                        if (VariousUtils.isString((Token<PHPTokenId>)string)) {
                            stringBuilder.insert(0, "@fld:");
                            stringBuilder.insert(0, ((Object)string.text()).toString());
                            state = State.CLASSNAME;
                            break;
                        }
                        if (!VariousUtils.isSelf((Token<PHPTokenId>)string) && !VariousUtils.isParent((Token<PHPTokenId>)string)) break;
                        stringBuilder.insert(0, VariousUtils.translateSpecialClassName(variableScope, ((Object)string.text()).toString()));
                        state = State.CLASSNAME;
                        break;
                    }
                    case PARAMS: {
                        if (VariousUtils.isWhiteSpace((Token<PHPTokenId>)string)) {
                            state = State.PARAMS;
                        } else if (VariousUtils.isComma((Token<PHPTokenId>)string)) {
                            if (stringBuilder.length() == 0) {
                                ++n;
                            }
                        } else if (CTX_DELIMITERS.contains(string.id())) {
                            state = State.INVALID;
                        } else if (VariousUtils.isLeftBracket((Token<PHPTokenId>)string)) {
                            ++n3;
                        } else if (VariousUtils.isRightBracket((Token<PHPTokenId>)string)) {
                            ++n4;
                        }
                        if (n3 != n4) break;
                        state = State.FUNCTION;
                        break;
                    }
                    case FUNCTION: {
                        state = State.INVALID;
                        if (!VariousUtils.isString((Token<PHPTokenId>)string)) break;
                        stringBuilder.insert(0, ((Object)string.text()).toString());
                        if (n2 == -1) {
                            n2 = tokenSequence.offset();
                        }
                        state = State.METHOD;
                        break;
                    }
                    case ARRAY_FIELD: 
                    case FIELD: {
                        state = State.INVALID;
                        if (!VariousUtils.isReference((Token<PHPTokenId>)string)) break;
                        stringBuilder.insert(0, "@fld:");
                        state = State.REFERENCE;
                        break;
                    }
                    case VARBASE: {
                        state = State.INVALID;
                        if (VariousUtils.isStaticReference((Token<PHPTokenId>)string)) {
                            state = State.STATIC_REFERENCE;
                            break;
                        }
                        state = State.VARIABLE;
                    }
                    case ARRAY_VARIABLE: 
                    case VARIABLE: {
                        if (state.equals((Object)State.ARRAY_VARIABLE)) {
                            stringBuilder.insert(0, "@array:");
                        } else {
                            stringBuilder.insert(0, "@var:");
                        }
                    }
                    case CLASSNAME: {
                        if (VariousUtils.isNamespaceSeparator((Token<PHPTokenId>)string) && tokenSequence.movePrevious()) {
                            stringBuilder.insert(0, ((Object)string.text()).toString());
                            string = tokenSequence.token();
                            if (VariousUtils.isString((Token<PHPTokenId>)string)) {
                                stringBuilder.insert(0, ((Object)string.text()).toString());
                                break;
                            }
                        }
                        state = State.STOP;
                    }
                }
                continue;
            }
            if (state.equals((Object)State.CLASSNAME)) {
                state = State.STOP;
                break;
            }
            if (!state.equals((Object)State.METHOD)) continue;
            state = State.STOP;
            PHPTokenId pHPTokenId = (PHPTokenId)string.id();
            if (pHPTokenId != null && PHPTokenId.PHP_NEW.equals((Object)pHPTokenId)) {
                stringBuilder.insert(0, "@constuct:");
                break;
            }
            stringBuilder.insert(0, "@fn:");
            break;
        }
        if (state.equals((Object)State.STOP) && (string = stringBuilder.toString()) != null) {
            return string;
        }
        return null;
    }

    public static String getVariableName(String string) {
        String string2;
        if (string != null && string.startsWith(string2 = "@var:")) {
            return string.substring(string2.length(), string.lastIndexOf("@"));
        }
        return null;
    }

    private static boolean skipWhitespaces(TokenSequence<PHPTokenId> tokenSequence) {
        Token token = tokenSequence.token();
        while (token != null && VariousUtils.isWhiteSpace((Token<PHPTokenId>)token)) {
            boolean bl = tokenSequence.movePrevious();
            token = tokenSequence.token();
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static String translateSpecialClassName(Scope scope, String string) {
        if (scope instanceof MethodScope) {
            ClassScope classScope;
            MethodScope methodScope = (MethodScope)scope;
            ClassScope classScope2 = (ClassScope)methodScope.getInScope();
            if ("self".equals(string) || "this".equals(string)) {
                string = classScope2.getName();
            } else if ("parent".equals(string) && (classScope = ModelUtils.getFirst(classScope2.getSuperClasses())) != null) {
                string = classScope.getName();
            }
        }
        return string;
    }

    private static boolean moveToOffset(TokenSequence<PHPTokenId> tokenSequence, int n) {
        return tokenSequence == null || tokenSequence.move(n) < 0;
    }

    private static boolean isDolar(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "$".contentEquals(token.text());
    }

    private static boolean isLeftBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "(".contentEquals(token.text());
    }

    private static boolean isRightBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && ")".contentEquals(token.text());
    }

    private static boolean isRightArryBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "]".contentEquals(token.text());
    }

    private static boolean isLeftArryBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "[".contentEquals(token.text());
    }

    private static boolean isComma(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && ",".contentEquals(token.text());
    }

    private static boolean isReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OBJECT_OPERATOR);
    }

    private static boolean isNamespaceSeparator(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_NS_SEPARATOR);
    }

    private static boolean isWhiteSpace(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.WHITESPACE);
    }

    private static boolean isStaticReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM);
    }

    private static boolean isVariable(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_VARIABLE);
    }

    private static boolean isSelf(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_SELF);
    }

    private static boolean isParent(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_PARENT);
    }

    private static boolean isString(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_STRING);
    }

    public static Collection<? extends TypeScope> getStaticTypeName(Scope scope, String string) {
        TypeScope typeScope = null;
        if (scope instanceof MethodScope) {
            MethodScope methodScope = (MethodScope)scope;
            typeScope = (ClassScope)methodScope.getInScope();
        }
        if (scope instanceof ClassScope || scope instanceof InterfaceScope) {
            typeScope = (TypeScope)scope;
        }
        if (typeScope != null) {
            if ("self".equals(string)) {
                return Collections.singletonList(typeScope);
            }
            if ("parent".equals(string) && typeScope instanceof ClassScope) {
                return ((ClassScope)typeScope).getSuperClasses();
            }
        }
        return CachingSupport.getTypes(string, scope);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        CONSTRUCTOR,
        FUNCTION,
        METHOD,
        STATIC_METHOD,
        FIELD,
        STATIC_FIELD,
        VAR;


        public String toString() {
            switch (this) {
                case CONSTRUCTOR: {
                    return VariousUtils.CONSTRUCTOR_TYPE_PREFIX;
                }
                case FUNCTION: {
                    return VariousUtils.FUNCTION_TYPE_PREFIX;
                }
                case METHOD: {
                    return VariousUtils.METHOD_TYPE_PREFIX;
                }
                case STATIC_METHOD: {
                    return VariousUtils.STATIC_METHOD_TYPE_PREFIX;
                }
                case FIELD: {
                    return VariousUtils.FIELD_TYPE_PREFIX;
                }
                case STATIC_FIELD: {
                    return VariousUtils.STATIC_FIELD__TYPE_PREFIX;
                }
                case VAR: {
                    return VariousUtils.VAR_TYPE_PREFIX;
                }
            }
            return super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        START,
        METHOD,
        INVALID,
        VARBASE,
        DOLAR,
        PARAMS,
        ARRAYREFERENCE,
        REFERENCE,
        STATIC_REFERENCE,
        FUNCTION,
        FIELD,
        VARIABLE,
        ARRAY_FIELD,
        ARRAY_VARIABLE,
        CLASSNAME,
        STOP,
        IDX;

    }
}

