/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.Collection;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.MagicMethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.PhpDocTypeTagInfo;
import org.netbeans.modules.php.editor.parser.PHPDocCommentParser;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarationFinderImpl
implements DeclarationFinder {
    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult parserResult, int n) {
        return DeclarationFinderImpl.findDeclarationImpl(parserResult, n);
    }

    public OffsetRange getReferenceSpan(Document document, int n) {
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(document, n);
        return DeclarationFinderImpl.getReferenceSpan(tokenSequence, n);
    }

    public static OffsetRange getReferenceSpan(TokenSequence<PHPTokenId> tokenSequence, int n) {
        block16: {
            String string;
            PHPTokenId pHPTokenId;
            Token token;
            block18: {
                block17: {
                    tokenSequence.move(n);
                    if (!tokenSequence.moveNext()) break block16;
                    token = tokenSequence.token();
                    pHPTokenId = (PHPTokenId)token.id();
                    if (pHPTokenId.equals((Object)PHPTokenId.PHP_STRING) || pHPTokenId.equals((Object)PHPTokenId.PHP_VARIABLE)) {
                        return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
                    }
                    if (!pHPTokenId.equals((Object)PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING)) break block17;
                    OffsetRange offsetRange = new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
                    for (int i = 0; i < 2 && tokenSequence.movePrevious(); ++i) {
                        token = tokenSequence.token();
                        pHPTokenId = (PHPTokenId)token.id();
                        if (pHPTokenId.equals((Object)PHPTokenId.PHP_INCLUDE) || pHPTokenId.equals((Object)PHPTokenId.PHP_INCLUDE_ONCE) || pHPTokenId.equals((Object)PHPTokenId.PHP_REQUIRE) || pHPTokenId.equals((Object)PHPTokenId.PHP_REQUIRE_ONCE)) {
                            return offsetRange;
                        }
                        if (!pHPTokenId.equals((Object)PHPTokenId.PHP_STRING) || !((Object)token.text()).toString().equalsIgnoreCase("define")) continue;
                        return offsetRange;
                    }
                    break block16;
                }
                if (!pHPTokenId.equals((Object)PHPTokenId.PHPDOC_COMMENT)) break block18;
                PHPDocCommentParser pHPDocCommentParser = new PHPDocCommentParser();
                PHPDocBlock pHPDocBlock = pHPDocCommentParser.parse(tokenSequence.offset() - 3, tokenSequence.offset() + token.length() - 3, token.toString());
                ASTNode[] aSTNodeArray = Utils.getNodeHierarchyAtOffset(pHPDocBlock, n);
                PhpDocTypeTagInfo phpDocTypeTagInfo = null;
                PHPDocTypeTag pHPDocTypeTag = null;
                if (aSTNodeArray != null && aSTNodeArray.length > 0) {
                    if (aSTNodeArray[0] instanceof PHPDocTypeTag) {
                        pHPDocTypeTag = (PHPDocTypeTag)aSTNodeArray[0];
                        if (pHPDocTypeTag.getStartOffset() < n && n < pHPDocTypeTag.getEndOffset()) {
                            List<? extends PhpDocTypeTagInfo> list = PhpDocTypeTagInfo.create(pHPDocTypeTag, ASTNodeInfo.Kind.CLASS);
                            for (PhpDocTypeTagInfo phpDocTypeTagInfo2 : list) {
                                if (!phpDocTypeTagInfo2.getKind().equals((Object)ASTNodeInfo.Kind.CLASS)) continue;
                                phpDocTypeTagInfo = phpDocTypeTagInfo2;
                                break;
                            }
                            if (phpDocTypeTagInfo == null || !phpDocTypeTagInfo.getRange().containsInclusive(n)) {
                                list = PhpDocTypeTagInfo.create(pHPDocTypeTag, ASTNodeInfo.Kind.VARIABLE);
                                for (PhpDocTypeTagInfo offsetRange : list) {
                                    if (!offsetRange.getKind().equals((Object)ASTNodeInfo.Kind.VARIABLE)) continue;
                                    phpDocTypeTagInfo = offsetRange;
                                    break;
                                }
                            }
                            if (phpDocTypeTagInfo != null) {
                                return phpDocTypeTagInfo.getRange().containsInclusive(n) ? phpDocTypeTagInfo.getRange() : OffsetRange.NONE;
                            }
                        }
                    } else {
                        List<PHPDocTag> list = pHPDocBlock.getTags();
                        for (PHPDocTag pHPDocTag : list) {
                            MagicMethodDeclarationInfo magicMethodDeclarationInfo = MagicMethodDeclarationInfo.create(pHPDocTag);
                            if (magicMethodDeclarationInfo == null) continue;
                            if (magicMethodDeclarationInfo.getRange().containsInclusive(n)) {
                                return magicMethodDeclarationInfo.getRange();
                            }
                            if (!magicMethodDeclarationInfo.getTypeRange().containsInclusive(n)) continue;
                            return magicMethodDeclarationInfo.getTypeRange();
                        }
                    }
                }
                break block16;
            }
            if (!pHPTokenId.equals((Object)PHPTokenId.PHP_COMMENT) || token.text() == null || !(string = ((Object)token.text()).toString()).contains("@var")) break block16;
            String[] stringArray = string.split("\\s");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (!string2.equals("@var") || stringArray.length <= i + 2) continue;
                for (int j = 1; j <= 2; ++j) {
                    OffsetRange offsetRange;
                    string2 = stringArray[i + j];
                    if (string2 == null || string2.trim().length() <= 0) continue;
                    int n2 = string.indexOf(string2);
                    assert (n2 != -1);
                    if (!(offsetRange = new OffsetRange(n2 += tokenSequence.offset(), n2 + string2.length())).containsInclusive(n)) continue;
                    return offsetRange;
                }
                return OffsetRange.NONE;
            }
        }
        return OffsetRange.NONE;
    }

    public static DeclarationFinder.DeclarationLocation findDeclarationImpl(ParserResult parserResult, int n) {
        if (!(parserResult instanceof PHPParseResult)) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        PHPParseResult pHPParseResult = (PHPParseResult)parserResult;
        Model model = pHPParseResult.getModel();
        OccurencesSupport occurencesSupport = model.getOccurencesSupport(n);
        Occurence occurence = occurencesSupport.getOccurence();
        return DeclarationFinderImpl.findDeclarationImpl(occurence, parserResult);
    }

    private static DeclarationFinder.DeclarationLocation findDeclarationImpl(Occurence occurence, ParserResult parserResult) {
        DeclarationFinder.DeclarationLocation declarationLocation = DeclarationFinder.DeclarationLocation.NONE;
        if (occurence != null && occurence.gotoDeclarationEnabled()) {
            ModelElement modelElement = occurence.gotoDeclaratin();
            FileObject fileObject = modelElement.getFileObject();
            if (fileObject == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            declarationLocation = new DeclarationFinder.DeclarationLocation(fileObject, modelElement.getOffset(), (ElementHandle)modelElement.getPHPElement());
            if (parserResult.getSnapshot().getSource().getFileObject() == modelElement.getFileObject()) {
                return declarationLocation;
            }
            Collection<? extends ModelElement> collection = occurence.getAllDeclarations();
            if (collection.size() > 1) {
                declarationLocation = DeclarationFinder.DeclarationLocation.NONE;
                for (ModelElement modelElement2 : collection) {
                    FileObject fileObject2 = modelElement2.getFileObject();
                    if (fileObject2 == null) continue;
                    DeclarationFinder.DeclarationLocation declarationLocation2 = new DeclarationFinder.DeclarationLocation(fileObject2, modelElement2.getOffset(), (ElementHandle)modelElement2.getPHPElement());
                    AlternativeLocationImpl alternativeLocationImpl = new AlternativeLocationImpl(modelElement2, declarationLocation2);
                    if (declarationLocation == DeclarationFinder.DeclarationLocation.NONE) {
                        declarationLocation = alternativeLocationImpl.getLocation();
                    }
                    declarationLocation.addAlternative((DeclarationFinder.AlternativeLocation)alternativeLocationImpl);
                }
                return declarationLocation;
            }
        }
        return declarationLocation;
    }

    private static class AlternativeLocationImpl
    implements DeclarationFinder.AlternativeLocation {
        private ModelElement modelElement;
        private DeclarationFinder.DeclarationLocation declaration;

        AlternativeLocationImpl(ModelElement modelElement, DeclarationFinder.DeclarationLocation declarationLocation) {
            this.modelElement = modelElement;
            this.declaration = declarationLocation;
        }

        public ElementHandle getElement() {
            return this.modelElement.getPHPElement();
        }

        public String getDisplayHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            ElementKind elementKind = this.modelElement.getPHPElement().getKind();
            if (elementKind != null) {
                htmlFormatter.name(elementKind, true);
                QualifiedName qualifiedName = this.modelElement.getNamespaceName();
                if (qualifiedName.isDefaultNamespace()) {
                    htmlFormatter.appendText(this.modelElement.getName());
                } else {
                    htmlFormatter.appendText(qualifiedName.append(this.modelElement.getName()).toString());
                }
                htmlFormatter.name(elementKind, false);
            } else {
                htmlFormatter.appendText(this.modelElement.getName());
            }
            if (this.declaration.getFileObject() != null) {
                htmlFormatter.appendText(" in ");
                htmlFormatter.appendText(FileUtil.getFileDisplayName((FileObject)this.declaration.getFileObject()));
            }
            return htmlFormatter.getText();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return this.declaration;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation alternativeLocation) {
            AlternativeLocationImpl alternativeLocationImpl = (AlternativeLocationImpl)alternativeLocation;
            return this.modelElement.getName().compareTo(alternativeLocationImpl.modelElement.getName());
        }
    }
}

