/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CodeCompletionPanel
extends JPanel {
    private static final long serialVersionUID = -24730122182427272L;
    static final String PHP_AUTO_COMPLETION_FULL = "phpAutoCompletionFull";
    static final String PHP_AUTO_COMPLETION_VARIABLES = "phpAutoCompletionVariables";
    static final String PHP_AUTO_COMPLETION_TYPES = "phpAutoCompletionTypes";
    static final String PHP_AUTO_COMPLETION_NAMESPACES = "phpAutoCompletionNamespaces";
    static final String PHP_CODE_COMPLETION_STATIC_METHODS = "phpCodeCompletionStaticMethods";
    static final String PHP_CODE_COMPLETION_NON_STATIC_METHODS = "phpCodeCompletionNonStaticMethods";
    static final String PHP_CODE_COMPLETION_VARIABLES_SCOPE = "phpCodeCompletionVariablesScope";
    static final String PHP_CODE_COMPLETION_TYPE = "phpCodeCompletionType";
    static final boolean PHP_AUTO_COMPLETION_FULL_DEFAULT = true;
    static final boolean PHP_AUTO_COMPLETION_VARIABLES_DEFAULT = true;
    static final boolean PHP_AUTO_COMPLETION_TYPES_DEFAULT = true;
    static final boolean PHP_AUTO_COMPLETION_NAMESPACES_DEFAULT = true;
    static final boolean PHP_CODE_COMPLETION_STATIC_METHODS_DEFAULT = true;
    static final boolean PHP_CODE_COMPLETION_NON_STATIC_METHODS_DEFAULT = false;
    private final Preferences preferences;
    private final ItemListener defaultCheckBoxListener = new DefaultCheckBoxListener();
    private final ItemListener defaultRadioButtonListener = new DefaultRadioButtonListener();
    private JRadioButton allVariablesRadioButton;
    private ButtonGroup autoCompletionButtonGroup;
    private JRadioButton autoCompletionCustomizeRadioButton;
    private JRadioButton autoCompletionFullRadioButton;
    private JCheckBox autoCompletionNamespacesCheckBox;
    private JCheckBox autoCompletionTypesCheckBox;
    private JCheckBox autoCompletionVariablesCheckBox;
    private JCheckBox codeCompletionNonStaticMethodsCheckBox;
    private JCheckBox codeCompletionStaticMethodsCheckBox;
    private ButtonGroup codeCompletionTypeButtonGroup;
    private JLabel codeCompletionTypeLabel;
    private ButtonGroup codeCompletionVariablesScopeButtonGroup;
    private JLabel codeCompletionVariablesScopeLabel;
    private JRadioButton currentFileVariablesRadioButton;
    private JLabel enableAutocompletionLabel;
    private JLabel fullyQualifiedInfoLabel;
    private JRadioButton fullyQualifiedRadioButton;
    private JLabel methodCodeCompletionLabel;
    private JLabel smartInfoLabel;
    private JRadioButton smartRadioButton;
    private JLabel unqualifiedInfoLabel;
    private JRadioButton unqualifiedRadioButton;

    public CodeCompletionPanel(Preferences preferences) {
        assert (preferences != null);
        this.preferences = preferences;
        this.initComponents();
        this.initAutoCompletion();
        this.initCodeCompletionForMethods();
        this.initCodeCompletionForVariables();
        this.initCodeCompletionType();
    }

    public static PreferencesCustomizer.Factory getCustomizerFactory() {
        return new PreferencesCustomizer.Factory(){

            public PreferencesCustomizer create(Preferences preferences) {
                return new CodeCompletionPreferencesCustomizer(preferences);
            }
        };
    }

    private void initAutoCompletion() {
        this.autoCompletionFullRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CodeCompletionPanel.this.setAutoCompletionState(false);
                }
            }
        });
        this.autoCompletionCustomizeRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CodeCompletionPanel.this.setAutoCompletionState(true);
                }
            }
        });
        boolean bl = this.preferences.getBoolean(PHP_AUTO_COMPLETION_FULL, true);
        if (bl) {
            this.autoCompletionFullRadioButton.setSelected(true);
        } else {
            this.autoCompletionCustomizeRadioButton.setSelected(true);
        }
        this.autoCompletionFullRadioButton.addItemListener(this.defaultRadioButtonListener);
        this.autoCompletionCustomizeRadioButton.addItemListener(this.defaultRadioButtonListener);
        boolean bl2 = this.preferences.getBoolean(PHP_AUTO_COMPLETION_VARIABLES, true);
        this.autoCompletionVariablesCheckBox.setSelected(bl2);
        this.autoCompletionVariablesCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean bl3 = this.preferences.getBoolean(PHP_AUTO_COMPLETION_TYPES, true);
        this.autoCompletionTypesCheckBox.setSelected(bl3);
        this.autoCompletionTypesCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean bl4 = this.preferences.getBoolean(PHP_AUTO_COMPLETION_NAMESPACES, true);
        this.autoCompletionNamespacesCheckBox.setSelected(bl4);
        this.autoCompletionNamespacesCheckBox.addItemListener(this.defaultCheckBoxListener);
    }

    private void initCodeCompletionForMethods() {
        boolean bl = this.preferences.getBoolean(PHP_CODE_COMPLETION_STATIC_METHODS, true);
        this.codeCompletionStaticMethodsCheckBox.setSelected(bl);
        this.codeCompletionStaticMethodsCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean bl2 = this.preferences.getBoolean(PHP_CODE_COMPLETION_NON_STATIC_METHODS, false);
        this.codeCompletionNonStaticMethodsCheckBox.setSelected(bl2);
        this.codeCompletionNonStaticMethodsCheckBox.addItemListener(this.defaultCheckBoxListener);
    }

    private void initCodeCompletionForVariables() {
        VariablesScope variablesScope = VariablesScope.resolve(this.preferences.get(PHP_CODE_COMPLETION_VARIABLES_SCOPE, null));
        switch (variablesScope) {
            case ALL: {
                this.allVariablesRadioButton.setSelected(true);
                break;
            }
            case CURRENT_FILE: {
                this.currentFileVariablesRadioButton.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown variables scope: " + (Object)((Object)variablesScope));
            }
        }
        this.allVariablesRadioButton.addItemListener(this.defaultRadioButtonListener);
        this.currentFileVariablesRadioButton.addItemListener(this.defaultRadioButtonListener);
    }

    private void initCodeCompletionType() {
        CodeCompletionType codeCompletionType = CodeCompletionType.resolve(this.preferences.get(PHP_CODE_COMPLETION_TYPE, null));
        switch (codeCompletionType) {
            case SMART: {
                this.smartRadioButton.setSelected(true);
                break;
            }
            case FULLY_QUALIFIED: {
                this.fullyQualifiedRadioButton.setSelected(true);
                break;
            }
            case UNQUALIFIED: {
                this.unqualifiedRadioButton.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown code completion type: " + (Object)((Object)codeCompletionType));
            }
        }
        this.smartRadioButton.addItemListener(this.defaultRadioButtonListener);
        this.fullyQualifiedRadioButton.addItemListener(this.defaultRadioButtonListener);
        this.unqualifiedRadioButton.addItemListener(this.defaultRadioButtonListener);
    }

    void validateData() {
        this.preferences.putBoolean(PHP_AUTO_COMPLETION_FULL, this.autoCompletionFullRadioButton.isSelected());
        this.preferences.putBoolean(PHP_AUTO_COMPLETION_VARIABLES, this.autoCompletionVariablesCheckBox.isSelected());
        this.preferences.putBoolean(PHP_AUTO_COMPLETION_TYPES, this.autoCompletionTypesCheckBox.isSelected());
        this.preferences.putBoolean(PHP_AUTO_COMPLETION_NAMESPACES, this.autoCompletionNamespacesCheckBox.isSelected());
        this.preferences.putBoolean(PHP_CODE_COMPLETION_STATIC_METHODS, this.codeCompletionStaticMethodsCheckBox.isSelected());
        this.preferences.putBoolean(PHP_CODE_COMPLETION_NON_STATIC_METHODS, this.codeCompletionNonStaticMethodsCheckBox.isSelected());
        VariablesScope variablesScope = null;
        if (this.allVariablesRadioButton.isSelected()) {
            variablesScope = VariablesScope.ALL;
        } else if (this.currentFileVariablesRadioButton.isSelected()) {
            variablesScope = VariablesScope.CURRENT_FILE;
        }
        assert (variablesScope != null);
        this.preferences.put(PHP_CODE_COMPLETION_VARIABLES_SCOPE, variablesScope.name());
        CodeCompletionType codeCompletionType = null;
        if (this.smartRadioButton.isSelected()) {
            codeCompletionType = CodeCompletionType.SMART;
        } else if (this.fullyQualifiedRadioButton.isSelected()) {
            codeCompletionType = CodeCompletionType.FULLY_QUALIFIED;
        } else if (this.unqualifiedRadioButton.isSelected()) {
            codeCompletionType = CodeCompletionType.UNQUALIFIED;
        }
        assert (codeCompletionType != null);
        this.preferences.put(PHP_CODE_COMPLETION_TYPE, codeCompletionType.name());
    }

    void setAutoCompletionState(boolean bl) {
        this.autoCompletionVariablesCheckBox.setEnabled(bl);
        this.autoCompletionTypesCheckBox.setEnabled(bl);
        this.autoCompletionNamespacesCheckBox.setEnabled(bl);
    }

    private void initComponents() {
        this.codeCompletionTypeButtonGroup = new ButtonGroup();
        this.codeCompletionVariablesScopeButtonGroup = new ButtonGroup();
        this.autoCompletionButtonGroup = new ButtonGroup();
        this.enableAutocompletionLabel = new JLabel();
        this.autoCompletionFullRadioButton = new JRadioButton();
        this.autoCompletionCustomizeRadioButton = new JRadioButton();
        this.autoCompletionVariablesCheckBox = new JCheckBox();
        this.autoCompletionTypesCheckBox = new JCheckBox();
        this.autoCompletionNamespacesCheckBox = new JCheckBox();
        this.methodCodeCompletionLabel = new JLabel();
        this.codeCompletionStaticMethodsCheckBox = new JCheckBox();
        this.codeCompletionNonStaticMethodsCheckBox = new JCheckBox();
        this.codeCompletionVariablesScopeLabel = new JLabel();
        this.allVariablesRadioButton = new JRadioButton();
        this.currentFileVariablesRadioButton = new JRadioButton();
        this.codeCompletionTypeLabel = new JLabel();
        this.smartRadioButton = new JRadioButton();
        this.smartInfoLabel = new JLabel();
        this.fullyQualifiedRadioButton = new JRadioButton();
        this.fullyQualifiedInfoLabel = new JLabel();
        this.unqualifiedRadioButton = new JRadioButton();
        this.unqualifiedInfoLabel = new JLabel();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                return CodeCompletionPanel.this.unqualifiedRadioButton;
            }

            public Component getFirstComponent(Container container) {
                return CodeCompletionPanel.this.unqualifiedRadioButton;
            }

            public Component getLastComponent(Container container) {
                return CodeCompletionPanel.this.unqualifiedRadioButton;
            }

            public Component getComponentAfter(Container container, Component component) {
                if (component == CodeCompletionPanel.this.autoCompletionFullRadioButton) {
                    return CodeCompletionPanel.this.autoCompletionCustomizeRadioButton;
                }
                if (component == CodeCompletionPanel.this.autoCompletionCustomizeRadioButton) {
                    return CodeCompletionPanel.this.autoCompletionVariablesCheckBox;
                }
                if (component == CodeCompletionPanel.this.autoCompletionVariablesCheckBox) {
                    return CodeCompletionPanel.this.autoCompletionTypesCheckBox;
                }
                if (component == CodeCompletionPanel.this.autoCompletionTypesCheckBox) {
                    return CodeCompletionPanel.this.autoCompletionNamespacesCheckBox;
                }
                if (component == CodeCompletionPanel.this.codeCompletionStaticMethodsCheckBox) {
                    return CodeCompletionPanel.this.codeCompletionNonStaticMethodsCheckBox;
                }
                if (component == CodeCompletionPanel.this.autoCompletionNamespacesCheckBox) {
                    return CodeCompletionPanel.this.codeCompletionStaticMethodsCheckBox;
                }
                if (component == CodeCompletionPanel.this.codeCompletionNonStaticMethodsCheckBox) {
                    return CodeCompletionPanel.this.allVariablesRadioButton;
                }
                if (component == CodeCompletionPanel.this.currentFileVariablesRadioButton) {
                    return CodeCompletionPanel.this.smartRadioButton;
                }
                if (component == CodeCompletionPanel.this.allVariablesRadioButton) {
                    return CodeCompletionPanel.this.currentFileVariablesRadioButton;
                }
                if (component == CodeCompletionPanel.this.smartRadioButton) {
                    return CodeCompletionPanel.this.fullyQualifiedRadioButton;
                }
                if (component == CodeCompletionPanel.this.fullyQualifiedRadioButton) {
                    return CodeCompletionPanel.this.unqualifiedRadioButton;
                }
                return CodeCompletionPanel.this.unqualifiedRadioButton;
            }

            public Component getComponentBefore(Container container, Component component) {
                if (component == CodeCompletionPanel.this.autoCompletionCustomizeRadioButton) {
                    return CodeCompletionPanel.this.autoCompletionFullRadioButton;
                }
                if (component == CodeCompletionPanel.this.autoCompletionVariablesCheckBox) {
                    return CodeCompletionPanel.this.autoCompletionCustomizeRadioButton;
                }
                if (component == CodeCompletionPanel.this.autoCompletionTypesCheckBox) {
                    return CodeCompletionPanel.this.autoCompletionVariablesCheckBox;
                }
                if (component == CodeCompletionPanel.this.autoCompletionNamespacesCheckBox) {
                    return CodeCompletionPanel.this.autoCompletionTypesCheckBox;
                }
                if (component == CodeCompletionPanel.this.codeCompletionNonStaticMethodsCheckBox) {
                    return CodeCompletionPanel.this.codeCompletionStaticMethodsCheckBox;
                }
                if (component == CodeCompletionPanel.this.codeCompletionStaticMethodsCheckBox) {
                    return CodeCompletionPanel.this.autoCompletionNamespacesCheckBox;
                }
                if (component == CodeCompletionPanel.this.allVariablesRadioButton) {
                    return CodeCompletionPanel.this.codeCompletionNonStaticMethodsCheckBox;
                }
                if (component == CodeCompletionPanel.this.smartRadioButton) {
                    return CodeCompletionPanel.this.currentFileVariablesRadioButton;
                }
                if (component == CodeCompletionPanel.this.currentFileVariablesRadioButton) {
                    return CodeCompletionPanel.this.allVariablesRadioButton;
                }
                if (component == CodeCompletionPanel.this.fullyQualifiedRadioButton) {
                    return CodeCompletionPanel.this.smartRadioButton;
                }
                if (component == CodeCompletionPanel.this.unqualifiedRadioButton) {
                    return CodeCompletionPanel.this.fullyQualifiedRadioButton;
                }
                return CodeCompletionPanel.this.unqualifiedRadioButton;
            }
        });
        this.enableAutocompletionLabel.setLabelFor(this.autoCompletionFullRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.enableAutocompletionLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.enableAutocompletionLabel.text"));
        this.autoCompletionButtonGroup.add(this.autoCompletionFullRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionFullRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionFullRadioButton.text"));
        this.autoCompletionButtonGroup.add(this.autoCompletionCustomizeRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionCustomizeRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionCustomizeRadioButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionVariablesCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionVariablesCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionTypesCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionTypesCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionNamespacesCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionNamespacesCheckBox.text"));
        this.methodCodeCompletionLabel.setLabelFor(this.codeCompletionStaticMethodsCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.methodCodeCompletionLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.methodCodeCompletionLabel.text"));
        this.codeCompletionStaticMethodsCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.codeCompletionStaticMethodsCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionStaticMethodsCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.codeCompletionNonStaticMethodsCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionNonStaticMethodsCheckBox.text"));
        this.codeCompletionVariablesScopeLabel.setLabelFor(this.allVariablesRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.codeCompletionVariablesScopeLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionVariablesScopeLabel.text"));
        this.codeCompletionVariablesScopeButtonGroup.add(this.allVariablesRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.allVariablesRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.allVariablesRadioButton.text"));
        this.codeCompletionVariablesScopeButtonGroup.add(this.currentFileVariablesRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.currentFileVariablesRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.currentFileVariablesRadioButton.text"));
        this.codeCompletionTypeLabel.setLabelFor(this.smartRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.codeCompletionTypeLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionTypeLabel.text"));
        this.codeCompletionTypeButtonGroup.add(this.smartRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.smartRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.smartRadioButton.text"));
        this.smartInfoLabel.setLabelFor(this.smartRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.smartInfoLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.smartInfoLabel.text"));
        this.codeCompletionTypeButtonGroup.add(this.fullyQualifiedRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.fullyQualifiedRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedRadioButton.text"));
        this.fullyQualifiedInfoLabel.setLabelFor(this.fullyQualifiedRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.fullyQualifiedInfoLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedInfoLabel.text"));
        this.codeCompletionTypeButtonGroup.add(this.unqualifiedRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.unqualifiedRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.unqualifiedRadioButton.text"));
        this.unqualifiedInfoLabel.setLabelFor(this.unqualifiedRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.unqualifiedInfoLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.unqualifiedInfoLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.autoCompletionCustomizeRadioButton).add((Component)this.autoCompletionFullRadioButton).add((Component)this.currentFileVariablesRadioButton).add((Component)this.allVariablesRadioButton).add((Component)this.methodCodeCompletionLabel).add((Component)this.codeCompletionNonStaticMethodsCheckBox).add((Component)this.codeCompletionStaticMethodsCheckBox).add((Component)this.codeCompletionTypeLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.smartInfoLabel)).add((Component)this.smartRadioButton).add((Component)this.fullyQualifiedRadioButton).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.fullyQualifiedInfoLabel)).add((Component)this.unqualifiedRadioButton).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.unqualifiedInfoLabel)).add((Component)this.enableAutocompletionLabel).add((Component)this.codeCompletionVariablesScopeLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.autoCompletionTypesCheckBox).add((Component)this.autoCompletionVariablesCheckBox).add((Component)this.autoCompletionNamespacesCheckBox)))).addContainerGap(109, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.enableAutocompletionLabel).addPreferredGap(0).add((Component)this.autoCompletionFullRadioButton).addPreferredGap(0).add((Component)this.autoCompletionCustomizeRadioButton).addPreferredGap(0).add((Component)this.autoCompletionVariablesCheckBox).addPreferredGap(0).add((Component)this.autoCompletionTypesCheckBox).addPreferredGap(0).add((Component)this.autoCompletionNamespacesCheckBox).add(18, 18, 18).add((Component)this.methodCodeCompletionLabel).addPreferredGap(0).add((Component)this.codeCompletionStaticMethodsCheckBox).addPreferredGap(0).add((Component)this.codeCompletionNonStaticMethodsCheckBox).add(18, 18, 18).add((Component)this.codeCompletionVariablesScopeLabel).addPreferredGap(0).add((Component)this.allVariablesRadioButton).addPreferredGap(0).add((Component)this.currentFileVariablesRadioButton).add(18, 18, 18).add((Component)this.codeCompletionTypeLabel).addPreferredGap(0).add((Component)this.smartRadioButton).addPreferredGap(0).add((Component)this.smartInfoLabel).addPreferredGap(0).add((Component)this.fullyQualifiedRadioButton).addPreferredGap(0).add((Component)this.fullyQualifiedInfoLabel).addPreferredGap(0).add((Component)this.unqualifiedRadioButton).addPreferredGap(0).add((Component)this.unqualifiedInfoLabel).addContainerGap(64, Short.MAX_VALUE)));
        this.enableAutocompletionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.enableAutocompletionLabel.AccessibleContext.accessibleName"));
        this.enableAutocompletionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.enableAutocompletionLabel.AccessibleContext.accessibleDescription"));
        this.autoCompletionFullRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionFullRadioButton.AccessibleContext.accessibleName"));
        this.autoCompletionFullRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionFullRadioButton.AccessibleContext.accessibleDescription"));
        this.autoCompletionCustomizeRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionCustomizeRadioButton.AccessibleContext.accessibleName"));
        this.autoCompletionCustomizeRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionCustomizeRadioButton.AccessibleContext.accessibleDescription"));
        this.autoCompletionVariablesCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionVariablesCheckBox.AccessibleContext.accessibleName"));
        this.autoCompletionVariablesCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionVariablesCheckBox.AccessibleContext.accessibleDescription"));
        this.autoCompletionTypesCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionTypesCheckBox.AccessibleContext.accessibleName"));
        this.autoCompletionTypesCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionTypesCheckBox.AccessibleContext.accessibleDescription"));
        this.autoCompletionNamespacesCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionNamespacesCheckBox.AccessibleContext.accessibleName"));
        this.autoCompletionNamespacesCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionNamespacesCheckBox.AccessibleContext.accessibleDescription"));
        this.methodCodeCompletionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.methodCodeCompletionLabel.AccessibleContext.accessibleName"));
        this.methodCodeCompletionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.methodCodeCompletionLabel.AccessibleContext.accessibleDescription"));
        this.codeCompletionStaticMethodsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionStaticMethodsCheckBox.AccessibleContext.accessibleName"));
        this.codeCompletionStaticMethodsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionStaticMethodsCheckBox.AccessibleContext.accessibleDescription"));
        this.codeCompletionNonStaticMethodsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionNonStaticMethodsCheckBox.AccessibleContext.accessibleName"));
        this.codeCompletionNonStaticMethodsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionNonStaticMethodsCheckBox.AccessibleContext.accessibleDescription"));
        this.codeCompletionVariablesScopeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionVariablesScopeLabel.AccessibleContext.accessibleName"));
        this.codeCompletionVariablesScopeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionVariablesScopeLabel.AccessibleContext.accessibleDescription"));
        this.allVariablesRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.allVariablesRadioButton.AccessibleContext.accessibleName"));
        this.allVariablesRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.allVariablesRadioButton.AccessibleContext.accessibleDescription"));
        this.currentFileVariablesRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.currentFileVariablesRadioButton.AccessibleContext.accessibleName"));
        this.currentFileVariablesRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.currentFileVariablesRadioButton.AccessibleContext.accessibleDescription"));
        this.codeCompletionTypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionTypeLabel.AccessibleContext.accessibleName"));
        this.codeCompletionTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionTypeLabel.AccessibleContext.accessibleDescription"));
        this.smartRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.smartRadioButton.AccessibleContext.accessibleName"));
        this.smartRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.smartRadioButton.AccessibleContext.accessibleDescription"));
        this.smartInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.smartInfoLabel.AccessibleContext.accessibleDescription"));
        this.fullyQualifiedRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedRadioButton.AccessibleContext.accessibleName"));
        this.fullyQualifiedRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedRadioButton.AccessibleContext.accessibleDescription"));
        this.fullyQualifiedInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedInfoLabel.AccessibleContext.accessibleName"));
        this.fullyQualifiedInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedInfoLabel.AccessibleContext.accessibleDescription"));
        this.unqualifiedRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.unqualifiedRadioButton.AccessibleContext.accessibleName"));
        this.unqualifiedRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.unqualifiedRadioButton.AccessibleContext.accessibleDescription"));
        this.unqualifiedInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.unqualifiedInfoLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.AccessibleContext.accessibleDescription"));
    }

    static final class CodeCompletionPreferencesCustomizer
    implements PreferencesCustomizer {
        private final Preferences preferences;

        private CodeCompletionPreferencesCustomizer(Preferences preferences) {
            this.preferences = preferences;
        }

        public String getId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getDisplayName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(CodeCompletionPanel.class);
        }

        public JComponent getComponent() {
            return new CodeCompletionPanel(this.preferences);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CodeCompletionType {
        SMART,
        FULLY_QUALIFIED,
        UNQUALIFIED;


        public static CodeCompletionType resolve(String string) {
            if (string != null) {
                try {
                    return CodeCompletionType.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return SMART;
        }
    }

    private final class DefaultCheckBoxListener
    implements ItemListener {
        private DefaultCheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            CodeCompletionPanel.this.validateData();
        }
    }

    private final class DefaultRadioButtonListener
    implements ItemListener {
        private DefaultRadioButtonListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                CodeCompletionPanel.this.validateData();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VariablesScope {
        ALL,
        CURRENT_FILE;


        public static VariablesScope resolve(String string) {
            if (string != null) {
                try {
                    return VariablesScope.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return ALL;
        }
    }
}

