/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.options;

import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.php.editor.options.CodeCompletionPanel;
import org.openide.util.WeakListeners;

public final class OptionsUtils {
    private static final AtomicBoolean INITED = new AtomicBoolean(false);
    private static final PreferenceChangeListener PREFERENCES_TRACKER = new PreferenceChangeListener(){

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string;
            String string2 = string = preferenceChangeEvent == null ? null : preferenceChangeEvent.getKey();
            if (string == null || "phpAutoCompletionFull".equals(string)) {
                autoCompletionFull = preferences.getBoolean("phpAutoCompletionFull", true);
            }
            if (string == null || "phpAutoCompletionVariables".equals(string)) {
                autoCompletionVariables = preferences.getBoolean("phpAutoCompletionVariables", true);
            }
            if (string == null || "phpAutoCompletionTypes".equals(string)) {
                autoCompletionTypes = preferences.getBoolean("phpAutoCompletionTypes", true);
            }
            if (string == null || "phpAutoCompletionNamespaces".equals(string)) {
                autoCompletionNamespaces = preferences.getBoolean("phpAutoCompletionNamespaces", true);
            }
            if (string == null || "phpCodeCompletionStaticMethods".equals(string)) {
                codeCompletionStaticMethods = preferences.getBoolean("phpCodeCompletionStaticMethods", true);
            }
            if (string == null || "phpCodeCompletionNonStaticMethods".equals(string)) {
                codeCompletionNonStaticMethods = preferences.getBoolean("phpCodeCompletionNonStaticMethods", false);
            }
            if (string == null || "phpCodeCompletionVariablesScope".equals(string)) {
                codeCompletionVariablesScope = CodeCompletionPanel.VariablesScope.resolve(preferences.get("phpCodeCompletionVariablesScope", null));
            }
            if (string == null || "phpCodeCompletionType".equals(string)) {
                OptionsUtils.codeCompletionType = CodeCompletionPanel.CodeCompletionType.resolve(preferences.get("phpCodeCompletionType", null));
            }
        }
    };
    private static Preferences preferences;
    private static Boolean autoCompletionFull;
    private static Boolean autoCompletionVariables;
    private static Boolean autoCompletionTypes;
    private static Boolean autoCompletionNamespaces;
    private static Boolean codeCompletionStaticMethods;
    private static Boolean codeCompletionNonStaticMethods;
    private static CodeCompletionPanel.VariablesScope codeCompletionVariablesScope;
    private static CodeCompletionPanel.CodeCompletionType codeCompletionType;

    private OptionsUtils() {
    }

    public static boolean autoCompletionFull() {
        OptionsUtils.lazyInit();
        assert (autoCompletionFull != null);
        return autoCompletionFull;
    }

    public static boolean autoCompletionVariables() {
        OptionsUtils.lazyInit();
        assert (autoCompletionVariables != null);
        if (OptionsUtils.autoCompletionFull()) {
            return true;
        }
        return autoCompletionVariables;
    }

    public static boolean autoCompletionTypes() {
        OptionsUtils.lazyInit();
        assert (autoCompletionTypes != null);
        if (OptionsUtils.autoCompletionFull()) {
            return true;
        }
        return autoCompletionTypes;
    }

    public static boolean autoCompletionNamespaces() {
        OptionsUtils.lazyInit();
        assert (autoCompletionNamespaces != null);
        if (OptionsUtils.autoCompletionFull()) {
            return true;
        }
        return autoCompletionNamespaces;
    }

    public static boolean codeCompletionStaticMethods() {
        OptionsUtils.lazyInit();
        assert (codeCompletionStaticMethods != null);
        return codeCompletionStaticMethods;
    }

    public static boolean codeCompletionNonStaticMethods() {
        OptionsUtils.lazyInit();
        assert (codeCompletionNonStaticMethods != null);
        return codeCompletionNonStaticMethods;
    }

    public static CodeCompletionPanel.VariablesScope codeCompletionVariablesScope() {
        OptionsUtils.lazyInit();
        assert (codeCompletionVariablesScope != null);
        return codeCompletionVariablesScope;
    }

    public static CodeCompletionPanel.CodeCompletionType codeCompletionType() {
        OptionsUtils.lazyInit();
        assert (codeCompletionType != null);
        return codeCompletionType;
    }

    private static void lazyInit() {
        if (INITED.compareAndSet(false, true)) {
            preferences = (Preferences)MimeLookup.getLookup((String)"text/x-php5").lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)PREFERENCES_TRACKER, (Object)preferences));
            PREFERENCES_TRACKER.preferenceChange(null);
        }
    }

    static {
        autoCompletionFull = null;
        autoCompletionVariables = null;
        autoCompletionTypes = null;
        autoCompletionNamespaces = null;
        codeCompletionStaticMethods = null;
        codeCompletionNonStaticMethods = null;
        codeCompletionVariablesScope = null;
        codeCompletionType = null;
    }
}

