/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Parameter;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.UseElement;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.openide.util.ImageUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpStructureScanner
implements StructureScanner {
    private static ImageIcon INTERFACE_ICON = null;
    private static final String FOLD_CODE_BLOCKS = "codeblocks";
    private static final String FOLD_CLASS = "codeblocks";
    private static final String FOLD_PHPDOC = "comments";
    private static final String FOLD_COMMENT = "initial-comment";
    private static final String FONT_GRAY_COLOR = "<font color=\"#999999\">";
    private static final String CLOSE_FONT = "</font>";
    private static final String LAST_CORRECT_FOLDING_PROPERTY = "LAST_CORRECT_FOLDING_PROPERY";

    public List<? extends StructureItem> scan(ParserResult parserResult) {
        ArrayList<PHPNamespaceStructureItem> arrayList = new ArrayList<PHPNamespaceStructureItem>();
        PHPParseResult pHPParseResult = (PHPParseResult)parserResult;
        Model model = pHPParseResult.getModel();
        FileScope fileScope = model.getFileScope();
        Collection<? extends NamespaceScope> collection = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : collection) {
            Object object;
            ArrayList<PHPNamespaceStructureItem> arrayList2;
            ArrayList<PHPNamespaceStructureItem> arrayList3 = arrayList2 = namespaceScope.isDefaultNamespace() ? arrayList : new ArrayList<PHPNamespaceStructureItem>();
            if (!namespaceScope.isDefaultNamespace()) {
                arrayList.add(new PHPNamespaceStructureItem(namespaceScope, arrayList2));
            }
            Collection<? extends UseElement> collection3 = namespaceScope.getDeclaredUses();
            for (UseElement useElement : collection3) {
                arrayList2.add((PHPNamespaceStructureItem)((Object)new PHPUseStructureItem(useElement)));
            }
            Collection<? extends FunctionScope> collection4 = namespaceScope.getDeclaredFunctions();
            Iterator iterator = collection4.iterator();
            while (iterator.hasNext()) {
                object = (FunctionScope)iterator.next();
                if (object.isAnonymous()) continue;
                ArrayList arrayList4 = new ArrayList();
                arrayList2.add((PHPNamespaceStructureItem)((Object)new PHPFunctionStructureItem((FunctionScope)object, arrayList4)));
            }
            Collection<? extends ConstantElement> collection22 = namespaceScope.getDeclaredConstants();
            for (ConstantElement constantElement : collection22) {
                arrayList2.add((PHPNamespaceStructureItem)((Object)new PHPSimpleStructureItem(constantElement, "const")));
            }
            object = namespaceScope.getDeclaredTypes();
            Iterator<? extends TypeScope> iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Collection<? extends FieldElement> collection2;
                TypeScope typeScope = iterator2.next();
                ArrayList<PHPStructureItem> arrayList5 = new ArrayList<PHPStructureItem>();
                if (typeScope instanceof ClassScope) {
                    arrayList2.add((PHPNamespaceStructureItem)((Object)new PHPClassStructureItem((ClassScope)typeScope, arrayList5)));
                } else if (typeScope instanceof InterfaceScope) {
                    arrayList2.add((PHPNamespaceStructureItem)((Object)new PHPInterfaceStructureItem((InterfaceScope)typeScope, arrayList5)));
                }
                Collection<? extends MethodScope> collection5 = typeScope.getDeclaredMethods();
                for (MethodScope methodScope : collection5) {
                    collection2 = new ArrayList();
                    if (methodScope.isConstructor()) {
                        arrayList5.add(new PHPConstructorStructureItem(methodScope, (List<? extends StructureItem>)collection2));
                        continue;
                    }
                    arrayList5.add(new PHPMethodStructureItem(methodScope, (List<? extends StructureItem>)collection2));
                }
                Collection<? extends ClassConstantElement> collection6 = typeScope.getDeclaredConstants();
                Iterator iterator3 = collection6.iterator();
                while (iterator3.hasNext()) {
                    collection2 = (ClassConstantElement)iterator3.next();
                    arrayList5.add(new PHPSimpleStructureItem((ModelElement)((Object)collection2), "con"));
                }
                if (!(typeScope instanceof ClassScope)) continue;
                ClassScope classScope = (ClassScope)typeScope;
                collection2 = classScope.getDeclaredFields();
                for (FieldElement fieldElement : collection2) {
                    arrayList5.add(new PHPFieldStructureItem(fieldElement));
                }
            }
        }
        return arrayList;
    }

    public Map<String, List<OffsetRange>> folds(ParserResult parserResult) {
        HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
        Program program = Utils.getRoot(parserResult);
        if (program != null) {
            if (program.getStatements().size() == 1 && program.getStatements().get(0) instanceof ASTError) {
                Map map;
                Document document = parserResult.getSnapshot().getSource().getDocument(false);
                Map map2 = map = document != null ? (Map)document.getProperty(LAST_CORRECT_FOLDING_PROPERTY) : null;
                if (map != null) {
                    return map;
                }
                return Collections.emptyMap();
            }
            List<Comment> list = program.getComments();
            if (list != null) {
                for (Comment object22 : list) {
                    if (object22.getCommentType() == Comment.Type.TYPE_PHPDOC) {
                        this.getRanges(hashMap, FOLD_PHPDOC).add(this.createOffsetRange(object22));
                        continue;
                    }
                    if (object22.getCommentType() != Comment.Type.TYPE_MULTILINE) continue;
                    this.getRanges(hashMap, FOLD_COMMENT).add(this.createOffsetRange(object22));
                }
            }
            PHPParseResult pHPParseResult = (PHPParseResult)parserResult;
            Model model = pHPParseResult.getModel();
            FileScope fileScope = model.getFileScope();
            List<Scope> list2 = this.getEmbededScopes(fileScope, null);
            for (Scope scope : list2) {
                OffsetRange offsetRange = scope.getBlockRange();
                if (offsetRange == null) continue;
                if (scope instanceof TypeScope) {
                    this.getRanges(hashMap, "codeblocks").add(offsetRange);
                    continue;
                }
                this.getRanges(hashMap, "codeblocks").add(offsetRange);
            }
            Source source = parserResult.getSnapshot().getSource();
            assert (source != null) : "source was null";
            Document document = source.getDocument(false);
            if (document != null) {
                document.putProperty(LAST_CORRECT_FOLDING_PROPERTY, hashMap);
            }
            return hashMap;
        }
        return Collections.emptyMap();
    }

    private OffsetRange createOffsetRange(ASTNode aSTNode) {
        return new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset());
    }

    private List<OffsetRange> getRanges(Map<String, List<OffsetRange>> map, String string) {
        List<OffsetRange> list = map.get(string);
        if (list == null) {
            list = new ArrayList<OffsetRange>();
            map.put(string, list);
        }
        return list;
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(true, true);
    }

    private List<Scope> getEmbededScopes(Scope scope, List<Scope> list) {
        if (list == null) {
            list = new ArrayList<Scope>();
        }
        List<? extends ModelElement> list2 = scope.getElements();
        for (ModelElement modelElement : list2) {
            if (!(modelElement instanceof Scope)) continue;
            list.add((Scope)modelElement);
            this.getEmbededScopes((Scope)modelElement, list);
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PHPClassStructureItem
    extends PHPStructureItem {
        public PHPClassStructureItem(ClassScope classScope, List<? extends StructureItem> list) {
            super(classScope, list, "cl");
        }

        public ClassScope getClassScope() {
            return (ClassScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            Collection<? extends String> collection;
            htmlFormatter.reset();
            htmlFormatter.appendText(this.getName());
            String string = ModelUtils.getFirst(this.getClassScope().getSuperClassNames());
            if (string != null) {
                htmlFormatter.appendHtml("<font color=\"#999999\">::");
                htmlFormatter.appendText(string);
                htmlFormatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
            }
            if ((collection = this.getClassScope().getSuperInterfaceNames()) != null && collection.size() > 0) {
                htmlFormatter.appendHtml("<font color=\"#999999\">:");
                this.appendInterfeas(collection, htmlFormatter);
                htmlFormatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
            }
            return htmlFormatter.getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PHPConstructorStructureItem
    extends PHPStructureItem {
        public PHPConstructorStructureItem(MethodScope methodScope, List<? extends StructureItem> list) {
            super(methodScope, list, "con");
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CONSTRUCTOR;
        }

        public MethodScope getMethodScope() {
            return (MethodScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            this.appendFunctionDescription(this.getMethodScope(), htmlFormatter);
            return htmlFormatter.getText();
        }
    }

    private class PHPFieldStructureItem
    extends PHPSimpleStructureItem {
        public PHPFieldStructureItem(ModelElement modelElement) {
            super(modelElement, "field");
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            ElementHandle elementHandle = this.getElementHandle();
            htmlFormatter.appendText(elementHandle.getName());
            if (elementHandle instanceof FieldElement) {
                FieldElement fieldElement = (FieldElement)elementHandle;
                Collection<? extends String> collection = fieldElement.getDefaultTypeNames();
                StringBuilder stringBuilder = null;
                if (!collection.isEmpty()) {
                    htmlFormatter.appendHtml("<font color=\"#999999\">:");
                    for (String string : collection) {
                        if (stringBuilder == null) {
                            stringBuilder = new StringBuilder();
                        } else {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(string);
                    }
                    htmlFormatter.appendText(stringBuilder.toString());
                    htmlFormatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
                }
            }
            return htmlFormatter.getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PHPFunctionStructureItem
    extends PHPStructureItem {
        public PHPFunctionStructureItem(FunctionScope functionScope, List<? extends StructureItem> list) {
            super(functionScope, list, "fn");
        }

        public FunctionScope getFunctionScope() {
            return (FunctionScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            this.appendFunctionDescription(this.getFunctionScope(), htmlFormatter);
            return htmlFormatter.getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PHPInterfaceStructureItem
    extends PHPStructureItem {
        private static final String PHP_INTERFACE_ICON = "org/netbeans/modules/php/editor/resources/interface.png";

        public PHPInterfaceStructureItem(InterfaceScope interfaceScope, List<? extends StructureItem> list) {
            super(interfaceScope, list, "cl");
        }

        @Override
        public ImageIcon getCustomIcon() {
            if (INTERFACE_ICON == null) {
                INTERFACE_ICON = new ImageIcon(ImageUtilities.loadImage((String)PHP_INTERFACE_ICON));
            }
            return INTERFACE_ICON;
        }

        public InterfaceScope getInterfaceScope() {
            return (InterfaceScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            htmlFormatter.appendText(this.getElementHandle().getName());
            Collection<? extends String> collection = this.getInterfaceScope().getSuperInterfaceNames();
            if (collection != null && collection.size() > 0) {
                htmlFormatter.appendHtml("<font color=\"#999999\">::");
                this.appendInterfeas(collection, htmlFormatter);
                htmlFormatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
            }
            return htmlFormatter.getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PHPMethodStructureItem
    extends PHPStructureItem {
        public PHPMethodStructureItem(MethodScope methodScope, List<? extends StructureItem> list) {
            super(methodScope, list, "fn");
        }

        public MethodScope getMethodScope() {
            return (MethodScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            this.appendFunctionDescription(this.getMethodScope(), htmlFormatter);
            return htmlFormatter.getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PHPNamespaceStructureItem
    extends PHPStructureItem {
        public PHPNamespaceStructureItem(NamespaceScope namespaceScope, List<? extends StructureItem> list) {
            super(namespaceScope, list, "namespace");
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            htmlFormatter.appendText(this.getName());
            return htmlFormatter.getText();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.MODULE;
        }
    }

    private class PHPSimpleStructureItem
    extends PHPStructureItem {
        private String simpleText;

        public PHPSimpleStructureItem(ModelElement modelElement, String string) {
            super(modelElement, null, string);
            this.simpleText = modelElement.getName();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.appendText(this.simpleText);
            return htmlFormatter.getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class PHPStructureItem
    implements StructureItem {
        private final ModelElement modelElement;
        private final List<? extends StructureItem> children;
        private final String sortPrefix;

        public PHPStructureItem(ModelElement modelElement, List<? extends StructureItem> list, String string) {
            this.modelElement = modelElement;
            this.sortPrefix = string;
            this.children = list != null ? list : Collections.emptyList();
        }

        public boolean equals(Object object) {
            PHPStructureItem pHPStructureItem;
            boolean bl = false;
            if (object instanceof PHPStructureItem && (pHPStructureItem = (PHPStructureItem)object).getName() != null && this.getName() != null) {
                bl = pHPStructureItem.modelElement.getName().equals(this.modelElement.getName()) && pHPStructureItem.modelElement.getOffset() == this.modelElement.getOffset();
            }
            return bl;
        }

        public int hashCode() {
            int n = 11;
            if (this.getName() != null) {
                n = 31 * this.getName().hashCode() + n;
            }
            n = (int)(31L * this.getPosition() + (long)n);
            return n;
        }

        public String getName() {
            return this.modelElement.getName();
        }

        public String getSortText() {
            return this.sortPrefix + this.modelElement.getName();
        }

        public ElementHandle getElementHandle() {
            return this.modelElement.getPHPElement();
        }

        public ModelElement getModelElement() {
            return this.modelElement;
        }

        public ElementKind getKind() {
            return this.modelElement.getPHPElement().getKind();
        }

        public Set<Modifier> getModifiers() {
            return this.modelElement.getPHPElement().getModifiers();
        }

        public boolean isLeaf() {
            return this.children.size() == 0;
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.children;
        }

        public long getPosition() {
            return this.modelElement.getOffset();
        }

        public long getEndPosition() {
            OffsetRange offsetRange;
            if (this.modelElement instanceof Scope && (offsetRange = ((Scope)this.modelElement).getBlockRange()) != null) {
                return offsetRange.getEnd();
            }
            return this.modelElement.getNameRange().getEnd();
        }

        public ImageIcon getCustomIcon() {
            return null;
        }

        protected void appendInterfeas(Collection<? extends String> collection, HtmlFormatter htmlFormatter) {
            boolean bl = true;
            for (String string : collection) {
                if (string == null) continue;
                if (!bl) {
                    htmlFormatter.appendText(", ");
                } else {
                    bl = false;
                }
                htmlFormatter.appendText(string);
            }
        }

        protected void appendFunctionDescription(FunctionScope functionScope, HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            if (functionScope == null) {
                return;
            }
            htmlFormatter.appendText(functionScope.getName());
            htmlFormatter.appendText("(");
            List<? extends Parameter> list = functionScope.getParameters();
            if (list != null && list.size() > 0) {
                boolean bl = true;
                for (Parameter object : list) {
                    String string = object.getName();
                    List<QualifiedName> list2 = object.getTypes();
                    if (string == null) continue;
                    if (!bl) {
                        htmlFormatter.appendText(", ");
                    }
                    if (!list2.isEmpty()) {
                        htmlFormatter.appendHtml(PhpStructureScanner.FONT_GRAY_COLOR);
                        Iterator<QualifiedName> iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            QualifiedName qualifiedName = iterator.next();
                            htmlFormatter.appendText(qualifiedName.toName().toString());
                            if (!iterator.hasNext()) continue;
                            htmlFormatter.appendText("|");
                        }
                        htmlFormatter.appendText(" ");
                        htmlFormatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
                    }
                    htmlFormatter.appendText(string);
                    bl = false;
                }
            }
            htmlFormatter.appendText(")");
            Collection<? extends String> collection = functionScope.getReturnTypeNames();
            if (!collection.isEmpty()) {
                htmlFormatter.appendHtml("<font color=\"#999999\">:");
                Object object = null;
                for (String string : collection) {
                    if (object == null) {
                        object = new StringBuilder();
                    } else {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append(string);
                }
                htmlFormatter.appendText(((StringBuilder)object).toString());
                htmlFormatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
            }
        }
    }

    private class PHPUseStructureItem
    extends PHPStructureItem {
        public PHPUseStructureItem(UseElement useElement) {
            super(useElement, null, "aaaa_use");
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            htmlFormatter.appendText(this.getName());
            UseElement useElement = (UseElement)this.getElementHandle();
            if (useElement.getAliasName() != null) {
                htmlFormatter.appendText(" as ");
                htmlFormatter.appendText(useElement.getAliasName());
            }
            return htmlFormatter.getText();
        }

        public ElementKind getKind() {
            return ElementKind.RULE;
        }
    }
}

