/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.core.UiUtils;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PHPCompletionItem;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassMemberElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.PHPHintsProvider;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroduceHint
extends AbstractRule {
    public String getId() {
        return "Introduce.Hint";
    }

    public String getDescription() {
        return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintDispName");
    }

    @Override
    void computeHintsImpl(PHPRuleContext pHPRuleContext, List<Hint> list, PHPHintsProvider.Kind kind) throws BadLocationException {
        PHPParseResult pHPParseResult = (PHPParseResult)pHPRuleContext.parserResult;
        if (pHPParseResult.getProgram() == null) {
            return;
        }
        BaseDocument baseDocument = pHPRuleContext.doc;
        int n = pHPRuleContext.caretOffset;
        int n2 = -1;
        int n3 = -1;
        n2 = n > 0 ? Utilities.getRowStart((BaseDocument)baseDocument, (int)n) : -1;
        int n4 = n3 = n2 != -1 ? Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) : -1;
        if (n2 != -1 && n3 != -1 && n > n2) {
            Model model = pHPParseResult.getModel();
            IntroduceFixVisitor introduceFixVisitor = new IntroduceFixVisitor(model, n2, n3);
            pHPParseResult.getProgram().accept(introduceFixVisitor);
            IntroduceFix introduceFix = introduceFixVisitor.getIntroduceFix();
            if (introduceFix != null) {
                list.add(new Hint((Rule)this, this.getDisplayName(), pHPRuleContext.parserResult.getSnapshot().getSource().getFileObject(), introduceFix.getOffsetRange(), Collections.singletonList(introduceFix), 500));
            }
        }
    }

    private static boolean isInside(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    private static boolean isBefore(int n, int n2) {
        return n <= n2;
    }

    private static String getParameters(List<Expression> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Expression expression = list.get(i);
            String string = null;
            if (expression instanceof Variable) {
                string = CodeUtils.extractVariableName((Variable)expression);
            }
            if (string == null) {
                string = String.format("$param%d", i);
            }
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static int getOffset(BaseDocument baseDocument, TypeScope typeScope, PhpKind phpKind) throws BadLocationException {
        int n = -1;
        HashSet<ClassMemberElement> hashSet = new HashSet<ClassMemberElement>();
        switch (phpKind) {
            case CLASS_CONSTANT: {
                hashSet.addAll(typeScope.getDeclaredConstants());
                break;
            }
            case METHOD: 
            case FIELD: {
                hashSet.addAll(typeScope.getDeclaredConstants());
                if (!(typeScope instanceof ClassScope)) break;
                ClassScope classScope = (ClassScope)typeScope;
                hashSet.addAll(classScope.getDeclaredFields());
            }
        }
        for (ModelElement modelElement : hashSet) {
            if (modelElement.getOffset() <= n) continue;
            n = modelElement.getOffset();
        }
        n = n != -1 ? Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) : IntroduceHint.getClassCurlyOpenOffset(baseDocument, typeScope.getOffset());
        return n;
    }

    private static int getClassCurlyOpenOffset(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = n;
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n2);
        if (tokenSequence != null) {
            tokenSequence.move(n2);
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                if (token.id() != PHPTokenId.PHP_CURLY_OPEN) continue;
                n2 = tokenSequence.offset();
                break;
            }
        }
        return Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2);
    }

    private static class IntroduceClassConstantFix
    extends IntroduceFix {
        private TypeScope type;
        private String templ;
        private String constantName;

        public IntroduceClassConstantFix(BaseDocument baseDocument, StaticConstantAccess staticConstantAccess, TypeScope typeScope) {
            super(baseDocument, staticConstantAccess);
            this.type = typeScope;
            this.constantName = staticConstantAccess.getConstant().getName();
            this.templ = String.format("const %s = \"\";", this.constantName);
        }

        public void implement() throws Exception {
            int n = this.getOffset();
            EditList editList = new EditList(this.doc);
            editList.replace(n, 0, "\n" + this.templ, true, 0);
            editList.apply();
            n = Utilities.getRowEnd((BaseDocument)this.doc, (int)(n + 1)) - 2;
            UiUtils.open((FileObject)this.type.getFileObject(), (int)n);
        }

        public String getDescription() {
            String string = this.type.getName();
            String string2 = this.type.getFileObject().getNameExt();
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintClassConstDesc", (Object)this.constantName, (Object)string, (Object)string2);
        }

        int getOffset() throws BadLocationException {
            return IntroduceHint.getOffset(this.doc, this.type, PhpKind.CLASS_CONSTANT);
        }
    }

    private static class IntroduceClassFix
    extends IntroduceFix {
        private Model model;
        private String clsName;
        private FileObject folder;
        private FileObject template;

        static IntroduceClassFix getInstance(String string, Model model, ClassInstanceCreation classInstanceCreation) {
            FileObject fileObject = model.getFileScope().getFileObject();
            FileObject fileObject2 = fileObject.getParent();
            String string2 = "Templates/Scripting/PHPClass";
            FileObject fileObject3 = FileUtil.getConfigFile((String)string2);
            return fileObject3 != null && fileObject2 != null && fileObject2.canWrite() ? new IntroduceClassFix(string, fileObject3, fileObject2, model, classInstanceCreation) : null;
        }

        IntroduceClassFix(String string, FileObject fileObject, FileObject fileObject2, Model model, ClassInstanceCreation classInstanceCreation) {
            super(null, classInstanceCreation);
            this.model = model;
            this.clsName = string;
            this.template = fileObject;
            this.folder = fileObject2;
        }

        public void implement() throws Exception {
            final DataFolder dataFolder = DataFolder.findFolder((FileObject)this.folder);
            final DataObject dataObject = DataObject.find((FileObject)this.template);
            final FileObject[] fileObjectArray = new FileObject[1];
            FileUtil.runAtomicAction((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, IntroduceClassFix.this.clsName);
                        fileObjectArray[0] = dataObject2.getPrimaryFile();
                        FileObject fileObject = fileObjectArray[0];
                        FileLock fileLock = fileObject.lock();
                        try {
                            fileObject.rename(fileLock, fileObject.getName(), "php");
                        }
                        finally {
                            fileLock.releaseLock();
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            });
            if (fileObjectArray[0] != null) {
                UiUtils.open((FileObject)fileObjectArray[0], (int)0);
            }
        }

        public String getDescription() {
            String string = FileUtil.getFileDisplayName((FileObject)this.folder);
            int n = string.length();
            if (n > 30) {
                int n2 = (string = string.substring(n - 30)).indexOf("/");
                if (n2 != -1) {
                    string = string.substring(n2);
                }
                string = String.format("...%s/%s.php", string, this.clsName);
            }
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintClassDesc", (Object)this.clsName, (Object)string);
        }
    }

    private static class IntroduceFieldFix
    extends IntroduceFix {
        private ClassScope clz;
        private String templ;
        private String fieldName;

        public IntroduceFieldFix(BaseDocument baseDocument, FieldAccess fieldAccess, ClassScope classScope) {
            super(baseDocument, fieldAccess);
            this.clz = classScope;
            this.templ = this.createTemplate();
        }

        public void implement() throws Exception {
            int n = this.getOffset();
            EditList editList = new EditList(this.doc);
            editList.replace(n, 0, "\n" + this.templ, true, 0);
            editList.apply();
            n = Utilities.getRowEnd((BaseDocument)this.doc, (int)(n + 1)) - 2;
            UiUtils.open((FileObject)this.clz.getFileObject(), (int)n);
        }

        public String getDescription() {
            String string = this.clz.getName();
            String string2 = this.clz.getFileObject().getNameExt();
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintFieldDesc", (Object)this.templ, (Object)string, (Object)string2);
        }

        int getOffset() throws BadLocationException {
            return IntroduceHint.getOffset(this.doc, this.clz, PhpKind.FIELD);
        }

        private String createTemplate() {
            Variable variable = ((FieldAccess)this.node).getField();
            this.fieldName = CodeUtils.extractVariableName(variable);
            if (!variable.isDollared()) {
                this.fieldName = "$" + this.fieldName;
            }
            return String.format("public %s = \"\";", this.fieldName);
        }
    }

    static abstract class IntroduceFix
    implements HintFix {
        BaseDocument doc;
        ASTNode node;

        public IntroduceFix(BaseDocument baseDocument, ASTNode aSTNode) {
            this.doc = baseDocument;
            this.node = aSTNode;
        }

        OffsetRange getOffsetRange() {
            return new OffsetRange(this.node.getStartOffset(), this.node.getEndOffset());
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean isSafe() {
            return true;
        }
    }

    private class IntroduceFixVisitor
    extends DefaultTreePathVisitor {
        private int lineBegin;
        private int lineEnd;
        private IntroduceFix fix;
        private Model model;

        IntroduceFixVisitor(Model model, int n, int n2) {
            this.lineBegin = n;
            this.lineEnd = n2;
            this.model = model;
        }

        public void scan(ASTNode aSTNode) {
            if (aSTNode != null && IntroduceHint.isBefore(aSTNode.getStartOffset(), this.lineEnd)) {
                super.scan(aSTNode);
            }
        }

        public void visit(ClassInstanceCreation classInstanceCreation) {
            if (IntroduceHint.isInside(classInstanceCreation.getStartOffset(), this.lineBegin, this.lineEnd)) {
                String string = CodeUtils.extractClassName(classInstanceCreation.getClassName());
                string = string != null && string.trim().length() > 0 ? string : null;
                PHPIndex pHPIndex = this.model.getIndexScope().getIndex();
                Collection<Object> collection = Collections.emptyList();
                if (string != null) {
                    collection = pHPIndex.getClasses(null, string, QuerySupport.Kind.EXACT);
                }
                if (string != null && collection.isEmpty()) {
                    IndexedClass indexedClass;
                    IndexedClass indexedClass2 = indexedClass = string != null ? this.getIndexedClass(string) : null;
                    if (indexedClass == null && string != null) {
                        this.fix = IntroduceClassFix.getInstance(string, this.model, classInstanceCreation);
                    }
                }
            }
            super.visit(classInstanceCreation);
        }

        public void visit(MethodInvocation methodInvocation) {
            Collection<? extends TypeScope> collection;
            String string;
            if (IntroduceHint.isInside(methodInvocation.getStartOffset(), this.lineBegin, this.lineEnd) && (string = CodeUtils.extractFunctionName(methodInvocation.getMethod())) != null && (collection = ModelUtils.resolveType(this.model, methodInvocation)).size() == 1) {
                TypeScope typeScope = ModelUtils.getFirst(collection);
                PHPIndex pHPIndex = this.model.getIndexScope().getIndex();
                Collection<IndexedFunction> collection2 = PHPIndex.toMembers(pHPIndex.getAllMethods(null, typeScope.getName(), string, QuerySupport.Kind.EXACT, -1));
                if (collection2.isEmpty()) {
                    BaseDocument baseDocument;
                    FileObject fileObject = typeScope.getFileObject();
                    BaseDocument baseDocument2 = baseDocument = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)true) : null;
                    if (baseDocument != null && fileObject.canWrite()) {
                        this.fix = new IntroduceMethodFix(baseDocument, methodInvocation, typeScope);
                    }
                }
            }
            super.visit(methodInvocation);
        }

        public void visit(StaticMethodInvocation staticMethodInvocation) {
            if (IntroduceHint.isInside(staticMethodInvocation.getStartOffset(), this.lineBegin, this.lineEnd)) {
                Collection<? extends TypeScope> collection;
                String string = CodeUtils.extractFunctionName(staticMethodInvocation.getMethod());
                String string2 = CodeUtils.extractUnqualifiedClassName(staticMethodInvocation);
                if (string2 != null && (collection = ModelUtils.resolveType(this.model, staticMethodInvocation)).size() == 1) {
                    TypeScope typeScope = ModelUtils.getFirst(collection);
                    PHPIndex pHPIndex = this.model.getIndexScope().getIndex();
                    Collection<IndexedFunction> collection2 = PHPIndex.toMembers(pHPIndex.getAllMethods(null, typeScope.getName(), string, QuerySupport.Kind.EXACT, -1));
                    if (collection2.isEmpty()) {
                        BaseDocument baseDocument;
                        FileObject fileObject = typeScope.getFileObject();
                        BaseDocument baseDocument2 = baseDocument = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)true) : null;
                        if (baseDocument != null && fileObject.canWrite()) {
                            this.fix = new IntroduceStaticMethodFix(baseDocument, staticMethodInvocation, typeScope);
                        }
                    }
                }
            }
            super.visit(staticMethodInvocation);
        }

        public void visit(FieldAccess fieldAccess) {
            Collection<? extends TypeScope> collection;
            String string;
            if (IntroduceHint.isInside(fieldAccess.getStartOffset(), this.lineBegin, this.lineEnd) && (string = CodeUtils.extractVariableName(fieldAccess.getField())) != null && (collection = ModelUtils.resolveType(this.model, fieldAccess)).size() == 1) {
                TypeScope typeScope = ModelUtils.getFirst(collection);
                PHPIndex pHPIndex = this.model.getIndexScope().getIndex();
                Collection<IndexedConstant> collection2 = PHPIndex.toMembers(pHPIndex.getAllFields(null, typeScope.getName(), string, QuerySupport.Kind.EXACT, -1));
                if (collection2.isEmpty()) {
                    BaseDocument baseDocument;
                    FileObject fileObject = typeScope.getFileObject();
                    BaseDocument baseDocument2 = baseDocument = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)false) : null;
                    if (baseDocument != null && fileObject.canWrite() && typeScope instanceof ClassScope) {
                        this.fix = new IntroduceFieldFix(baseDocument, fieldAccess, (ClassScope)typeScope);
                    }
                }
            }
            super.visit(fieldAccess);
        }

        public void visit(StaticFieldAccess staticFieldAccess) {
            if (IntroduceHint.isInside(staticFieldAccess.getStartOffset(), this.lineBegin, this.lineEnd)) {
                Variable variable = staticFieldAccess.getField();
                String string = CodeUtils.extractUnqualifiedClassName(staticFieldAccess);
                if (string != null) {
                    Collection<? extends TypeScope> collection;
                    String string2 = CodeUtils.extractVariableName(variable);
                    if (string2 == null) {
                        return;
                    }
                    if (string2.startsWith("$")) {
                        string2 = string2.substring(1);
                    }
                    if ((collection = ModelUtils.resolveType(this.model, staticFieldAccess)).size() == 1) {
                        TypeScope typeScope = ModelUtils.getFirst(collection);
                        PHPIndex pHPIndex = this.model.getIndexScope().getIndex();
                        Collection<IndexedConstant> collection2 = PHPIndex.toMembers(pHPIndex.getAllFields(null, typeScope.getName(), string2, QuerySupport.Kind.EXACT, -1));
                        if (collection2.isEmpty()) {
                            BaseDocument baseDocument;
                            FileObject fileObject = typeScope.getFileObject();
                            BaseDocument baseDocument2 = baseDocument = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)false) : null;
                            if (baseDocument != null && fileObject.canWrite() && typeScope instanceof ClassScope) {
                                this.fix = new IntroduceStaticFieldFix(baseDocument, staticFieldAccess, (ClassScope)typeScope);
                            }
                        }
                    }
                }
            }
            super.visit(staticFieldAccess);
        }

        public void visit(StaticConstantAccess staticConstantAccess) {
            if (IntroduceHint.isInside(staticConstantAccess.getStartOffset(), this.lineBegin, this.lineEnd)) {
                Collection<? extends TypeScope> collection;
                String string = staticConstantAccess.getConstant().getName();
                String string2 = CodeUtils.extractUnqualifiedClassName(staticConstantAccess);
                if (string2 != null && string != null && (collection = ModelUtils.resolveType(this.model, staticConstantAccess)).size() == 1) {
                    TypeScope typeScope = ModelUtils.getFirst(collection);
                    PHPIndex pHPIndex = this.model.getIndexScope().getIndex();
                    Collection<IndexedConstant> collection2 = PHPIndex.toMembers(pHPIndex.getAllTypeConstants(null, typeScope.getName(), string, QuerySupport.Kind.EXACT));
                    if (collection2.isEmpty()) {
                        BaseDocument baseDocument;
                        FileObject fileObject = typeScope.getFileObject();
                        BaseDocument baseDocument2 = baseDocument = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)false) : null;
                        if (baseDocument != null && fileObject.canWrite()) {
                            this.fix = new IntroduceClassConstantFix(baseDocument, staticConstantAccess, typeScope);
                        }
                    }
                }
            }
            super.visit(staticConstantAccess);
        }

        public IntroduceFix getIntroduceFix() {
            return this.fix;
        }

        private IndexedClass getIndexedClass(String string) {
            Object object;
            IndexedClass indexedClass = null;
            PHPIndex pHPIndex = this.model.getIndexScope().getIndex();
            Collection<Object> collection = Collections.emptyList();
            if ("self".equals(string) || "parent".equals(string)) {
                object = this.getPath();
                Iterator<ASTNode> iterator = object.iterator();
                while (iterator.hasNext()) {
                    ASTNode aSTNode = iterator.next();
                    if (!(aSTNode instanceof ClassDeclaration)) continue;
                    collection = pHPIndex.getClasses(null, CodeUtils.extractClassName((ClassDeclaration)aSTNode), QuerySupport.Kind.EXACT);
                    break;
                }
            } else {
                collection = pHPIndex.getClasses(null, string, QuerySupport.Kind.EXACT);
            }
            if (collection.size() == 1) {
                indexedClass = (IndexedClass)collection.iterator().next();
                if ("parent".equals(string) && (object = indexedClass.getSuperClass()) != null) {
                    collection = pHPIndex.getClasses(null, (String)object, QuerySupport.Kind.EXACT);
                    indexedClass = collection.size() == 1 ? (IndexedClass)collection.iterator().next() : null;
                }
            }
            return indexedClass;
        }
    }

    private static class IntroduceMethodFix
    extends IntroduceFix {
        private TypeScope type;
        private MethodDeclarationItem item;

        public IntroduceMethodFix(BaseDocument baseDocument, MethodInvocation methodInvocation, TypeScope typeScope) {
            super(baseDocument, methodInvocation);
            this.type = typeScope;
            this.item = IntroduceMethodFix.createMethodDeclarationItem(methodInvocation);
        }

        public void implement() throws Exception {
            int n = this.getOffset();
            EditList editList = new EditList(this.doc);
            editList.replace(n, 0, "\n" + this.item.getCustomInsertTemplate(), true, 0);
            editList.apply();
            n = Utilities.getRowEnd((BaseDocument)this.doc, (int)(n + 1));
            UiUtils.open((FileObject)this.type.getFileObject(), (int)(Utilities.getRowEnd((BaseDocument)this.doc, (int)(n + 1)) - 1));
        }

        public String getDescription() {
            String string = this.type.getName();
            String string2 = this.type.getFileObject().getNameExt();
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintMethodDesc", (Object)this.item.getFunction().getFunctionSignature(true), (Object)string, (Object)string2);
        }

        static MethodDeclarationItem createMethodDeclarationItem(MethodInvocation methodInvocation) {
            return new MethodDeclarationItem(methodInvocation, 0);
        }

        int getOffset() throws BadLocationException {
            return IntroduceHint.getOffset(this.doc, this.type, PhpKind.METHOD);
        }
    }

    private static class IntroduceStaticFieldFix
    extends IntroduceFix {
        private ClassScope clz;
        private String templ;
        private String fieldName;

        public IntroduceStaticFieldFix(BaseDocument baseDocument, StaticFieldAccess staticFieldAccess, ClassScope classScope) {
            super(baseDocument, staticFieldAccess);
            this.clz = classScope;
            this.templ = this.createTemplate();
        }

        public void implement() throws Exception {
            int n = this.getOffset();
            EditList editList = new EditList(this.doc);
            editList.replace(n, 0, "\n" + this.templ, true, 0);
            editList.apply();
            n = Utilities.getRowEnd((BaseDocument)this.doc, (int)(n + 1)) - 2;
            UiUtils.open((FileObject)this.clz.getFileObject(), (int)n);
        }

        public String getDescription() {
            String string = this.clz.getName();
            String string2 = this.clz.getFileObject().getNameExt();
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintStaticFieldDesc", (Object)this.fieldName, (Object)string, (Object)string2);
        }

        int getOffset() throws BadLocationException {
            return IntroduceHint.getOffset(this.doc, this.clz, PhpKind.FIELD);
        }

        private String createTemplate() {
            Variable variable = ((StaticFieldAccess)this.node).getField();
            this.fieldName = CodeUtils.extractVariableName(variable);
            if (!variable.isDollared()) {
                this.fieldName = "$" + this.fieldName;
            }
            return String.format("static %s = \"\";", this.fieldName);
        }
    }

    private static class IntroduceStaticMethodFix
    extends IntroduceFix {
        private TypeScope type;
        private MethodDeclarationItem item;

        public IntroduceStaticMethodFix(BaseDocument baseDocument, StaticMethodInvocation staticMethodInvocation, TypeScope typeScope) {
            super(baseDocument, staticMethodInvocation);
            this.type = typeScope;
            this.item = IntroduceStaticMethodFix.createMethodDeclarationItem(staticMethodInvocation);
        }

        public void implement() throws Exception {
            int n = this.getOffset();
            EditList editList = new EditList(this.doc);
            editList.replace(n, 0, "\n" + this.item.getCustomInsertTemplate(), true, 0);
            editList.apply();
            n = Utilities.getRowEnd((BaseDocument)this.doc, (int)(n + 1));
            UiUtils.open((FileObject)this.type.getFileObject(), (int)(Utilities.getRowEnd((BaseDocument)this.doc, (int)(n + 1)) - 1));
        }

        public String getDescription() {
            String string = this.type.getName();
            String string2 = this.type.getFileObject().getNameExt();
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintStaticMethodDesc", (Object)this.item.getFunction().getFunctionSignature(true), (Object)string, (Object)string2);
        }

        static MethodDeclarationItem createMethodDeclarationItem(StaticMethodInvocation staticMethodInvocation) {
            return new MethodDeclarationItem(staticMethodInvocation, 8);
        }

        int getOffset() throws BadLocationException {
            return IntroduceHint.getOffset(this.doc, this.type, PhpKind.METHOD);
        }
    }

    private static class MethodDeclarationItem
    extends PHPCompletionItem.FunctionDeclarationItem {
        MethodDeclarationItem(MethodInvocation methodInvocation, int n) {
            super(PredefinedSymbols.createMagicFunction(CodeUtils.extractFunctionName(methodInvocation.getMethod()), IntroduceHint.getParameters(methodInvocation.getMethod().getParameters()), 0), null, n, false);
        }

        MethodDeclarationItem(StaticMethodInvocation staticMethodInvocation, int n) {
            super(PredefinedSymbols.createMagicFunction(CodeUtils.extractFunctionName(staticMethodInvocation.getMethod()), IntroduceHint.getParameters(staticMethodInvocation.getMethod().getParameters()), n), null, 0, false);
        }

        protected String getFunctionBodyForTemplate() {
            return "\n";
        }
    }
}

