/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting;
import org.netbeans.modules.editor.lib2.search.EditorFindSupport;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class TextSearchHighlighting
extends AbstractHighlightsContainer
implements PropertyChangeListener,
HighlightsChangeListener,
DocumentListener {
    private static final Logger LOG = Logger.getLogger(TextSearchHighlighting.class.getName());
    public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.TextSearchHighlighting";
    private static final RequestProcessor RP = new RequestProcessor("org.netbeans.modules.editor.lib2.highlighting.TextSearchHighlighting");
    private final MimePath mimePath;
    private final JTextComponent component;
    private final Document document;
    private final OffsetsBag bag;

    public TextSearchHighlighting(JTextComponent jTextComponent) {
        String string = BlockHighlighting.getMimeType(jTextComponent);
        this.mimePath = string == null ? MimePath.EMPTY : MimePath.parse((String)string);
        this.component = jTextComponent;
        this.document = jTextComponent.getDocument();
        this.document.addDocumentListener(WeakListeners.document((DocumentListener)this, (Object)this.document));
        this.bag = new OffsetsBag(this.document);
        this.bag.addHighlightsChangeListener(this);
        EditorFindSupport.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)EditorFindSupport.getInstance()));
        this.fillInTheBag();
    }

    public HighlightsSequence getHighlights(int n, int n2) {
        return this.bag.getHighlights(n, n2);
    }

    public void highlightChanged(HighlightsChangeEvent highlightsChangeEvent) {
        this.fireHighlightsChange(highlightsChangeEvent.getStartOffset(), highlightsChangeEvent.getEndOffset());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == null || "find-what".equals(propertyChangeEvent.getPropertyName()) || "find-highlight-search".equals(propertyChangeEvent.getPropertyName())) {
            this.fillInTheBag();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.bag.removeHighlights(Math.max(documentEvent.getOffset() - 1, 0), Math.min(documentEvent.getOffset() + 1, this.document.getLength()), false);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.bag.removeHighlights(documentEvent.getOffset(), documentEvent.getOffset() + documentEvent.getLength(), false);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void fillInTheBag() {
        final Document document = this.document;
        final OffsetsBag offsetsBag = this.bag;
        RP.post(new Runnable(){
            private boolean documentLocked = false;

            public void run() {
                if (!this.documentLocked) {
                    this.documentLocked = true;
                    document.render(this);
                    return;
                }
                OffsetsBag offsetsBag2 = new OffsetsBag(document);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("TSH: filling the bag; enabled = " + TextSearchHighlighting.this.isEnabled());
                }
                if (TextSearchHighlighting.this.isEnabled()) {
                    try {
                        int[] nArray = EditorFindSupport.getInstance().getBlocks(new int[]{-1, -1}, document, 0, document.getLength());
                        assert (nArray.length % 2 == 0) : "Wrong number of block offsets";
                        AttributeSet attributeSet = TextSearchHighlighting.this.getAttribs();
                        for (int i = 0; i < nArray.length / 2; ++i) {
                            offsetsBag2.addHighlight(nArray[2 * i], nArray[2 * i + 1], attributeSet);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        LOG.log(Level.WARNING, badLocationException.getMessage(), badLocationException);
                    }
                }
                offsetsBag.setHighlights(offsetsBag2);
            }
        });
    }

    private boolean isEnabled() {
        Object object = EditorFindSupport.getInstance().getFindProperty("find-highlight-search");
        return object instanceof Boolean && (Boolean)object != false;
    }

    private AttributeSet getAttribs() {
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)this.mimePath).lookup(FontColorSettings.class);
        AttributeSet attributeSet = fontColorSettings.getFontColors("highlight-search");
        return attributeSet == null ? SimpleAttributeSet.EMPTY : attributeSet;
    }
}

