/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.loader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.api.sql.execute.SQLExecuteCookie;
import org.netbeans.modules.db.core.SQLCoreUILogger;
import org.netbeans.modules.db.dataview.api.DataView;
import org.netbeans.modules.db.dataview.api.DataViewPageContext;
import org.netbeans.modules.db.sql.execute.SQLExecuteHelper;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;
import org.netbeans.modules.db.sql.loader.SQLCloneableEditor;
import org.netbeans.modules.db.sql.loader.SQLDataObject;
import org.netbeans.modules.db.sql.loader.SQLExecutionLoggerImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.CloneableOpenSupport;

public class SQLEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie,
SQLExecuteCookie,
CloseCookie {
    private static final Logger LOGGER = Logger.getLogger(SQLEditorSupport.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    static final String EDITOR_CONTAINER = "sqlEditorContainer";
    private static final String MIME_TYPE = "text/x-sql";
    private final PropertyChangeSupport sqlPropChangeSupport = new PropertyChangeSupport(this);
    private final RequestProcessor rp = new RequestProcessor("SQLExecution", 1, true);
    private DatabaseConnection dbconn;
    private boolean executing;
    private SQLExecutionResults executionResults;
    private SQLExecutionLoggerImpl logger;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            SQLEditorSupport.this.saveDocument();
        }
    };

    public SQLEditorSupport(SQLDataObject sQLDataObject) {
        super((DataObject)sQLDataObject, (CloneableEditorSupport.Env)new Environment(sQLDataObject));
        this.setMIMEType(MIME_TYPE);
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        if (!this.isConsole()) {
            FileObject fileObject = this.getDataObject().getPrimaryFile();
            SQLDataObject sQLDataObject = (SQLDataObject)this.getDataObject();
            if (sQLDataObject.getCookie(SaveCookie.class) == null) {
                sQLDataObject.addCookie((Node.Cookie)this.saveCookie);
                sQLDataObject.setModified(true);
            }
        }
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        SQLDataObject sQLDataObject = (SQLDataObject)this.getDataObject();
        Node.Cookie cookie = sQLDataObject.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            sQLDataObject.removeCookie((Node.Cookie)this.saveCookie);
            sQLDataObject.setModified(false);
        }
    }

    protected String messageToolTip() {
        if (this.isConsole()) {
            return this.getDataObject().getPrimaryFile().getName();
        }
        return super.messageToolTip();
    }

    protected String messageName() {
        if (!this.isValid()) {
            return "";
        }
        if (this.isConsole()) {
            return this.getDataObject().getName();
        }
        return super.messageName();
    }

    protected String messageHtmlName() {
        if (!this.isValid()) {
            return "";
        }
        if (this.isConsole()) {
            String string = this.getDataObject().getName();
            if (string != null && !string.startsWith("<html>")) {
                string = "<html>" + string;
            }
            return string;
        }
        return super.messageHtmlName();
    }

    protected void notifyClosed() {
        super.notifyClosed();
        this.closeExecutionResult();
        this.closeLogger();
        if (this.isConsole() && this.isValid()) {
            try {
                this.getDataObject().delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    protected boolean canClose() {
        if (this.isConsole()) {
            return true;
        }
        return super.canClose();
    }

    boolean isConsole() {
        return ((SQLDataObject)this.getDataObject()).isConsole();
    }

    boolean isValid() {
        return this.getDataObject().isValid();
    }

    protected CloneableEditor createCloneableEditor() {
        return new SQLCloneableEditor(this);
    }

    protected Component wrapEditorComponent(Component component) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setName(EDITOR_CONTAINER);
        jPanel.add(component, "Center");
        return jPanel;
    }

    public void open() {
        SQLCoreUILogger.logEditorOpened();
        super.open();
    }

    public void edit() {
        SQLCoreUILogger.logEditorOpened();
        super.edit();
    }

    void addSQLPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.sqlPropChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    void removeSQLPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.sqlPropChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    synchronized DatabaseConnection getActiveDatabaseConnection() {
        return this.dbconn;
    }

    public synchronized void setDatabaseConnection(DatabaseConnection databaseConnection) {
        this.dbconn = databaseConnection;
        this.sqlPropChangeSupport.firePropertyChange("databaseConnection", null, null);
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.dbconn;
    }

    public void execute() {
        StyledDocument styledDocument = this.getDocument();
        if (styledDocument == null) {
            return;
        }
        String string = null;
        try {
            string = styledDocument.getText(0, styledDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger("global").log(Level.INFO, null, badLocationException);
            string = "";
        }
        this.execute(string, 0, string.length());
    }

    public void saveAs(FileObject fileObject, String string) throws IOException {
        String string2 = FileUtil.getFileDisplayName((FileObject)fileObject) + File.separator + string;
        File file = FileUtil.normalizeFile((File)new File(string2));
        if (file.exists()) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(SQLEditorSupport.class, (String)"MSG_ConfirmReplace", (Object)string), NbBundle.getMessage(SQLEditorSupport.class, (String)"MSG_ConfirmReplaceFileTitle"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (!confirmation.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                return;
            }
        }
        if (this.isConsole()) {
            this.saveDocument();
        }
        super.saveAs(fileObject, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(String string, int n, int n2) {
        DatabaseConnection databaseConnection;
        Object object = this;
        synchronized (object) {
            databaseConnection = this.dbconn;
        }
        if (databaseConnection == null) {
            return;
        }
        object = new SQLExecutor(this, databaseConnection, string, n, n2);
        RequestProcessor.Task task = this.rp.create((Runnable)object);
        ((SQLExecutor)object).setTask(task);
        task.schedule(0);
    }

    synchronized boolean isExecuting() {
        return this.executing;
    }

    private synchronized void setExecuting(boolean bl) {
        this.executing = bl;
        this.sqlPropChangeSupport.firePropertyChange("executing", null, null);
    }

    private void setResultsToEditors(final SQLExecutionResults sQLExecutionResults) {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                ArrayList<Component> arrayList = null;
                if (sQLExecutionResults != null) {
                    arrayList = new ArrayList<Component>();
                    for (SQLExecutionResult object : sQLExecutionResults.getResults()) {
                        for (Component component : object.getDataView().createComponents()) {
                            arrayList.add(component);
                        }
                    }
                }
                Enumeration enumeration = SQLEditorSupport.this.allEditors.getComponents();
                while (enumeration.hasMoreElements()) {
                    SQLCloneableEditor sQLCloneableEditor = (SQLCloneableEditor)((Object)enumeration.nextElement());
                    sQLCloneableEditor.setResults(arrayList);
                }
            }
        });
    }

    private void setExecutionResults(SQLExecutionResults sQLExecutionResults) {
        this.executionResults = sQLExecutionResults;
    }

    private void closeExecutionResult() {
        this.setResultsToEditors(null);
        Runnable runnable = new Runnable(){

            public void run() {
                if (SQLEditorSupport.this.executionResults != null) {
                    SQLEditorSupport.this.executionResults = null;
                }
            }
        };
        if (this.rp.isRequestProcessorThread()) {
            runnable.run();
        } else {
            this.rp.post(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLExecutionLoggerImpl createLogger() {
        this.closeLogger();
        String string = null;
        string = this.isConsole() ? this.getDataObject().getName() : this.getDataObject().getNodeDelegate().getDisplayName();
        SQLEditorSupport sQLEditorSupport = this;
        synchronized (sQLEditorSupport) {
            this.logger = new SQLExecutionLoggerImpl(string, (LineCookie)this);
        }
        return this.logger;
    }

    private synchronized void closeLogger() {
        if (this.logger != null) {
            this.logger.close();
        }
    }

    static final class Environment
    extends DataEditorSupport.Env {
        public static final long serialVersionUID = 7968926994844480435L;
        private transient boolean modified = false;
        private transient FileLock fileLock;

        public Environment(SQLDataObject sQLDataObject) {
            super((DataObject)sQLDataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            MultiDataObject multiDataObject = (MultiDataObject)this.getDataObject();
            this.fileLock = multiDataObject.getPrimaryEntry().takeLock();
            return this.fileLock;
        }

        public void markModified() throws IOException {
            if (this.findSQLEditorSupport().isConsole()) {
                this.modified = true;
            } else {
                super.markModified();
            }
        }

        public void unmarkModified() {
            if (this.findSQLEditorSupport().isConsole()) {
                this.modified = false;
                if (this.fileLock != null && this.fileLock.isValid()) {
                    this.fileLock.releaseLock();
                }
            } else {
                super.unmarkModified();
            }
        }

        public boolean isModified() {
            if (this.findSQLEditorSupport().isConsole()) {
                return this.modified;
            }
            return super.isModified();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return this.findSQLEditorSupport();
        }

        private SQLEditorSupport findSQLEditorSupport() {
            return (SQLEditorSupport)this.getDataObject().getCookie(SQLEditorSupport.class);
        }
    }

    private static final class SQLExecutor
    implements Runnable,
    Cancellable {
        private final SQLEditorSupport parent;
        private final DatabaseConnection dbconn;
        private final String sql;
        private final int startOffset;
        private final int endOffset;
        private RequestProcessor.Task task;

        public SQLExecutor(SQLEditorSupport sQLEditorSupport, DatabaseConnection databaseConnection, String string, int n, int n2) {
            assert (sQLEditorSupport != null);
            assert (databaseConnection != null);
            assert (string != null);
            this.parent = sQLEditorSupport;
            this.dbconn = databaseConnection;
            this.sql = string;
            this.startOffset = n;
            this.endOffset = n2;
        }

        public void setTask(RequestProcessor.Task task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            assert (this.task != null) : "Should have called setTask()";
            this.parent.setExecuting(true);
            try {
                if (LOG) {
                    LOGGER.log(Level.FINE, "Started the SQL execution task");
                    LOGGER.log(Level.FINE, "Executing against " + this.dbconn);
                }
                Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

                    public Void run() {
                        ConnectionManager.getDefault().showConnectionDialog(SQLExecutor.this.dbconn);
                        return null;
                    }
                });
                Connection connection = this.dbconn.getJDBCConnection();
                if (LOG) {
                    LOGGER.log(Level.FINE, "SQL connection: " + connection);
                }
                if (connection == null) {
                    return;
                }
                try {
                    Mutex.EVENT.readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            SQLExecutor.this.parent.saveDocument();
                            return null;
                        }
                    });
                }
                catch (MutexException mutexException) {
                    Exceptions.printStackTrace((Throwable)mutexException.getException());
                    this.parent.setExecuting(false);
                    return;
                }
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutingStatements"), (Cancellable)this);
                progressHandle.start();
                try {
                    progressHandle.switchToIndeterminate();
                    this.setStatusText("");
                    if (LOG) {
                        LOGGER.log(Level.FINE, "Closing the old execution result");
                    }
                    int n = -1;
                    if (this.parent.executionResults != null && this.parent.executionResults.size() > 0) {
                        for (SQLExecutionResult object2 : this.parent.executionResults.getResults()) {
                            int n2 = DataViewPageContext.getPageSize((DataView)object2.getDataView());
                            n = n < n2 ? n2 : n;
                        }
                    }
                    if (n == -1) {
                        n = 20;
                    }
                    this.parent.closeExecutionResult();
                    SQLExecutionLoggerImpl sQLExecutionLoggerImpl = this.parent.createLogger();
                    SQLExecutionResults sQLExecutionResults = SQLExecuteHelper.execute(this.sql, this.startOffset, this.endOffset, this.dbconn, sQLExecutionLoggerImpl, n);
                    this.handleExecutionResults(sQLExecutionResults, sQLExecutionLoggerImpl);
                }
                finally {
                    progressHandle.finish();
                }
            }
            finally {
                this.parent.setExecuting(false);
            }
        }

        private void handleExecutionResults(SQLExecutionResults sQLExecutionResults, SQLExecutionLoggerImpl sQLExecutionLoggerImpl) {
            if (sQLExecutionResults == null) {
                this.setStatusText(NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutionCancelled"));
                return;
            }
            this.parent.setExecutionResults(sQLExecutionResults);
            if (sQLExecutionResults.size() <= 0) {
                this.setStatusText(NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutedSuccessfully"));
                return;
            }
            this.parent.setResultsToEditors(sQLExecutionResults);
            if (sQLExecutionResults.hasExceptions()) {
                this.setStatusText(NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutionFinishedWithErrors"));
            } else {
                this.setStatusText(NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutedSuccessfully"));
            }
        }

        private void setStatusText(String string) {
            StatusDisplayer.getDefault().setStatusText(string);
        }

        public boolean cancel() {
            return this.task.cancel();
        }
    }
}

