/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util.swing;

import javax.swing.event.DocumentEvent;
import javax.swing.text.Element;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.lib.editor.util.GapList;

public abstract class GapBranchElement
implements Element {
    protected static final Element[] EMPTY_ELEMENT_ARRAY = new Element[0];
    private final GapList children = new GapList();

    public int getElementCount() {
        return this.children.size();
    }

    public Element getElement(int n) {
        return (Element)this.children.get(n);
    }

    public void copyElements(int n, int n2, Element[] elementArray, int n3) {
        this.children.copyElements(n, n2, elementArray, n3);
    }

    public int getElementIndex(int n) {
        int n2 = 0;
        int n3 = this.getElementCount() - 1;
        if (n3 == -1) {
            return -1;
        }
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = this.getElement(n4).getStartOffset();
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    public boolean isLeaf() {
        return false;
    }

    protected void replace(int n, int n2, Element[] elementArray) {
        if (n2 > 0) {
            this.children.remove(n, n2);
        }
        if (elementArray != null) {
            this.children.addArray(n, elementArray);
        }
    }

    public String toString() {
        return this.children.toString();
    }

    public class Edit
    extends AbstractUndoableEdit
    implements DocumentEvent.ElementChange {
        private int index;
        private Element[] childrenAdded;
        private Element[] childrenRemoved;

        public Edit(int n, Element[] elementArray, Element[] elementArray2) {
            this.index = n;
            this.childrenRemoved = elementArray;
            this.childrenAdded = elementArray2;
        }

        public Element getElement() {
            return GapBranchElement.this;
        }

        public int getIndex() {
            return this.index;
        }

        public Element[] getChildrenRemoved() {
            return this.childrenRemoved;
        }

        public Element[] getChildrenAdded() {
            return this.childrenAdded;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            GapBranchElement.this.replace(this.index, this.childrenAdded.length, this.childrenRemoved);
            Element[] elementArray = this.childrenRemoved;
            this.childrenRemoved = this.childrenAdded;
            this.childrenAdded = elementArray;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Element[] elementArray = this.childrenRemoved;
            this.childrenRemoved = this.childrenAdded;
            this.childrenAdded = elementArray;
            GapBranchElement.this.replace(this.index, this.childrenRemoved.length, this.childrenAdded);
        }
    }

    public abstract class LastIndex {
        private int lastReturnedElementIndex;

        public int getElementIndex(int n) {
            int n2;
            int n3 = 0;
            int n4 = GapBranchElement.this.getElementCount() - 1;
            if (n4 == -1) {
                return -1;
            }
            int n5 = this.lastReturnedElementIndex;
            if (n5 >= n3 && n5 <= n4) {
                Element element = GapBranchElement.this.getElement(n5);
                n2 = element.getStartOffset();
                if (n >= n2) {
                    int n6 = element.getEndOffset();
                    if (n < n6) {
                        return n5;
                    }
                    n3 = n5 + 1;
                } else {
                    n4 = n5 - 1;
                }
            }
            while (n3 <= n4) {
                int n7 = (n3 + n4) / 2;
                n2 = ((Element)GapBranchElement.this.children.get(n7)).getStartOffset();
                if (n2 < n) {
                    n3 = n7 + 1;
                    continue;
                }
                if (n2 > n) {
                    n4 = n7 - 1;
                    continue;
                }
                this.lastReturnedElementIndex = n7;
                return n7;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            this.lastReturnedElementIndex = n4;
            return n4;
        }
    }
}

