/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.generator;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.XMLDataObject;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.modules.xml.lib.GuiUtil;
import org.netbeans.modules.xml.tools.generator.SelectFileDialog;
import org.netbeans.modules.xml.tools.generator.Util;
import org.netbeans.modules.xml.tools.generator.XMLGenerateCookie;
import org.netbeans.tax.TreeUtilities;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class GenerateDTDSupport
implements XMLGenerateCookie {
    static final String DTD_EXT = "dtd";
    private final DataObject template;
    private ElementInfo current;
    private Stack elementStack;
    private Map elementInfos;
    private String warning;
    private String rootQName;

    public GenerateDTDSupport(XMLDataObject xMLDataObject) {
        this.template = xMLDataObject;
        this.rootQName = null;
        this.warning = null;
        this.current = null;
    }

    public void generate() {
        try {
            SaveCookie saveCookie = (SaveCookie)this.template.getCookie(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
            FileObject fileObject = this.template.getPrimaryFile();
            String string = fileObject.getName();
            FileObject fileObject2 = fileObject.getParent();
            FileObject fileObject3 = new SelectFileDialog(fileObject2, string, DTD_EXT, Util.NONEMPTY_CHECK).getFileObject();
            string = fileObject3.getName();
            String string2 = EncodingUtil.getProjectEncoding((FileObject)fileObject);
            this.generateDTDContent(string2, string, fileObject3);
            GuiUtil.performDefaultAction((FileObject)fileObject3);
        }
        catch (UserCancelException userCancelException) {
        }
        catch (Exception exception) {
            GuiUtil.notifyException((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDTDContent(String string, String string2, FileObject fileObject) throws IOException {
        FileLock fileLock = null;
        Writer writer = null;
        try {
            String string3 = this.xml2dtd(string2, string);
            if (string3 == null) {
                String string4 = NbBundle.getMessage((Class)GenerateDTDSupport.class, (String)"BK0009");
                GuiUtil.notifyWarning((String)(string4 + "\n" + this.warning));
                return;
            }
            fileLock = fileObject.lock();
            string = TreeUtilities.iana2java((String)(string == null ? "UTF-8" : string));
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            try {
                writer = new OutputStreamWriter(outputStream, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                writer = new OutputStreamWriter(outputStream);
            }
            writer = new PrintWriter(writer);
            writer.write(string3.toString());
            fileLock.releaseLock();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    String xml2dtd(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.elementStack = new Stack();
        this.elementInfos = new LinkedHashMap(101);
        if (!this.scanTemplate()) {
            return null;
        }
        if (string2 != null) {
            stringBuffer.append("<?xml version='1.0' encoding='").append(string2).append("'?>\n\n");
        }
        String string3 = NbBundle.getMessage((Class)GenerateDTDSupport.class, (String)"TODO", (Object)(string + "." + DTD_EXT));
        stringBuffer.append("<!--\n    ").append(string3).append("\n\n-->\n\n");
        String string4 = NbBundle.getMessage((Class)GenerateDTDSupport.class, (String)"BK0010");
        stringBuffer.append("<!--\n").append("    " + string4 + "\n\n").append("    <?xml version=\"1.0\"?>\n\n").append("    <!DOCTYPE ").append(this.rootQName).append(" SYSTEM \"").append(string).append(".").append(DTD_EXT).append("\">\n\n").append("    <").append(this.rootQName).append(">\n    ...\n").append("    </").append(this.rootQName).append(">\n").append("-->\n");
        Iterator iterator = this.elementInfos.values().iterator();
        while (iterator.hasNext()) {
            Object object;
            Iterator iterator2;
            stringBuffer.append("\n");
            ElementInfo elementInfo = (ElementInfo)iterator.next();
            stringBuffer.append("<!--- " + NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$tools$generator$GenerateDTDSupport == null ? GenerateDTDSupport.class$("org.netbeans.modules.xml.tools.generator.GenerateDTDSupport") : class$org$netbeans$modules$xml$tools$generator$GenerateDTDSupport), (String)"FMT_DTDDoc") + " -->\n");
            stringBuffer.append("<!ELEMENT ").append(elementInfo.name.qName).append(" ");
            if (elementInfo.empty) {
                stringBuffer.append("EMPTY");
            } else {
                iterator2 = elementInfo.children;
                if (elementInfo.pcdata || iterator2.size() == 0) {
                    object = new Vector(iterator2);
                    ((Vector)object).insertElementAt(new XName("", "", "#PCDATA"), 0);
                    iterator2 = object;
                }
                object = iterator2.iterator();
                XName xName = (XName)object.next();
                stringBuffer.append("(").append(xName.qName);
                while (object.hasNext()) {
                    xName = (XName)object.next();
                    stringBuffer.append("|").append(xName.qName);
                }
                if (!stringBuffer.toString().endsWith("#PCDATA")) {
                    stringBuffer.append(")*");
                } else {
                    stringBuffer.append(")");
                }
            }
            stringBuffer.append(">\n");
            if (elementInfo.attributes.size() == 0) continue;
            stringBuffer.append("<!ATTLIST ").append(elementInfo.name.qName).append("\n");
            iterator2 = elementInfo.attributes.iterator();
            while (iterator2.hasNext()) {
                object = (XName)iterator2.next();
                stringBuffer.append("    ").append(((XName)object).qName).append(" CDATA #IMPLIED\n");
            }
            stringBuffer.append("  >\n");
        }
        return stringBuffer.toString();
    }

    private boolean scanTemplate() {
        Object object;
        URL uRL = null;
        XMLReader xMLReader = null;
        try {
            uRL = this.template.getPrimaryFile().getURL();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            this.warning = fileStateInvalidException.getLocalizedMessage();
            return false;
        }
        String string = uRL.toExternalForm();
        try {
            EntityResolver entityResolver;
            xMLReader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
            object = new Impl();
            xMLReader.setContentHandler((ContentHandler)object);
            xMLReader.setErrorHandler((ErrorHandler)object);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            UserCatalog userCatalog = UserCatalog.getDefault();
            if (userCatalog != null && (entityResolver = userCatalog.getEntityResolver()) != null) {
                xMLReader.setEntityResolver(entityResolver);
            }
        }
        catch (SAXException sAXException) {
            this.warning = sAXException.getLocalizedMessage();
            return false;
        }
        object = new InputSource(string);
        try {
            xMLReader.parse((InputSource)object);
            return true;
        }
        catch (IOException iOException) {
            this.warning = iOException.getLocalizedMessage();
            return false;
        }
        catch (SAXException sAXException) {
            this.warning = sAXException.getLocalizedMessage();
            return false;
        }
    }

    private boolean wsOnly(String string) {
        if (string == null) {
            return true;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            return false;
        }
        return true;
    }

    private boolean wsOnly(char[] cArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            return false;
        }
        return true;
    }

    private class ElementInfo {
        XName name;
        Set children;
        Set attributes;
        boolean pcdata;
        boolean empty;

        public ElementInfo(String string, String string2, String string3) {
            this.name = new XName(string, string2, string3);
            this.children = new HashSet();
            this.attributes = new HashSet();
            this.pcdata = false;
            this.empty = true;
        }

        public void hasPCDATA() {
            this.pcdata = true;
            this.empty = false;
        }

        public boolean isTextAllowed() {
            return this.pcdata;
        }

        public void addChild(ElementInfo elementInfo) {
            this.empty = false;
            this.children.add(elementInfo.name);
        }

        public void addAttribute(String string, String string2, String string3) {
            this.attributes.add(new XName(string, string2, string3));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof ElementInfo) {
                ElementInfo elementInfo = (ElementInfo)object;
                return this.name.equals(elementInfo.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private class Impl
    implements ContentHandler,
    ErrorHandler {
        private Impl() {
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (!GenerateDTDSupport.this.wsOnly(cArray, n, n2) && GenerateDTDSupport.this.current != null) {
                GenerateDTDSupport.this.current.hasPCDATA();
            }
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            GenerateDTDSupport.this.current = (ElementInfo)GenerateDTDSupport.this.elementStack.pop();
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String string) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (GenerateDTDSupport.this.rootQName == null) {
                GenerateDTDSupport.this.rootQName = string3;
            }
            XName xName = new XName(string, string2, string3);
            ElementInfo elementInfo = (ElementInfo)GenerateDTDSupport.this.elementInfos.get(xName);
            if (elementInfo == null) {
                elementInfo = new ElementInfo(string, string2, string3);
                GenerateDTDSupport.this.elementInfos.put(xName, elementInfo);
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                elementInfo.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i));
            }
            if (GenerateDTDSupport.this.current != null) {
                GenerateDTDSupport.this.current.addChild(elementInfo);
            }
            GenerateDTDSupport.this.elementStack.push(GenerateDTDSupport.this.current);
            GenerateDTDSupport.this.current = elementInfo;
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }
    }

    private static class XName {
        private String uri;
        private String localName;
        private String qName;

        public XName(String string, String string2, String string3) {
            this.uri = string;
            this.localName = string2;
            this.qName = string3;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof XName) {
                XName xName = (XName)object;
                return this.uri.equals(xName.uri) && this.localName.equals(xName.localName) && this.qName.equals(xName.qName);
            }
            return false;
        }

        public int hashCode() {
            return this.uri.hashCode() ^ this.localName.hashCode() ^ this.qName.hashCode();
        }
    }
}

