/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264;

import com.wowza.wms.mediareader.h264.H264CursorPosition;
import com.wowza.wms.mediareader.h264.atom.QTAtomtrak;
import com.wowza.wms.mediareader.h264.atom.QTMediaCursor;

public class H264Cursor {
    private QTAtomtrak videoTrackAtom = null;
    private QTAtomtrak audioTrackAtom = null;
    private QTMediaCursor vCursor = null;
    private boolean vAtEnd = false;
    private QTMediaCursor aCursor = null;
    private boolean aAtEnd = false;
    private int cursorType = 0;

    public H264Cursor(QTAtomtrak qTAtomtrak, QTAtomtrak qTAtomtrak2) {
        this.videoTrackAtom = qTAtomtrak;
        this.audioTrackAtom = qTAtomtrak2;
        this.init();
    }

    public H264Cursor(QTAtomtrak qTAtomtrak, QTAtomtrak qTAtomtrak2, int n) {
        this.videoTrackAtom = qTAtomtrak;
        this.audioTrackAtom = qTAtomtrak2;
        this.init();
    }

    private void init() {
        QTMediaCursor qTMediaCursor = this.vCursor = this.videoTrackAtom == null ? null : new QTMediaCursor(this.videoTrackAtom);
        if (this.vCursor != null) {
            this.vCursor.setCursorType(this.cursorType);
        }
        QTMediaCursor qTMediaCursor2 = this.aCursor = this.audioTrackAtom == null ? null : new QTMediaCursor(this.audioTrackAtom);
        if (this.aCursor != null) {
            this.aCursor.setCursorType(this.cursorType);
        }
        if (this.aCursor == null) {
            this.aAtEnd = true;
        }
        if (this.vCursor == null) {
            this.vAtEnd = true;
        }
    }

    public boolean containsAudio() {
        return this.audioTrackAtom != null;
    }

    public boolean containsVideo() {
        return this.videoTrackAtom != null;
    }

    public void close() {
        if (this.vCursor != null) {
            this.vCursor.close();
        }
        this.vCursor = null;
        if (this.aCursor != null) {
            this.aCursor.close();
        }
        this.aCursor = null;
    }

    private QTMediaCursor getCurrent() {
        QTMediaCursor qTMediaCursor = null;
        if (this.vAtEnd && this.aAtEnd) {
            return null;
        }
        long l = this.vAtEnd || this.vCursor == null ? Long.MAX_VALUE : this.vCursor.getTimeMillis();
        long l2 = this.aAtEnd || this.aCursor == null ? Long.MAX_VALUE : this.aCursor.getTimeMillis();
        QTMediaCursor qTMediaCursor2 = qTMediaCursor = l <= l2 ? this.vCursor : this.aCursor;
        if (qTMediaCursor == null) {
            qTMediaCursor = this.vCursor == null ? this.aCursor : this.vCursor;
        }
        return qTMediaCursor;
    }

    public boolean isCurrentAudio() {
        boolean bl;
        if (this.vAtEnd && this.aAtEnd) {
            return false;
        }
        long l = this.vAtEnd || this.vCursor == null ? Long.MAX_VALUE : this.vCursor.getTimeMillis();
        long l2 = this.aAtEnd || this.aCursor == null ? Long.MAX_VALUE : this.aCursor.getTimeMillis();
        boolean bl2 = bl = l > l2;
        if (bl && this.aCursor == null) {
            return false;
        }
        if (!bl && this.vCursor == null) {
            return true;
        }
        return bl;
    }

    public boolean isAtEnd() {
        return this.vAtEnd && this.aAtEnd;
    }

    public long getTimeMillis() {
        return this.getCurrent().getTimeMillis();
    }

    public double getSeekPoint() {
        return this.getCurrent().getSeekPoint();
    }

    public int getCTTS() {
        return this.getCurrent().getCTTS();
    }

    public int getCTTSMillis() {
        return this.getCurrent().getCTTSMillis();
    }

    public long getFileLoc() {
        return this.getCurrent().getFileLoc();
    }

    public long getSample() {
        return this.getCurrent().getSample();
    }

    public long getSampleDesc() {
        return this.getCurrent().getSampleDesc();
    }

    public long getAudioSample() {
        return this.aCursor == null ? -1L : this.aCursor.getSample();
    }

    public void setAudioSample(long l) {
        if (this.aCursor != null && l != -1L) {
            this.aCursor.moveToSample(l);
        }
    }

    public long getVideoSample() {
        return this.vCursor == null ? -1L : this.vCursor.getSample();
    }

    public void setVideoSample(long l) {
        if (this.vCursor != null && l != -1L) {
            this.vCursor.moveToSample(l);
        }
    }

    public boolean isKeyFrame() {
        return this.getCurrent().isKeyFrame();
    }

    public long getSize() {
        return this.getCurrent().getSize();
    }

    public long videoFindKeySample(long l, int n) {
        if (this.vCursor != null) {
            return this.vCursor.findKeySample(l, n);
        }
        return -1L;
    }

    public long videoTimecodeToSample(long l) {
        if (this.vCursor != null) {
            return this.vCursor.timecodeToSample(l);
        }
        return -1L;
    }

    public long videoSampleToTimecode(long l) {
        if (this.vCursor != null) {
            return this.vCursor.sampleToTimecode(l);
        }
        return -1L;
    }

    public long videoTimeMillisToTimecode(long l) {
        if (this.vCursor != null) {
            return this.vCursor.timeMillisToTimecode(l);
        }
        return 0L;
    }

    public long videoTimecodeToTimeMillis(long l) {
        if (this.vCursor != null) {
            return this.vCursor.timecodeToTimeMillis(l);
        }
        return 0L;
    }

    public long audioTimecodeToSample(long l) {
        if (this.aCursor != null) {
            return this.aCursor.timecodeToSample(l);
        }
        return -1L;
    }

    public long audioSampleToTimecode(long l) {
        if (this.aCursor != null) {
            return this.aCursor.sampleToTimecode(l);
        }
        return -1L;
    }

    public long audioTimeMillisToTimecode(long l) {
        if (this.aCursor != null) {
            return this.aCursor.timeMillisToTimecode(l);
        }
        return 0L;
    }

    public long audioTimecodeToTimeMillis(long l) {
        if (this.aCursor != null) {
            return this.aCursor.timecodeToTimeMillis(l);
        }
        return 0L;
    }

    public boolean movePrevSample() {
        if (this.isCurrentAudio()) {
            if (!this.aCursor.movePrevSample()) {
                this.aAtEnd = true;
            }
        } else if (!this.vCursor.movePrevSample()) {
            this.vAtEnd = true;
        }
        return this.vAtEnd && this.aAtEnd;
    }

    public boolean moveNextSample() {
        if (this.isCurrentAudio()) {
            if (!this.aCursor.moveNextSample()) {
                this.aAtEnd = true;
            }
        } else if (!this.vCursor.moveNextSample()) {
            this.vAtEnd = true;
        }
        return this.vAtEnd && this.aAtEnd;
    }

    public void resetAudioAtEnd() {
        this.aAtEnd = false;
        if (this.aCursor == null) {
            this.aAtEnd = true;
        }
    }

    public void resetVideoAtEnd() {
        this.vAtEnd = false;
        if (this.vCursor == null) {
            this.vAtEnd = true;
        }
    }

    public void setCurrentPosition(H264CursorPosition h264CursorPosition) {
        this.setAudioSample(h264CursorPosition.getAudioSample());
        this.setVideoSample(h264CursorPosition.getVideoSample());
        this.vAtEnd = h264CursorPosition.isVAtEnd();
        this.aAtEnd = h264CursorPosition.isAAtEnd();
    }

    public H264CursorPosition getCurrentPosition() {
        return new H264CursorPosition(this.getVideoSample(), this.vAtEnd, this.getAudioSample(), this.aAtEnd);
    }
}

