/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264.atom;

import com.wowza.util.IFastIntBuffer;
import com.wowza.util.IFastLongBuffer;
import com.wowza.wms.mediareader.h264.atom.AVCCData;
import com.wowza.wms.mediareader.h264.atom.ESDSData;
import com.wowza.wms.mediareader.h264.atom.QTAtom;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QTAtomstbl
extends QTAtom {
    public static final int TIMETOSAMPLE_COUNT = 0;
    public static final int TIMETOSAMPLE_DURATION = 1;
    public static final int SAMPLETOCHUNK_FIRSTCHUNK = 0;
    public static final int SAMPLETOCHUNK_SAMPLESPERCHUNK = 1;
    public static final int SAMPLETOCHUNK_SAMPLEDESCRIPTION = 2;
    public static final int CTTS_COUNT = 0;
    public static final int CTTS_DURATION = 1;
    List<String> dataTypes = new ArrayList<String>();
    int frameWidth = 0;
    int frameHeight = 0;
    int framesPerSample = 0;
    int audioChannels = 0;
    List<AVCCData> avccList = new ArrayList<AVCCData>();
    List<ESDSData> esdsList = new ArrayList<ESDSData>();
    int aacAOT = 2;
    boolean isValidVideoFormat = false;
    boolean isValidAudioFormat = false;
    IFastIntBuffer timeToSample = null;
    IFastLongBuffer syncSamples = null;
    IFastIntBuffer sampleSizes = null;
    IFastLongBuffer chunkOffsets = null;
    IFastIntBuffer sampleToChunk = null;
    IFastIntBuffer cttsValues = null;
    long sampleSize = 0L;

    public QTAtomstbl(String string, long l, long l2, long l3) {
        super(string, l, l2, l3);
    }

    public QTAtomstbl(QTAtom qTAtom) {
        super(qTAtom.type, qTAtom.offset, qTAtom.size, qTAtom.headerSize);
    }

    public void addDataType(String string) {
        if (string.toLowerCase().indexOf("mp3") >= 0 || string.toLowerCase().indexOf("mp4a") >= 0) {
            this.isValidAudioFormat = true;
        }
        if (string.toLowerCase().indexOf("avc1") >= 0) {
            this.isValidVideoFormat = true;
        }
        this.dataTypes.add(string);
    }

    public List<String> getDataTypes() {
        return this.dataTypes;
    }

    public boolean containsDataType(String string) {
        return this.dataTypes.contains(string);
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public void setFrameWidth(int n) {
        this.frameWidth = n;
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public void setFrameHeight(int n) {
        this.frameHeight = n;
    }

    public int getFramesPerSample() {
        return this.framesPerSample;
    }

    public void setFramesPerSample(int n) {
        this.framesPerSample = n;
    }

    public int getAacAOT() {
        return this.aacAOT;
    }

    public void setAacAOT(int n) {
        this.aacAOT = n;
    }

    public int getAudioChannels() {
        return this.audioChannels;
    }

    public void setAudioChannels(int n) {
        this.audioChannels = n;
    }

    public IFastLongBuffer getSyncSamples() {
        return this.syncSamples;
    }

    public void setSyncSamples(IFastLongBuffer iFastLongBuffer) {
        this.syncSamples = iFastLongBuffer;
    }

    public long getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(long l) {
        this.sampleSize = l;
    }

    public IFastIntBuffer getSampleSizes() {
        return this.sampleSizes;
    }

    public void setSampleSizes(IFastIntBuffer iFastIntBuffer) {
        this.sampleSizes = iFastIntBuffer;
    }

    public IFastLongBuffer getChunkOffsets() {
        return this.chunkOffsets;
    }

    public void setChunkOffsets(IFastLongBuffer iFastLongBuffer) {
        this.chunkOffsets = iFastLongBuffer;
    }

    @Override
    public String toString() {
        return "qtAtom {type:" + this.type + ", offset:" + this.offset + ", size:" + this.size + ", frameWidth:" + this.frameWidth + ", frameHeight:" + this.frameHeight + ", framesPerSample:" + this.framesPerSample + ", subtype:" + (this.dataTypes.size() > 0 ? this.dataTypes.get(0) : "unkn") + "}";
    }

    public IFastIntBuffer getTimeToSample() {
        return this.timeToSample;
    }

    public void setTimeToSample(IFastIntBuffer iFastIntBuffer) {
        this.timeToSample = iFastIntBuffer;
    }

    public IFastIntBuffer getSampleToChunk() {
        return this.sampleToChunk;
    }

    public void setSampleToChunk(IFastIntBuffer iFastIntBuffer) {
        this.sampleToChunk = iFastIntBuffer;
    }

    public IFastIntBuffer getCttsValues() {
        return this.cttsValues;
    }

    public void setCttsValues(IFastIntBuffer iFastIntBuffer) {
        this.cttsValues = iFastIntBuffer;
    }

    public boolean isValidVideoFormat() {
        return this.isValidVideoFormat;
    }

    public boolean isValidAudioFormat() {
        return this.isValidAudioFormat;
    }

    public void addAVCCData(AVCCData aVCCData) {
        this.avccList.add(aVCCData);
    }

    public AVCCData getAVCCData() {
        return this.getAVCCData(0);
    }

    public AVCCData getAVCCData(int n) {
        AVCCData aVCCData = null;
        for (int i = n; i >= 0 && (i >= this.avccList.size() || (aVCCData = this.avccList.get(i)) == null); --i) {
        }
        return aVCCData;
    }

    public void addESDSData(ESDSData eSDSData) {
        this.esdsList.add(eSDSData);
    }

    public ESDSData getESDSData() {
        return this.getESDSData(0);
    }

    public ESDSData getESDSData(int n) {
        ESDSData eSDSData = null;
        for (int i = n; i >= 0 && (i >= this.esdsList.size() || (eSDSData = this.esdsList.get(i)) == null); --i) {
        }
        return eSDSData;
    }

    public List<AVCCData> getAVCCDataList() {
        return this.avccList;
    }

    public List<ESDSData> getESDSDataList() {
        return this.esdsList;
    }

    public long getSampleDescriptionCount() {
        return Math.max(this.avccList.size(), this.esdsList.size());
    }
}

