/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264.util;

import com.wowza.io.IRandomAccessReader;
import com.wowza.util.BufferUtils;
import com.wowza.wms.mediareader.h264.atom.ESDSData;

public class MP4Utils {
    public static final int MP4_TAG_ESDS_DESCRIPTOR = 3;
    public static final int MP4_TAG_CONFIG_DESCRIPTOR = 4;
    public static final int MP4_TAG_SPEC_DESCRIPTOR = 5;

    static int readMP4DescriptorLen(IRandomAccessReader iRandomAccessReader, byte[] byArray) {
        int n = 0;
        int n2 = 4;
        try {
            while (n2-- != 0) {
                iRandomAccessReader.read(byArray, 0, 1);
                int n3 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)1);
                n = n << 7 | n3 & 0x7F;
                if ((n3 & 0x80) != 0) continue;
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("Error: readMP4DescriptorLen: " + exception.toString());
        }
        return n;
    }

    static MP4Descriptor readMP4Descriptor(IRandomAccessReader iRandomAccessReader, byte[] byArray) {
        MP4Descriptor mP4Descriptor = null;
        try {
            iRandomAccessReader.read(byArray, 0, 1);
            int n = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)1);
            int n2 = MP4Utils.readMP4DescriptorLen(iRandomAccessReader, byArray);
            mP4Descriptor = new MP4Descriptor(n, n2);
        }
        catch (Exception exception) {
            System.out.println("Error: readMP4Descriptor: " + exception.toString());
        }
        return mP4Descriptor;
    }

    static ESDSData decodeESDS(IRandomAccessReader iRandomAccessReader) {
        ESDSData eSDSData = new ESDSData();
        byte[] byArray = new byte[4];
        try {
            iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 4L);
            MP4Descriptor mP4Descriptor = MP4Utils.readMP4Descriptor(iRandomAccessReader, byArray);
            if (mP4Descriptor.tag == 3) {
                iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 3L);
            } else {
                iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 2L);
            }
            MP4Descriptor mP4Descriptor2 = MP4Utils.readMP4Descriptor(iRandomAccessReader, byArray);
            if (mP4Descriptor2.tag == 4) {
                iRandomAccessReader.read(byArray, 0, 1);
                eSDSData.objecType = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)1);
                iRandomAccessReader.read(byArray, 0, 1);
                eSDSData.streamType = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)1);
                iRandomAccessReader.read(byArray, 0, 3);
                eSDSData.bufferSize = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)3);
                iRandomAccessReader.read(byArray, 0, 4);
                eSDSData.maxBitRate = BufferUtils.byteArrayToInt((byte[])byArray);
                iRandomAccessReader.read(byArray, 0, 4);
                eSDSData.avgBitRate = BufferUtils.byteArrayToInt((byte[])byArray);
                MP4Descriptor mP4Descriptor3 = MP4Utils.readMP4Descriptor(iRandomAccessReader, byArray);
                if (mP4Descriptor3.tag == 5 && mP4Descriptor3.len > 0) {
                    eSDSData.specData = new byte[mP4Descriptor3.len];
                    iRandomAccessReader.read(eSDSData.specData, 0, mP4Descriptor3.len);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error: decodeESDS: " + exception.toString());
        }
        return eSDSData;
    }

    static class MP4Descriptor {
        public int tag = 0;
        public int len = 0;

        public MP4Descriptor(int n, int n2) {
            this.tag = n;
            this.len = n2;
        }
    }
}

