/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.analyzer.InsertStatement;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatementAnalyzer;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InsertStatementAnalyzer
extends SQLStatementAnalyzer {
    private final List<String> columns = new ArrayList<String>();
    private final List<String> values = new ArrayList<String>();
    private QualIdent table = null;

    public static InsertStatement analyze(TokenSequence<SQLTokenId> tokenSequence, SQLIdentifiers.Quoter quoter) {
        tokenSequence.moveStart();
        if (!tokenSequence.moveNext()) {
            return null;
        }
        InsertStatementAnalyzer insertStatementAnalyzer = new InsertStatementAnalyzer(tokenSequence, quoter);
        insertStatementAnalyzer.parse();
        return new InsertStatement(insertStatementAnalyzer.startOffset, tokenSequence.offset() + tokenSequence.token().length(), insertStatementAnalyzer.getTable(), Collections.unmodifiableList(insertStatementAnalyzer.columns), Collections.unmodifiableList(insertStatementAnalyzer.values), insertStatementAnalyzer.offset2Context);
    }

    private InsertStatementAnalyzer(TokenSequence<SQLTokenId> tokenSequence, SQLIdentifiers.Quoter quoter) {
        super(tokenSequence, quoter);
    }

    private void parse() {
        this.startOffset = this.seq.offset();
        block20: do {
            switch (this.context) {
                case START: {
                    if (!SQLStatementAnalyzer.isKeyword("INSERT", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.INSERT);
                    break;
                }
                case INSERT: {
                    if (!SQLStatementAnalyzer.isKeyword("INTO", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.INSERT_INTO);
                    break;
                }
                case INSERT_INTO: {
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            this.table = this.parseIdentifier();
                            break;
                        }
                        case LPAREN: {
                            this.moveToContext(SQLStatement.Context.COLUMNS);
                            break;
                        }
                        case KEYWORD: {
                            if (!SQLStatementAnalyzer.isKeyword("VALUES", (TokenSequence<SQLTokenId>)this.seq)) break;
                            this.moveToContext(SQLStatement.Context.VALUES);
                        }
                    }
                    continue block20;
                }
                case COLUMNS: {
                    List<String> list;
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            list = this.analyzeChosenColumns();
                            if (list.isEmpty()) break;
                            this.columns.addAll(list);
                            break;
                        }
                        case KEYWORD: {
                            if (!SQLStatementAnalyzer.isKeyword("VALUES", (TokenSequence<SQLTokenId>)this.seq)) break;
                            this.moveToContext(SQLStatement.Context.VALUES);
                            break;
                        }
                        case RPAREN: {
                            this.moveToContext(SQLStatement.Context.VALUES);
                        }
                    }
                    continue block20;
                }
                case VALUES: {
                    List<String> list;
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            list = this.analyzeChosenColumns();
                            if (list.isEmpty()) break;
                            this.values.addAll(list);
                        }
                    }
                    break;
                }
            }
        } while (this.nextToken());
    }

    private List<String> analyzeChosenColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getUnquotedIdentifier());
        block5: while (this.seq.moveNext()) {
            switch ((SQLTokenId)this.seq.token().id()) {
                case WHITESPACE: {
                    continue block5;
                }
                case COMMA: {
                    continue block5;
                }
                case RPAREN: {
                    return arrayList;
                }
            }
            arrayList.add(this.getUnquotedIdentifier());
        }
        return arrayList;
    }

    private QualIdent getTable() {
        return this.table;
    }
}

