/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.JTextComponent;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionResultSet;
import org.netbeans.modules.db.sql.editor.api.completion.SubstitutionHandler;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLCompletionItems
implements Iterable<SQLCompletionItem> {
    private final List<SQLCompletionItem> items = new ArrayList<SQLCompletionItem>();
    private final SQLIdentifiers.Quoter quoter;
    private final SubstitutionHandler substitutionHandler;

    public SQLCompletionItems(SQLIdentifiers.Quoter quoter, SubstitutionHandler substitutionHandler) {
        this.quoter = quoter;
        this.substitutionHandler = substitutionHandler;
    }

    public void addKeywords(String string, int n, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!SQLCompletionItems.filter(string2, string)) continue;
            this.items.add(SQLCompletionItem.keyword(string2, n, this.substitutionHandler));
        }
    }

    public Set<String> addCatalogs(Metadata metadata, Set<String> set, String string, final boolean bl, final int n) {
        TreeSet<String> treeSet = new TreeSet<String>();
        SQLCompletionItems.filterMetadata(metadata.getCatalogs(), set, string, new Handler<Catalog>(){

            @Override
            public void handle(Catalog catalog) {
                String string = catalog.getName();
                SQLCompletionItems.this.items.add(SQLCompletionItem.catalog(string, SQLCompletionItems.this.doQuote(string, bl), n, SQLCompletionItems.this.substitutionHandler));
            }
        });
        return treeSet;
    }

    public Set<String> addSchemas(Catalog catalog, Set<String> set, String string, final boolean bl, final int n) {
        TreeSet<String> treeSet = new TreeSet<String>();
        SQLCompletionItems.filterMetadata(catalog.getSchemas(), set, string, new Handler<Schema>(){

            @Override
            public void handle(Schema schema) {
                if (!schema.isSynthetic()) {
                    String string = schema.getName();
                    SQLCompletionItems.this.items.add(SQLCompletionItem.schema(string, SQLCompletionItems.this.doQuote(string, bl), n, SQLCompletionItems.this.substitutionHandler));
                }
            }
        });
        return treeSet;
    }

    public void addTables(Schema schema, Set<String> set, String string, boolean bl, int n) {
        this.addTables(schema, null, set, string, bl, n, false);
    }

    public void addTablesAtInsertInto(Schema schema, QualIdent qualIdent, Set<String> set, String string, boolean bl, int n) {
        this.addTables(schema, qualIdent, set, string, bl, n, true);
    }

    private void addTables(Schema schema, QualIdent qualIdent, Set<String> set, String string, final boolean bl, int n, final boolean bl2) {
        final String string2 = qualIdent == null ? "" : qualIdent.getSimpleName() + '.';
        final int n2 = qualIdent == null ? n : n - (qualIdent.getSimpleName().length() + 1);
        SQLCompletionItems.filterMetadata(schema.getTables(), set, string, new Handler<Table>(){

            @Override
            public void handle(Table table) {
                String string = table.getName();
                SQLCompletionItems.this.items.add(SQLCompletionItem.table(string, SQLCompletionItems.this.doQuote(string, bl), n2, bl2 ? new ExtendedSubstitutionHandler(SQLCompletionItems.this.substitutionHandler, string2, " (") : SQLCompletionItems.this.substitutionHandler));
            }
        });
    }

    public void addAliases(Map<String, QualIdent> map, String string, boolean bl, final int n) {
        SQLCompletionItems.filterMap(map, null, string, new ParamHandler<String, QualIdent>(){

            @Override
            public void handle(String string, QualIdent qualIdent) {
                SQLCompletionItems.this.items.add(SQLCompletionItem.alias(string, qualIdent, string, n, SQLCompletionItems.this.substitutionHandler));
            }
        });
    }

    public void addColumnsWithTableName(Table table, QualIdent qualIdent, String string, boolean bl, int n) {
        this.addColumns(table, qualIdent, string, bl, n, true);
    }

    public void addColumns(Table table, String string, boolean bl, int n) {
        this.addColumns(table, null, string, bl, n, false);
    }

    private void addColumns(Table table, QualIdent qualIdent, String string, final boolean bl, int n, final boolean bl2) {
        Schema schema = table.getParent();
        Catalog catalog = schema.getParent();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        if (!catalog.isDefault()) {
            arrayList.add(catalog.getName());
        }
        if (!schema.isSynthetic() && !schema.isDefault()) {
            arrayList.add(schema.getName());
        }
        arrayList.add(table.getName());
        final QualIdent qualIdent2 = new QualIdent(arrayList);
        final String string2 = qualIdent == null ? table.getName() : qualIdent.getFirstQualifier() + '.' + qualIdent.getSecondQualifier();
        final int n2 = qualIdent == null ? n : n - (qualIdent.getFirstQualifier().length() + qualIdent.getSecondQualifier().length() + 2);
        SQLCompletionItems.filterMetadata(table.getColumns(), null, string, new Handler<Column>(){

            @Override
            public void handle(Column column) {
                String string = column.getName();
                SQLCompletionItems.this.items.add(SQLCompletionItem.column(qualIdent2, string, SQLCompletionItems.this.doQuote(string, bl), n2, bl2 ? new ExtendedSubstitutionHandler(SQLCompletionItems.this.substitutionHandler, string2 + " (", null) : SQLCompletionItems.this.substitutionHandler));
            }
        });
    }

    public void fill(CompletionResultSet completionResultSet) {
        completionResultSet.addAllItems(this.items);
    }

    public void fill(SQLCompletionResultSet sQLCompletionResultSet) {
        sQLCompletionResultSet.addAllItems(this.items);
    }

    @Override
    public Iterator<SQLCompletionItem> iterator() {
        return this.items.iterator();
    }

    private String doQuote(String string, boolean bl) {
        if (bl) {
            return this.quoter.quoteAlways(string);
        }
        return this.quoter.quoteIfNeeded(string);
    }

    private static boolean startsWithIgnoreCase(String string, String string2) {
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    private static boolean filter(String string, String string2) {
        return string2 == null || SQLCompletionItems.startsWithIgnoreCase(string, string2);
    }

    private static <P> void filterMap(Map<String, P> map, Set<String> set, String string, ParamHandler<String, P> paramHandler) {
        for (Map.Entry<String, P> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (set != null && !set.contains(string2) || !SQLCompletionItems.filter(string2, string)) continue;
            paramHandler.handle(string2, entry.getValue());
        }
    }

    private static <T extends MetadataElement> void filterMetadata(Collection<T> collection, Set<String> set, String string, Handler<T> handler) {
        for (MetadataElement metadataElement : collection) {
            String string2 = metadataElement.getName();
            if (string2 == null || set != null && !set.contains(string2) || !SQLCompletionItems.filter(string2, string)) continue;
            handler.handle(metadataElement);
        }
    }

    private static final class ExtendedSubstitutionHandler
    implements SubstitutionHandler {
        private final SubstitutionHandler original;
        private final String prefix;
        private final String postfix;

        public ExtendedSubstitutionHandler(SubstitutionHandler substitutionHandler, String string, String string2) {
            this.original = substitutionHandler;
            this.prefix = string == null ? "" : string;
            this.postfix = string2 == null ? "" : string2;
        }

        public void substituteText(JTextComponent jTextComponent, int n, String string) {
            this.original.substituteText(jTextComponent, n, this.prefix + string + this.postfix);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Handler<T> {
        public void handle(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ParamHandler<T, P> {
        public void handle(T var1, P var2);
    }
}

