<?php
  /*************************************************************
   *                    START HERE
   *     HERE ARE DEFINED CHAT RULES AND CHAT BEHAVIOR
   ************************************************************/
?>
<?php
/**
 * Radical Flash Chat
 *
 * LICENSE
 *
 * This source file is subject of Jaromir Sivic's ownership
 * and the commercial license on http://www.cze.cz.
 * It is not allowed to redistribute or modify source code
 * of this file. It is also not allowed to use any part
 * of the following Radical Chat source code in another projects.
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to radicalchat@cze.cz and you will be issued with a copy immediately.
 *
 * @category   Radical Chat
 * @copyright  Jaromir Sivic 2009
 * @license    http://www.cze.cz commercial license
 */
?>
<?php
    require_once("serviceconfiguration.php");
?>
<?php

    /**
     * !!!!!!!!
     * Please do not access variables and properties
     * from classes "Client", "Stream", "ChatRoom" directly.
     * Use setters, getters and implemented public functions.
     */

     //set the encoding of this php file script
     //Configuration::$LOCAL_ENCODING = "cp1250";


    /**
     * OnApplicationStarted event is triggered when Radical Bridge
     * application is loaded into the stream server memory.
     */
    function _onApplicationStarted()
    {
    	Logger::func("onApplictionStarted");
    }





    /**
     * OnApplicationStopped event is triggered a few moments before
     * Radical Bridge application is unloaded from the stream server memory.
     * Typically it is just before the stream server is properly terminated,
     * or also in case that there are no connected clients for a long time.
     * WARNING: onApplicationStopped is not triggered if the stream server crashes down.
     */
    function _onApplicationStopped()
    {
    	Logger::func("onApplicationStopped");
    }








    /**
     * OnClientWantsToConnect event is triggered when a client attempts
     * to connect to the Radical Bridge (before he/she is assigned into
     * the chat room). Developers should always implement this function.
     * “AcceptConnection” or “RejectConnection” method must be called
     * somewhere in the body of this function.
     *
     * @param Client $client - client who wants to connect to the system
     */
    function _onClientWantsToConnect(&$client)
    {
        Logger::func("onClientWantsToConnect");
        //accept client's connection
        $client->AcceptConnection();
        Logger::info("User ".$client->getUID()." wants to connect.");
        //set client nick name
        $client->setNickName($client->getUID());
        $BR = chr(13).chr(10);
        //send room message
        $client->SendRoomMessage(
                "Admin", "000000", "User \"" . $client->getNickName() .
                "\" has entered the room.");
        //send private message about the chat
        $client->SendPrivateMessage(
                "Admin", $client->getUID(), "000000",
                "This chat is written in Radical Chat Framework for PHP - ".
                "the first available solution which enables the developers ".
                "to write flash videoconferencing applications entirely ".
                "in PHP language without any further knowledge of ".
                "Flash, Actionscript, RTMP protocol or stream server API. ".
                "The framework unique design speeds up the video chat ".
                "development process from 3-6 months to 2-4 days.".$BR.
                "The design of this application could be altered by editing ".
                "the XML configuration file on ".
                "{{FONT COLOR='#0000FF'}}{{A HREF='config.xml' ".
                "TARGET='_blank'}}./config.xml{{/A}}{{/FONT}}".$BR.
                "The chat rules could be altered by editing ".
                "{{FONT COLOR='#0000FF'}}{{A HREF='./service/service.php' ".
                "TARGET='_blank'}}".
                "./service/service.php file.".
                "{{/A}}{{/FONT}}".$BR.
                "If you want more information, please see ".
                "{{FONT COLOR='#0000FF'}}".
                "{{A HREF='http://en.cze.cz/Radical-Flash-Chat/' ".
                "TARGET='_blank'}}".
                "http://en.cze.cz/Radical-Flash-Chat/{{/A}}{{/FONT}}".$BR.$BR);
    }









    /**
     * OnClientConnectionWasAccepted event comes after onClientWantsToConnect,
     * but only if a client was accepted by “AcceptConnection” method. Usually
     * it is not necessary to implement the body of this function.
     *
     * @param Client $client client who was accepted and entered
     * the chat successfully
     */
    function _onClientConnectionWasAccepted(&$client)
    {
        Logger::func("onClientConnectionWasAccepted");
    }









    /**
     * OnClientConnectionWasRejected event comes after onClientWantsToConnect
     * If the client was fired (kicked out) by “RejectConnection” method.
     * Usually it is not necessary to implement the body of this function.
     *
     * @param Client $client handler of the client which connection
     * was rejected in the onClientWantsToConnect event
     */
    function _onClientConnectionWasRejected($client)
    {
        Logger::func("onClientConnectionWasRejected");
    }








    /**
     * OnClientDisconnected event occurs when the client is disconnected
     * by “RejectConnection” or if a connection is somehow terminated,
     * for example because of network malfunction or because the client
     * turned off the computer or closed the web browser.
     *
     * @param Client $client handler of the client who has disconnected
     * himself from the server. This parameter is not transfered back
     * to the stream server.
     * @param ChatRoom $room handler to the ChatRoom, where client
     * belonged before he disconnected himself. This parameter is
     * transfered back to the stream server.
     */
    function _onClientDisconnected($client, &$room = null)
    {
        //WARNING room can be null if user was rejected
        //        before he was assigned into the room

        Logger::func("onClientDisconnected");
        Logger::info("User ".$client->getUID()." is disconnected.");
        //send the message that client left the room
        $room->SendRoomMessage("Admin","000000","User " .
                               $client->getNickName() . " left the room");
    }








    /**
     * OnClientWantsToStartStreaming event is triggered every time when any
     * client wants to publish live audio or video stream.
     * Mostly it is a live video from a web camera.
     *
     * @param Client $client handler of the client who wants to publish
     * the stream
     * @param Stream $stream stream descriptor
     */
    function _onClientWantsToStartStreaming(&$client, $stream)
    {
        Logger::func("onClientWantsToStartStreaming");

        //deny streaming by default
        $client->setStreamingRejected();

        //initialize mutex for transaction operation
        $mutexName = "Mutex".$client->getRoomUID();
        $mutex = new Mutex($mutexName);
        //try to begin transaction on persistent object
        //Radical Chat persistent object is a temporary object
        // which is not stored in any database
        $mutex->lock();
        {
            //open persistent object
            $po = new PersistentObject($mutexName);
            //test if persistent object has been setted or if it is necessary
            //to set it right now
            if(!isset($po->vars["WhoIsStreaming"]))
            {
                $po->vars["WhoIsStreaming"] = "noone";
                $po->vars["verified"] = time();
                $po->save();
            }

            //test if there is anyone else who is streaming
            if(($po->vars["WhoIsStreaming"]=="noone") ||
               (time() - $po->vars["verified"] > 3))
            {
                //if there is noone else
                
                //accept the streaming
                $client->setStreamingAccepted();
                //show information about the stream
                $client->SendPrivateMessage(
                        "Admin", $client->getUID(),"C00000", "You are " .
                        "attempting to start streaming.{{BR/}}{{BR/}} Information: " .
                        $stream->getInformations());

                //save information about client to the persistent object
                $po->vars["WhoIsStreaming"] = $client->getUID();
                $po->vars["verified"] = time();
                $po->save();

                //this client will call oncheckclients every three seconds
                $ssc = $client->getStreamServerCommands();
                //set interval for onCheckClients to three seconds
                $ssc->client_setNextCheckDefaultValue($client->getUID(), 3);
            }
            else
            {
                //send the message that someone else is streaming
                $client->SendPrivateMessage(
                        "Admin", $client->getUID(),"C00000", "Sorry ".
                        "your stream cannot be published because someone ".
                        "else \"".$po->vars["WhoIsStreaming"]."\" ".
                        "is streaming.");
            }

            //unlock the mutex
            $mutex->unlock();
        }
    }






    /**
     * OnClientStoppedStreaming is a notification event that indicates
     * that the client stopped streaming.
     *
     * @param Client $client handler of the client who stopped streaming
     * @param Stream $stream stream descriptor
     */
    function _onClientStoppedStreaming($client, $stream)
    {
        Logger::func("onClientStoppedStreaming");
    }








    /**
     * OnClientWantsToPlayStream event is triggered when some client
     * attempts to play live audio or video.
     *
     * @param Client $client handler of the client who wants to play
     * some stream
     * @param Stream $stream stream descriptor
     */
    function _onClientWantsToPlayStream(&$client, $stream)
    {
        Logger::func("onClientWantsToPlayStream");
        //accept playing stream
        $client->setPlayStreamAccepted();
        //send information about the stream
        $client->SendPrivateMessage(
                "Admin",$client->getUID(),"00C000", "Client is " .
                "attempting to play the stream.{{BR/}} Information are " .
                $stream->getInformations());
    }






    /**
     * OnClientStoppedPlayingStream is a notification event triggered
     * when some client stopped playing live audio or video.
     *
     * @param Client $client handler of the client who stopped playing
     * the stream
     * @param Stream $stream stream descriptor
     */
    function _onClientStoppedPlayingStream($client, $stream)
    {
        Logger::func("onClientStoppedPlayingStream");
    }







    /**
     * OnCheckClients - This event is executed at a periodic
     * time interval, which depends on the property NextCheck of each client
     * in the system. Every one second Radical Bridge decrements NextCheck
     * value of each client in all stream server chat rooms by one. When
     * NextCheck value is equal to 0, client's manipulator (handler) is pushed
     * to the associative array and passed to the onCheckClients event
     * there the property NextCheck must be reset, otherwise the concrete
     * client will never more call onCheckClients again. This function is very
     * useful for such systems, where on the beginning each user has an account
     * with some amount of money or credits and later, if he/she runs
     * out of credit, then his/her connection to the chat is terminated.
     *
     * @param array[int]Client $clients array of handlers of the clients which
     * has to be checked.
     */
    function _onCheckClients(&$clients)
    {
        Logger::func("onCheckClients");
        foreach($clients as $client)
        {
            //cast to client is here only because we need code insight
            //or intellisense when typing the code
            $client = Client::castToClient($client);

            //initialize mutex for transaction operation
            $mutexName = "Mutex".$client->getRoomUID();
            $mutex = new Mutex($mutexName);
            //try to begin transaction on persistent object
            //Radical Chat persistent object is a temporary object
            // which is not stored in any database
            $mutex->lock();
            {
                //open persistent object
                $po = new PersistentObject($mutexName);
                //test if persistent object has been setted or if it is necessary
                //to set it right now
                $po->vars["WhoIsStreaming"] = $client->getUID();
                $po->vars["verified"] = time();
                $po->save();

                //unlock the mutex
                $mutex->unlock();
            }
        }
    }


    /**
     * OnClientSendMessage function is called every time when a client sends
     * a text message, but only in case that the client's flag
     * dispatchEventIfClientSendTextMessage is set to true.
     *
     * @param Client $client handler of the client who is sending the
     * message
     * @param sstring $toUID UID of the recipient
     * @param sstring $color the color of the message
     * @param sstring $message the text of the message
     */
    function _onClientSendMessage(&$client,$toUID,$color,$message)
    {
        Logger::func("onClientSendMessage");
        Logger::info($message);
        $prefix = "prefix ";
        $postfix = " postfix. This message was altered on the fly.".
        $client->SendPrivateMessage($client->getNickName(), $toUID, $color,
                $prefix . $message . $postfix);
    }







    /**
     * OnUniversalCall event is triggered when custom BasicButton
     * in “Radical Flash Chat”  application
     * (application in client’s web browser) is pressed.
     *
     * @param array[int]Client $clients array of clients
     * @param $senderName action which caused this call,
     * for example button click
     * @param $eventName - name of the event,
     * please see the class ChatEvents
     * @param $value optional parameter
     */
    function _onUniversalCall(&$clients,$senderName,$eventName,$value)
    {
        Logger::func("onUniversalCall");

        //If basic button was clicked then
        //clients[0] is client who clicked the button
        //clients[1..n] clients selected in clients[0] userslist
        if($eventName==ChatEvents::$EVENT_BASICBUTTONCLICKED_WITHSELECTEDCLIENTS)
        {
            //if kickOut button was pressed
            if($senderName=="KickOutButton")
            {
                //client who is kicking out
                $clientWhoIsKickingOut = Client::castToClient($clients[0]);
                $clientWhoIsKickingOut->SendPrivateMessage(
                        "Admin",$clientWhoIsKickingOut->getUID(),"000000",
                        "You are attempting to KickOut clients.");

                //kickout all other clients
                for($a = 1; $a<sizeof($clients); $a++)
                {
                    $clients[$a]->SendPrivateMessage(
                            "Admin",$clients[$a]->getUID(),"000000",
                            "You were kicked out by " .
                            $clientWhoIsKickingOut->getNickName());
                }
            }

            //if PirvateButton was pressed
            if($senderName=="PrivateButton")
            {
                    //Client who wants to go to private chat
                    $client = Client::castToClient($clients[0]);
                    $client->SendPrivateMessage("Admin", $client->getUID(),
                            "000000", "You are trying to invite some other ".
                            "user to the private chat. ".
                            "Take a look on service.php - event ".
                            "onUniversalCall and setup private chat there.");

                    $ssc = $client->getStreamServerCommands();
                    //the new web browser window should be opened where
                    //two users can communicate one with each other
                    $ssc->client_OpenWebPage($client->getUID(),
                            "index.php","_blank");
                    ///the other user can be redirected to the same page
                    //$ssc->client_OpenWebPage("performer",
                    //        "http://127.0.0.1/","_self");
            }
        }
    }






    /**
     * OnChatRoomCreated event occurs when new chat room is created just
     * before the first client attempts to enter it.
     *
     * @param ChatRoom $room handler of the room which is going to be
     * created
     */
    function _onChatRoomCreated(&$room)
    {
        Logger::func("onChatRoomCreated");
        //send the message that chat room has been created
        $room->SendRoomMessage("Admin","00FF00",
                "Chat room has been created");
        //try to alter room skin
        $ssc = $room->getStreamServerCommands();
        $skin = $ssc->room_getSkin($room->getUID());
        //set room name
        $skin->updateSkinObject(
            '<Skin><BG><SkinObject><Type>HtmlTextArea</Type>
                    <Name>RoomName</Name>
                    <Visible>true</Visible>
                    <Position>
                            <Left>{PerformerVideoPanel.Left}+10</Left>
                            <Top>{PerformerVideoPanel.Top}+5</Top>
                            <Width>400</Width>
                            <Height>50</Height>
                    </Position>'.
                    '<HtmlText>{{FONT SIZE="12" COLOR="#000000" '.
                    'LETTERSPACING="0" KERNING="0"}}'.
                    '{{B}}'.$room->getUID().'{{/B}}{{/FONT}}</HtmlText>'.
                    '<IsTextSelectable>false</IsTextSelectable>
            </SkinObject></BG></Skin>');
    }







	/**
	 * OnCheckChatRooms - very similar to onCheckClients, but associative
         * array contains chat room handlers instead of client handlers.
         * This function is very useful for online SMS chats.
	 *
         * @param ChatRoom[] $rooms array of handlers of the chatrooms
         * which need to be checked
	 */
	function _onCheckChatRooms(&$rooms)
	{
		Logger::func("onCheckChatRooms");
		foreach($rooms as $room)
		{
			
		}
	}







    /**
     * OnChatRoomClosed event is invoked when a room is about to close,
     * just after the last client left the room.
     *
     * @param ChatRoom $room handler of the chat room which has been closed
     */
    function _onChatRoomClosed($room)
    {
        Logger::func("onChatRoomClosed");
    }




?>
<?php
    //handle service
    require_once("servicehandler.php");
?>