<?php
/**
 * Radical Flash Chat
 *
 * LICENSE
 *
 * This source file is subject of Jaromir Sivic's ownership
 * and the commercial license on http://www.cze.cz.
 * It is not allowed to redistribute or modify source code
 * of this file. It is also not allowed to use any part
 * of the following Radical Chat source code in another projects.
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to radicalchat@cze.cz and you will be issued with a copy immediately.
 *
 * @category   Radical Chat
 * @copyright  Jaromir Sivic 2009
 * @license    http://www.cze.cz commercial license
 */
?>
<?php
/**
 * !!!!
 * DO NOT MODIFY THIS DOCUMENT
 */

require_once("serviceconfiguration.php");


/*COMMENT{*/
/**
 * Return string without text between tags
 * @param $prefix
 * @param $postfix
 * @param $value
 * @return sstring
 */
function deleteTextBetweenTags($prefix,$postfix,$value,$useEcho=false)
{
	$arr = explode($prefix,$value);
	$result = $arr[0];
	if($useEcho)
	{
		//print_r($arr);
		//exit();
	}
	for($a=1;$a<sizeof($arr);$a++)
	{
		$values = explode($postfix,$arr[$a],2);
		if(sizeof($values)==2)
		{
			$result .= $values[1];
			if($useEcho)
			{
				print_r($values);
			}
		}
	}
	return $result;
}


/**
 * Compress this php and save the result to servicehandler_compressed.php
 */
if(isset($HTTP_GET_VARS['compress']))
{
	$slash = "/";
	
	$file = "./servicehandler.php";
	if(isset($HTTP_GET_VARS["filename"]))
	{
		$file = $HTTP_GET_VARS["filename"];
	}
	
	if(file_exists($file))
	{
		$lines = file($file);
		for($a=0;$a<sizeof($lines);$a++)
		{
			$lines[$a] = trim($lines[$a]," \t\r\0\x0B");
		}
		$str = implode("",$lines);
		
		//delete comments
		$str = deleteTextBetweenTags($slash."*COMMENT{*".$slash,
		                             $slash."*}COMMENT*".$slash,$str);
		//delete comments
		$str = deleteTextBetweenTags($slash."**","*".$slash,$str);
		//delete empty lines
		for($a=0;$a<100;$a++)
		{
			$str = str_replace("\n\n","\n",$str);
			$str = str_replace("\n\r\n","\n",$str);
		}
		//delete comments
		$str = deleteTextBetweenTags($slash.$slash,"\n",$str);
		//delete brake line before {
		$str = str_replace("\r\n{","{",$str);
		//delete brake line after {
		$str = str_replace("{\r\n","{",$str);
		//delete brake line before }
		$str = str_replace("\r\n}","}",$str);
		//delete brake line after (
		$str = str_replace("(\r\n","(",$str);
		//delete brake line before )
		$str = str_replace("\r\n)",")",$str);
		//delete brake line after ,
		$str = str_replace(",\r\n",",",$str);
		
		$f = fopen($file.".compressed.php","w+");
		fputs($f,$str);
		fclose($f);
		echo $str;
	}
	exit();
}
/*}COMMENT*/


if($_SERVER["REQUEST_METHOD"]=="GET")
{
	
	/**
	* if wsdl is needed then show only wsdl
	*/
	if(isset($HTTP_GET_VARS['WSDL']) || isset($HTTP_GET_VARS['wsdl']))
	{
	   	header ("content-type: text/xml");
		$lines = file("./service.wsdl");
	   	//find location of service
	   	$slash = "/";
	   	$servicelocation = "http:".$slash.$slash.
	   	                   $_SERVER['HTTP_HOST'].$_SERVER[PHP_SELF];
	   	foreach($lines as $line)
	   	{
	   		echo str_replace("SERVICELOCATION", $servicelocation, $line);
	   	}
	   	exit();
	}
	/*COMMENT{*/
	else
	{
		echo '
				<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
				<html xmlns="http://www.w3.org/1999/xhtml">
				<head>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
				<title>Service</title>
				<style type="text/css">
				<!--
				body,td,th {
					color: #444;
				}
				body {
					background-color: #FFF;
				}
				.red {
					color: #900;
				}
				.black {
					color: #000;
				}
				.green {
					color: #090;
				}
				-->
				</style></head>
				<body>
				<h2><span class="red">R</span>adical <span class="black">C</span>hat (PHP)</h2>
				<p>&nbsp;</p>
				<p>
			';
		if(extension_loaded("soap"))
		{
			echo '
				<span class="green"><strong>SOAP</strong> extension detected.</span><br/>
			';
		}
		else
		{
			echo '
				<span class="red"><strong>SOAP </strong>extension not detected. Please install SOAP extension and enable it in php.ini.</span><br/>
			';
		}
		if(extension_loaded("iconv"))
		{
			echo '
				<span class="green"><strong>ICONV</strong> extension detected. Actual charset is Configuration::$LOCAL_ENCODING="'.Configuration::$LOCAL_ENCODING.'"</span><br/>
			';
		}
		else
		{
			echo '
				<span class="red"><strong>ICONV </strong>extension not detected. There might be some problems with special characters. Please install ICONV extension and enable it in php.ini.</span><br/>
			';
		}
		
		echo '
			</p>
			<p>Web service description - <a href="?wsdl">here</a>.<br />
			More information on <a href="http://www.cze.cz">http://www.cze.cz</a>.</p>
			</body>
			</html>
		';
	}
	/*}COMMENT*/
}



/**
 * Class with constants
 */
class Constants
{
    public static $SEPARATOR = "~~";
    public static $NEWLINE = "~!~";
        
    public static function clearFromSeparators($value)
    {
    	return str_replace(Constants::$NEWLINE,"TYLDA",
    	       str_replace(Constants::$SEPARATOR,"TYLDA",$value));
    }
    
    
    
    /**
     * Convert value to utf8
     * @param $value in any encoding
     * @return string
     */
    public static function utf8encode($value)
    {
    	//change tags, etc into html entities
    	$value = htmlspecialchars($value);
    	//check if function iconv exists
    	if((Configuration::$LOCAL_ENCODING=="ISO-8559-1") ||
    	   (!(function_exists("iconv"))))
    	{
   			$value = utf8_encode($value);
    		return $value;
    	}
    	//encode string
    	return iconv(Configuration::$LOCAL_ENCODING,"UTF-8",$value);
    }
    
    
    
	/**
     * Convert value from utf8 to local encoding
     * @param $value in any encoding
     * @return string
     */
    public static function utf8decode($value)
    {
     	//check if function iconv exists
    	if((Configuration::$LOCAL_ENCODING=="ISO-8559-1") ||
    	   (!(function_exists("iconv"))))
    	{
   			$value = utf8_decode($value);
    		$value = htmlspecialchars_decode($value);
    		return $value;
    	}
    	//decode string
    	$value = iconv("UTF-8",Configuration::$LOCAL_ENCODING,$value);
    	return htmlspecialchars_decode($value);
    }
    
    
    
	/**
	 * Trim string value
	 * @param sstring $value
	 * @return sstring
	 */
	public static function trim($value)
	{
		return trim($value,"  \t\n\r\0\x0B");
	}
}


/**
 * Class with chat events
 * @author jarda
 *
 */
class ChatEvents
{
	public static $EVENT_BASICBUTTONCLICKED_WITHSELECTEDCLIENTS = 
    	    "CHAT.SKIN.BASICBUTTON.CLICKED_WITHSELECTEDCLIENTS";
	public static $EVENT_BASICBUTTONCLICKED = "CHAT.SKIN.BASICBUTTON.CLICKED";
}


/**
 * GlobalStatus refering in which status
 * the service actually is
 */
/*COMMENT{*/
class GlobalStatus
{
	public static $clientGetFuncOnly = false;
	public static $roomGetFuncOnly = false;
	public static $actualServiceFunction = "";
	public static $disableWarnings = false;
	
	/**
	 * Set global status
	 * @param $aClientGetFuncOnly
	 * @param $aRoomGetFuncOnly
	 * @param $aActualServiceFunction
	 * @return unknown_type
	 */
	public function setGlobalStatus($aClientGetFuncOnly, 
	                                $aRoomGetFuncOnly,
	                                $aActualServiceFunction)
	{
		GlobalStatus::$clientGetFuncOnly = $aClientGetFuncOnly;
		GlobalStatus::$roomGetFuncOnly = $aRoomGetFuncOnly;
		GlobalStatus::$actualServiceFunction = $aActualServiceFunction;
	}
	
	public function potentialThreat($className, $methodName, $UID)
	{
		if(!GlobalStatus::$disableWarnings)
		{
			Logger::warn("You are attemting to use method \"" .
		             $className . "->" . $methodName .
		             "\" somewhere inside <br/>\"_" .
		             GlobalStatus::$actualServiceFunction . 
		             "\" function, which is not allowed.<br/> " . 
		             "Method will proceed most likely without any effect " .
		             "and in the future this may cause ".
		             "potential problems.<br/> " .
		             "Please do not use method \"" .
		             $className . "->" . $methodName . 
		             "\" in the \"_" . 
		             GlobalStatus::$actualServiceFunction .
		             "\" function.");
		}
	}
}
/*}COMMENT*/



class StreamServerCommands
{
	/**
	 * @var Client
	 */
	private $parentObject;
	
	/**
	 * This StreamServerCommands are in Client class or in Room class
	 * @var unknown_type
	 */
	private $amIClient = true;
	
	public static $COMMAND_OPENWEBPAGE = "commandOpenWebPage";
	public static $COMMAND_REJECTCONNECTION = "COMMAND_REJECTCONNECTION";
	public static $COMMAND_SETNEXTCHECK = "COMMAND_SETNEXTCHECK";
	public static $COMMAND_SETDESCRIPTION = "COMMAND_SETDESCRIPTION";
	public static $COMMAND_CLOSEROOM = "COMMAND_CLOSEROOM";
	public static $COMMAND_STOPSTREAMING = "COMMAND_STOPSTREAMING";
	public static $COMMAND_SETDEFAULTNEXTCHECK = "COMMAND_SETDEFAULTNEXTCHECK";
	
	/**
	 * Constructor
	 * @param $aParentObject
	 * @param $aAmIClient
	 */
	public function StreamServerCommands($aParentObject,$aAmIClient)
	{
		//save parent object
		$this->parentObject = $aParentObject;
		//save if I am client
		$this->amIClient = $aAmIClient;
	}
	
	
	
	/*COMMENT{*/
	/**
	 * Check if method can be used
	 * @param $methodName
	 */
	private function checkIfMethodCanBeUsed($methodName)
	{
		if((GlobalStatus::$clientGetFuncOnly) && ($this->amIClient))
    	{
    		GlobalStatus::potentialThreat(
    				"Client->getStreamServerCommands()",
    		        $methodName,$this->parentObject->getUID());
    	}    	
    	if((GlobalStatus::$roomGetFuncOnly)   && (!$this->amIClient))
    	{
    		GlobalStatus::potentialThreat(
    				"ChatRoom->getStreamServerCommands()",
    		        $methodName,$this->parentObject->getUID());
    	}
	}
	/*}COMMENT*/
	
	/**
	 * Open new web page in the client's web browser.
         * @example
         *      $ssc = $client->getStreamServerCommands();<br />
         *      $ssc->client_OpenWebPage($client->getUID(), "http://www.cze.cz", "_blank");<br />
	 * @param sstring $url - url like http://www.mypage.com/nextchat
         * @param sstring $target - like _self, _blank,
	 * @param sstring $clientUID - uid of the client where the window 
	 * will be opened, if $clientUID is null 
	 */
	public function client_OpenWebPage($clientUID,$url,$target)
	{
		//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "client_OpenWebPage";
    	$this->checkIfMethodCanBeUsed($methodName);
    	/*}COMMENT*/
    	
    	//open web page in clients browser
    	$this->parentObject->pushCommand(
    					  StreamServerCommands::$COMMAND_OPENWEBPAGE,
                          $clientUID,false,
                          array("URL=$url", "TARGET=$target"));
	}
	
	
	
	/**
	 * Reject connection to the stream server for the client with UID $clientUID
	 * @param sstring $clientUID UID of the client which connection will be rejected
	 */
	public function client_RejectConnection($clientUID)
	{
		//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "client_RejectConnection";
    	$this->checkIfMethodCanBeUsed($methodName);
    	/*}COMMENT*/
		
		//reject client connection
    	$this->parentObject->pushCommand(
			    StreamServerCommands::$COMMAND_REJECTCONNECTION,
			    $clientUID,false,null);
	}
	
	
	
	/**
	 * Set client's nextCheck variable
	 * @param sstring $clientUID UID of the client
	 * @param int $nextCheck integer value (in seconds), which specifies the interval when
         * the onCheckClients event will be called by the client with $clientUID. If the
         * value is equal or lower than zero, then onCheckClients will
         * never be called (by the client $client) again.
	 */
	public function client_setNextCheck($clientUID,$nextCheck)
	{
		//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "client_setNextCheck";
    	$this->checkIfMethodCanBeUsed($methodName);
    	/*}COMMENT*/
		
		//set client next check
    	$this->parentObject->pushCommand(
			    StreamServerCommands::$COMMAND_SETNEXTCHECK,
			    $clientUID,false,
			    array("nextCheck=$nextCheck"));
	}
	
	
	
        /**
	 * If client's NextCheck property is lower than zero, then nextCheckDefault will be used.
	 * When client is created the nextCheckDefault value is -1 by default.
	 * @param sstring $clientUID UID of the client which nextCheckDefault value is manipulated
	 * @param int $defaultNextCheck new value of nextCheckDefaultValue
	 */
	public function client_setNextCheckDefaultValue($clientUID,$defaultNextCheck)
	{
		//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "client_setNextCheckDefaultValue";
    	$this->checkIfMethodCanBeUsed($methodName);
    	/*}COMMENT*/
    	
    	//open web page in clients browser
    	$this->parentObject->pushCommand(
    					  StreamServerCommands::$COMMAND_SETDEFAULTNEXTCHECK,
                          $clientUID,false,
                          array("defaultNextCheck=$defaultNextCheck"));
	}
	
	
	
	/**
	 * Set client's description
	 * @param sstring $clientUID UID of the client which description value is manipulated
	 * @param sstring $description new description
	 */
	public function client_setDescription($clientUID,$description)
	{
		//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "client_setDescription";
    	$this->checkIfMethodCanBeUsed($methodName);
    	/*}COMMENT*/
		
		//set clients description
    	$this->parentObject->pushCommand(
			    StreamServerCommands::$COMMAND_SETDESCRIPTION,
			    $clientUID,false,
			    array("description=$description"));
	}
	
	
	

	/**
	 * Force the client with specified UID to stop publishing the stream
	 * @param sstring $clientUID - client who will be forced to stop streaming
	 * @param sstring $streamUID - full unique id of the stream
	 */
	public function client_stopStreaming($clientUID,$streamUID)
	{
		//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "client_stopStreaming";
    	$this->checkIfMethodCanBeUsed($methodName);
    	/*}COMMENT*/
		
		//set clients description
    	$this->parentObject->pushCommand(
			    StreamServerCommands::$COMMAND_STOPSTREAMING,
			    $clientUID,false,
			    array("streamUID=$streamUID"));
	}
	
	
	
	/**
	 * Return the client's skin manipulator
	 * @param sstring $clientUID UID of the client
	 * @return Skin Skin manipulator
	 */
	public function client_getSkin($clientUID)
	{
		//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "client_getSkin";
    	$this->checkIfMethodCanBeUsed($methodName);
    	/*}COMMENT*/
		
    	//return client skin
		return new Skin($this->parentObject,true,$clientUID);
	}
	
	
	
	/**
	 * Set room's next check variable
	 * @param sstring $roomUID UID of the room
	 * @param int $nextCheck integer value (in seconds), which specifies the interval when
         * the onCheckChatRooms event will be called by the chat room with $roomUID. If the
         * nextCheck value is equal or lower than zero, then onCheckChatRooms will
         * never be called (by the chat room) again.
	 */
	public function room_setNextCheck($roomUID,$nextCheck)
	{
		//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "room_setNextCheck";
    	$this->checkIfMethodCanBeUsed($methodName);
    	/*}COMMENT*/
		
		//set rooms description
    	$this->parentObject->pushCommand(
			    StreamServerCommands::$COMMAND_SETNEXTCHECK,
			    $roomUID,true,
			    array("nextCheck=$nextCheck"));
	}
	
	
	
    /**
	 * If room's NextCheck property is lower than zero, then nextCheckDefaultValue will be used.
	 * When room is created the nextCheckDefaultvalue is -1 by default.
	 * @param sstring $roomUID UID of the room which nextCheckDefaultValue is manipulated
	 * @param sstring $defaultNextCheck new nextCheckDefaultValue
	 */
	public function room_setNextCheckDefaultValue($roomUID,$defaultNextCheck)
	{
		//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "room_setNextCheckDefaultValue";
    	$this->checkIfMethodCanBeUsed($methodName);
    	/*}COMMENT*/
    	
    	//open web page in clients browser
    	$this->parentObject->pushCommand(
    					  StreamServerCommands::$COMMAND_SETDEFAULTNEXTCHECK,
                          $roomUID,true,
                          array("defaultNextCheck=$defaultNextCheck"));
	}
	
	
	
	/**
	 * Set room's description
	 * @param sstring $roomUID UID of the room
	 * @param sstring $description new description
	 */
	public function room_setDescription($roomUID,$description)
	{
		//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "room_setDescription";
    	$this->checkIfMethodCanBeUsed($methodName);
    	/*}COMMENT*/
		
		//set rooms description
    	$this->parentObject->pushCommand(
			    StreamServerCommands::$COMMAND_SETDESCRIPTION,
			    $roomUID,true,
			    array("description=$description"));
	}
	
	
	
	/**
	 * Close the room and disconnect all clients in it
	 * @param sstring $roomUID UID of the room
	 */
	public function room_CloseRoom($roomUID)
	{
		//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "room_CloseRoom";
    	$this->checkIfMethodCanBeUsed($methodName);
    	/*}COMMENT*/
		
		//set rooms description
    	$this->parentObject->pushCommand(
			    StreamServerCommands::$COMMAND_CLOSEROOM,
			    $roomUID,true,null);
	}
	
	
	
	/**
	 * Return the room skin manipulator
	 * @param sstring $roomUID UID of the room
	 * @return Skin skin manipulator
	 */
	public function room_getSkin($roomUID)
	{
		//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "room_getSkin";
    	$this->checkIfMethodCanBeUsed($methodName);
    	/*}COMMENT*/
		
    	//return room skin
		return new Skin($this->parentObject,false,$roomUID);
	}
}



class Skin
{
	/**
	 * @var Client
	 */
	private $parentObject;
	
	/**
	 * This StreamServerCommands are in Client class or in Room class
	 * @var unknown_type
	 */
	private $amIClient = true;
	/**
	 * Client or room uid which skin will be changed
	 * @var unknown_type
	 */
	private $clientRoomUID = "";
	
	public static $COMMAND_UPDATESKINOBJECT = "COMMAND_UPDATESKINOBJECT";
	public static $COMMAND_DELETEALLSKINOBJECTUPDATES = 
					"COMMAND_DELETEALLSKINOBJECTUPDATES";
	
	
	
	/**
	 * Constructor
	 * @param $aParentObject
	 * @param $aAmIClient
	 */
	public function Skin($aParentObject,$aAmIClient,$aClientRoomUID)
	{
		//save parent object like Client or ChatRoom
		$this->parentObject = $aParentObject;
		//save if I am client
		$this->amIClient = $aAmIClient;
		//set clientRoomUID
		$this->clientRoomUID = $aClientRoomUID;
	}
	
	
	
	/*COMMENT{*/
	/**
	 * Check if method can be used
	 * @param $methodName
	 */
	private function checkIfMethodCanBeUsed($methodName)
	{
		if((GlobalStatus::$clientGetFuncOnly) && 
		   (GlobalStatus::$roomGetFuncOnly))
    	{
    		GlobalStatus::potentialThreat(
    				"client_getSkin() or room_getSkin()",
    		        $methodName,$this->parentObject->getUID());
    	}    	
	}
	/*}COMMENT*/
	
	
	
	/**
	 * Update or create new SkinObject. Using this method the developer
         * can update only one SkinObject at most. If developer wants to update
         * more SkinObjects, then updateSkinObject must be executed more times
         * (one per each object). The given XML path must be the full path
         * to the SkinObject including XML
         * elements &lt;Skin&gt; and layer(&lt;BG&gt;&lt;ML&gt;&lt;FG&gt;).It is possible to change all
         * properties of SkinOjbect at once. If SkinObject with
         * a given &lt;Name&gt; does not exist in the Radical Flash Player,
         * then it is dynamically created, otherwise existing
         * object is updated. &lt;Type&gt; of the old and new SkinObject
         * must be the same.
	 * @param sstring $xmlText SkinObject xml
         * @example
         *      //try to alter room skin<br />
         *      $ssc = $room->getStreamServerCommands();<br />
         *      $skin = $ssc->room_getSkin($room->getUID());<br />
         *      //set room name<br />
         *      $skin->updateSkinObject(<br />
         *         '&lt;Skin&gt;&lt;BG&gt;&lt;SkinObject&gt;&lt;Type&gt;HtmlTextArea&lt;/Type&gt;<br />
         *          &lt;Name&gt;RoomName&lt;/Name&gt;<br />
         *          &lt;Visible&gt;true&lt;/Visible&gt;<br />
         *          &lt;Position&gt;<br />
         *                  &lt;Left&gt;10&lt;/Left&gt;<br />
         *                  &lt;Top&gt;5&lt;/Top&gt;<br />
         *                  &lt;Width&gt;400&lt;/Width&gt;<br />
         *                  &lt;Height&gt;50&lt;/Height&gt;<br />
         *          &lt;/Position&gt;'.<br />
         *          '&lt;HtmlText&gt;{{FONT SIZE="12" COLOR="#000000" '.<br />
         *          'LETTERSPACING="0" KERNING="0"}}'.<br />
         *          '{{B}}'.$room->getUID().'{{/B}}{{/FONT}}&lt;/HtmlText&gt;'.<br />
         *          '&lt;IsTextSelectable&gt;false&lt;/IsTextSelectable&gt;<br />
         *          &lt;/SkinObject&gt;&lt;/BG&gt;&lt;/Skin&gt;');<br />
	 */
	public function updateSkinObject($xmlText)
	{
		//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "updateSkinObject";
    	$this->checkIfMethodCanBeUsed($methodName);
    	
    	if(preg_match_all("/<|>/",$xmlText,$out) & 1 == 1)
    	{
    		Logger::error("There is different count of ".
    					 "&gt;, than &lt; in: ".
    					 Constants::utf8encode($xmlText));
    	}
    	
    	//test if there is only one name tag in $xmlText
    	$arr = explode("<Name>",$xmlText);
    	if(sizeof($arr)!=2)
    	{
    		Logger::error("You are attempting to update more SkinObjects ".
    					 "at once. :".
    					 "There were found more &lt;Name&gt; tags in: ".
    					 Constants::utf8encode($xmlText));
    	}
    	else
    	{
    		$arr = explode("</Name>",$arr[1]);
	    	if((sizeof($arr)!=2) || (strlen(trim($arr[0]))<1))
	    	{
	    		Logger::error("You are attempting to update SkinObject ".
	    					 "with empty name: ".
	    					 Constants::utf8encode($xmlText));
	    	}
    	}
    	/*}COMMENT*/
		
		//delete all white spaces between end and start tag
    	$xmlText = preg_replace("/>(\n|\r|\t| )*</","> <",$xmlText);
    	
    	//set object xml text
    	$this->parentObject->pushCommand(
			    Skin::$COMMAND_UPDATESKINOBJECT,
			    $this->clientRoomUID,!$this->amIClient,
			    (array("xml=".Constants::utf8encode($xmlText))));
	}
	
	
	
	/**
         * Method returns SkinObject back to stage before
         * Radical Flash Chat established connection with stream server.
         * That means - if object was created dynamically, then it is deleted,
         * otherwise object is restored to the state specified in XML
         * configuration file.
         * @param sstring $skinObjectName name of the SkinObject
         */
        public function deleteAllSkinObjectUpdates($skinObjectName)
	{
		//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "deleteAllSkinObjectUpdates";
    	$this->checkIfMethodCanBeUsed($methodName);
    	/*}COMMENT*/
		
		//set object xml text
    	$this->parentObject->pushCommand(
			    Skin::$COMMAND_DELETEALLSKINOBJECTUPDATES,
			    $this->clientRoomUID,!$this->amIClient,
			    (array("skinObjectName=$skinObjectName")));
	}
}
    
    
    

//if (!class_exists("getAPICode")) {
/**
 * getAPICode
 */
class getAPICode {
}
//}





//if (!class_exists("getAPICodeResponse")) {
/**
 * getAPICodeResponse
 */
class getAPICodeResponse {
	/**
	 * @access public
	 * @var sstring
	 */
	public $getAPICodeResult;
	//set the final result
	public function setResult($value)
	{
		$this->getAPICodeResult = $value;
	}
	
	public function SOAPResult()
	{
		return new SoapParam($this,"getAPICodeResponse");
	}
}
//}









//if (!class_exists("getImplementedFunctions")) {
/**
 * getImplementedFunctions
 */
class getImplementedFunctions {
}
//}

//if (!class_exists("getImplementedFunctionsResponse")) {
/**
 * getImplementedFunctionsResponse
 */
class getImplementedFunctionsResponse {
	/**
	 * @access public
	 * @var sstring
	 */
	public $getImplementedFunctionsResult;
	//set final result
	public function setResult($value)
	{
		$this->getImplementedFunctionsResult = $value;
	}
	//return response
	public function SOAPResult()
	{
		return new SoapParam($this,"getImplementedFunctionsResponse");
	}
}
//}








//if (!class_exists("onApplicationStarted")) {
/**
 * onApplicationStarted
 */
class onApplicationStarted {
}
//}

//if (!class_exists("onApplicationStartedResponse")) {
/**
 * onApplicationStartedResponse
 */
class onApplicationStartedResponse {
    //return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onApplicationStartedResponse");
	}
}
//}








//if (!class_exists("onApplicationStopped")) {
/**
 * onApplicationStopped
 */
class onApplicationStopped {
}
//}

//if (!class_exists("onApplicationStoppedResponse")) {
/**
 * onApplicationStoppedResponse
 */
class onApplicationStoppedResponse {
    //return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onApplicationStoppedResponse");
	}
}
//}







//if (!class_exists("onClientWantsToConnect")) {
/**
 * onClientWantsToConnect
 */
class onClientWantsToConnect {
	/**
	 * @access public
	 * @var Client
	 */
	public $client;
}
//}

//if (!class_exists("Client")) {
/**
 * Client
 */
class Client {
		
	/**
	 * @access public
	 * @var sstring
	 */
	private $UID;
    /**
     * Get client unique id - this id was setted up in config.xml or by flashvars
     * @return sstring return client UID
     */
    public function getUID() { return $this->UID; }
	
    
    
    
	/**
	 * @access public
	 * @var sstring
	 */
	private $nickname;
    /**
     * Get client nick name.
     * @return sstring return client's nick name
     */
    public function getNickName() { return $this->nickname; }
    /**
     * Set client nick name. This method could be called only in onClientWantsToConnect.
     * @param sstring $value new client nick name.
     */
    public function setNickName($value)
    { 
    	//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "setNickName";
    	if((GlobalStatus::$clientGetFuncOnly) || 
    	   (GlobalStatus::$actualServiceFunction!="onClientWantsToConnect"))
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->nickname = $value; 
    }
	
    
    
	/**
	 * @access public
	 * @var sboolean
	 */
	private $isStreaming;
    /**
     * Return true if client has published at least one stream.
     * @return sboolean
     */
    public function getIsStreaming() { return $this->isStreaming; }
    
    
    
    
	/**
	 * @access public
	 * @var sboolean
	 */
	private $connected;
	
	
	
	
	/**
	 * @access public
	 * @var sstring
	 */
	private $roomUID;
    /**
     * Get room unique ID where the client is presented (logged in)
     * @return sstring;
     */
    public function getRoomUID() { return $this->roomUID; }
    /**
     * Set unique ID of the room, where client will be redirected.
     * This could be done only in onClientWantsToConnect.
     * @param sstring $value
     */
    private function setRoomUID($value)
    { 
    	//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "setRoomUID";
    	if((GlobalStatus::$clientGetFuncOnly) || 
    	   (GlobalStatus::$actualServiceFunction!="onClientWantsToConnect"))
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->roomUID = $value; 
    }
	
	
	
	
	/**
	 * @access public
	 * @var sstring
	 */
	private $chatText;
	
	
	
	
	/**
	 * @access public
	 * @var int
	 */
	private $nextCheck;
    /**
     * Return amount of seconds (timeout) indicating when the
     * client will be checked next time and when the 
     * event onCheckClients will be triggered by the client.
     * @return int
     */
    public function getNextCheck() { return $this->nextCheck; }
    /**
     * Set "timeout" when the client will be checked by onCheckClients event
     * @param int $value
     */
    public function setNextCheck($value) 
    { 
    	//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "setNextCheck";
    	if(GlobalStatus::$clientGetFuncOnly)
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->nextCheck = $value; 
    }
    
    
    
    
	/**
	 * @access public
	 * @var sstring
	 */
	private $commands;
	/**
	 * @access public
	 * @var sstring
	 */
	private $additionalVariables;
	private $_unserializedVars = null;
	
	
	
	/**
	 * Get property (additional variable) previously
	 * defined by setProperty method.
	 * Always test if value is not null.
	 * @param $propertyName - name of the property
	 * @return mixed
	 */
	private function getProperty($propertyName)
	{
		//if variable was not unserialized yet then unserialize it
		if($this->_unserializedVars == null)
		{
			//if additionalVariables does not contain anything then create
		    //plain array
			if(($this->additionalVariables==null) || 
			   (strlen(trim($this->additionalVariables," \t\n\r\0\x0B"))<1))
			{
				$this->_unserializedVars = array();
			}
			//else unserialize additional variables
			else
			{
				$this->_unserializedVars = 
				        unserialize($this->additionalVariables);
			}
		}
		
		//return result
		return $this->_unserializedVars[$propertyName];
	}
	
	
	
	/**
	 * By setProperty method you can add your own
	 * variables into this object. Variables type can be
	 * string, boolean, byte, integer, object.
	 * @param $propertyName
	 * @param $mixed
	 */
	private function setProperty($propertyName,$mixed)
	{
	    //check if method can be used here
    	/*COMMENT{*/
    	$methodName = "setProperty";
    	if(GlobalStatus::$clientGetFuncOnly)
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
		
		//if variable was not unserialized yet then unserialize it
		if($this->_unserializedVars == null)
		{
			//if additionalVariables does not contain anything then create
		    //plain array
			if(($this->additionalVariables==null) || 
			   (strlen(trim($this->additionalVariables," \t\n\r\0\x0B"))<1))
			{
				$this->_unserializedVars = array();
			}
			//else unserialize additional variables
			else
			{
				$this->_unserializedVars = 
				        unserialize($this->additionalVariables);
			}
		}
		
		//save variable
		$this->_unserializedVars[$propertyName] = $mixed;
	}
	
	
	/**
	 * Save variables
	 * deprecated method.
	 * Please use setProperty and getProperty methods.
	 */
	public function saveAdditionalVariables()
	{
		//if there were some changes to unserialized variables
		//then serialize them to AdditionalVariables
		if($this->_unserializedVars != null)
		{
			$this->additionalVariables = 
			        serialize($this->_unserializedVars);
		}
	}
	
	
	
	
	/**
	 * @access public
	 * @var sboolean
	 */
	private $dispatchEventIfClientSendChatMessage;
    /**
     * Return true if client is dispatching event
     * onClientSendMessage every time
     * when client send a chat message
     * @return sboolean
     */
    public function getDispatchEventIfClientSendChatMessage() 
    { return $this->dispatchEventIfClientSendChatMessage; }
    /**
     * If $value is true, then client will dispatch event
     * onClientSendMessage every time
     * when client send chat text message
     * @param sboolean $value
     */
    public function setDispatchEventIfClientSendChatMessage($value)
    { 
    	//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "setDispatchEventIfClientSendChatMessage";
    	if(GlobalStatus::$clientGetFuncOnly)
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->dispatchEventIfClientSendChatMessage = $value; 
    }
    
    
	/**
	 * @access public
	 * @var sstring
	 */
	private $description;
    /**
     * Return client's description
     * @return sstring
     */
    public function getDescription() { return $this->description; }
     /**
     * Set client's description
     * @param sstring $value
     */
    public function setDescription($value) 
    { 
    	//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "setDescription";
    	if(GlobalStatus::$clientGetFuncOnly)
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->description = $value; 
    }
	
	
	
	
	/**
	 * @access public
	 * @var sboolean
	 */
	private $StreamAccepted;
	
	
	
	
	/**
	 * @access public
	 * @var sstring
	 */
	private $IP;
    /**
     * Return client's IP address
     * @return sstring
     */
    public function getIP() { return $this->IP; }
	
	
	
	
	/**
	 * @access public
	 * @var sstring
	 */
	private $flashVersion;
    /**
     * Return version of client's flash player
     * @return sstring
     */
    public function getFlashVersion() { return $this->flashVersion; }
    
    
    
    
	/**
	 * @access public
	 * @var sstring
	 */
	private $userFlag;
     /**
     * Return client userFlag - used only if client can publish stream.
     * UserFlag specify videopanel where client's stream 
     * will be published - see config.xml.
     * @return sstring
     */
    private function getUserFlag() { return $this->userFlag; }
    /**
     * Set client userFlag - used only if client can publish stream. 
     * UserFlag specify videopanel where client's stream
     * will be published - see config.xml.
     * @param sstring $value
     * @return unknown_type
     */
    private function setUserFlag($value)
    { 
    	//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "setUserFlag";
    	if((GlobalStatus::$clientGetFuncOnly) ||
    	   (GlobalStatus::$actualServiceFunction!="onClientWantsToConnect"))
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->userFlag = $value; 
    }
	
	/**
	 * @access public
	 * @var sstring
	 */
	private $cookie;
	
	
	
    /**
     * Reject (disconnect) client from the chat.
     */
    public function RejectConnection()
    {
        //check if method can be used here
    	/*COMMENT{*/
    	$methodName = "RejectConnection";
    	if(GlobalStatus::$clientGetFuncOnly)
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->connected = false;
    }

    /**
     * Accept client's connection.
     * This method must be called in onClientWantsToConnect event,
     * otherwise client will be rejected.
     */
    public function AcceptConnection()
    {
     	//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "AcceptConnection";
    	if(GlobalStatus::$clientGetFuncOnly)
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->connected = true;
    }

	/**
	 * Initialize $_SESSION variables for this client.
	 * If developer wants to use a session in the chat,
	 * then the "cookie" property must be set in the flashvars, before
	 * the main swf file is loaded.
	 * 
	 * @example
	 *     &lt;param name="FlashVars"<br />
	 *     value="config=config.xml&UID.............<br />
	 *     ....&cookie=<?php echo ini_get("session.name").<br />
	 *     "%3D".session_id();  ........"&gt;
	 */
    public function StartSESSION()
	{
	    //start the session
		$arr = explode("=",$this->cookie);
		if(sizeof($arr==2))
		{
		    Configuration::startSession($arr[1]);
		}
	}

    /**
     * Ssend text message to the client with uid $toUID
     * @param sstring $fromUserName - nickname of the sender. For example Admin.
     * @param sstring $toUID - UID of the receiver
     * @param sstring $color - message color in hexformat like "FF0011"
     * @param sstring $text - message text
     */
    public function SendPrivateMessage($fromUserName, $toUID, $color, $text)
    {
        //check if method can be used here
    	/*COMMENT{*/
    	$methodName = "SendPrivateMessage";
    	if(GlobalStatus::$clientGetFuncOnly)
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->SendMessage($this->UID,$fromUserName,$toUID,$color,$text);
    }
    
    
    
    /**
     * Send indirect private message
     * @param $fromUID - UID of the client who is sending message
     * @param $fromUserName - nickname of the sender. For example Admin
     * @param $toUID - UID of the receiver
     * @param $color - message color in hexformat like "FF0011"
     * @param $text - message text
     */
    public function SendIndirectPrivateMessage($fromUID, $fromUserName, $toUID, $color, $text)
    {
    	//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "SendIndirectPrivateMessage";
    	if(GlobalStatus::$clientGetFuncOnly)
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->SendMessage($fromUID, $fromUserName, $toUID, $color, $text);
    }

    /**
     * Send text message to all clients in the actual chat room.
     * @param sstring $fromUserName - nicname of the sender
     * @param sstring $color - message color in hexformat like "FF0011"
     * @param sstring $text - message text
     */
    public function SendRoomMessage($fromUserName, $color, $text)
    {
        //check if method can be used here
    	/*COMMENT{*/
    	$methodName = "SendRoomMessage";
    	if(GlobalStatus::$clientGetFuncOnly)
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->SendMessage($this->UID,$fromUserName,"_ALL",$color,$text);
    }
    
	/**
	 * Send a message
	 * @param $fromUID
	 * @param $fromUserName
	 * @param $toUID
	 * @param $color
	 * @param $text
	 * @return unknown_type
	 */
    private function SendMessage($fromUID, $fromUserName, $toUID, $color, $text)
    {	
    	//convert fromUserName to utf8
    	$fromUserName = Constants::utf8encode(strtr($fromUserName,'~',';'));
    	//convert text to utf8
    	$text = Constants::utf8encode(strtr($text,'~',';'));
    	
    	$this->chatText .= "TextMessage" .
        		"~~fromClientUID=" . strtr($fromUID,'~',';') . 
                "~~fromClientNickName=" . $fromUserName . 
        		"~~toClientUID=" . strtr($toUID,'~',';') .
        		"~~color=" . strtr($color,'~',';') . 
        		"~~message=" . $text . "~!~";
    }

    
    
    
    /**
     * This function can be used if intellisense does not work.
     * You can retype any variable into Client.
     * @param mixed $variable
     * @return Client
     */
    public static function castToClient($variable)
    {
    	return $variable;
    }
    
    
    
    /**
     * @var StreamServerCommands
     */
    private $streamServerCommands = null;
    
    /**
     * Return stream server commands,
     * huge set of more sophisticated commands
     * @return StreamServerCommands
     */
    public function getStreamServerCommands()
    {
    	//if stream server commands was not created before than create it
    	if($streamServerCommands==null)
    	{
    		$streamServerCommands = new StreamServerCommands($this,true);
    	}
    	//return $streamServerCommands
    	return $streamServerCommands;
    }
    
    
    
    /**
     * Deprecated function, please use getStreamServerCommands() instead.
     * @deprecated
     * @param $commandName
     * @param $parameters
     * @param $clientRoomUID
     * @param $commandForWholeRoom
     */
    public function pushCommand($commandName, 
                                $clientRoomUID = null,
                                $isRoomCommand = false,
                                $parameters = null)
    {
    	//test if command is null
        if($this->commands==null)
        {
            $this->commands = "";
        }
        //clear parameters from separators
        $outparams = "";
        if($parameters!=null)
        {
	        for($a=0;$a<sizeof($parameters);$a++)
	        {
	        	$parameters[$a] = 
	        		Constants::clearFromSeparators($parameters[$a]);
	        }
	        //create outparams
	        $outparams = implode(Constants::$SEPARATOR,$parameters);
        }
        
        //if $clientRoomUID is null then use my UID
        if($clientRoomUID==null)
        {
        	$clientRoomUID = $this->getUID();
        }
        
        $strIsRoomCommand = "false";
        if($isRoomCommand)
        {
        	$strIsRoomCommand = "true";
        }
                     
        //create command
        $this->commands .= "Command" . Constants::$SEPARATOR .
        			Configuration::generateNextContinuousUID() . Constants::$SEPARATOR .
                    $strIsRoomCommand . Constants::$SEPARATOR .
                    $clientRoomUID . Constants::$SEPARATOR . 
        		    $commandName . Constants::$SEPARATOR .
        		    $outparams . Constants::$NEWLINE;
    }

    
    
    
    /**
     * Enable streaming - now client can publish the stream
     */
    public function setStreamingAccepted()
    {
        //check if method can be used here
    	/*COMMENT{*/
    	$methodName = "setStreamingAccepted";
    	if((GlobalStatus::$clientGetFuncOnly) || 
    	   (GlobalStatus::$actualServiceFunction!="onClientWantsToStartStreaming"))
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->StreamAccepted = true;
    }

    /**
     * Disable streaming - client can not publish the stream
     */
    public function setStreamingRejected()
    {
        //check if method can be used here
    	/*COMMENT{*/
    	$methodName = "setStreamingRejected";
    	if((GlobalStatus::$clientGetFuncOnly) || 
    	   (GlobalStatus::$actualServiceFunction!="onClientWantsToStartStreaming"))
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->StreamAccepted = false;
    }

    /**
     * Client can play the stream - client can attach live stream
     */
    public function setPlayStreamAccepted()
    {
        //check if method can be used here
    	/*COMMENT{*/
    	$methodName = "setPlayStreamAccepted";
    	if((GlobalStatus::$clientGetFuncOnly) || 
    	   (GlobalStatus::$actualServiceFunction!="onClientWantsToPlayStream"))
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->StreamAccepted = true;
    }

    /**
     * Client cannot play stream - client cannot attach live stream
     */
    public function setPlayStreamRejected()
    {
        //check if method can be used here
    	/*COMMENT{*/
    	$methodName = "setPlayStreamRejected";
    	if((GlobalStatus::$clientGetFuncOnly) || 
    	   (GlobalStatus::$actualServiceFunction!="onClientWantsToPlayStream"))
    	{
    		GlobalStatus::potentialThreat("Client",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->StreamAccepted = false;
    }
}
//}

//if (!class_exists("onClientWantsToConnectResponse")) {
/**
 * onClientWantsToConnectResponse
 */
class onClientWantsToConnectResponse {
	/**
	 * @access public
	 * @var Client
	 */
	public $onClientWantsToConnectResult;
	//set result value
	public function setResult($value)
	{
		$this->onClientWantsToConnectResult = $value;
	}
    //return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onClientWantsToConnectResponse");
	}
}
//}






//if (!class_exists("onClientConnectionWasAccepted")) {
/**
 * onClientConnectionWasAccepted
 */
class onClientConnectionWasAccepted {
	/**
	 * @access public
	 * @var Client
	 */
	public $client;
}
//}

//if (!class_exists("onClientConnectionWasAcceptedResponse")) {
/**
 * onClientConnectionWasAcceptedResponse
 */
class onClientConnectionWasAcceptedResponse {
	/**
	 * @access public
	 * @var Client
	 */
	public $onClientConnectionWasAcceptedResult;
    //set result value
	public function setResult($value)
	{
		$this->onClientConnectionWasAcceptedResult = $value;
	}
    //return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onClientConnectionWasAcceptedResponse");
	}
}
//}






//if (!class_exists("onClientConnectionWasRejected")) {
/**
 * onClientConnectionWasRejected
 */
class onClientConnectionWasRejected {
	/**
	 * @access public
	 * @var Client
	 */
	public $client;
}
//}

//if (!class_exists("onClientConnectionWasRejectedResponse")) {
/**
 * onClientConnectionWasRejectedResponse
 */
class onClientConnectionWasRejectedResponse {
    //return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onClientConnectionWasRejectedResponse");
	}
}
//}





//if (!class_exists("onClientDisconnected")) {
/**
 * onClientDisconnected
 */
class onClientDisconnected {
	/**
	 * @access public
	 * @var Client
	 */
	public $client;
	/**
	 * @access public
	 * @var ChatRoom
	 */
	public $room;
}
//}

//if (!class_exists("onClientDisconnectedResponse")) {
/**
 * onClientDisconnectedResponse
 */
class onClientDisconnectedResponse {
	/**
	 * @access public
	 * @var ChatRoom
	 */
	public $onClientDisconnectedResult;
	//set result value
	public function setResult($value)
	{
		$this->onClientDisconnectedResult = $value;
	}	
	//return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onClientDisconnectedResponse");
	}
}
//}





//if (!class_exists("onClientWantsToStartStreaming")) {
/**
 * onClientWantsToStartStreaming
 */
class onClientWantsToStartStreaming {
	/**
	 * @access public
	 * @var Client
	 */
	public $client;
	/**
	 * @access public
	 * @var Stream
	 */
	public $stream;
}
//}

//if (!class_exists("Stream")) {
/**
 * Stream
 */
class Stream {
	/**
	 * @access public
	 * @var sstring
	 */
	public $UID;
    /**
     * Return stream unique ID
     * @return sstring
     */
    public function getUID() { return $this->UID; }
	
	
	
	
	/**
	 * @access public
	 * @var sstring
	 */
	public $informations;
    /**
     * Return information about the stream
     * @return sstring
     */
    public function getInformations() { return $this->informations; }
}
//}

//if (!class_exists("onClientWantsToStartStreamingResponse")) {
/**
 * onClientWantsToStartStreamingResponse
 */
class onClientWantsToStartStreamingResponse {
	/**
	 * @access public
	 * @var Client
	 */
	public $onClientWantsToStartStreamingResult;
    //set result value
	public function setResult($value)
	{
		$this->onClientWantsToStartStreamingResult = $value;
	}
    //return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onClientWantsToStartStreamingResponse");
	}
}
//}






//if (!class_exists("onClientStoppedStreaming")) {
/**
 * onClientStoppedStreaming
 */
class onClientStoppedStreaming {
	/**
	 * @access public
	 * @var Client
	 */
	public $client;
	/**
	 * @access public
	 * @var Stream
	 */
	public $stream;
}
//}

//if (!class_exists("onClientStoppedStreamingResponse")) {
/**
 * onClientStoppedStreamingResponse
 */
class onClientStoppedStreamingResponse {
    //return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onClientStoppedStreamingResponse");
	}
}
//}





//if (!class_exists("onClientWantsToPlayStream")) {
/**
 * onClientWantsToPlayStream
 */
class onClientWantsToPlayStream {
	/**
	 * @access public
	 * @var Client
	 */
	public $client;
	/**
	 * @access public
	 * @var Stream
	 */
	public $stream;
}
//}

//if (!class_exists("onClientWantsToPlayStreamResponse")) {
/**
 * onClientWantsToPlayStreamResponse
 */
class onClientWantsToPlayStreamResponse {
	/**
	 * @access public
	 * @var Client
	 */
	public $onClientWantsToPlayStreamResult;
    //set result value
	public function setResult($value)
	{
		$this->onClientWantsToPlayStreamResult = $value;
	}
    //return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onClientWantsToPlayStreamResponse");
	}
}
//}






//if (!class_exists("onClientStoppedPlayingStream")) {
/**
 * onClientStoppedPlayingStream
 */
class onClientStoppedPlayingStream {
	/**
	 * @access public
	 * @var Client
	 */
	public $client;
	/**
	 * @access public
	 * @var Stream
	 */
	public $stream;
}
//}

//if (!class_exists("onClientStoppedPlayingStreamResponse")) {
/**
 * onClientStoppedPlayingStreamResponse
 */
class onClientStoppedPlayingStreamResponse {
    //return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onClientStoppedPlayingStreamResponse");
	}
}
//}





//if (!class_exists("onCheckClients")) {
/**
 * onCheckClients
 */
class onCheckClients {
	/**
	 * @access public
	 * @var ArrayOfClient
	 */
	public $clients;
}
//}

//if (!class_exists("onCheckClientsResponse")) {
/**
 * onCheckClientsResponse
 */
class onCheckClientsResponse {
	/**
	 * @access public
	 * @var ArrayOfClient
	 */
	public $onCheckClientsResult;
    //set result value
	public function setResult($value)
	{
		$this->onCheckClientsResult = $value;
	}
    //return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onCheckClientsResponse");
	}
}
//}





//if (!class_exists("onClientSendMessage")) {
/**
 * onClientSendMessage
 */
class onClientSendMessage {
	/**
	 * @access public
	 * @var Client
	 */
	public $clientFrom;
	/**
	 * @access public
	 * @var sstring
	 */
	public $toUID;
	/**
	 * @access public
	 * @var sstring
	 */
	public $color;
	/**
	 * @access public
	 * @var sstring
	 */
	public $message;
}
//}

//if (!class_exists("onClientSendMessageResponse")) {
/**
 * onClientSendMessageResponse
 */
class onClientSendMessageResponse {
	/**
	 * @access public
	 * @var Client
	 */
	public $onClientSendMessageResult;
    //set result value
	public function setResult($value)
	{
		$this->onClientSendMessageResult = $value;
	}
    //return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onClientSendMessageResponse");
	}
}
//}






//if (!class_exists("onUniversalCall")) {
/**
 * onUniversalCall
 */
class onUniversalCall {
	/**
	 * @access public
	 * @var ArrayOfClient
	 */
	public $clients;
	/**
	 * @access public
	 * @var sstring
	 */
	public $senderName;
	/**
	 * @access public
	 * @var sstring
	 */
	public $eventName;
	/**
	 * @access public
	 * @var sstring
	 */
	public $value;
}
//}

//if (!class_exists("onUniversalCallResponse")) {
/**
 * onUniversalCallResponse
 */
class onUniversalCallResponse {
	/**
	 * @access public
	 * @var ArrayOfClient
	 */
	public $onUniversalCallResult;
    //set result value
	public function setResult($value)
	{
		$this->onUniversalCallResult = $value;
	}
    //return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onUniversalCallResponse");
	}
}
//}





//if (!class_exists("onChatRoomCreated")) {
/**
 * onChatRoomCreated
 */
class onChatRoomCreated {
	/**
	 * @access public
	 * @var ChatRoom
	 */
	public $room;
}
//}

//if (!class_exists("ChatRoom")) {
/**
 * ChatRoom
 */
class ChatRoom {
	/**
	 * @access public
	 * @var sstring
	 */
	private $UID;
    /**
     * Return room unique ID
     * @return sstring
     */
    public function getUID() { return $this->UID; }
	
	
	
	
	/**
	 * @access public
	 * @var sint
	 */
	private $nextCheck;
     /**
     * Return integer value (time interval in seconds), when room
     * will trigger onCheckChatRooms event
     * @return sint
     */
    public function getNextCheck() { return $this->nextCheck; }
    /**
     * Set "timeout" in seconds, when room 
     * will trigger onCheckChatRooms event
     * @param sstring $value
     */
    public function setNextCheck($value) 
    { 
    	//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "setNextCheck";
    	if(GlobalStatus::$roomGetFuncOnly)
    	{
    		GlobalStatus::potentialThreat("Room",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->nextCheck = $value; 
    }
	
	
	
	
	/**
	 * @access public
	 * @var sstring
	 */
	private $roomName;
    /**
     * Return room name
     * @return sstring
     */
    public function getRoomName() { return $this->roomName; }
    /**
     * Set room name
     * @param sstring $value
     */
    public function setRoomName($value) 
    { 
    	//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "setRoomName";
    	if((GlobalStatus::$roomGetFuncOnly) || 
    	   (GlobalStatus::$actualServiceFunction!="onChatRoomCreated"))
    	{
    		GlobalStatus::potentialThreat("Room",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->roomName = $value; 
    }
	
	
	
	
	/**
	 * @access public
	 * @var sstring
	 */
	private $description;
    /**
     * Return description.
     * @return sstring
     */
    public function getDescription() { return $this->description; }
    /**
     * Set description.
     * @param sstring $value
     */
    public function setDescription($value) 
    { 
    	//check if method can be used here
    	/*COMMENT{*/
    	$methodName = "setDescription";
    	if(GlobalStatus::$roomGetFuncOnly)
    	{
    		GlobalStatus::potentialThreat("Room",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->description = $value; 
    }
	
	
	
	
	/**
	 * @access public
	 * @var sboolean
	 */
	private $roomClosed;
	
	
	
	
	/**
	 * @access public
	 * @var sint
	 */
	private $usersCount;
    /**
     * Return count of users in the room.
     * @return sint
     */
    public function getUsersCount() { return $this->usersCount; }
    
	/**
	 * @access public
	 * @var sstring
	 */
	private $chatText;
	/**
	 * @access public
	 * @var sstring
	 */
	private $commands;
	/**
	 * @access public
	 * @var sstring
	 */
	private $additionalVariables;
	private $_unserializedVars = null;
	
	
	
	
	
	/**
	 * Get property (additional variable) previously
	 * defined by setProperty method.
	 * Always test if value is not null.
	 * @param $propertyName - name of the property
	 * @return mixed
	 */
	private function getProperty($propertyName)
	{
		//if variable was not unserialized yet then unserialize it
		if($this->_unserializedVars == null)
		{
			//if additionalVariables does not contain anything then create
		    //plain array
			if(($this->additionalVariables==null) || 
			   (strlen(trim($this->additionalVariables," \t\n\r\0\x0B"))<1))
			{
				$this->_unserializedVars = array();
			}
			//else unserialize additional variables
			else
			{
				$this->_unserializedVars = 
				        unserialize($this->additionalVariables);
			}
		}
		
		//return result
		return $this->_unserializedVars[$propertyName];
	}
	
	
	
	/**
	 * By setProperty method you can add your own
	 * variables into this object. Variables type can be
	 * string, boolean, byte, integer, object.
	 * @param $propertyName
	 * @param $mixed
	 */
	private function setProperty($propertyName,$mixed)
	{
	    //check if method can be used here
    	/*COMMENT{*/
    	$methodName = "setProperty";
    	if(GlobalStatus::$roomGetFuncOnly)
    	{
    		GlobalStatus::potentialThreat("Room",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
		
		//if variable was not unserialized yet then unserialize it
		if($this->_unserializedVars == null)
		{
			//if additionalVariables does not contain anything then create
		    //plain array
			if(($this->additionalVariables==null) || 
			   (strlen(trim($this->additionalVariables," \t\n\r\0\x0B"))<1))
			{
				$this->_unserializedVars = array();
			}
			//else unserialize additional variables
			else
			{
				$this->_unserializedVars = 
				        unserialize($this->additionalVariables);
			}
		}
		
		//save variable
		$this->_unserializedVars[$propertyName] = $mixed;
	}
	
	
	/**
	 * Save variables
	 * deprecated method.
	 * Please use setProperty and getProperty methods.
	 */
	public function saveAdditionalVariables()
	{
		//if there were some changes to unserialized variables
		//then serialize them to AdditionalVariables
		if($this->_unserializedVars != null)
		{
			$this->additionalVariables = 
			        serialize($this->_unserializedVars);
		}
	}
	
	
	
    /**
     * Close the room and reject all clients
     */
    public function CloseRoom()
    {
        //check if method can be used here
    	/*COMMENT{*/
    	$methodName = "CloseRoom";
    	if((GlobalStatus::$roomGetFuncOnly) || 
    	   (GlobalStatus::$actualServiceFunction=="onChatRoomCreated"))
    	{
    		GlobalStatus::potentialThreat("Room",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	$this->roomClosed = true;
    }

    /**
     * Send text message to all clients in the chat room
     * @param sstring $fromUserName Nick name of the sender
     * @param sstring $color message color in haxformat like "FF0011"
     * @param sstring $text message text
     */
    public function SendRoomMessage($fromUserName, $color, $text)
    {
        //check if method can be used here
    	/*COMMENT{*/
    	$methodName = "SendRoomMessage";
    	if(GlobalStatus::$roomGetFuncOnly)
    	{
    		GlobalStatus::potentialThreat("Room",$methodName,$this->UID);
    	}
    	/*}COMMENT*/
    	
    	//convert fromUserName to utf8
    	$fromUserName = Constants::utf8encode(strtr($fromUserName,'~',';'));
    	//convert text to utf8
    	$text = Constants::utf8encode(strtr($text,'~',';'));
    	
    	$this->chatText .= "TextMessage" . 
        				   "~~fromClientUID=" . "_ADMIN" . 
                		   "~~fromClientNickName=" . $fromUserName . 
        				   "~~toClientUID=_ALL" .
        				   "~~color=" . strtr($color,'~',';') . 
        				   "~~message=" . $text . "~!~";
    }
    
	
    
    
    /**
     * This function can be used if intellisense does not work.
     * You can cast any variable into ChatRoom.
     * @param mixed $variable
     * @return ChatRoom
     */
    public static function castToChatRoom($variable)
    {
    	return $variable;
    }
	
	/**
     * @var StreamServerCommands
     */
    private $streamServerCommands = null;
    
    /**
     * Return stream server commands,
     * huge set of more sophisticated commands
     * @return StreamServerCommands
     */
    public function getStreamServerCommands()
    {
    	//if stream server commands was not created before than create it
    	if($streamServerCommands==null)
    	{
    		$streamServerCommands = new StreamServerCommands($this,false);
    	}
    	//return $streamServerCommands
    	return $streamServerCommands;
    }
    
    private function getCommands()
    {
    	return $this->commands;
    }
	
    /**
     * Deprecated function, please use getStreamServerCommands() instead.
     * @deprecated
     * @param $commandName
     * @param $clientRoomUID
     * @param $isRoomCommand
     * @param $parameters
     */
    public function pushCommand($commandName, 
                                $clientRoomUID = null,
                                $isRoomCommand = false,
                                $parameters = null)
    {
    	//test if command is null
        if($this->commands==null)
        {
            $this->commands = "";
        }
    	//clear parameters from separators
        $outparams = "";
        if($parameters!=null)
        {
	        for($a=0;$a<sizeof($parameters);$a++)
	        {
	        	$parameters[$a] = 
	        		Constants::clearFromSeparators($parameters[$a]);
	        }
	        //create outparams
	        $outparams = implode(Constants::$SEPARATOR,$parameters);
        }
        
        //if $clientRoomUID is null then use my UID
        if($clientRoomUID==null)
        {
        	$clientRoomUID = $this->getUID();
        }
        
        $strIsRoomCommand = "false";
        if($isRoomCommand)
        {
        	$strIsRoomCommand = "true";
        }
                     
        //create command
        $this->commands .= "Command" . Constants::$SEPARATOR .
        			Configuration::generateNextContinuousUID() . Constants::$SEPARATOR .
                    $strIsRoomCommand . Constants::$SEPARATOR .
                    $clientRoomUID . Constants::$SEPARATOR . 
        		    $commandName . Constants::$SEPARATOR .
        		    $outparams . Constants::$NEWLINE;
    }
}
//}

//if (!class_exists("onChatRoomCreatedResponse")) {
/**
 * onChatRoomCreatedResponse
 */
class onChatRoomCreatedResponse {
	/**
	 * @access public
	 * @var ChatRoom
	 */
	public $onChatRoomCreatedResult;
    //set result value
	public function setResult($value)
	{
		$this->onChatRoomCreatedResult = $value;
	}
    //return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onChatRoomCreatedResponse");
	}
}
//}





//if (!class_exists("onCheckChatRooms")) {
/**
 * onCheckChatRooms
 */
class onCheckChatRooms {
	/**
	 * @access public
	 * @var ArrayOfChatRoom
	 */
	public $rooms;
}
//}

//if (!class_exists("onCheckChatRoomsResponse")) {
/**
 * onCheckChatRoomsResponse
 */
class onCheckChatRoomsResponse {
	/**
	 * @access public
	 * @var ArrayOfChatRoom
	 */
	public $onCheckChatRoomsResult;
    //set result value
	public function setResult($value)
	{
		$this->onCheckChatRoomsResult = $value;
	}
    //return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onCheckChatRoomsResponse");
	}
}
//}





//if (!class_exists("onChatRoomClosed")) {
/**
 * onChatRoomClosed
 */
class onChatRoomClosed {
	/**
	 * @access public
	 * @var ChatRoom
	 */
	public $room;
}
//}

//if (!class_exists("onChatRoomClosedResponse")) {
/**
 * onChatRoomClosedResponse
 */
class onChatRoomClosedResponse {
    //return response
	public function SOAPResult()
	{
		return new SoapParam($this,"onChatRoomClosedResponse");
	}
}
//}





//if (!class_exists("RadicalChatService")) {
	/**
	 * RadicalChatService
	 */
	class RadicalChatService 
	{
		
	}
	
	
	/**
	 * Prepare client before any function is called
	 * @param Client $client
	 */
	function updateClientBeforeFunction(&$client)
	{
		if($client!=null)
		{
			/*COMMENT{*/
			GlobalStatus::$disableWarnings = true;
			/*}COMMENT*/
			
			//decode nickname from utf8
			$client->setNickName(
					    Constants::utf8decode($client->getNickName()));
			//decode description from utf8
			$client->setDescription(
					    Constants::utf8decode($client->getDescription()));
			
			/*COMMENT{*/
			GlobalStatus::$disableWarnings = false;
			/*}COMMENT*/
		}
	}
	
	
	
	/**
	 * Update client after function is called
	 * @param Client $client
	 */
	function updateClientAfterFunction(&$client)
	{
		if($client!=null)
		{
			//save additional variables
			$client->saveAdditionalVariables();
			
			
			/*COMMENT{*/
			GlobalStatus::$disableWarnings = true;
			/*}COMMENT*/
			
			//encode nick name to utf8
			$client->setNickName(
					    Constants::utf8encode($client->getNickName()));
			//encode description to utf8
			$client->setDescription(
					    Constants::utf8encode($client->getDescription()));
					    
			/*COMMENT{*/
			GlobalStatus::$disableWarnings = false;
			/*}COMMENT*/
		}
	}
	
	
	
	/**
	 * Update room before function is called
	 * @param ChatRoom $room
	 */
	function updateRoomBeforeFunction(&$room)
	{
		if($room!=null)
		{
			/*COMMENT{*/
			GlobalStatus::$disableWarnings = true;
			/*}COMMENT*/
			
			//decode room name from utf8
			$room->setRoomName(
					    Constants::utf8decode($room->getRoomName()));
			//decode description from utf8
			$room->setDescription(
					    Constants::utf8decode($room->getDescription()));
					    
			/*COMMENT{*/
			GlobalStatus::$disableWarnings = false;
			/*}COMMENT*/
		}
	}
	
	
	
	/**
	 * Update room after function is called
	 * @param ChatRoom $room
	 */
	function updateRoomAfterFunction(&$room)
	{
		if($room!=null)
		{
			//save additional variables
			$room->saveAdditionalVariables();
			
			
			/*COMMENT{*/
			GlobalStatus::$disableWarnings = true;
			/*}COMMENT*/
			
			//encode room name to utf8
			$room->setRoomName(
					    Constants::utf8encode($room->getRoomName()));
			//encode description to utf8
			$room->setDescription(
					    Constants::utf8encode($room->getDescription()));
					    
			/*COMMENT{*/
			GlobalStatus::$disableWarnings = false;
			/*}COMMENT*/
		}
	}
	
	
	
	
	
	
	
	function getAPICode() 
    {
		//set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(true,true,"getAPICode");
    	/*}COMMENT*/
    	
    	$result = new getAPICodeResponse();
		$result->setResult("RadicalChat 1.0.0");
		return $result->SOAPResult();
	}
	
	
	
	function getImplementedFunctions()
	{
    	$resultString = "";
    	if(function_exists("_onApplicationStarted"))
    	{
    		$resultString .= "onApplicationStarted,";
    	}
		if(function_exists("_onApplicationStopped"))
    	{
    		$resultString .= "onApplicationStopped,";
    	}
		if(function_exists("_onClientWantsToConnect"))
    	{
    		$resultString .= "onClientWantsToConnect,";
    	}
		if(function_exists("_onClientConnectionWasAccepted"))
    	{
    		$resultString .= "onClientConnectionWasAccepted,";
    	}
		if(function_exists("_onClientConnectionWasRejected"))
    	{
    		$resultString .= "onClientConnectionWasRejected,";
    	}
		if(function_exists("_onClientDisconnected"))
    	{
    		$resultString .= "onClientDisconnected,";
    	}
		if(function_exists("_onClientWantsToStartStreaming"))
    	{
    		$resultString .= "onClientWantsToStartStreaming,";
    	}
		if(function_exists("_onClientStoppedStreaming"))
    	{
    		$resultString .= "onClientStoppedStreaming,";
    	}
		if(function_exists("_onClientWantsToPlayStream"))
    	{
    		$resultString .= "onClientWantsToPlayStream,";
    	}
		if(function_exists("_onClientStoppedPlayingStream"))
    	{
    		$resultString .= "onClientStoppedPlayingStream,";
    	}
		if(function_exists("_onCheckClients"))
    	{
    		$resultString .= "onCheckClients,";
    	}
		if(function_exists("_onClientSendMessage"))
    	{
    		$resultString .= "onClientSendMessage,";
    	}
		if(function_exists("_onUniversalCall"))
    	{
    		$resultString .= "onUniversalCall,";
    	}
		if(function_exists("_onChatRoomCreated"))
    	{
    		$resultString .= "onChatRoomCreated,";
    	}
		if(function_exists("_onCheckChatRooms"))
    	{
    		$resultString .= "onCheckChatRooms,";
    	}
		if(function_exists("_onChatRoomClosed"))
    	{
    		$resultString .= "onChatRoomClosed,";
    	}
		
		$result = new getImplementedFunctionsResponse();
		//call get implemented functions
		$result->setResult($resultString);
		return $result->SOAPResult();
	}
	
	
	
	function onApplicationStarted() 
    {
		//set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(true,true,"onApplicationStarted");
    	/*}COMMENT*/
    	
    	//call onApplictionStarted
    	_onApplicationStarted();
    	
		$result = new onApplicationStartedResponse();
    	return $result->SOAPResult();
	}
	
	
	
	function onApplicationStopped() 
    {
		//set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(true,true,"onApplicationStopped");
    	/*}COMMENT*/
    	
    	//call onApplicationStopped
    	_onApplicationStopped();
    	
		$result = new onApplicationStartedResponse();
    	return $result->SOAPResult();
	}
	
	
	
	function onClientWantsToConnect($value)
	{
		//set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(false,true,"onClientWantsToConnect");
    	/*}COMMENT*/
		
		$client = $value->client;
		
		//update client before function is called
		updateClientBeforeFunction($client);
		
		//call onClientWantsToConnect
		_onClientWantsToConnect($client);
		
		//update client after function is called
		updateClientAfterFunction($client);
		
		$result = new onClientWantsToConnectResponse();
		$result->setResult($client);
		return $result->SOAPResult();
	}
	
	
	
	function onClientConnectionWasAccepted($value)
	{
		//set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(false,true,"onClientConnectionWasAccepted");
    	/*}COMMENT*/
		
		$client = $value->client;
		
		//update client before function is called
		updateClientBeforeFunction($client);
		
		//call onClientConnectionWasAccepted
		_onClientConnectionWasAccepted($client);
		
		//update client after function is called
		updateClientAfterFunction($client);
		
		$result = new onClientConnectionWasAcceptedResponse();
		$result->setResult($client);
		return $result->SOAPResult();
	}
	
	
	
	function onClientConnectionWasRejected($value)
	{
	    //set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(true,true,"onClientConnectionWasRejected");
    	/*}COMMENT*/
		
		$client = $value->client;
		
		//update client before function is called
		updateClientBeforeFunction($client);
		
		//call onClientConnectionWasRejected
		_onClientConnectionWasRejected($client);
		
		$result = new onClientConnectionWasRejectedResponse();
		return $result->SOAPResult();
	}
	
	
	
	function onClientDisconnected($value)
	{
		//set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(true,false,"onClientDisconnected");
    	/*}COMMENT*/
		
		$client = $value->client;
		$room = $value->room;
		
		//update client before function is called
		updateClientBeforeFunction($client);
		//update room before function is called
		updateRoomBeforeFunction($room);
		
		//call onClientDisconnected
		_onClientDisconnected($client,&$room);
		
		//update room after function is called
		updateRoomAfterFunction($room);
		
		$result = new onClientDisconnectedResponse();
		$result->setResult($room);
		return $result->SOAPResult();
	}
	
	
	
	
	
	function onClientWantsToStartStreaming($value)
	{		
		//set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(false,true,"onClientWantsToStartStreaming");
    	/*}COMMENT*/
		
		$client = $value->client;
		$stream = $value->stream;
		
		//update client before function is called
		updateClientBeforeFunction($client);
		
		//call onClientWantsToStartStreaming
		_onClientWantsToStartStreaming($client,$stream);
		
		//update client after function is called
		updateClientAfterFunction($client);
		
		$result = new onClientWantsToStartStreamingResponse();
		$result->setResult($client);
		return $result->SOAPResult();
	}
	
	
	
	function onClientStoppedStreaming($value)
	{		
		//set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(true,true,"onClientStoppedStreaming");
    	/*}COMMENT*/
		
		$client = $value->client;
		$stream = $value->stream;
		
		//update client before function is called
		updateClientBeforeFunction($client);
		
		//call onClientStoppedStreaming
		_onClientStoppedStreaming($client,$stream);
		
		$result = new onClientStoppedStreamingResponse();
		return $result->SOAPResult();
	}
	
	
	
	function onClientWantsToPlayStream($value)
	{
		//set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(false,true,"onClientWantsToPlayStream");
    	/*}COMMENT*/
		
		$client = $value->client;
		$stream = $value->stream;
		
		//update client before function is called
		updateClientBeforeFunction($client);
		
		//call onClientWantsToPlayStream
		_onClientWantsToPlayStream($client,$stream);
		
		//update client after function is called
		updateClientAfterFunction($client);
		
		$result = new onClientWantsToPlayStreamResponse();
		$result->setResult($client);
		return $result->SOAPResult();
	}
	
	
	
	function onClientStoppedPlayingStream($value)
	{
		//set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(true,true,"onClientStoppedPlayingStream");
    	/*}COMMENT*/
		
		$client = $value->client;
		$stream = $value->stream;
		
		//update client before function is called
		updateClientBeforeFunction($client);
		
		//call onClientStoppedPlayingStream
		_onClientStoppedPlayingStream($client,$stream);
		
		$result = new onClientStoppedPlayingStreamResponse();
		return $result->SOAPResult();
	}
	
	
	
	function onCheckClients($value)
	{
		//set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(false,true,"onCheckClients");
    	/*}COMMENT*/
		
		if(sizeof($value->clients->Client)==1)
		{
			$clients = array($value->clients->Client);
		}
		else if(sizeof($value->clients->Client)>1)
		{		
		    $clients = $value->clients->Client;
		}
		else
		{
			$result = new onCheckClientsResponse();
			$result->setResult(null);
			return $result->SOAPResult();
		}
		
		foreach($clients as $client)
		{
			//update client before function is called
			updateClientBeforeFunction($client);
		}
				
		//call onCheckClients
		_onCheckClients($clients);
		
		//save additional variables
		if($clients!=null)
		{
			foreach($clients as $client)
			{
				//update client after function is called
				updateClientAfterFunction($client);
			}
		}
		
		$result = new onCheckClientsResponse();
		$result->setResult($clients);
		return $result->SOAPResult();
	}
	
	
	
	function onClientSendMessage($value)
	{
		//set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(false,true,"onClientSendMessage");
    	/*}COMMENT*/
		
		$client = $value->clientFrom;
		$toUID = $value->toUID;
		$color = $value->color;
		$message = Constants::utf8decode($value->message);
		
		//update client before function is called
		updateClientBeforeFunction($client);
		
		//call onClientSendMessage
		_onClientSendMessage($client,$toUID,$color,$message);
		
		//update client after function is called
		updateClientAfterFunction($client);
		
		$result = new onClientSendMessageResponse();
		$result->setResult($client);
		return $result->SOAPResult();
	}
	
	
	
	function onUniversalCall($value)
	{
		//set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(false,true,"onUniversalCall");
    	/*}COMMENT*/
		
		if(sizeof($value->clients->Client)==1)
		{
			$clients = array($value->clients->Client);
		}
		else if(sizeof($value->clients->Client)>1)
		{		
		    $clients = $value->clients->Client;
		}
		else
		{
			$result = new onUniversalCallResponse();
			$result->setResult(null);
			return $result->SOAPResult();
		}
		$senderName = $value->senderName;
		$eventName = $value->eventName;
		$stringvalue = $value->value;
		
		foreach($clients as $client)
		{
			//update client before function is called
			updateClientBeforeFunction($client);
		}
		
		//call onUniversalCall
		_onUniversalCall($clients,$senderName,
		                 $eventName,$stringvalue);
		                            
		//save additional variables
		if($clients!=null)
		{
			foreach($clients as $client)
			{
				//update client after function is called
				updateClientAfterFunction($client);
			}
		}
		
		$result = new onUniversalCallResponse();
		$result->setResult($clients);
		return $result->SOAPResult();
	}
	
	
	
	function onChatRoomCreated($value)
	{
		//set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(true,false,"onChatRoomCreated");
    	/*}COMMENT*/
		
		$room = $value->room;
		
		//update room before function is called
		updateRoomBeforeFunction($room);

		//call onChatRoomCreated
		_onChatRoomCreated($room);
		
		//update room after function is called
		updateRoomAfterFunction($room);
		
		$result = new onChatRoomCreatedResponse();
		$result->setResult($room);
		return $result->SOAPResult();
	}
	
	
	
	function onCheckChatRooms($value)
	{
	    //set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(true,false,"onCheckChatRooms");
    	/*}COMMENT*/
		
		if(sizeof($value->rooms->ChatRoom)==1)
		{
			$rooms = array($value->rooms->ChatRoom);
		}
		else if(sizeof($value->rooms->ChatRoom)>1)
		{		
		    $rooms = $value->rooms->ChatRoom;
		}
		else
		{
			$result = new onCheckChatRoomsResponse();
			$result->setResult(null);
			return $result->SOAPResult();
		}
		
		foreach($rooms as $room)
		{
			//update room before function is called
			updateRoomBeforeFunction($room);
		}
		
		//call onCheckChatRooms
		_onCheckChatRooms($rooms);
		
		//save additional variables
		if($rooms!=null)
		{
			foreach($rooms as $room)
			{
				//update room after function is called
				updateRoomAfterFunction($room);
			}
		}
				
		$result = new onCheckChatRoomsResponse();
		$result->setResult($rooms);
		return $result->SOAPResult();
	}
	
	
	
	function onChatRoomClosed($value)
	{
		//set global status
		/*COMMENT{*/
    	GlobalStatus::setGlobalStatus(true,true,"onChatRoomClosed");
    	/*}COMMENT*/
		
		$room = $value->room;
		
		//update room before function is called
		updateRoomBeforeFunction($room);
		
		//call onChatRoomClosed
		_onChatRoomClosed($room);
				
		$result = new onChatRoomClosedResponse();
		return $result->SOAPResult();
	}
//}

	

	//classmap array
	$classmap = array(
		"getAPICode" => "getAPICode",
		"getAPICodeResponse" => "getAPICodeResponse",
		"getImplementedFunctions" => "getImplementedFunctions",
		"getImplementedFunctionsResponse" => "getImplementedFunctionsResponse",
		"onApplicationStarted" => "onApplicationStarted",
		"onApplicationStartedResponse" => "onApplicationStartedResponse",
		"onApplicationStopped" => "onApplicationStopped",
		"onApplicationStoppedResponse" => "onApplicationStoppedResponse",
		"onClientWantsToConnect" => "onClientWantsToConnect",
		"Client" => "Client",
		"onClientWantsToConnectResponse" => "onClientWantsToConnectResponse",
		"onClientConnectionWasAccepted" => "onClientConnectionWasAccepted",
		"onClientConnectionWasAcceptedResponse" => "onClientConnectionWasAcceptedResponse",
		"onClientConnectionWasRejected" => "onClientConnectionWasRejected",
		"onClientConnectionWasRejectedResponse" => "onClientConnectionWasRejectedResponse",
		"onClientDisconnected" => "onClientDisconnected",
		"onClientDisconnectedResponse" => "onClientDisconnectedResponse",
		"onClientWantsToStartStreaming" => "onClientWantsToStartStreaming",
		"Stream" => "Stream",
		"onClientWantsToStartStreamingResponse" => "onClientWantsToStartStreamingResponse",
		"onClientStoppedStreaming" => "onClientStoppedStreaming",
		"onClientStoppedStreamingResponse" => "onClientStoppedStreamingResponse",
		"onClientWantsToPlayStream" => "onClientWantsToPlayStream",
		"onClientWantsToPlayStreamResponse" => "onClientWantsToPlayStreamResponse",
		"onClientStoppedPlayingStream" => "onClientStoppedPlayingStream",
		"onClientStoppedPlayingStreamResponse" => "onClientStoppedPlayingStreamResponse",
		"onCheckClients" => "onCheckClients",
		"onCheckClientsResponse" => "onCheckClientsResponse",
		"onClientSendMessage" => "onClientSendMessage",
		"onClientSendMessageResponse" => "onClientSendMessageResponse",
		"onUniversalCall" => "onUniversalCall",
		"onUniversalCallResponse" => "onUniversalCallResponse",
		"onChatRoomCreated" => "onChatRoomCreated",
		"ChatRoom" => "ChatRoom",
		"onChatRoomCreatedResponse" => "onChatRoomCreatedResponse",
		"onCheckChatRooms" => "onCheckChatRooms",
		"onCheckChatRoomsResponse" => "onCheckChatRoomsResponse",
		"onChatRoomClosed" => "onChatRoomClosed",
		"onChatRoomClosedResponse" => "onChatRoomClosedResponse",
	);

    //set wsdl
	ini_set("soap.wsdl_cache_enabled", "0"); 
    $server = new SoapServer("service.wsdl",array('classmap' => $classmap));
	
    //attach functions
    $server->addFunction("getAPICode");
	$server->addFunction("getImplementedFunctions");
	$server->addFunction("onApplicationStarted");
	$server->addFunction("onApplicationStopped");
	$server->addFunction("onClientWantsToConnect");
	$server->addFunction("onClientConnectionWasAccepted");
	$server->addFunction("onClientConnectionWasRejected");
	$server->addFunction("onClientDisconnected");
	$server->addFunction("onClientWantsToStartStreaming");
	$server->addFunction("onClientStoppedStreaming");
	$server->addFunction("onClientWantsToPlayStream");
	$server->addFunction("onClientStoppedPlayingStream");
	$server->addFunction("onCheckClients");
	$server->addFunction("onClientSendMessage");
	$server->addFunction("onUniversalCall");
	$server->addFunction("onChatRoomCreated");
	$server->addFunction("onCheckChatRooms");
	$server->addFunction("onChatRoomClosed");
    
	//handle service
	$server->handle();

?>
