/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.Util;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.NotCompliantMBeanException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MBeanAnalyzer<M> {
    private Map<String, List<M>> opMap = Util.newInsertionOrderMap();
    private Map<String, AttrMethods<M>> attrMap = Util.newInsertionOrderMap();

    void visit(MBeanVisitor<M> mBeanVisitor) {
        for (Map.Entry<String, AttrMethods<M>> entry : this.attrMap.entrySet()) {
            String string = entry.getKey();
            AttrMethods<Object> attrMethods = entry.getValue();
            mBeanVisitor.visitAttribute(string, (AttrMethods<AttrMethods<M>>)attrMethods.getter, (AttrMethods<AttrMethods<M>>)attrMethods.setter);
        }
        for (Map.Entry<String, Object> entry : this.opMap.entrySet()) {
            for (AttrMethods<Object> attrMethods : (List)entry.getValue()) {
                mBeanVisitor.visitOperation(entry.getKey(), attrMethods);
            }
        }
    }

    static <M> MBeanAnalyzer<M> analyzer(Class<?> clazz, MBeanIntrospector<M> mBeanIntrospector) throws NotCompliantMBeanException {
        return new MBeanAnalyzer<M>(clazz, mBeanIntrospector);
    }

    private MBeanAnalyzer(Class<?> clazz, MBeanIntrospector<M> mBeanIntrospector) throws NotCompliantMBeanException {
        if (!clazz.isInterface()) {
            throw new NotCompliantMBeanException("Not an interface: " + clazz.getName());
        }
        try {
            this.initMaps(clazz, mBeanIntrospector);
        }
        catch (Exception exception) {
            throw Introspector.throwException(clazz, exception);
        }
    }

    private void initMaps(Class<?> clazz, MBeanIntrospector<M> mBeanIntrospector) throws Exception {
        Object object;
        Object object2;
        Method[] methodArray = clazz.getMethods();
        List<Method> list = MBeanAnalyzer.eliminateCovariantMethods(methodArray);
        for (Method object3 : list) {
            Object object4;
            object2 = object3.getName();
            object = mBeanIntrospector.mFrom(object3);
            String string = "";
            if (((String)object2).startsWith("get")) {
                string = ((String)object2).substring(3);
            } else if (((String)object2).startsWith("is") && object3.getReturnType() == Boolean.TYPE) {
                string = ((String)object2).substring(2);
            }
            if (string.length() != 0 && object3.getParameterTypes().length == 0 && object3.getReturnType() != Void.TYPE) {
                object4 = this.attrMap.get(string);
                if (object4 == null) {
                    object4 = new AttrMethods();
                } else if (((AttrMethods)object4).getter != null) {
                    String string2 = "Attribute " + string + " has more than one getter";
                    throw new NotCompliantMBeanException(string2);
                }
                ((AttrMethods)object4).getter = object;
                this.attrMap.put(string, (AttrMethods<M>)object4);
                continue;
            }
            if (((String)object2).startsWith("set") && ((String)object2).length() > 3 && object3.getParameterTypes().length == 1 && object3.getReturnType() == Void.TYPE) {
                string = ((String)object2).substring(3);
                object4 = this.attrMap.get(string);
                if (object4 == null) {
                    object4 = new AttrMethods();
                } else if (((AttrMethods)object4).setter != null) {
                    String string3 = "Attribute " + string + " has more than one setter";
                    throw new NotCompliantMBeanException(string3);
                }
                ((AttrMethods)object4).setter = object;
                this.attrMap.put(string, (AttrMethods<M>)object4);
                continue;
            }
            object4 = this.opMap.get(object2);
            if (object4 == null) {
                object4 = Util.newList();
            }
            object4.add(object);
            this.opMap.put((String)object2, (List<M>)object4);
        }
        for (Map.Entry entry : this.attrMap.entrySet()) {
            object2 = (AttrMethods)entry.getValue();
            if (mBeanIntrospector.consistent(((AttrMethods)object2).getter, ((AttrMethods)object2).setter)) continue;
            object = "Getter and setter for " + (String)entry.getKey() + " have inconsistent types";
            throw new NotCompliantMBeanException((String)object);
        }
    }

    static List<Method> eliminateCovariantMethods(Method[] methodArray) {
        int n = methodArray.length;
        Method[] methodArray2 = (Method[])methodArray.clone();
        Arrays.sort(methodArray2, MethodOrder.instance);
        Set<Method> set = Util.newSet();
        for (int i = 1; i < n; ++i) {
            Method method = methodArray2[i - 1];
            Method method2 = methodArray2[i];
            if (!method.getName().equals(method2.getName()) || !Arrays.equals(method.getParameterTypes(), method2.getParameterTypes())) continue;
            set.add(method);
        }
        List<Method> list = Util.newList(Arrays.asList(methodArray));
        list.removeAll(set);
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttrMethods<M> {
        M getter;
        M setter;

        private AttrMethods() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface MBeanVisitor<M> {
        public void visitAttribute(String var1, M var2, M var3);

        public void visitOperation(String var1, M var2);
    }

    private static class MethodOrder
    implements Comparator<Method> {
        public static final MethodOrder instance = new MethodOrder();

        private MethodOrder() {
        }

        @Override
        public int compare(Method a, Method b) {
            Class<?> bret;
            Object[] bparams;
            int cmp = a.getName().compareTo(b.getName());
            if (cmp != 0) {
                return cmp;
            }
            Object[] aparams = a.getParameterTypes();
            if (aparams.length != (bparams = b.getParameterTypes()).length) {
                return aparams.length - bparams.length;
            }
            if (!Arrays.equals(aparams, bparams)) {
                return Arrays.toString(aparams).compareTo(Arrays.toString(bparams));
            }
            Class<?> aret = a.getReturnType();
            if (aret == (bret = b.getReturnType())) {
                return 0;
            }
            if (aret.isAssignableFrom(bret)) {
                return -1;
            }
            return 1;
        }
    }
}

