/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.IPAcl;

import com.sun.jmx.snmp.IPAcl.AclEntryImpl;
import com.sun.jmx.snmp.IPAcl.AclImpl;
import com.sun.jmx.snmp.IPAcl.JDMAccess;
import com.sun.jmx.snmp.IPAcl.JDMAclItem;
import com.sun.jmx.snmp.IPAcl.JDMCommunities;
import com.sun.jmx.snmp.IPAcl.JDMHost;
import com.sun.jmx.snmp.IPAcl.JDMHostInform;
import com.sun.jmx.snmp.IPAcl.JDMHostTrap;
import com.sun.jmx.snmp.IPAcl.JDMInformCommunity;
import com.sun.jmx.snmp.IPAcl.JDMInformInterestedHost;
import com.sun.jmx.snmp.IPAcl.JDMInformItem;
import com.sun.jmx.snmp.IPAcl.JDMManagers;
import com.sun.jmx.snmp.IPAcl.JDMTrapCommunity;
import com.sun.jmx.snmp.IPAcl.JDMTrapInterestedHost;
import com.sun.jmx.snmp.IPAcl.JDMTrapItem;
import com.sun.jmx.snmp.IPAcl.Parser;
import com.sun.jmx.snmp.IPAcl.PrincipalImpl;
import com.sun.jmx.snmp.IPAcl.SimpleNode;
import com.sun.jmx.trace.Trace;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.acl.NotOwnerException;
import java.util.Hashtable;
import java.util.Vector;

abstract class Host
extends SimpleNode
implements Serializable {
    String dbgTag = "Host";

    public Host(int n) {
        super(n);
    }

    public Host(Parser parser, int n) {
        super(parser, n);
    }

    protected abstract PrincipalImpl createAssociatedPrincipal() throws UnknownHostException;

    protected abstract String getHname();

    public void buildAclEntries(PrincipalImpl principalImpl, AclImpl aclImpl) {
        PrincipalImpl principalImpl2 = null;
        try {
            principalImpl2 = this.createAssociatedPrincipal();
        }
        catch (UnknownHostException unknownHostException) {
            if (this.isDebugOn()) {
                this.debug("buildAclEntries", "Cannot create ACL entry for " + unknownHostException.getMessage());
            }
            throw new IllegalArgumentException("Cannot create ACL entry for " + unknownHostException.getMessage());
        }
        AclEntryImpl aclEntryImpl = null;
        try {
            aclEntryImpl = new AclEntryImpl(principalImpl2);
            this.registerPermission(aclEntryImpl);
            aclImpl.addEntry(principalImpl, aclEntryImpl);
        }
        catch (UnknownHostException unknownHostException) {
            if (this.isDebugOn()) {
                this.debug("buildAclEntries", "Cannot create ACL entry for " + unknownHostException.getMessage());
            }
            return;
        }
        catch (NotOwnerException notOwnerException) {
            if (this.isDebugOn()) {
                this.debug("buildAclEntries", "Not owner of ACL " + notOwnerException.getMessage());
            }
            return;
        }
    }

    private void registerPermission(AclEntryImpl aclEntryImpl) {
        JDMHost jDMHost = (JDMHost)this.jjtGetParent();
        JDMManagers jDMManagers = (JDMManagers)jDMHost.jjtGetParent();
        JDMAclItem jDMAclItem = (JDMAclItem)jDMManagers.jjtGetParent();
        JDMAccess jDMAccess = jDMAclItem.getAccess();
        jDMAccess.putPermission(aclEntryImpl);
        JDMCommunities jDMCommunities = jDMAclItem.getCommunities();
        jDMCommunities.buildCommunities(aclEntryImpl);
    }

    public void buildTrapEntries(Hashtable hashtable) {
        JDMHostTrap jDMHostTrap = (JDMHostTrap)this.jjtGetParent();
        JDMTrapInterestedHost jDMTrapInterestedHost = (JDMTrapInterestedHost)jDMHostTrap.jjtGetParent();
        JDMTrapItem jDMTrapItem = (JDMTrapItem)jDMTrapInterestedHost.jjtGetParent();
        JDMTrapCommunity jDMTrapCommunity = jDMTrapItem.getCommunity();
        String string = jDMTrapCommunity.getCommunity();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.getHname());
        }
        catch (UnknownHostException unknownHostException) {
            if (this.isDebugOn()) {
                this.debug("buildTrapEntries", "Cannot create TRAP entry for " + unknownHostException.getMessage());
            }
            return;
        }
        Vector vector = null;
        if (hashtable.containsKey(inetAddress)) {
            vector = (Vector)hashtable.get(inetAddress);
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
        } else {
            vector = new Vector();
            vector.addElement(string);
            hashtable.put(inetAddress, vector);
        }
    }

    public void buildInformEntries(Hashtable hashtable) {
        JDMHostInform jDMHostInform = (JDMHostInform)this.jjtGetParent();
        JDMInformInterestedHost jDMInformInterestedHost = (JDMInformInterestedHost)jDMHostInform.jjtGetParent();
        JDMInformItem jDMInformItem = (JDMInformItem)jDMInformInterestedHost.jjtGetParent();
        JDMInformCommunity jDMInformCommunity = jDMInformItem.getCommunity();
        String string = jDMInformCommunity.getCommunity();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.getHname());
        }
        catch (UnknownHostException unknownHostException) {
            if (this.isDebugOn()) {
                this.debug("buildInformEntries", "Cannot create INFORM entry for " + unknownHostException.getMessage());
            }
            return;
        }
        Vector vector = null;
        if (hashtable.containsKey(inetAddress)) {
            vector = (Vector)hashtable.get(inetAddress);
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
        } else {
            vector = new Vector();
            vector.addElement(string);
            hashtable.put(inetAddress, vector);
        }
    }

    boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)512);
    }

    void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)512, (String)string, (String)string2, (String)string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)512);
    }

    void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)512, (String)string, (String)string2, (String)string3);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }
}

